// python wrapper for vtkPVChangeOfBasisHelper
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkSmartPointer.h"
#include "vtkPVChangeOfBasisHelper.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVChangeOfBasisHelper(PyObject *dict); }

static PyObject *
PyvtkPVChangeOfBasisHelper_GetChangeOfBasisMatrix_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetChangeOfBasisMatrix");

  vtkVector3d *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  vtkVector3d *temp1 = nullptr;
  PyObject *pobj1 = nullptr;
  vtkVector3d *temp2 = nullptr;
  PyObject *pobj2 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkVector3d") &&
      ap.GetSpecialObject(temp1, pobj1, "vtkVector3d") &&
      ap.GetSpecialObject(temp2, pobj2, "vtkVector3d"))
  {
    vtkSmartPointer<vtkMatrix4x4> tempr = vtkPVChangeOfBasisHelper::GetChangeOfBasisMatrix(*temp0, *temp1, *temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  Py_XDECREF(pobj0);
  Py_XDECREF(pobj1);
  Py_XDECREF(pobj2);

  return result;
}

static PyObject *
PyvtkPVChangeOfBasisHelper_GetChangeOfBasisMatrix_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetChangeOfBasisMatrix");

  vtkDataObject *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkDataObject"))
  {
    vtkSmartPointer<vtkMatrix4x4> tempr = vtkPVChangeOfBasisHelper::GetChangeOfBasisMatrix(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkPVChangeOfBasisHelper_GetChangeOfBasisMatrix(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 3:
      return PyvtkPVChangeOfBasisHelper_GetChangeOfBasisMatrix_s1(self, args);
    case 1:
      return PyvtkPVChangeOfBasisHelper_GetChangeOfBasisMatrix_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetChangeOfBasisMatrix");
  return nullptr;
}


static PyObject *
PyvtkPVChangeOfBasisHelper_GetBasisVectors(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetBasisVectors");

  vtkMatrix4x4 *temp0 = nullptr;
  vtkVector3d *temp1 = nullptr;
  vtkVector3d *temp2 = nullptr;
  vtkVector3d *temp3 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(4) &&
      ap.GetVTKObject(temp0, "vtkMatrix4x4") &&
      ap.GetSpecialObject(temp1, "vtkVector3d") &&
      ap.GetSpecialObject(temp2, "vtkVector3d") &&
      ap.GetSpecialObject(temp3, "vtkVector3d"))
  {
    bool tempr = vtkPVChangeOfBasisHelper::GetBasisVectors(temp0, *temp1, *temp2, *temp3);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVChangeOfBasisHelper_AddChangeOfBasisMatrixToFieldData(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "AddChangeOfBasisMatrixToFieldData");

  vtkDataObject *temp0 = nullptr;
  vtkMatrix4x4 *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkDataObject") &&
      ap.GetVTKObject(temp1, "vtkMatrix4x4"))
  {
    bool tempr = vtkPVChangeOfBasisHelper::AddChangeOfBasisMatrixToFieldData(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVChangeOfBasisHelper_AddBasisNames(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "AddBasisNames");

  vtkDataObject *temp0 = nullptr;
  const char *temp1 = nullptr;
  const char *temp2 = nullptr;
  const char *temp3 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(4) &&
      ap.GetVTKObject(temp0, "vtkDataObject") &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    bool tempr = vtkPVChangeOfBasisHelper::AddBasisNames(temp0, temp1, temp2, temp3);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVChangeOfBasisHelper_AddBoundingBoxInBasis(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "AddBoundingBoxInBasis");

  vtkDataObject *temp0 = nullptr;
  const size_t size1 = 6;
  double temp1[6];
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkDataObject") &&
      ap.GetArray(temp1, size1))
  {
    bool tempr = vtkPVChangeOfBasisHelper::AddBoundingBoxInBasis(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVChangeOfBasisHelper_GetBoundingBoxInBasis(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetBoundingBoxInBasis");

  vtkDataObject *temp0 = nullptr;
  const size_t size1 = 6;
  double temp1[6];
  double save1[6];
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkDataObject") &&
      ap.GetArray(temp1, size1))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    bool tempr = vtkPVChangeOfBasisHelper::GetBoundingBoxInBasis(temp0, temp1);

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVChangeOfBasisHelper_Methods[] = {
  {"GetChangeOfBasisMatrix", PyvtkPVChangeOfBasisHelper_GetChangeOfBasisMatrix, METH_VARARGS,
   "GetChangeOfBasisMatrix(u:vtkVector3d, v:vtkVector3d,\n    w:vtkVector3d) -> vtkMatrix4x4\nC++: static vtkSmartPointer<vtkMatrix4x4> GetChangeOfBasisMatrix(\n    const vtkVector3d &u, const vtkVector3d &v,\n    const vtkVector3d &w)\nGetChangeOfBasisMatrix(dataObject:vtkDataObject) -> vtkMatrix4x4\nC++: static vtkSmartPointer<vtkMatrix4x4> GetChangeOfBasisMatrix(\n    vtkDataObject *dataObject)\n\nGiven a set of basis vectors, returns the change-of-basis matrix.\n"},
  {"GetBasisVectors", PyvtkPVChangeOfBasisHelper_GetBasisVectors, METH_VARARGS,
   "GetBasisVectors(matrix:vtkMatrix4x4, u:vtkVector3d, v:vtkVector3d,\n     w:vtkVector3d) -> bool\nC++: static bool GetBasisVectors(vtkMatrix4x4 *matrix,\n    vtkVector3d &u, vtkVector3d &v, vtkVector3d &w)\n\n"},
  {"AddChangeOfBasisMatrixToFieldData", PyvtkPVChangeOfBasisHelper_AddChangeOfBasisMatrixToFieldData, METH_VARARGS,
   "AddChangeOfBasisMatrixToFieldData(dataObject:vtkDataObject,\n    matrix:vtkMatrix4x4) -> bool\nC++: static bool AddChangeOfBasisMatrixToFieldData(\n    vtkDataObject *dataObject, vtkMatrix4x4 *matrix)\n\n"},
  {"AddBasisNames", PyvtkPVChangeOfBasisHelper_AddBasisNames, METH_VARARGS,
   "AddBasisNames(dataObject:vtkDataObject, utitle:str, vtitle:str,\n    wtitle:str) -> bool\nC++: static bool AddBasisNames(vtkDataObject *dataObject,\n    const char *utitle, const char *vtitle, const char *wtitle)\n\nAdd basis titles to field data.\n"},
  {"AddBoundingBoxInBasis", PyvtkPVChangeOfBasisHelper_AddBoundingBoxInBasis, METH_VARARGS,
   "AddBoundingBoxInBasis(dataObject:vtkDataObject, bbox:(float,\n    float, float, float, float, float)) -> bool\nC++: static bool AddBoundingBoxInBasis(vtkDataObject *dataObject,\n    const double bbox[6])\n\nAdd bounding box in model space.\n"},
  {"GetBoundingBoxInBasis", PyvtkPVChangeOfBasisHelper_GetBoundingBoxInBasis, METH_VARARGS,
   "GetBoundingBoxInBasis(dataObject:vtkDataObject, bbox:[float,\n    float, float, float, float, float]) -> bool\nC++: static bool GetBoundingBoxInBasis(vtkDataObject *dataObject,\n    double bbox[6])\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVChangeOfBasisHelper_GetSets[] = {
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};

static PyObject *
PyvtkPVChangeOfBasisHelper_vtkPVChangeOfBasisHelper_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkPVChangeOfBasisHelper");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkPVChangeOfBasisHelper *op = new vtkPVChangeOfBasisHelper();

    result = PyVTKSpecialObject_New("vtkPVChangeOfBasisHelper", op);
  }

  return result;
}

static PyObject *
PyvtkPVChangeOfBasisHelper_vtkPVChangeOfBasisHelper_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkPVChangeOfBasisHelper");

  vtkPVChangeOfBasisHelper *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkPVChangeOfBasisHelper"))
  {
    vtkPVChangeOfBasisHelper *op = new vtkPVChangeOfBasisHelper(*temp0);

    result = PyVTKSpecialObject_New("vtkPVChangeOfBasisHelper", op);
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyMethodDef PyvtkPVChangeOfBasisHelper_vtkPVChangeOfBasisHelper_Methods[] = {
  {"vtkPVChangeOfBasisHelper", PyvtkPVChangeOfBasisHelper_vtkPVChangeOfBasisHelper_s2, METH_VARARGS,
   "@W vtkPVChangeOfBasisHelper"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkPVChangeOfBasisHelper_vtkPVChangeOfBasisHelper(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 0:
      return PyvtkPVChangeOfBasisHelper_vtkPVChangeOfBasisHelper_s1(self, args);
    case 1:
      return PyvtkPVChangeOfBasisHelper_vtkPVChangeOfBasisHelper_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "vtkPVChangeOfBasisHelper");
  return nullptr;
}


static const char *PyvtkPVChangeOfBasisHelper_Doc =

  "vtkPVChangeOfBasisHelper() -> vtkPVChangeOfBasisHelper\nC++: vtkPVChangeOfBasisHelper()\nvtkPVChangeOfBasisHelper(__a:vtkPVChangeOfBasisHelper)\n    -> vtkPVChangeOfBasisHelper\nC++: vtkPVChangeOfBasisHelper(const &vtkPVChangeOfBasisHelper)\n""\n"
  "vtkPVChangeOfBasisHelper - vtkPVChangeOfBasisHelper is designed for\nORNL-SNS use-cases where we needed to add support for different basis.\n\n"
;

static PyObject *
PyvtkPVChangeOfBasisHelper_New(PyTypeObject *, PyObject *args, PyObject *kwds)
{
  if (kwds && PyDict_Size(kwds))
  {
    PyErr_SetString(PyExc_TypeError,
                    "this function takes no keyword arguments");
    return nullptr;
  }

  return PyvtkPVChangeOfBasisHelper_vtkPVChangeOfBasisHelper(nullptr, args);
}

static void PyvtkPVChangeOfBasisHelper_Delete(PyObject *self)
{
  PyVTKSpecialObject *obj = (PyVTKSpecialObject *)self;
  delete static_cast<vtkPVChangeOfBasisHelper *>(obj->vtk_ptr);
  PyObject_Del(self);
}

static Py_hash_t PyvtkPVChangeOfBasisHelper_Hash(PyObject *self)
{
  return PyObject_HashNotImplemented(self);
}

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVChangeOfBasisHelper_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsMisc.vtkPVChangeOfBasisHelper", // tp_name
  sizeof(PyVTKSpecialObject), // tp_basicsize
  0, // tp_itemsize
  PyvtkPVChangeOfBasisHelper_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKSpecialObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  PyvtkPVChangeOfBasisHelper_Hash, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT, // tp_flags
  PyvtkPVChangeOfBasisHelper_Doc, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  PyvtkPVChangeOfBasisHelper_New, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static void *PyvtkPVChangeOfBasisHelper_CCopy(const void *obj)
{
  if (obj)
  {
    return new vtkPVChangeOfBasisHelper(*static_cast<const vtkPVChangeOfBasisHelper*>(obj));
  }
  return nullptr;
}

#ifndef DECLARED_PyvtkPVChangeOfBasisHelper_TypeNew
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVChangeOfBasisHelper_TypeNew(); }
#define DECLARED_PyvtkPVChangeOfBasisHelper_TypeNew
#endif

PyObject *PyvtkPVChangeOfBasisHelper_TypeNew()
{
  PyTypeObject *pytype = PyVTKSpecialType_Add(
    &PyvtkPVChangeOfBasisHelper_Type,
    PyvtkPVChangeOfBasisHelper_Methods,
    PyvtkPVChangeOfBasisHelper_GetSets,
    PyvtkPVChangeOfBasisHelper_vtkPVChangeOfBasisHelper_Methods,
    &PyvtkPVChangeOfBasisHelper_CCopy);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVChangeOfBasisHelper(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVChangeOfBasisHelper_TypeNew();

  if (o && PyDict_SetItemString(dict, "vtkPVChangeOfBasisHelper", o) != 0)
  {
    Py_DECREF(o);
  }

}

