// python wrapper for vtkSMStringVectorProperty
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSMStringVectorProperty.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMStringVectorProperty(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMStringVectorProperty_ClassNew(); }

#ifndef DECLARED_PyvtkSMVectorProperty_ClassNew
extern "C" { PyObject *PyvtkSMVectorProperty_ClassNew(); }
#define DECLARED_PyvtkSMVectorProperty_ClassNew
#endif
#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMStringVectorProperty_ElementTypes_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingServerManager.vtkSMStringVectorProperty.ElementTypes", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkSMStringVectorProperty_ElementTypes_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkSMStringVectorProperty_ElementTypes_Type, static_cast<int>(val));
}


static PyObject *
PyvtkSMStringVectorProperty_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMStringVectorProperty::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMStringVectorProperty_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStringVectorProperty *op = static_cast<vtkSMStringVectorProperty *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMStringVectorProperty::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMStringVectorProperty_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMStringVectorProperty *tempr = vtkSMStringVectorProperty::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMStringVectorProperty_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStringVectorProperty *op = static_cast<vtkSMStringVectorProperty *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMStringVectorProperty *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMStringVectorProperty::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMStringVectorProperty_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMStringVectorProperty::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMStringVectorProperty_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStringVectorProperty *op = static_cast<vtkSMStringVectorProperty *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMStringVectorProperty::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMStringVectorProperty_GetNumberOfElements(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfElements");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStringVectorProperty *op = static_cast<vtkSMStringVectorProperty *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetNumberOfElements() :
      op->vtkSMStringVectorProperty::GetNumberOfElements());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMStringVectorProperty_SetNumberOfElements(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfElements");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStringVectorProperty *op = static_cast<vtkSMStringVectorProperty *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfElements(temp0);
    }
    else
    {
      op->vtkSMStringVectorProperty::SetNumberOfElements(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMStringVectorProperty_SetElement(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetElement");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStringVectorProperty *op = static_cast<vtkSMStringVectorProperty *>(vp);

  unsigned int temp0;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    int tempr = (ap.IsBound() ?
      op->SetElement(temp0, temp1) :
      op->vtkSMStringVectorProperty::SetElement(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMStringVectorProperty_SetElements_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetElements");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStringVectorProperty *op = static_cast<vtkSMStringVectorProperty *>(vp);

  vtkStringList *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkStringList"))
  {
    int tempr = (ap.IsBound() ?
      op->SetElements(temp0) :
      op->vtkSMStringVectorProperty::SetElements(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMStringVectorProperty_SetElements_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetElements");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStringVectorProperty *op = static_cast<vtkSMStringVectorProperty *>(vp);

  std::vector<std::string> temp0(ap.GetArgSize(0));
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0.data(), temp0.size()))
  {
    int tempr = (ap.IsBound() ?
      op->SetElements(temp0) :
      op->vtkSMStringVectorProperty::SetElements(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMStringVectorProperty_SetElements_Methods[] = {
  {"SetElements", PyvtkSMStringVectorProperty_SetElements_s1, METH_VARARGS,
   "@V *vtkStringList"},
  {"SetElements", PyvtkSMStringVectorProperty_SetElements_s2, METH_VARARGS,
   "@T s"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkSMStringVectorProperty_SetElements(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkSMStringVectorProperty_SetElements_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetElements");
  return nullptr;
}


static PyObject *
PyvtkSMStringVectorProperty_SetUncheckedElements_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUncheckedElements");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStringVectorProperty *op = static_cast<vtkSMStringVectorProperty *>(vp);

  std::vector<std::string> temp0(ap.GetArgSize(0));
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0.data(), temp0.size()))
  {
    int tempr = (ap.IsBound() ?
      op->SetUncheckedElements(temp0) :
      op->vtkSMStringVectorProperty::SetUncheckedElements(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMStringVectorProperty_SetUncheckedElements_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUncheckedElements");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStringVectorProperty *op = static_cast<vtkSMStringVectorProperty *>(vp);

  vtkStringList *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkStringList"))
  {
    int tempr = (ap.IsBound() ?
      op->SetUncheckedElements(temp0) :
      op->vtkSMStringVectorProperty::SetUncheckedElements(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMStringVectorProperty_SetUncheckedElements_Methods[] = {
  {"SetUncheckedElements", PyvtkSMStringVectorProperty_SetUncheckedElements_s1, METH_VARARGS,
   "@T s"},
  {"SetUncheckedElements", PyvtkSMStringVectorProperty_SetUncheckedElements_s2, METH_VARARGS,
   "@V *vtkStringList"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkSMStringVectorProperty_SetUncheckedElements(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkSMStringVectorProperty_SetUncheckedElements_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetUncheckedElements");
  return nullptr;
}


static PyObject *
PyvtkSMStringVectorProperty_AppendElements(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AppendElements");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStringVectorProperty *op = static_cast<vtkSMStringVectorProperty *>(vp);

  std::vector<std::string> temp0(ap.GetArgSize(0));
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0.data(), temp0.size()))
  {
    int tempr = (ap.IsBound() ?
      op->AppendElements(temp0) :
      op->vtkSMStringVectorProperty::AppendElements(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMStringVectorProperty_AppendUncheckedElements(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AppendUncheckedElements");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStringVectorProperty *op = static_cast<vtkSMStringVectorProperty *>(vp);

  std::vector<std::string> temp0(ap.GetArgSize(0));
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0.data(), temp0.size()))
  {
    int tempr = (ap.IsBound() ?
      op->AppendUncheckedElements(temp0) :
      op->vtkSMStringVectorProperty::AppendUncheckedElements(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMStringVectorProperty_GetElements_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetElements");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStringVectorProperty *op = static_cast<vtkSMStringVectorProperty *>(vp);

  vtkStringList *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkStringList"))
  {
    if (ap.IsBound())
    {
      op->GetElements(temp0);
    }
    else
    {
      op->vtkSMStringVectorProperty::GetElements(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkSMStringVectorProperty_GetElements_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetElements");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStringVectorProperty *op = static_cast<vtkSMStringVectorProperty *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const std::vector<std::string> *tempr = (ap.IsBound() ?
      &op->GetElements() :
      &op->vtkSMStringVectorProperty::GetElements());

    if (!ap.ErrorOccurred())
    {
      if (tempr->empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr->data(), tempr->size());
      }
    }
  }

  return result;
}

static PyObject *
PyvtkSMStringVectorProperty_GetElements(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkSMStringVectorProperty_GetElements_s1(self, args);
    case 0:
      return PyvtkSMStringVectorProperty_GetElements_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetElements");
  return nullptr;
}


static PyObject *
PyvtkSMStringVectorProperty_GetUncheckedElements_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUncheckedElements");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStringVectorProperty *op = static_cast<vtkSMStringVectorProperty *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const std::vector<std::string> *tempr = (ap.IsBound() ?
      &op->GetUncheckedElements() :
      &op->vtkSMStringVectorProperty::GetUncheckedElements());

    if (!ap.ErrorOccurred())
    {
      if (tempr->empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr->data(), tempr->size());
      }
    }
  }

  return result;
}

static PyObject *
PyvtkSMStringVectorProperty_GetUncheckedElements_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUncheckedElements");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStringVectorProperty *op = static_cast<vtkSMStringVectorProperty *>(vp);

  vtkStringList *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkStringList"))
  {
    if (ap.IsBound())
    {
      op->GetUncheckedElements(temp0);
    }
    else
    {
      op->vtkSMStringVectorProperty::GetUncheckedElements(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkSMStringVectorProperty_GetUncheckedElements(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 0:
      return PyvtkSMStringVectorProperty_GetUncheckedElements_s1(self, args);
    case 1:
      return PyvtkSMStringVectorProperty_GetUncheckedElements_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetUncheckedElements");
  return nullptr;
}


static PyObject *
PyvtkSMStringVectorProperty_GetElement(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetElement");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStringVectorProperty *op = static_cast<vtkSMStringVectorProperty *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetElement(temp0) :
      op->vtkSMStringVectorProperty::GetElement(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMStringVectorProperty_GetElementIndex(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetElementIndex");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStringVectorProperty *op = static_cast<vtkSMStringVectorProperty *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetElementIndex(temp0, temp1) :
      op->vtkSMStringVectorProperty::GetElementIndex(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      ap.SetArgValue(1, temp1);
    }
    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMStringVectorProperty_SetElementType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetElementType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStringVectorProperty *op = static_cast<vtkSMStringVectorProperty *>(vp);

  unsigned int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetElementType(temp0, temp1);
    }
    else
    {
      op->vtkSMStringVectorProperty::SetElementType(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMStringVectorProperty_GetElementType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetElementType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStringVectorProperty *op = static_cast<vtkSMStringVectorProperty *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetElementType(temp0) :
      op->vtkSMStringVectorProperty::GetElementType(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMStringVectorProperty_GetUncheckedElement(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUncheckedElement");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStringVectorProperty *op = static_cast<vtkSMStringVectorProperty *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetUncheckedElement(temp0) :
      op->vtkSMStringVectorProperty::GetUncheckedElement(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMStringVectorProperty_SetUncheckedElement(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUncheckedElement");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStringVectorProperty *op = static_cast<vtkSMStringVectorProperty *>(vp);

  unsigned int temp0;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetUncheckedElement(temp0, temp1);
    }
    else
    {
      op->vtkSMStringVectorProperty::SetUncheckedElement(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMStringVectorProperty_GetNumberOfUncheckedElements(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfUncheckedElements");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStringVectorProperty *op = static_cast<vtkSMStringVectorProperty *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetNumberOfUncheckedElements() :
      op->vtkSMStringVectorProperty::GetNumberOfUncheckedElements());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMStringVectorProperty_Copy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Copy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStringVectorProperty *op = static_cast<vtkSMStringVectorProperty *>(vp);

  vtkSMProperty *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProperty"))
  {
    if (ap.IsBound())
    {
      op->Copy(temp0);
    }
    else
    {
      op->vtkSMStringVectorProperty::Copy(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMStringVectorProperty_GetDefaultValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDefaultValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStringVectorProperty *op = static_cast<vtkSMStringVectorProperty *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetDefaultValue(temp0) :
      op->vtkSMStringVectorProperty::GetDefaultValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMStringVectorProperty_ClearUncheckedElements(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearUncheckedElements");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStringVectorProperty *op = static_cast<vtkSMStringVectorProperty *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearUncheckedElements();
    }
    else
    {
      op->vtkSMStringVectorProperty::ClearUncheckedElements();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMStringVectorProperty_IsValueDefault(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsValueDefault");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStringVectorProperty *op = static_cast<vtkSMStringVectorProperty *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsValueDefault() :
      op->vtkSMStringVectorProperty::IsValueDefault());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMStringVectorProperty_ResetToXMLDefaults(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetToXMLDefaults");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStringVectorProperty *op = static_cast<vtkSMStringVectorProperty *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ResetToXMLDefaults();
    }
    else
    {
      op->vtkSMStringVectorProperty::ResetToXMLDefaults();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkSMStringVectorProperty_Methods[] = {
  {"IsTypeOf", PyvtkSMStringVectorProperty_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMStringVectorProperty_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMStringVectorProperty_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMStringVectorProperty\nC++: static vtkSMStringVectorProperty *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMStringVectorProperty_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMStringVectorProperty\nC++: vtkSMStringVectorProperty *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMStringVectorProperty_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMStringVectorProperty_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfElements", PyvtkSMStringVectorProperty_GetNumberOfElements, METH_VARARGS,
   "GetNumberOfElements(self) -> int\nC++: unsigned int GetNumberOfElements() override;\n\nReturns the size of the vector.\n"},
  {"SetNumberOfElements", PyvtkSMStringVectorProperty_SetNumberOfElements, METH_VARARGS,
   "SetNumberOfElements(self, num:int) -> None\nC++: void SetNumberOfElements(unsigned int num) override;\n\nSets the size of the vector. If num is larger than the current\nnumber of elements, this may cause reallocation and copying.\n"},
  {"SetElement", PyvtkSMStringVectorProperty_SetElement, METH_VARARGS,
   "SetElement(self, idx:int, value:str) -> int\nC++: int SetElement(unsigned int idx, const char *value)\n\nSet the value of 1 element. The vector is resized as necessary.\nReturns 0 if Set fails either because the property is read only\nor the value is not in all domains. Returns 1 otherwise.\n"},
  {"SetElements", PyvtkSMStringVectorProperty_SetElements, METH_VARARGS,
   "SetElements(self, newvalue:vtkStringList) -> int\nC++: int SetElements(vtkStringList *newvalue)\nSetElements(self, newvalue:(str, ...)) -> int\nC++: int SetElements(const std::vector<std::string> &newvalue)\n\nSets multiple elements. The size of the property is changed to\nmatch count.\n"},
  {"SetUncheckedElements", PyvtkSMStringVectorProperty_SetUncheckedElements, METH_VARARGS,
   "SetUncheckedElements(self, newvalue:(str, ...)) -> int\nC++: int SetUncheckedElements(\n    const std::vector<std::string> &newvalue)\nSetUncheckedElements(self, list:vtkStringList) -> int\nC++: int SetUncheckedElements(vtkStringList *list)\n\n"},
  {"AppendElements", PyvtkSMStringVectorProperty_AppendElements, METH_VARARGS,
   "AppendElements(self, newvalue:(str, ...)) -> int\nC++: int AppendElements(const std::vector<std::string> &newvalue)\n\nAppend the values. The vector is resized as necessary.\n"},
  {"AppendUncheckedElements", PyvtkSMStringVectorProperty_AppendUncheckedElements, METH_VARARGS,
   "AppendUncheckedElements(self, newvalue:(str, ...)) -> int\nC++: int AppendUncheckedElements(\n    const std::vector<std::string> &newvalue)\n\nAppend the values to the unchecked elements. The vector is\nresized as necessary.\n"},
  {"GetElements", PyvtkSMStringVectorProperty_GetElements, METH_VARARGS,
   "GetElements(self, list:vtkStringList) -> None\nC++: void GetElements(vtkStringList *list)\nGetElements(self) -> (str, ...)\nC++: const std::vector<std::string> &GetElements()\n\nFills up the vtkStringList instance with the current value.\n"},
  {"GetUncheckedElements", PyvtkSMStringVectorProperty_GetUncheckedElements, METH_VARARGS,
   "GetUncheckedElements(self) -> (str, ...)\nC++: const std::vector<std::string> &GetUncheckedElements()\nGetUncheckedElements(self, list:vtkStringList) -> None\nC++: void GetUncheckedElements(vtkStringList *list)\n\n"},
  {"GetElement", PyvtkSMStringVectorProperty_GetElement, METH_VARARGS,
   "GetElement(self, idx:int) -> str\nC++: const char *GetElement(unsigned int idx)\n\nReturns the value of 1 element.\n"},
  {"GetElementIndex", PyvtkSMStringVectorProperty_GetElementIndex, METH_VARARGS,
   "GetElementIndex(self, value:str, exists:int) -> int\nC++: unsigned int GetElementIndex(const char *value, int &exists)\n\nReturns the index of an element with a particular value. exists\nis set to false if element does not exist.\n"},
  {"SetElementType", PyvtkSMStringVectorProperty_SetElementType, METH_VARARGS,
   "SetElementType(self, idx:int, type:int) -> None\nC++: void SetElementType(unsigned int idx, int type)\n\nSet the cast type used when passing a value to the stream. For\nexample, if the type is INT, the string is converted to an int\n(with atoi()) before being passed to stream. Note that\nrepresenting scalar values as strings can result in loss of\naccuracy. Possible values are: INT, DOUBLE, STRING.\n"},
  {"GetElementType", PyvtkSMStringVectorProperty_GetElementType, METH_VARARGS,
   "GetElementType(self, idx:int) -> int\nC++: int GetElementType(unsigned int idx)\n\n"},
  {"GetUncheckedElement", PyvtkSMStringVectorProperty_GetUncheckedElement, METH_VARARGS,
   "GetUncheckedElement(self, idx:int) -> str\nC++: const char *GetUncheckedElement(unsigned int idx)\n\nReturns the value of 1 unchecked element. These are used by\ndomains. SetElement() first sets the value of 1 unchecked element\nand then calls IsInDomain and updates the value of the\ncorresponding element only if IsInDomain passes.\n"},
  {"SetUncheckedElement", PyvtkSMStringVectorProperty_SetUncheckedElement, METH_VARARGS,
   "SetUncheckedElement(self, idx:int, value:str) -> None\nC++: void SetUncheckedElement(unsigned int idx, const char *value)\n\nSet the value of 1 unchecked element. This can be used to check\nif a value is in all domains of the property. Call this and call\nIsInDomains().\n"},
  {"GetNumberOfUncheckedElements", PyvtkSMStringVectorProperty_GetNumberOfUncheckedElements, METH_VARARGS,
   "GetNumberOfUncheckedElements(self) -> int\nC++: unsigned int GetNumberOfUncheckedElements() override;\n\nReturns the size of unchecked elements. Usually this is the same\nas the number of elements but can be different before a domain\ncheck is performed.\n"},
  {"Copy", PyvtkSMStringVectorProperty_Copy, METH_VARARGS,
   "Copy(self, src:vtkSMProperty) -> None\nC++: void Copy(vtkSMProperty *src) override;\n\nCopy all property values.\n"},
  {"GetDefaultValue", PyvtkSMStringVectorProperty_GetDefaultValue, METH_VARARGS,
   "GetDefaultValue(self, idx:int) -> str\nC++: const char *GetDefaultValue(int idx)\n\nReturns the default value, if any, specified in the XML.\n"},
  {"ClearUncheckedElements", PyvtkSMStringVectorProperty_ClearUncheckedElements, METH_VARARGS,
   "ClearUncheckedElements(self) -> None\nC++: void ClearUncheckedElements() override;\n\nUse this method to clear unchecked values set of this property.\n"},
  {"IsValueDefault", PyvtkSMStringVectorProperty_IsValueDefault, METH_VARARGS,
   "IsValueDefault(self) -> bool\nC++: bool IsValueDefault() override;\n\nReturns true if the property's value is different from the\ndefault value. This is used as a hint by the state saving code to\ndetermine if the value should be written to the file or if the\ndefaults are sufficient.\n"},
  {"ResetToXMLDefaults", PyvtkSMStringVectorProperty_ResetToXMLDefaults, METH_VARARGS,
   "ResetToXMLDefaults(self) -> None\nC++: void ResetToXMLDefaults() override;\n\nFor properties that support specifying defaults in XML\nconfiguration, this method will reset the property value to the\ndefault values specified in the XML.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMStringVectorProperty_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("elements"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMStringVectorProperty_GetElements(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetElements\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("unchecked_elements"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMStringVectorProperty_GetUncheckedElements(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetUncheckedElements\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_elements"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMStringVectorProperty_GetNumberOfElements(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMStringVectorProperty_SetNumberOfElements(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMStringVectorProperty_SetNumberOfElements(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNumberOfElements/SetNumberOfElements\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_unchecked_elements"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMStringVectorProperty_GetNumberOfUncheckedElements(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfUncheckedElements\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMStringVectorProperty_Doc =
  "vtkSMStringVectorProperty - property representing a vector of strings\n\n"
  "Superclass: vtkSMVectorProperty\n\n"
  "vtkSMStringVectorProperty is a concrete sub-class of\n"
  "vtkSMVectorProperty representing a vector of strings.\n"
  "vtkSMStringVectorProperty can also be used to store double and int\n"
  "values as strings. The strings are converted to the appropriate type\n"
  "when they are being passed to the stream. This is generally used for\n"
  "calling methods that have mixed type arguments.\n"
  "@sa\n"
  "vtkSMVectorProperty vtkSMDoubleVectorProperty vtkSMIntVectorProperty\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMStringVectorProperty_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingServerManager.vtkSMStringVectorProperty", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMStringVectorProperty_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMStringVectorProperty_StaticNew()
{
  return vtkSMStringVectorProperty::New();
}

PyObject *PyvtkSMStringVectorProperty_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMStringVectorProperty_Type, PyvtkSMStringVectorProperty_Methods,
    "vtkSMStringVectorProperty",
 &PyvtkSMStringVectorProperty_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkSMVectorProperty_ClassNew();

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkSMStringVectorProperty_ElementTypes_Type);
  PyVTKEnum_Add(&PyvtkSMStringVectorProperty_ElementTypes_Type, "vtkSMStringVectorProperty.ElementTypes");

  o = (PyObject *)&PyvtkSMStringVectorProperty_ElementTypes_Type;
  if (PyDict_SetItemString(d, "ElementTypes", o) != 0)
  {
    Py_DECREF(o);
  }

  for (int c = 0; c < 3; c++)
  {
    typedef vtkSMStringVectorProperty::ElementTypes cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[3] = {
        { "INT", vtkSMStringVectorProperty::INT },
        { "DOUBLE", vtkSMStringVectorProperty::DOUBLE },
        { "STRING", vtkSMStringVectorProperty::STRING },
      };

    o = PyvtkSMStringVectorProperty_ElementTypes_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMStringVectorProperty_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMStringVectorProperty(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMStringVectorProperty_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMStringVectorProperty", o) != 0)
  {
    Py_DECREF(o);
  }

}

