// python wrapper for vtkXYChartRepresentation
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkXYChartRepresentation.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkXYChartRepresentation(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkXYChartRepresentation_ClassNew(); }

#ifndef DECLARED_PyvtkChartRepresentation_ClassNew
extern "C" { PyObject *PyvtkChartRepresentation_ClassNew(); }
#define DECLARED_PyvtkChartRepresentation_ClassNew
#endif

static PyObject *
PyvtkXYChartRepresentation_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkXYChartRepresentation::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkXYChartRepresentation::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkXYChartRepresentation *tempr = vtkXYChartRepresentation::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkXYChartRepresentation *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkXYChartRepresentation::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkXYChartRepresentation::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkXYChartRepresentation::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_SetVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetVisibility(temp0);
    }
    else
    {
      op->vtkXYChartRepresentation::SetVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_SetChartType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChartType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetChartType(temp0);
    }
    else
    {
      op->vtkXYChartRepresentation::SetChartType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_GetChartType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetChartType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetChartType() :
      op->vtkXYChartRepresentation::GetChartType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_SetChartTypeToLine(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChartTypeToLine");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetChartTypeToLine();
    }
    else
    {
      op->vtkXYChartRepresentation::SetChartTypeToLine();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_SetChartTypeToPoints(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChartTypeToPoints");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetChartTypeToPoints();
    }
    else
    {
      op->vtkXYChartRepresentation::SetChartTypeToPoints();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_SetChartTypeToBar(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChartTypeToBar");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetChartTypeToBar();
    }
    else
    {
      op->vtkXYChartRepresentation::SetChartTypeToBar();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_SetChartTypeToStacked(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChartTypeToStacked");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetChartTypeToStacked();
    }
    else
    {
      op->vtkXYChartRepresentation::SetChartTypeToStacked();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_SetChartTypeToBag(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChartTypeToBag");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetChartTypeToBag();
    }
    else
    {
      op->vtkXYChartRepresentation::SetChartTypeToBag();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_SetChartTypeToFunctionalBag(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChartTypeToFunctionalBag");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetChartTypeToFunctionalBag();
    }
    else
    {
      op->vtkXYChartRepresentation::SetChartTypeToFunctionalBag();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_SetChartTypeToArea(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChartTypeToArea");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetChartTypeToArea();
    }
    else
    {
      op->vtkXYChartRepresentation::SetChartTypeToArea();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_GetChart(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetChart");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkChartXY *tempr = (ap.IsBound() ?
      op->GetChart() :
      op->vtkXYChartRepresentation::GetChart());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_SetXAxisSeriesName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetXAxisSeriesName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetXAxisSeriesName(temp0);
    }
    else
    {
      op->vtkXYChartRepresentation::SetXAxisSeriesName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_GetXAxisSeriesName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetXAxisSeriesName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetXAxisSeriesName() :
      op->vtkXYChartRepresentation::GetXAxisSeriesName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_SetUseIndexForXAxis(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseIndexForXAxis");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseIndexForXAxis(temp0);
    }
    else
    {
      op->vtkXYChartRepresentation::SetUseIndexForXAxis(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_GetUseIndexForXAxis(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseIndexForXAxis");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseIndexForXAxis() :
      op->vtkXYChartRepresentation::GetUseIndexForXAxis());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_SetSortDataByXAxis(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSortDataByXAxis");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSortDataByXAxis(temp0);
    }
    else
    {
      op->vtkXYChartRepresentation::SetSortDataByXAxis(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_GetSortDataByXAxis(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSortDataByXAxis");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetSortDataByXAxis() :
      op->vtkXYChartRepresentation::GetSortDataByXAxis());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_SetSeriesVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSeriesVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  const char *temp0 = nullptr;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetSeriesVisibility(temp0, temp1);
    }
    else
    {
      op->vtkXYChartRepresentation::SetSeriesVisibility(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_SetLineThickness(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLineThickness");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  const char *temp0 = nullptr;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetLineThickness(temp0, temp1);
    }
    else
    {
      op->vtkXYChartRepresentation::SetLineThickness(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_SetLineStyle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLineStyle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetLineStyle(temp0, temp1);
    }
    else
    {
      op->vtkXYChartRepresentation::SetLineStyle(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_SetColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  const char *temp0 = nullptr;
  double temp1;
  double temp2;
  double temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetColor(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkXYChartRepresentation::SetColor(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_SetOpacity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOpacity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  const char *temp0 = nullptr;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetOpacity(temp0, temp1);
    }
    else
    {
      op->vtkXYChartRepresentation::SetOpacity(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_SetAxisCorner(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisCorner");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetAxisCorner(temp0, temp1);
    }
    else
    {
      op->vtkXYChartRepresentation::SetAxisCorner(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_SetMarkerStyle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMarkerStyle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetMarkerStyle(temp0, temp1);
    }
    else
    {
      op->vtkXYChartRepresentation::SetMarkerStyle(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_SetMarkerSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMarkerSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  const char *temp0 = nullptr;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetMarkerSize(temp0, temp1);
    }
    else
    {
      op->vtkXYChartRepresentation::SetMarkerSize(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_SetLabel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLabel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  const char *temp0 = nullptr;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetLabel(temp0, temp1);
    }
    else
    {
      op->vtkXYChartRepresentation::SetLabel(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_SetUseColorMapping(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseColorMapping");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  const char *temp0 = nullptr;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetUseColorMapping(temp0, temp1);
    }
    else
    {
      op->vtkXYChartRepresentation::SetUseColorMapping(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_SetLookupTable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLookupTable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  const char *temp0 = nullptr;
  vtkScalarsToColors *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkScalarsToColors"))
  {
    if (ap.IsBound())
    {
      op->SetLookupTable(temp0, temp1);
    }
    else
    {
      op->vtkXYChartRepresentation::SetLookupTable(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_GetLabel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLabel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetLabel(temp0) :
      op->vtkXYChartRepresentation::GetLabel(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_ClearSeriesVisibilities(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearSeriesVisibilities");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearSeriesVisibilities();
    }
    else
    {
      op->vtkXYChartRepresentation::ClearSeriesVisibilities();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_ClearLineThicknesses(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearLineThicknesses");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearLineThicknesses();
    }
    else
    {
      op->vtkXYChartRepresentation::ClearLineThicknesses();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_ClearLineStyles(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearLineStyles");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearLineStyles();
    }
    else
    {
      op->vtkXYChartRepresentation::ClearLineStyles();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_ClearColors(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearColors");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearColors();
    }
    else
    {
      op->vtkXYChartRepresentation::ClearColors();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_ClearOpacities(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearOpacities");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearOpacities();
    }
    else
    {
      op->vtkXYChartRepresentation::ClearOpacities();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_ClearAxisCorners(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearAxisCorners");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearAxisCorners();
    }
    else
    {
      op->vtkXYChartRepresentation::ClearAxisCorners();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_ClearMarkerSizes(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearMarkerSizes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearMarkerSizes();
    }
    else
    {
      op->vtkXYChartRepresentation::ClearMarkerSizes();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_ClearMarkerStyles(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearMarkerStyles");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearMarkerStyles();
    }
    else
    {
      op->vtkXYChartRepresentation::ClearMarkerStyles();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_ClearLabels(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearLabels");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearLabels();
    }
    else
    {
      op->vtkXYChartRepresentation::ClearLabels();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_SetSelectionColor_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSelectionColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetSelectionColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkXYChartRepresentation::SetSelectionColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkXYChartRepresentation_SetSelectionColor_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSelectionColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetSelectionColor(temp0);
    }
    else
    {
      op->vtkXYChartRepresentation::SetSelectionColor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkXYChartRepresentation_SetSelectionColor(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkXYChartRepresentation_SetSelectionColor_s1(self, args);
    case 1:
      return PyvtkXYChartRepresentation_SetSelectionColor_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetSelectionColor");
  return nullptr;
}


static PyObject *
PyvtkXYChartRepresentation_GetSelectionColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSelectionColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetSelectionColor() :
      op->vtkXYChartRepresentation::GetSelectionColor());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_SetSeriesLabelPrefix(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSeriesLabelPrefix");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSeriesLabelPrefix(temp0);
    }
    else
    {
      op->vtkXYChartRepresentation::SetSeriesLabelPrefix(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_GetSeriesLabelPrefix(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSeriesLabelPrefix");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetSeriesLabelPrefix() :
      op->vtkXYChartRepresentation::GetSeriesLabelPrefix());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXYChartRepresentation_Export(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Export");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkXYChartRepresentation *op = static_cast<vtkXYChartRepresentation *>(vp);

  vtkAbstractChartExporter *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkAbstractChartExporter"))
  {
    bool tempr = (ap.IsBound() ?
      op->Export(temp0) :
      op->vtkXYChartRepresentation::Export(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkXYChartRepresentation_Methods[] = {
  {"IsTypeOf", PyvtkXYChartRepresentation_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkXYChartRepresentation_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkXYChartRepresentation_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkXYChartRepresentation\nC++: static vtkXYChartRepresentation *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkXYChartRepresentation_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkXYChartRepresentation\nC++: vtkXYChartRepresentation *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkXYChartRepresentation_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkXYChartRepresentation_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetVisibility", PyvtkXYChartRepresentation_SetVisibility, METH_VARARGS,
   "SetVisibility(self, visible:bool) -> None\nC++: void SetVisibility(bool visible) override;\n\nSet visibility of the representation. Overridden to ensure that\ninternally added vtkPlot instances are updated when hiding the\nrepresentation.\n"},
  {"SetChartType", PyvtkXYChartRepresentation_SetChartType, METH_VARARGS,
   "SetChartType(self, _arg:int) -> None\nC++: virtual void SetChartType(int _arg)\n\nGet/Set the chart type, defaults to line chart. This must be set\nbefore this representation is updated. Valid values are\nvtkChart::LINE, vtkChart::POINTS, vtkChart::BAR, etc. Default is\nvtkChart::LINE.\n"},
  {"GetChartType", PyvtkXYChartRepresentation_GetChartType, METH_VARARGS,
   "GetChartType(self) -> int\nC++: virtual int GetChartType()\n\n"},
  {"SetChartTypeToLine", PyvtkXYChartRepresentation_SetChartTypeToLine, METH_VARARGS,
   "SetChartTypeToLine(self) -> None\nC++: void SetChartTypeToLine()\n\n"},
  {"SetChartTypeToPoints", PyvtkXYChartRepresentation_SetChartTypeToPoints, METH_VARARGS,
   "SetChartTypeToPoints(self) -> None\nC++: void SetChartTypeToPoints()\n\n"},
  {"SetChartTypeToBar", PyvtkXYChartRepresentation_SetChartTypeToBar, METH_VARARGS,
   "SetChartTypeToBar(self) -> None\nC++: void SetChartTypeToBar()\n\n"},
  {"SetChartTypeToStacked", PyvtkXYChartRepresentation_SetChartTypeToStacked, METH_VARARGS,
   "SetChartTypeToStacked(self) -> None\nC++: void SetChartTypeToStacked()\n\n"},
  {"SetChartTypeToBag", PyvtkXYChartRepresentation_SetChartTypeToBag, METH_VARARGS,
   "SetChartTypeToBag(self) -> None\nC++: void SetChartTypeToBag()\n\n"},
  {"SetChartTypeToFunctionalBag", PyvtkXYChartRepresentation_SetChartTypeToFunctionalBag, METH_VARARGS,
   "SetChartTypeToFunctionalBag(self) -> None\nC++: void SetChartTypeToFunctionalBag()\n\n"},
  {"SetChartTypeToArea", PyvtkXYChartRepresentation_SetChartTypeToArea, METH_VARARGS,
   "SetChartTypeToArea(self) -> None\nC++: void SetChartTypeToArea()\n\n"},
  {"GetChart", PyvtkXYChartRepresentation_GetChart, METH_VARARGS,
   "GetChart(self) -> vtkChartXY\nC++: vtkChartXY *GetChart()\n\nReturns the vtkChartXY instance from the view to which this\nrepresentation is added. Thus this will return a non-null value\nonly when this representation is added to a view.\n"},
  {"SetXAxisSeriesName", PyvtkXYChartRepresentation_SetXAxisSeriesName, METH_VARARGS,
   "SetXAxisSeriesName(self, _arg:str) -> None\nC++: virtual void SetXAxisSeriesName(const char *_arg)\n\nSet the series to use as the X-axis.\n"},
  {"GetXAxisSeriesName", PyvtkXYChartRepresentation_GetXAxisSeriesName, METH_VARARGS,
   "GetXAxisSeriesName(self) -> str\nC++: virtual char *GetXAxisSeriesName()\n\n"},
  {"SetUseIndexForXAxis", PyvtkXYChartRepresentation_SetUseIndexForXAxis, METH_VARARGS,
   "SetUseIndexForXAxis(self, _arg:bool) -> None\nC++: virtual void SetUseIndexForXAxis(bool _arg)\n\nSet whether the index should be used for the x axis. When true,\nXSeriesName is ignored.\n"},
  {"GetUseIndexForXAxis", PyvtkXYChartRepresentation_GetUseIndexForXAxis, METH_VARARGS,
   "GetUseIndexForXAxis(self) -> bool\nC++: virtual bool GetUseIndexForXAxis()\n\n"},
  {"SetSortDataByXAxis", PyvtkXYChartRepresentation_SetSortDataByXAxis, METH_VARARGS,
   "SetSortDataByXAxis(self, val:bool) -> None\nC++: void SetSortDataByXAxis(bool val)\n\nGet/set whether the points in the chart should be sorted by their\nx-axis value. Points are connected in line plots in the order\nthey are in the table.  Sorting by the x-axis allows the line to\nhave no cycles.\n"},
  {"GetSortDataByXAxis", PyvtkXYChartRepresentation_GetSortDataByXAxis, METH_VARARGS,
   "GetSortDataByXAxis(self) -> bool\nC++: virtual bool GetSortDataByXAxis()\n\n"},
  {"SetSeriesVisibility", PyvtkXYChartRepresentation_SetSeriesVisibility, METH_VARARGS,
   "SetSeriesVisibility(self, seriesname:str, visible:bool) -> None\nC++: void SetSeriesVisibility(const char *seriesname,\n    bool visible)\n\nSet/Clear the properties for Y series/columns.\n"},
  {"SetLineThickness", PyvtkXYChartRepresentation_SetLineThickness, METH_VARARGS,
   "SetLineThickness(self, name:str, value:float) -> None\nC++: void SetLineThickness(const char *name, double value)\n\n"},
  {"SetLineStyle", PyvtkXYChartRepresentation_SetLineStyle, METH_VARARGS,
   "SetLineStyle(self, name:str, value:int) -> None\nC++: void SetLineStyle(const char *name, int value)\n\n"},
  {"SetColor", PyvtkXYChartRepresentation_SetColor, METH_VARARGS,
   "SetColor(self, name:str, r:float, g:float, b:float) -> None\nC++: void SetColor(const char *name, double r, double g, double b)\n\n"},
  {"SetOpacity", PyvtkXYChartRepresentation_SetOpacity, METH_VARARGS,
   "SetOpacity(self, seriesname:str, opacity:float) -> None\nC++: void SetOpacity(const char *seriesname, double opacity)\n\n"},
  {"SetAxisCorner", PyvtkXYChartRepresentation_SetAxisCorner, METH_VARARGS,
   "SetAxisCorner(self, name:str, corner:int) -> None\nC++: void SetAxisCorner(const char *name, int corner)\n\n"},
  {"SetMarkerStyle", PyvtkXYChartRepresentation_SetMarkerStyle, METH_VARARGS,
   "SetMarkerStyle(self, name:str, style:int) -> None\nC++: void SetMarkerStyle(const char *name, int style)\n\n"},
  {"SetMarkerSize", PyvtkXYChartRepresentation_SetMarkerSize, METH_VARARGS,
   "SetMarkerSize(self, name:str, value:float) -> None\nC++: void SetMarkerSize(const char *name, double value)\n\n"},
  {"SetLabel", PyvtkXYChartRepresentation_SetLabel, METH_VARARGS,
   "SetLabel(self, name:str, label:str) -> None\nC++: void SetLabel(const char *name, const char *label)\n\n"},
  {"SetUseColorMapping", PyvtkXYChartRepresentation_SetUseColorMapping, METH_VARARGS,
   "SetUseColorMapping(self, name:str, useColorMapping:bool) -> None\nC++: void SetUseColorMapping(const char *name,\n    bool useColorMapping)\n\n"},
  {"SetLookupTable", PyvtkXYChartRepresentation_SetLookupTable, METH_VARARGS,
   "SetLookupTable(self, name:str, lut:vtkScalarsToColors) -> None\nC++: void SetLookupTable(const char *name,\n    vtkScalarsToColors *lut)\n\n"},
  {"GetLabel", PyvtkXYChartRepresentation_GetLabel, METH_VARARGS,
   "GetLabel(self, name:str) -> str\nC++: const char *GetLabel(const char *name)\n\n"},
  {"ClearSeriesVisibilities", PyvtkXYChartRepresentation_ClearSeriesVisibilities, METH_VARARGS,
   "ClearSeriesVisibilities(self) -> None\nC++: void ClearSeriesVisibilities()\n\n"},
  {"ClearLineThicknesses", PyvtkXYChartRepresentation_ClearLineThicknesses, METH_VARARGS,
   "ClearLineThicknesses(self) -> None\nC++: void ClearLineThicknesses()\n\n"},
  {"ClearLineStyles", PyvtkXYChartRepresentation_ClearLineStyles, METH_VARARGS,
   "ClearLineStyles(self) -> None\nC++: void ClearLineStyles()\n\n"},
  {"ClearColors", PyvtkXYChartRepresentation_ClearColors, METH_VARARGS,
   "ClearColors(self) -> None\nC++: void ClearColors()\n\n"},
  {"ClearOpacities", PyvtkXYChartRepresentation_ClearOpacities, METH_VARARGS,
   "ClearOpacities(self) -> None\nC++: void ClearOpacities()\n\n"},
  {"ClearAxisCorners", PyvtkXYChartRepresentation_ClearAxisCorners, METH_VARARGS,
   "ClearAxisCorners(self) -> None\nC++: void ClearAxisCorners()\n\n"},
  {"ClearMarkerSizes", PyvtkXYChartRepresentation_ClearMarkerSizes, METH_VARARGS,
   "ClearMarkerSizes(self) -> None\nC++: void ClearMarkerSizes()\n\n"},
  {"ClearMarkerStyles", PyvtkXYChartRepresentation_ClearMarkerStyles, METH_VARARGS,
   "ClearMarkerStyles(self) -> None\nC++: void ClearMarkerStyles()\n\n"},
  {"ClearLabels", PyvtkXYChartRepresentation_ClearLabels, METH_VARARGS,
   "ClearLabels(self) -> None\nC++: void ClearLabels()\n\n"},
  {"SetSelectionColor", PyvtkXYChartRepresentation_SetSelectionColor, METH_VARARGS,
   "SetSelectionColor(self, _arg1:float, _arg2:float, _arg3:float)\n    -> None\nC++: virtual void SetSelectionColor(double _arg1, double _arg2,\n    double _arg3)\nSetSelectionColor(self, _arg:(float, float, float)) -> None\nC++: virtual void SetSelectionColor(const double _arg[3])\n\n"},
  {"GetSelectionColor", PyvtkXYChartRepresentation_GetSelectionColor, METH_VARARGS,
   "GetSelectionColor(self) -> (float, float, float)\nC++: virtual double *GetSelectionColor()\n\n"},
  {"SetSeriesLabelPrefix", PyvtkXYChartRepresentation_SetSeriesLabelPrefix, METH_VARARGS,
   "SetSeriesLabelPrefix(self, _arg:str) -> None\nC++: virtual void SetSeriesLabelPrefix(const char *_arg)\n\nGet/Set the series label prefix.\n"},
  {"GetSeriesLabelPrefix", PyvtkXYChartRepresentation_GetSeriesLabelPrefix, METH_VARARGS,
   "GetSeriesLabelPrefix(self) -> str\nC++: virtual char *GetSeriesLabelPrefix()\n\n"},
  {"Export", PyvtkXYChartRepresentation_Export, METH_VARARGS,
   "Export(self, exporter:vtkAbstractChartExporter) -> bool\nC++: bool Export(vtkAbstractChartExporter *exporter) override;\n\nCalled by vtkPVContextView::Export() to export the\nrepresentation's data to a CSV file. Return false on failure\nwhich will call the exporting process to abort and raise an\nerror. Default implementation simply returns false.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkXYChartRepresentation_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkXYChartRepresentation_SetVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkXYChartRepresentation_SetVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("chart_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkXYChartRepresentation_GetChartType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkXYChartRepresentation_SetChartType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkXYChartRepresentation_SetChartType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetChartType/SetChartType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("x_axis_series_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkXYChartRepresentation_GetXAxisSeriesName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkXYChartRepresentation_SetXAxisSeriesName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkXYChartRepresentation_SetXAxisSeriesName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetXAxisSeriesName/SetXAxisSeriesName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_index_for_x_axis"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkXYChartRepresentation_GetUseIndexForXAxis(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkXYChartRepresentation_SetUseIndexForXAxis(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkXYChartRepresentation_SetUseIndexForXAxis(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseIndexForXAxis/SetUseIndexForXAxis\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("sort_data_by_x_axis"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkXYChartRepresentation_GetSortDataByXAxis(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkXYChartRepresentation_SetSortDataByXAxis(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkXYChartRepresentation_SetSortDataByXAxis(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSortDataByXAxis/SetSortDataByXAxis\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("selection_color"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkXYChartRepresentation_GetSelectionColor(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkXYChartRepresentation_SetSelectionColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkXYChartRepresentation_SetSelectionColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSelectionColor/SetSelectionColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("series_label_prefix"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkXYChartRepresentation_GetSeriesLabelPrefix(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkXYChartRepresentation_SetSeriesLabelPrefix(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkXYChartRepresentation_SetSeriesLabelPrefix(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSeriesLabelPrefix/SetSeriesLabelPrefix\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("chart"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkXYChartRepresentation_GetChart(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetChart\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkXYChartRepresentation_Doc =
  "vtkXYChartRepresentation - vtkXYChartRepresentation is representation\nthat is used to add vtkPlot subclasses to a vtkChartXY instance e.g.\n\n"
  "Superclass: vtkChartRepresentation\n\n"
  "adding vtkPlotBar to create a bar chart or vtkPlotLine to create a\n"
  "line chart. For every selected series (or column in a vtkTable), this\n"
  "class adds a new vtkPlot to the vtkChartXY. vtkXYChartRepresentation\n"
  "provides a union of APIs for changing the appearance of vtkPlot\n"
  "instances. Developers should only expose the applicable API in the\n"
  "ServerManager XML.\n\n"
  "To select which type of vtkPlot instances this class will use, you\n"
  "must set the ChartType. Refer to vtkChartXY::AddPlot() for details on\n"
  "what the type must be.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkXYChartRepresentation_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkXYChartRepresentation", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkXYChartRepresentation_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkXYChartRepresentation_StaticNew()
{
  return vtkXYChartRepresentation::New();
}

PyObject *PyvtkXYChartRepresentation_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkXYChartRepresentation_Type, PyvtkXYChartRepresentation_Methods,
    "vtkXYChartRepresentation",
 &PyvtkXYChartRepresentation_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkChartRepresentation_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkXYChartRepresentation_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkXYChartRepresentation(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkXYChartRepresentation_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkXYChartRepresentation", o) != 0)
  {
    Py_DECREF(o);
  }

}

