// ClientServer wrapper for vtkOpenGLShaderProperty object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkOpenGLShaderProperty.h"
#include "vtkSystemIncludes.h"
#include "vtkStdString.h"
#include "vtkClientServerInterpreter.h"
#include "vtkClientServerStream.h"


static vtkObjectBase *vtkOpenGLShaderPropertyClientServerNewCommand(void* /*ctx*/)
{
  return vtkOpenGLShaderProperty::New();
}


static int vtkOpenGLShaderPropertyCommand(
  vtkClientServerInterpreter *arlu, vtkObjectBase *ob,
  const char *method, const vtkClientServerStream& msg,
  vtkClientServerStream& resultStream, void* /*ctx*/)
{
  vtkOpenGLShaderProperty *op = vtkOpenGLShaderProperty::SafeDownCast(ob);
  if(!op)
    {
    vtkOStrStreamWrapper vtkmsg;
    vtkmsg << "Cannot cast " << ob->GetClassName() << " object to vtkOpenGLShaderProperty.  "
           << "This probably means the class specifies the incorrect superclass in vtkTypeMacro.";
    resultStream.Reset();
    resultStream << vtkClientServerStream::Error
                 << vtkmsg.str() << 0 << vtkClientServerStream::End;
    return 0;
    }
  (void)arlu;
  if (!strcmp("IsTypeOf",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    int      temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = vtkOpenGLShaderProperty::IsTypeOf(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("IsA",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    int      temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->IsA(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SafeDownCast",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkObjectBase  *temp0;
    vtkOpenGLShaderProperty  *temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkObjectBase"))
      {
      temp20 = vtkOpenGLShaderProperty::SafeDownCast(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("NewInstance",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkOpenGLShaderProperty  *temp20;
      {
      temp20 = (op)->NewInstance();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNumberOfGenerationsFromBaseType",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    long long   temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = vtkOpenGLShaderProperty::GetNumberOfGenerationsFromBaseType(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNumberOfGenerationsFromBase",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    long long   temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->GetNumberOfGenerationsFromBase(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("New",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkOpenGLShaderProperty  *temp20;
      {
      temp20 = vtkOpenGLShaderProperty::New();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("DeepCopy",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkOpenGLShaderProperty  *temp0;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkOpenGLShaderProperty"))
      {
      op->DeepCopy(temp0);
      return 1;
      }
    }
  if (!strcmp("AddVertexShaderReplacement",method) && msg.GetNumberOfArguments(0) == 6)
    {
    char    *temp0;
    bool   temp1;
    char    *temp2;
    bool   temp3;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1) &&
      msg.GetArgument(0, 4, &temp2) &&
      msg.GetArgument(0, 5, &temp3))
      {
      op->AddVertexShaderReplacement(static_cast<std::string>(vtkStdString(temp0)),temp1,static_cast<std::string>(vtkStdString(temp2)),temp3);
      return 1;
      }
    }
  if (!strcmp("AddFragmentShaderReplacement",method) && msg.GetNumberOfArguments(0) == 6)
    {
    char    *temp0;
    bool   temp1;
    char    *temp2;
    bool   temp3;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1) &&
      msg.GetArgument(0, 4, &temp2) &&
      msg.GetArgument(0, 5, &temp3))
      {
      op->AddFragmentShaderReplacement(static_cast<std::string>(vtkStdString(temp0)),temp1,static_cast<std::string>(vtkStdString(temp2)),temp3);
      return 1;
      }
    }
  if (!strcmp("AddGeometryShaderReplacement",method) && msg.GetNumberOfArguments(0) == 6)
    {
    char    *temp0;
    bool   temp1;
    char    *temp2;
    bool   temp3;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1) &&
      msg.GetArgument(0, 4, &temp2) &&
      msg.GetArgument(0, 5, &temp3))
      {
      op->AddGeometryShaderReplacement(static_cast<std::string>(vtkStdString(temp0)),temp1,static_cast<std::string>(vtkStdString(temp2)),temp3);
      return 1;
      }
    }
  if (!strcmp("AddTessControlShaderReplacement",method) && msg.GetNumberOfArguments(0) == 6)
    {
    char    *temp0;
    bool   temp1;
    char    *temp2;
    bool   temp3;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1) &&
      msg.GetArgument(0, 4, &temp2) &&
      msg.GetArgument(0, 5, &temp3))
      {
      op->AddTessControlShaderReplacement(static_cast<std::string>(vtkStdString(temp0)),temp1,static_cast<std::string>(vtkStdString(temp2)),temp3);
      return 1;
      }
    }
  if (!strcmp("AddTessEvaluationShaderReplacement",method) && msg.GetNumberOfArguments(0) == 6)
    {
    char    *temp0;
    bool   temp1;
    char    *temp2;
    bool   temp3;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1) &&
      msg.GetArgument(0, 4, &temp2) &&
      msg.GetArgument(0, 5, &temp3))
      {
      op->AddTessEvaluationShaderReplacement(static_cast<std::string>(vtkStdString(temp0)),temp1,static_cast<std::string>(vtkStdString(temp2)),temp3);
      return 1;
      }
    }
  if (!strcmp("GetNumberOfShaderReplacements",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetNumberOfShaderReplacements();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNthShaderReplacementTypeAsString",method) && msg.GetNumberOfArguments(0) == 3)
    {
    long long   temp0;
    std::string   temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->GetNthShaderReplacementTypeAsString(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("ClearVertexShaderReplacement",method) && msg.GetNumberOfArguments(0) == 4)
    {
    char    *temp0;
    bool   temp1;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1))
      {
      op->ClearVertexShaderReplacement(static_cast<std::string>(vtkStdString(temp0)),temp1);
      return 1;
      }
    }
  if (!strcmp("ClearFragmentShaderReplacement",method) && msg.GetNumberOfArguments(0) == 4)
    {
    char    *temp0;
    bool   temp1;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1))
      {
      op->ClearFragmentShaderReplacement(static_cast<std::string>(vtkStdString(temp0)),temp1);
      return 1;
      }
    }
  if (!strcmp("ClearGeometryShaderReplacement",method) && msg.GetNumberOfArguments(0) == 4)
    {
    char    *temp0;
    bool   temp1;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1))
      {
      op->ClearGeometryShaderReplacement(static_cast<std::string>(vtkStdString(temp0)),temp1);
      return 1;
      }
    }
  if (!strcmp("ClearTessControlShaderReplacement",method) && msg.GetNumberOfArguments(0) == 4)
    {
    char    *temp0;
    bool   temp1;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1))
      {
      op->ClearTessControlShaderReplacement(static_cast<std::string>(vtkStdString(temp0)),temp1);
      return 1;
      }
    }
  if (!strcmp("ClearTessEvaluationShaderReplacement",method) && msg.GetNumberOfArguments(0) == 4)
    {
    char    *temp0;
    bool   temp1;
    if(msg.GetArgument(0, 2, &temp0) &&
      msg.GetArgument(0, 3, &temp1))
      {
      op->ClearTessEvaluationShaderReplacement(static_cast<std::string>(vtkStdString(temp0)),temp1);
      return 1;
      }
    }
  if (!strcmp("ClearAllVertexShaderReplacements",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ClearAllVertexShaderReplacements();
      return 1;
      }
    }
  if (!strcmp("ClearAllFragmentShaderReplacements",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ClearAllFragmentShaderReplacements();
      return 1;
      }
    }
  if (!strcmp("ClearAllGeometryShaderReplacements",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ClearAllGeometryShaderReplacements();
      return 1;
      }
    }
  if (!strcmp("ClearAllTessControlShaderReplacements",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ClearAllTessControlShaderReplacements();
      return 1;
      }
    }
  if (!strcmp("ClearAllTessEvalShaderReplacements",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ClearAllTessEvalShaderReplacements();
      return 1;
      }
    }
  if (!strcmp("ClearAllShaderReplacements",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ClearAllShaderReplacements();
      return 1;
      }
    }

  {
    const char* commandName = "vtkShaderProperty";
    if (arlu->HasCommandFunction(commandName) &&
        arlu->CallCommandFunction(commandName, op, method, msg, resultStream)) { return 1; }
  }
  if(resultStream.GetNumberOfMessages() > 0 &&
     resultStream.GetCommand(0) == vtkClientServerStream::Error &&
     resultStream.GetNumberOfArguments(0) > 1)
    {
    /* A superclass wrapper prepared a special message. */
    return 0;
    }
  vtkOStrStreamWrapper vtkmsg;
  vtkmsg << "Object type: vtkOpenGLShaderProperty, could not find requested method: \""
         << method << "\"\nor the method was called with incorrect arguments.\n";
  resultStream.Reset();
  resultStream << vtkClientServerStream::Error
               << vtkmsg.str() << vtkClientServerStream::End;
  vtkmsg.rdbuf()->freeze(0);
  return 0;
}


//-------------------------------------------------------------------------auto
extern "C"
{
VTK_ABI_HIDDEN void vtkOpenGLShaderProperty_Init(vtkClientServerInterpreter* csi)
{
  static vtkClientServerInterpreter* last = nullptr;
  if(last != csi)
    {
    last = csi;
    csi->AddNewInstanceFunction("vtkOpenGLShaderProperty", vtkOpenGLShaderPropertyClientServerNewCommand);
    csi->AddCommandFunction("vtkOpenGLShaderProperty", vtkOpenGLShaderPropertyCommand);
    }
}
}
