// printing/mojom/print.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef PRINTING_MOJOM_PRINT_MOJOM_SHARED_H_
#define PRINTING_MOJOM_PRINT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "printing/mojom/print.mojom-shared-internal.h"







namespace printing {
namespace mojom {
class PageSizeMarginsDataView;



}  // namespace mojom
}  // namespace printing

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::printing::mojom::PageSizeMarginsDataView> {
  using Data = ::printing::mojom::internal::PageSizeMargins_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace printing {
namespace mojom {


enum class ColorModel : int32_t {
  
  kUnknownColorModel = 0,
  
  kGray = 1,
  
  kColor = 2,
  
  kCMYK = 3,
  
  kCMY = 4,
  
  kKCMY = 5,
  
  kCMYPlusK = 6,
  
  kBlack = 7,
  
  kGrayscale = 8,
  
  kRGB = 9,
  
  kRGB16 = 10,
  
  kRGBA = 11,
  
  kColorModeColor = 12,
  
  kColorModeMonochrome = 13,
  
  kHPColorColor = 14,
  
  kHPColorBlack = 15,
  
  kPrintoutModeNormal = 16,
  
  kPrintoutModeNormalGray = 17,
  
  kProcessColorModelCMYK = 18,
  
  kProcessColorModelGreyscale = 19,
  
  kProcessColorModelRGB = 20,
  
  kBrotherCUPSColor = 21,
  
  kBrotherCUPSMono = 22,
  
  kBrotherBRScript3Color = 23,
  
  kBrotherBRScript3Black = 24,
  
  kEpsonInkColor = 25,
  
  kEpsonInkMono = 26,
  
  kSharpARCModeCMColor = 27,
  
  kSharpARCModeCMBW = 28,
  
  kXeroxXRXColorAutomatic = 29,
  
  kXeroxXRXColorBW = 30,
  
  kColorModelLast = 30,
  kMinValue = 0,
  kMaxValue = 30,
};

 std::ostream& operator<<(std::ostream& os, ColorModel value);
inline bool IsKnownEnumValue(ColorModel value) {
  return internal::ColorModel_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class DuplexMode : int32_t {
  
  kUnknownDuplexMode = -1,
  
  kSimplex = 0,
  
  kLongEdge = 1,
  
  kShortEdge = 2,
  kMinValue = -1,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, DuplexMode value);
inline bool IsKnownEnumValue(DuplexMode value) {
  return internal::DuplexMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PageOrientation : int32_t {
  
  kUpright = 0,
  
  kRotateLeft = 1,
  
  kRotateRight = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, PageOrientation value);
inline bool IsKnownEnumValue(PageOrientation value) {
  return internal::PageOrientation_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PrintScalingOption : int32_t {
  
  kNone = 0,
  
  kFitToPrintableArea = 1,
  
  kSourceSize = 2,
  
  kFitToPaper = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, PrintScalingOption value);
inline bool IsKnownEnumValue(PrintScalingOption value) {
  return internal::PrintScalingOption_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SkiaDocumentType : int32_t {
  
  kPDF = 0,
  
  kMSKP = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, SkiaDocumentType value);
inline bool IsKnownEnumValue(SkiaDocumentType value) {
  return internal::SkiaDocumentType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MarginType : int32_t {
  
  kDefaultMargins = 0,
  
  kNoMargins = 1,
  
  kPrintableAreaMargins = 2,
  
  kCustomMargins = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, MarginType value);
inline bool IsKnownEnumValue(MarginType value) {
  return internal::MarginType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class PageSizeMarginsDataView {
 public:
  PageSizeMarginsDataView() {}

  PageSizeMarginsDataView(
      internal::PageSizeMargins_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  double content_width() const {
    return data_->content_width;
  }
  double content_height() const {
    return data_->content_height;
  }
  double margin_top() const {
    return data_->margin_top;
  }
  double margin_right() const {
    return data_->margin_right;
  }
  double margin_bottom() const {
    return data_->margin_bottom;
  }
  double margin_left() const {
    return data_->margin_left;
  }
 private:
  internal::PageSizeMargins_Data* data_ = nullptr;
};



}  // namespace mojom
}  // namespace printing

namespace std {

template <>
struct hash<::printing::mojom::ColorModel>
    : public mojo::internal::EnumHashImpl<::printing::mojom::ColorModel> {};

template <>
struct hash<::printing::mojom::DuplexMode>
    : public mojo::internal::EnumHashImpl<::printing::mojom::DuplexMode> {};

template <>
struct hash<::printing::mojom::PageOrientation>
    : public mojo::internal::EnumHashImpl<::printing::mojom::PageOrientation> {};

template <>
struct hash<::printing::mojom::PrintScalingOption>
    : public mojo::internal::EnumHashImpl<::printing::mojom::PrintScalingOption> {};

template <>
struct hash<::printing::mojom::SkiaDocumentType>
    : public mojo::internal::EnumHashImpl<::printing::mojom::SkiaDocumentType> {};

template <>
struct hash<::printing::mojom::MarginType>
    : public mojo::internal::EnumHashImpl<::printing::mojom::MarginType> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::printing::mojom::ColorModel, ::printing::mojom::ColorModel> {
  static ::printing::mojom::ColorModel ToMojom(::printing::mojom::ColorModel input) { return input; }
  static bool FromMojom(::printing::mojom::ColorModel input, ::printing::mojom::ColorModel* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::ColorModel, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::printing::mojom::ColorModel, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::printing::mojom::ColorModel>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::printing::mojom::DuplexMode, ::printing::mojom::DuplexMode> {
  static ::printing::mojom::DuplexMode ToMojom(::printing::mojom::DuplexMode input) { return input; }
  static bool FromMojom(::printing::mojom::DuplexMode input, ::printing::mojom::DuplexMode* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::DuplexMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::printing::mojom::DuplexMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::printing::mojom::DuplexMode>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::printing::mojom::PageOrientation, ::printing::mojom::PageOrientation> {
  static ::printing::mojom::PageOrientation ToMojom(::printing::mojom::PageOrientation input) { return input; }
  static bool FromMojom(::printing::mojom::PageOrientation input, ::printing::mojom::PageOrientation* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PageOrientation, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::printing::mojom::PageOrientation, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::printing::mojom::PageOrientation>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::printing::mojom::PrintScalingOption, ::printing::mojom::PrintScalingOption> {
  static ::printing::mojom::PrintScalingOption ToMojom(::printing::mojom::PrintScalingOption input) { return input; }
  static bool FromMojom(::printing::mojom::PrintScalingOption input, ::printing::mojom::PrintScalingOption* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PrintScalingOption, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::printing::mojom::PrintScalingOption, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::printing::mojom::PrintScalingOption>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::printing::mojom::SkiaDocumentType, ::printing::mojom::SkiaDocumentType> {
  static ::printing::mojom::SkiaDocumentType ToMojom(::printing::mojom::SkiaDocumentType input) { return input; }
  static bool FromMojom(::printing::mojom::SkiaDocumentType input, ::printing::mojom::SkiaDocumentType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::SkiaDocumentType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::printing::mojom::SkiaDocumentType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::printing::mojom::SkiaDocumentType>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::printing::mojom::MarginType, ::printing::mojom::MarginType> {
  static ::printing::mojom::MarginType ToMojom(::printing::mojom::MarginType input) { return input; }
  static bool FromMojom(::printing::mojom::MarginType input, ::printing::mojom::MarginType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::MarginType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::printing::mojom::MarginType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::printing::mojom::MarginType>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PageSizeMarginsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::PageSizeMarginsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::printing::mojom::internal::PageSizeMargins_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->content_width = Traits::content_width(input);
    (*output)->content_height = Traits::content_height(input);
    (*output)->margin_top = Traits::margin_top(input);
    (*output)->margin_right = Traits::margin_right(input);
    (*output)->margin_bottom = Traits::margin_bottom(input);
    (*output)->margin_left = Traits::margin_left(input);
  }

  static bool Deserialize(::printing::mojom::internal::PageSizeMargins_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::PageSizeMarginsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace printing {
namespace mojom {




}  // namespace mojom
}  // namespace printing

#endif  // PRINTING_MOJOM_PRINT_MOJOM_SHARED_H_