// third_party/blink/public/mojom/favicon/favicon_url.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FAVICON_FAVICON_URL_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FAVICON_FAVICON_URL_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/favicon/favicon_url.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"



#include "base/component_export.h"




namespace blink {
namespace mojom {
class FaviconURLDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::FaviconURLDataView> {
  using Data = ::blink::mojom::internal::FaviconURL_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {


enum class FaviconIconType : int32_t {
  
  kInvalid = 0,
  
  kFavicon = 1,
  
  kTouchIcon = 2,
  
  kTouchPrecomposedIcon = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, FaviconIconType value);
inline bool IsKnownEnumValue(FaviconIconType value) {
  return internal::FaviconIconType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class FaviconURLDataView {
 public:
  FaviconURLDataView() {}

  FaviconURLDataView(
      internal::FaviconURL_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetIconUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadIconUrl(UserType* output) {
    
    auto* pointer = data_->icon_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadIconType(UserType* output) const {
    auto data_value = data_->icon_type;
    return mojo::internal::Deserialize<::blink::mojom::FaviconIconType>(
        data_value, output);
  }

  FaviconIconType icon_type() const {
    return static_cast<FaviconIconType>(data_->icon_type);
  }
  inline void GetIconSizesDataView(
      mojo::ArrayDataView<::gfx::mojom::SizeDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadIconSizes(UserType* output) {
    
    auto* pointer = data_->icon_sizes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::SizeDataView>>(
        pointer, output, context_);
  }
 private:
  internal::FaviconURL_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

template <>
struct hash<::blink::mojom::FaviconIconType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::FaviconIconType> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::blink::mojom::FaviconIconType, ::blink::mojom::FaviconIconType> {
  static ::blink::mojom::FaviconIconType ToMojom(::blink::mojom::FaviconIconType input) { return input; }
  static bool FromMojom(::blink::mojom::FaviconIconType input, ::blink::mojom::FaviconIconType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FaviconIconType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::FaviconIconType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::FaviconIconType>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FaviconURLDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FaviconURLDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::FaviconURL_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::icon_url(input)) in_icon_url = Traits::icon_url(input);
    typename decltype((*output)->icon_url)::BaseType::BufferWriter
        icon_url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_icon_url, buffer, &icon_url_writer, context);
    (*output)->icon_url.Set(
        icon_url_writer.is_null() ? nullptr : icon_url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->icon_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null icon_url in FaviconURL struct");
    mojo::internal::Serialize<::blink::mojom::FaviconIconType>(
        Traits::icon_type(input), &(*output)->icon_type);
    decltype(Traits::icon_sizes(input)) in_icon_sizes = Traits::icon_sizes(input);
    typename decltype((*output)->icon_sizes)::BaseType::BufferWriter
        icon_sizes_writer;
    const mojo::internal::ContainerValidateParams icon_sizes_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::SizeDataView>>(
        in_icon_sizes, buffer, &icon_sizes_writer, &icon_sizes_validate_params,
        context);
    (*output)->icon_sizes.Set(
        icon_sizes_writer.is_null() ? nullptr : icon_sizes_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->icon_sizes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null icon_sizes in FaviconURL struct");
  }

  static bool Deserialize(::blink::mojom::internal::FaviconURL_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FaviconURLDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {

inline void FaviconURLDataView::GetIconUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->icon_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void FaviconURLDataView::GetIconSizesDataView(
    mojo::ArrayDataView<::gfx::mojom::SizeDataView>* output) {
  auto pointer = data_->icon_sizes.Get();
  *output = mojo::ArrayDataView<::gfx::mojom::SizeDataView>(pointer, context_);
}



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FAVICON_FAVICON_URL_MOJOM_SHARED_H_