// third_party/blink/public/mojom/timing/resource_timing.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/timing/resource_timing.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"

#include "third_party/blink/public/mojom/timing/resource_timing.mojom-params-data.h"
namespace blink {
namespace mojom {

namespace internal {


// static
bool ServerTimingInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServerTimingInfo_Data* object = static_cast<const ServerTimingInfo_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 32 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->description, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams description_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->description, validation_context,
                                         &description_validate_params)) {
    return false;
  }

  return true;
}

ServerTimingInfo_Data::ServerTimingInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ResourceTimingInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ResourceTimingInfo_Data* object = static_cast<const ResourceTimingInfo_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 112 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->start_time, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->start_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->alpn_negotiated_protocol, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams alpn_negotiated_protocol_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->alpn_negotiated_protocol, validation_context,
                                         &alpn_negotiated_protocol_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->connection_info, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams connection_info_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->connection_info, validation_context,
                                         &connection_info_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->timing, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_redirect_end_time, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->last_redirect_end_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response_end, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response_end, validation_context))
    return false;


  if (!::blink::mojom::internal::RequestContextType_Data
        ::Validate(object->context_type, validation_context))
    return false;


  if (!::network::mojom::internal::RequestDestination_Data
        ::Validate(object->request_destination, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->server_timing, 18, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams server_timing_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->server_timing, validation_context,
                                         &server_timing_validate_params)) {
    return false;
  }

  return true;
}

ResourceTimingInfo_Data::ResourceTimingInfo_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink