// services/metrics/public/mojom/ukm_interface.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_METRICS_PUBLIC_MOJOM_UKM_INTERFACE_MOJOM_SHARED_H_
#define SERVICES_METRICS_PUBLIC_MOJOM_UKM_INTERFACE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/metrics/public/mojom/ukm_interface.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace ukm::mojom {
class UkmEntryDataView;

class UkmRecorderParametersDataView;



}  // ukm::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ukm::mojom::UkmEntryDataView> {
  using Data = ::ukm::mojom::internal::UkmEntry_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ukm::mojom::UkmRecorderParametersDataView> {
  using Data = ::ukm::mojom::internal::UkmRecorderParameters_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace ukm::mojom {
// Interface base classes. They are used for type safety check.
class SingularUkmInterfaceInterfaceBase {};

using SingularUkmInterfacePtrDataView =
    mojo::InterfacePtrDataView<SingularUkmInterfaceInterfaceBase>;
using SingularUkmInterfaceRequestDataView =
    mojo::InterfaceRequestDataView<SingularUkmInterfaceInterfaceBase>;
using SingularUkmInterfaceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SingularUkmInterfaceInterfaceBase>;
using SingularUkmInterfaceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SingularUkmInterfaceInterfaceBase>;
class UkmRecorderClientInterfaceInterfaceBase {};

using UkmRecorderClientInterfacePtrDataView =
    mojo::InterfacePtrDataView<UkmRecorderClientInterfaceInterfaceBase>;
using UkmRecorderClientInterfaceRequestDataView =
    mojo::InterfaceRequestDataView<UkmRecorderClientInterfaceInterfaceBase>;
using UkmRecorderClientInterfaceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<UkmRecorderClientInterfaceInterfaceBase>;
using UkmRecorderClientInterfaceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<UkmRecorderClientInterfaceInterfaceBase>;
class UkmRecorderInterfaceInterfaceBase {};

using UkmRecorderInterfacePtrDataView =
    mojo::InterfacePtrDataView<UkmRecorderInterfaceInterfaceBase>;
using UkmRecorderInterfaceRequestDataView =
    mojo::InterfaceRequestDataView<UkmRecorderInterfaceInterfaceBase>;
using UkmRecorderInterfaceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<UkmRecorderInterfaceInterfaceBase>;
using UkmRecorderInterfaceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<UkmRecorderInterfaceInterfaceBase>;
class UkmRecorderFactoryInterfaceBase {};

using UkmRecorderFactoryPtrDataView =
    mojo::InterfacePtrDataView<UkmRecorderFactoryInterfaceBase>;
using UkmRecorderFactoryRequestDataView =
    mojo::InterfaceRequestDataView<UkmRecorderFactoryInterfaceBase>;
using UkmRecorderFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<UkmRecorderFactoryInterfaceBase>;
using UkmRecorderFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<UkmRecorderFactoryInterfaceBase>;


class UkmEntryDataView {
 public:
  UkmEntryDataView() = default;

  UkmEntryDataView(
      internal::UkmEntry_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t source_id() const {
    return data_->source_id;
  }
  uint64_t event_hash() const {
    return data_->event_hash;
  }
  inline void GetMetricsDataView(
      mojo::MapDataView<uint64_t, int64_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMetrics(UserType* output) {
    
    auto* pointer = data_->metrics.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<uint64_t, int64_t>>(
        pointer, output, message_);
  }
 private:
  internal::UkmEntry_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UkmRecorderParametersDataView {
 public:
  UkmRecorderParametersDataView() = default;

  UkmRecorderParametersDataView(
      internal::UkmRecorderParameters_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool is_enabled() const {
    return data_->is_enabled;
  }
  inline void GetEventHashBypassListDataView(
      mojo::ArrayDataView<uint64_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEventHashBypassList(UserType* output) {
    
    auto* pointer = data_->event_hash_bypass_list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint64_t>>(
        pointer, output, message_);
  }
 private:
  internal::UkmRecorderParameters_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // ukm::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ukm::mojom::UkmEntryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ukm::mojom::UkmEntryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ukm::mojom::internal::UkmEntry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->source_id = Traits::source_id(input);
    fragment->event_hash = Traits::event_hash(input);
    decltype(Traits::metrics(input)) in_metrics = Traits::metrics(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->metrics)::BaseType>
        metrics_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& metrics_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<uint64_t, int64_t>>(
        in_metrics, metrics_fragment, &metrics_validate_params);
    fragment->metrics.Set(
        metrics_fragment.is_null() ? nullptr : metrics_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->metrics.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null metrics in UkmEntry struct");
  }

  static bool Deserialize(::ukm::mojom::internal::UkmEntry_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ukm::mojom::UkmEntryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ukm::mojom::UkmRecorderParametersDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ukm::mojom::UkmRecorderParametersDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ukm::mojom::internal::UkmRecorderParameters_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->is_enabled = Traits::is_enabled(input);
    decltype(Traits::event_hash_bypass_list(input)) in_event_hash_bypass_list = Traits::event_hash_bypass_list(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->event_hash_bypass_list)::BaseType>
        event_hash_bypass_list_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& event_hash_bypass_list_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<uint64_t>>(
        in_event_hash_bypass_list, event_hash_bypass_list_fragment, &event_hash_bypass_list_validate_params);
    fragment->event_hash_bypass_list.Set(
        event_hash_bypass_list_fragment.is_null() ? nullptr : event_hash_bypass_list_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->event_hash_bypass_list.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null event_hash_bypass_list in UkmRecorderParameters struct");
  }

  static bool Deserialize(::ukm::mojom::internal::UkmRecorderParameters_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ukm::mojom::UkmRecorderParametersDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace ukm::mojom {

inline void UkmEntryDataView::GetMetricsDataView(
    mojo::MapDataView<uint64_t, int64_t>* output) {
  auto pointer = data_->metrics.Get();
  *output = mojo::MapDataView<uint64_t, int64_t>(pointer, message_);
}


inline void UkmRecorderParametersDataView::GetEventHashBypassListDataView(
    mojo::ArrayDataView<uint64_t>* output) {
  auto pointer = data_->event_hash_bypass_list.Get();
  *output = mojo::ArrayDataView<uint64_t>(pointer, message_);
}



}  // ukm::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_METRICS_PUBLIC_MOJOM_UKM_INTERFACE_MOJOM_SHARED_H_