// services/viz/privileged/mojom/compositing/frame_sink_manager.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_MANAGER_MOJOM_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_MANAGER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/privileged/mojom/compositing/frame_sink_manager.mojom-features.h"  // IWYU pragma: export
#include "services/viz/privileged/mojom/compositing/frame_sink_manager.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/privileged/mojom/compositing/frame_sink_manager.mojom-forward.h"  // IWYU pragma: export
#include "gpu/ipc/common/surface_handle.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "services/viz/privileged/mojom/compositing/display_private.mojom-forward.h"
#include "services/viz/privileged/mojom/compositing/external_begin_frame_controller.mojom-forward.h"
#include "services/viz/privileged/mojom/compositing/features.mojom-forward.h"
#include "services/viz/privileged/mojom/compositing/frame_sink_manager_test_api.mojom-forward.h"
#include "services/viz/privileged/mojom/compositing/frame_sink_video_capture.mojom-forward.h"
#include "services/viz/privileged/mojom/compositing/frame_sinks_metrics_recorder.mojom-forward.h"
#include "services/viz/privileged/mojom/compositing/renderer_settings.mojom.h"
#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-forward.h"
#include "services/viz/public/mojom/compositing/copy_output_request.mojom.h"
#include "services/viz/public/mojom/compositing/copy_output_result.mojom.h"
#include "services/viz/public/mojom/compositing/frame_sink_bundle.mojom-forward.h"
#include "services/viz/public/mojom/compositing/frame_sink_bundle_id.mojom.h"
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom-forward.h"
#include "services/viz/public/mojom/compositing/surface_id.mojom.h"
#include "services/viz/public/mojom/compositing/surface_info.mojom.h"
#include "services/viz/public/mojom/compositing/video_detector_observer.mojom-forward.h"
#include "services/viz/public/mojom/hit_test/aggregated_hit_test_region.mojom.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom.h"
#include "third_party/blink/public/mojom/widget/platform_widget.mojom-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-forward.h"
#include "components/input/render_input_router.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace viz::mojom {

class FrameSinkManagerProxy;

template <typename ImplRefTraits>
class FrameSinkManagerStub;

class FrameSinkManagerRequestValidator;
class FrameSinkManagerResponseValidator;


class FrameSinkManager
    : public FrameSinkManagerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    195383258
  };
  static constexpr bool HasUninterruptableMethods_ = true;

  using Base_ = FrameSinkManagerInterfaceBase;
  using Proxy_ = FrameSinkManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrameSinkManagerStub<ImplRefTraits>;

  using RequestValidator_ = FrameSinkManagerRequestValidator;
  using ResponseValidator_ = FrameSinkManagerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRegisterFrameSinkIdMinVersion = 0,
    kInvalidateFrameSinkIdMinVersion = 0,
    kSetFrameSinkDebugLabelMinVersion = 0,
    kCreateRootCompositorFrameSinkMinVersion = 0,
    kCreateFrameSinkBundleMinVersion = 0,
    kCreateCompositorFrameSinkMinVersion = 0,
    kDestroyCompositorFrameSinkMinVersion = 0,
    kRegisterFrameSinkHierarchyMinVersion = 0,
    kUnregisterFrameSinkHierarchyMinVersion = 0,
    kAddVideoDetectorObserverMinVersion = 0,
    kCreateVideoCapturerMinVersion = 0,
    kEvictSurfacesMinVersion = 0,
    kThrottleMinVersion = 0,
    kStartThrottlingAllFrameSinksMinVersion = 0,
    kStopThrottlingAllFrameSinksMinVersion = 0,
    kRequestCopyOfOutputMinVersion = 0,
    kUpdateDebugRendererSettingsMinVersion = 0,
    kClearUnclaimedViewTransitionResourcesMinVersion = 0,
    kCreateMetricsRecorderForTestMinVersion = 0,
    kEnableFrameSinkManagerTestApiMinVersion = 0,
    kSetupRenderInputRouterDelegateConnectionMinVersion = 0,
    kNotifyRendererBlockStateChangedMinVersion = 0,
    kRequestInputBackMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RegisterFrameSinkId_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct InvalidateFrameSinkId_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetFrameSinkDebugLabel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateRootCompositorFrameSink_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateFrameSinkBundle_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateCompositorFrameSink_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DestroyCompositorFrameSink_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RegisterFrameSinkHierarchy_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UnregisterFrameSinkHierarchy_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddVideoDetectorObserver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateVideoCapturer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EvictSurfaces_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Throttle_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartThrottlingAllFrameSinks_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StopThrottlingAllFrameSinks_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestCopyOfOutput_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateDebugRendererSettings_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearUnclaimedViewTransitionResources_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateMetricsRecorderForTest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnableFrameSinkManagerTestApi_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetupRenderInputRouterDelegateConnection_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyRendererBlockStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestInputBack_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FrameSinkManager() = default;

  
  virtual void RegisterFrameSinkId(const ::viz::FrameSinkId& frame_sink_id, bool report_activation) = 0;

  
  virtual void InvalidateFrameSinkId(const ::viz::FrameSinkId& frame_sink_id) = 0;

  
  virtual void SetFrameSinkDebugLabel(const ::viz::FrameSinkId& frame_sink_id, const std::string& debug_label) = 0;

  
  virtual void CreateRootCompositorFrameSink(RootCompositorFrameSinkParamsPtr params) = 0;

  
  virtual void CreateFrameSinkBundle(const ::viz::FrameSinkBundleId& bundle_id, ::mojo::PendingReceiver<::viz::mojom::FrameSinkBundle> receiver, ::mojo::PendingRemote<::viz::mojom::FrameSinkBundleClient> client) = 0;

  
  virtual void CreateCompositorFrameSink(const ::viz::FrameSinkId& frame_sink_id, const std::optional<::viz::FrameSinkBundleId>& bundle_id, ::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink> compositor_frame_sink, ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> compositor_frame_sink_client, ::input::mojom::RenderInputRouterConfigPtr config) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool DestroyCompositorFrameSink(const ::viz::FrameSinkId& frame_sink_id);

  using DestroyCompositorFrameSinkCallback = base::OnceCallback<void()>;
  
  virtual void DestroyCompositorFrameSink(const ::viz::FrameSinkId& frame_sink_id, DestroyCompositorFrameSinkCallback callback) = 0;

  
  virtual void RegisterFrameSinkHierarchy(const ::viz::FrameSinkId& parent_frame_sink_id, const ::viz::FrameSinkId& child_frame_sink_id) = 0;

  
  virtual void UnregisterFrameSinkHierarchy(const ::viz::FrameSinkId& parent_frame_sink_id, const ::viz::FrameSinkId& child_frame_sink_id) = 0;

  
  virtual void AddVideoDetectorObserver(::mojo::PendingRemote<::viz::mojom::VideoDetectorObserver> observer) = 0;

  
  virtual void CreateVideoCapturer(::mojo::PendingReceiver<::viz::mojom::FrameSinkVideoCapturer> receiver) = 0;

  
  virtual void EvictSurfaces(const std::vector<::viz::SurfaceId>& surface_ids) = 0;

  
  virtual void Throttle(const std::vector<::viz::FrameSinkId>& frame_sink_ids, ::base::TimeDelta interval) = 0;

  
  virtual void StartThrottlingAllFrameSinks(::base::TimeDelta interval) = 0;

  
  virtual void StopThrottlingAllFrameSinks() = 0;

  
  virtual void RequestCopyOfOutput(const ::viz::SurfaceId& surface_id, ::std::unique_ptr<::viz::CopyOutputRequest> request, bool capture_exact_surface_id) = 0;

  
  virtual void UpdateDebugRendererSettings(const ::viz::DebugRendererSettings& debug_settings) = 0;

  
  virtual void ClearUnclaimedViewTransitionResources(const ::blink::ViewTransitionToken& transition_token) = 0;

  
  virtual void CreateMetricsRecorderForTest(::mojo::PendingReceiver<::viz::mojom::FrameSinksMetricsRecorder> receiver) = 0;

  
  virtual void EnableFrameSinkManagerTestApi(::mojo::PendingReceiver<::viz::mojom::FrameSinkManagerTestApi> receiver) = 0;

  
  virtual void SetupRenderInputRouterDelegateConnection(const ::base::UnguessableToken& grouping_id, ::mojo::PendingRemote<::input::mojom::RenderInputRouterDelegateClient> rir_delegate_client_remote, ::mojo::PendingReceiver<::input::mojom::RenderInputRouterDelegate> rir_delegate_receiver) = 0;

  
  virtual void NotifyRendererBlockStateChanged(bool blocked, const std::vector<::viz::FrameSinkId>& render_input_routers) = 0;

  
  virtual void RequestInputBack() = 0;
};

class FrameSinkManagerClientProxy;

template <typename ImplRefTraits>
class FrameSinkManagerClientStub;

class FrameSinkManagerClientRequestValidator;


class FrameSinkManagerClient
    : public FrameSinkManagerClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FrameSinkManagerClientInterfaceBase;
  using Proxy_ = FrameSinkManagerClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrameSinkManagerClientStub<ImplRefTraits>;

  using RequestValidator_ = FrameSinkManagerClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnFirstSurfaceActivationMinVersion = 0,
    kOnAggregatedHitTestRegionListUpdatedMinVersion = 0,
    kOnFrameTokenChangedMinVersion = 0,
    kOnScreenshotCapturedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnFirstSurfaceActivation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnAggregatedHitTestRegionListUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnFrameTokenChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnScreenshotCaptured_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FrameSinkManagerClient() = default;

  
  virtual void OnFirstSurfaceActivation(const ::viz::SurfaceInfo& surface_info) = 0;

  
  virtual void OnAggregatedHitTestRegionListUpdated(const ::viz::FrameSinkId& frame_sink_id, const std::vector<::viz::AggregatedHitTestRegion>& hit_test_data) = 0;

  
  virtual void OnFrameTokenChanged(const ::viz::FrameSinkId& frame_sink_id, uint32_t frame_token, ::base::TimeTicks activation_time) = 0;

  
  virtual void OnScreenshotCaptured(const ::blink::SameDocNavigationScreenshotDestinationToken& destination_token, ::std::unique_ptr<::viz::CopyOutputResult> copy_output_result) = 0;
};



class  FrameSinkManagerProxy
    : public FrameSinkManager {
 public:
  using InterfaceType = FrameSinkManager;

  explicit FrameSinkManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RegisterFrameSinkId(const ::viz::FrameSinkId& frame_sink_id, bool report_activation) final;
  
  void InvalidateFrameSinkId(const ::viz::FrameSinkId& frame_sink_id) final;
  
  void SetFrameSinkDebugLabel(const ::viz::FrameSinkId& frame_sink_id, const std::string& debug_label) final;
  
  void CreateRootCompositorFrameSink(RootCompositorFrameSinkParamsPtr params) final;
  
  void CreateFrameSinkBundle(const ::viz::FrameSinkBundleId& bundle_id, ::mojo::PendingReceiver<::viz::mojom::FrameSinkBundle> receiver, ::mojo::PendingRemote<::viz::mojom::FrameSinkBundleClient> client) final;
  
  void CreateCompositorFrameSink(const ::viz::FrameSinkId& frame_sink_id, const std::optional<::viz::FrameSinkBundleId>& bundle_id, ::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink> compositor_frame_sink, ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> compositor_frame_sink_client, ::input::mojom::RenderInputRouterConfigPtr config) final;
  
  bool DestroyCompositorFrameSink(const ::viz::FrameSinkId& frame_sink_id) final;
  
  void DestroyCompositorFrameSink(const ::viz::FrameSinkId& frame_sink_id, DestroyCompositorFrameSinkCallback callback) final;
  
  void RegisterFrameSinkHierarchy(const ::viz::FrameSinkId& parent_frame_sink_id, const ::viz::FrameSinkId& child_frame_sink_id) final;
  
  void UnregisterFrameSinkHierarchy(const ::viz::FrameSinkId& parent_frame_sink_id, const ::viz::FrameSinkId& child_frame_sink_id) final;
  
  void AddVideoDetectorObserver(::mojo::PendingRemote<::viz::mojom::VideoDetectorObserver> observer) final;
  
  void CreateVideoCapturer(::mojo::PendingReceiver<::viz::mojom::FrameSinkVideoCapturer> receiver) final;
  
  void EvictSurfaces(const std::vector<::viz::SurfaceId>& surface_ids) final;
  
  void Throttle(const std::vector<::viz::FrameSinkId>& frame_sink_ids, ::base::TimeDelta interval) final;
  
  void StartThrottlingAllFrameSinks(::base::TimeDelta interval) final;
  
  void StopThrottlingAllFrameSinks() final;
  
  void RequestCopyOfOutput(const ::viz::SurfaceId& surface_id, ::std::unique_ptr<::viz::CopyOutputRequest> request, bool capture_exact_surface_id) final;
  
  void UpdateDebugRendererSettings(const ::viz::DebugRendererSettings& debug_settings) final;
  
  void ClearUnclaimedViewTransitionResources(const ::blink::ViewTransitionToken& transition_token) final;
  
  void CreateMetricsRecorderForTest(::mojo::PendingReceiver<::viz::mojom::FrameSinksMetricsRecorder> receiver) final;
  
  void EnableFrameSinkManagerTestApi(::mojo::PendingReceiver<::viz::mojom::FrameSinkManagerTestApi> receiver) final;
  
  void SetupRenderInputRouterDelegateConnection(const ::base::UnguessableToken& grouping_id, ::mojo::PendingRemote<::input::mojom::RenderInputRouterDelegateClient> rir_delegate_client_remote, ::mojo::PendingReceiver<::input::mojom::RenderInputRouterDelegate> rir_delegate_receiver) final;
  
  void NotifyRendererBlockStateChanged(bool blocked, const std::vector<::viz::FrameSinkId>& render_input_routers) final;
  
  void RequestInputBack() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  FrameSinkManagerClientProxy
    : public FrameSinkManagerClient {
 public:
  using InterfaceType = FrameSinkManagerClient;

  explicit FrameSinkManagerClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnFirstSurfaceActivation(const ::viz::SurfaceInfo& surface_info) final;
  
  void OnAggregatedHitTestRegionListUpdated(const ::viz::FrameSinkId& frame_sink_id, const std::vector<::viz::AggregatedHitTestRegion>& hit_test_data) final;
  
  void OnFrameTokenChanged(const ::viz::FrameSinkId& frame_sink_id, uint32_t frame_token, ::base::TimeTicks activation_time) final;
  
  void OnScreenshotCaptured(const ::blink::SameDocNavigationScreenshotDestinationToken& destination_token, ::std::unique_ptr<::viz::CopyOutputResult> copy_output_result) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  FrameSinkManagerStubDispatch {
 public:
  static bool Accept(FrameSinkManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FrameSinkManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FrameSinkManager>>
class FrameSinkManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrameSinkManagerStub() = default;
  ~FrameSinkManagerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameSinkManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameSinkManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  FrameSinkManagerClientStubDispatch {
 public:
  static bool Accept(FrameSinkManagerClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FrameSinkManagerClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FrameSinkManagerClient>>
class FrameSinkManagerClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrameSinkManagerClientStub() = default;
  ~FrameSinkManagerClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameSinkManagerClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameSinkManagerClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  FrameSinkManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  FrameSinkManagerClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  FrameSinkManagerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  RootCompositorFrameSinkParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RootCompositorFrameSinkParams, T>::value>;
  using DataView = RootCompositorFrameSinkParamsDataView;
  using Data_ = internal::RootCompositorFrameSinkParams_Data;

  template <typename... Args>
  static RootCompositorFrameSinkParamsPtr New(Args&&... args) {
    return RootCompositorFrameSinkParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RootCompositorFrameSinkParamsPtr From(const U& u) {
    return mojo::TypeConverter<RootCompositorFrameSinkParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RootCompositorFrameSinkParams>::Convert(*this);
  }


  RootCompositorFrameSinkParams();

  RootCompositorFrameSinkParams(
      const ::viz::FrameSinkId& frame_sink_id,
      ::gpu::SurfaceHandle widget,
      bool gpu_compositing,
      const ::viz::RendererSettings& renderer_settings,
      bool send_swap_size_notifications,
      bool disable_frame_rate_limit,
      ::mojo::PendingAssociatedReceiver<::viz::mojom::CompositorFrameSink> compositor_frame_sink,
      ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> compositor_frame_sink_client,
      ::mojo::PendingAssociatedReceiver<::viz::mojom::DisplayPrivate> display_private,
      ::mojo::PendingRemote<::viz::mojom::DisplayClient> display_client,
      ::mojo::PendingAssociatedReceiver<::viz::mojom::ExternalBeginFrameController> external_begin_frame_controller);

RootCompositorFrameSinkParams(const RootCompositorFrameSinkParams&) = delete;
RootCompositorFrameSinkParams& operator=(const RootCompositorFrameSinkParams&) = delete;

  ~RootCompositorFrameSinkParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RootCompositorFrameSinkParamsPtr>
  RootCompositorFrameSinkParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RootCompositorFrameSinkParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RootCompositorFrameSinkParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RootCompositorFrameSinkParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RootCompositorFrameSinkParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RootCompositorFrameSinkParams_UnserializedMessageContext<
            UserType, RootCompositorFrameSinkParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RootCompositorFrameSinkParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RootCompositorFrameSinkParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RootCompositorFrameSinkParams_UnserializedMessageContext<
            UserType, RootCompositorFrameSinkParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RootCompositorFrameSinkParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::viz::FrameSinkId frame_sink_id;
  
  ::gpu::SurfaceHandle widget;
  
  bool gpu_compositing;
  
  ::viz::RendererSettings renderer_settings;
  
  bool send_swap_size_notifications;
  
  bool disable_frame_rate_limit;
  
  ::mojo::PendingAssociatedReceiver<::viz::mojom::CompositorFrameSink> compositor_frame_sink;
  
  ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> compositor_frame_sink_client;
  
  ::mojo::PendingAssociatedReceiver<::viz::mojom::DisplayPrivate> display_private;
  
  ::mojo::PendingRemote<::viz::mojom::DisplayClient> display_client;
  
  ::mojo::PendingAssociatedReceiver<::viz::mojom::ExternalBeginFrameController> external_begin_frame_controller;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RootCompositorFrameSinkParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RootCompositorFrameSinkParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RootCompositorFrameSinkParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RootCompositorFrameSinkParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
RootCompositorFrameSinkParamsPtr RootCompositorFrameSinkParams::Clone() const {
  return New(
      mojo::Clone(frame_sink_id),
      mojo::Clone(widget),
      mojo::Clone(gpu_compositing),
      mojo::Clone(renderer_settings),
      mojo::Clone(send_swap_size_notifications),
      mojo::Clone(disable_frame_rate_limit),
      mojo::Clone(compositor_frame_sink),
      mojo::Clone(compositor_frame_sink_client),
      mojo::Clone(display_private),
      mojo::Clone(display_client),
      mojo::Clone(external_begin_frame_controller)
  );
}

template <typename T, RootCompositorFrameSinkParams::EnableIfSame<T>*>
bool RootCompositorFrameSinkParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frame_sink_id, other_struct.frame_sink_id))
    return false;
  if (!mojo::Equals(this->widget, other_struct.widget))
    return false;
  if (!mojo::Equals(this->gpu_compositing, other_struct.gpu_compositing))
    return false;
  if (!mojo::Equals(this->renderer_settings, other_struct.renderer_settings))
    return false;
  if (!mojo::Equals(this->send_swap_size_notifications, other_struct.send_swap_size_notifications))
    return false;
  if (!mojo::Equals(this->disable_frame_rate_limit, other_struct.disable_frame_rate_limit))
    return false;
  if (!mojo::Equals(this->compositor_frame_sink, other_struct.compositor_frame_sink))
    return false;
  if (!mojo::Equals(this->compositor_frame_sink_client, other_struct.compositor_frame_sink_client))
    return false;
  if (!mojo::Equals(this->display_private, other_struct.display_private))
    return false;
  if (!mojo::Equals(this->display_client, other_struct.display_client))
    return false;
  if (!mojo::Equals(this->external_begin_frame_controller, other_struct.external_begin_frame_controller))
    return false;
  return true;
}

template <typename T, RootCompositorFrameSinkParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.frame_sink_id < rhs.frame_sink_id)
    return true;
  if (rhs.frame_sink_id < lhs.frame_sink_id)
    return false;
  if (lhs.widget < rhs.widget)
    return true;
  if (rhs.widget < lhs.widget)
    return false;
  if (lhs.gpu_compositing < rhs.gpu_compositing)
    return true;
  if (rhs.gpu_compositing < lhs.gpu_compositing)
    return false;
  if (lhs.renderer_settings < rhs.renderer_settings)
    return true;
  if (rhs.renderer_settings < lhs.renderer_settings)
    return false;
  if (lhs.send_swap_size_notifications < rhs.send_swap_size_notifications)
    return true;
  if (rhs.send_swap_size_notifications < lhs.send_swap_size_notifications)
    return false;
  if (lhs.disable_frame_rate_limit < rhs.disable_frame_rate_limit)
    return true;
  if (rhs.disable_frame_rate_limit < lhs.disable_frame_rate_limit)
    return false;
  if (lhs.compositor_frame_sink < rhs.compositor_frame_sink)
    return true;
  if (rhs.compositor_frame_sink < lhs.compositor_frame_sink)
    return false;
  if (lhs.compositor_frame_sink_client < rhs.compositor_frame_sink_client)
    return true;
  if (rhs.compositor_frame_sink_client < lhs.compositor_frame_sink_client)
    return false;
  if (lhs.display_private < rhs.display_private)
    return true;
  if (rhs.display_private < lhs.display_private)
    return false;
  if (lhs.display_client < rhs.display_client)
    return true;
  if (rhs.display_client < lhs.display_client)
    return false;
  if (lhs.external_begin_frame_controller < rhs.external_begin_frame_controller)
    return true;
  if (rhs.external_begin_frame_controller < lhs.external_begin_frame_controller)
    return false;
  return false;
}


}  // viz::mojom

namespace mojo {


template <>
struct  StructTraits<::viz::mojom::RootCompositorFrameSinkParams::DataView,
                                         ::viz::mojom::RootCompositorFrameSinkParamsPtr> {
  static bool IsNull(const ::viz::mojom::RootCompositorFrameSinkParamsPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::RootCompositorFrameSinkParamsPtr* output) { output->reset(); }

  static const decltype(::viz::mojom::RootCompositorFrameSinkParams::frame_sink_id)& frame_sink_id(
      const ::viz::mojom::RootCompositorFrameSinkParamsPtr& input) {
    return input->frame_sink_id;
  }

  static const decltype(::viz::mojom::RootCompositorFrameSinkParams::widget)& widget(
      const ::viz::mojom::RootCompositorFrameSinkParamsPtr& input) {
    return input->widget;
  }

  static decltype(::viz::mojom::RootCompositorFrameSinkParams::gpu_compositing) gpu_compositing(
      const ::viz::mojom::RootCompositorFrameSinkParamsPtr& input) {
    return input->gpu_compositing;
  }

  static const decltype(::viz::mojom::RootCompositorFrameSinkParams::renderer_settings)& renderer_settings(
      const ::viz::mojom::RootCompositorFrameSinkParamsPtr& input) {
    return input->renderer_settings;
  }

  static decltype(::viz::mojom::RootCompositorFrameSinkParams::send_swap_size_notifications) send_swap_size_notifications(
      const ::viz::mojom::RootCompositorFrameSinkParamsPtr& input) {
    return input->send_swap_size_notifications;
  }

  static decltype(::viz::mojom::RootCompositorFrameSinkParams::disable_frame_rate_limit) disable_frame_rate_limit(
      const ::viz::mojom::RootCompositorFrameSinkParamsPtr& input) {
    return input->disable_frame_rate_limit;
  }

  static  decltype(::viz::mojom::RootCompositorFrameSinkParams::compositor_frame_sink)& compositor_frame_sink(
       ::viz::mojom::RootCompositorFrameSinkParamsPtr& input) {
    return input->compositor_frame_sink;
  }

  static  decltype(::viz::mojom::RootCompositorFrameSinkParams::compositor_frame_sink_client)& compositor_frame_sink_client(
       ::viz::mojom::RootCompositorFrameSinkParamsPtr& input) {
    return input->compositor_frame_sink_client;
  }

  static  decltype(::viz::mojom::RootCompositorFrameSinkParams::display_private)& display_private(
       ::viz::mojom::RootCompositorFrameSinkParamsPtr& input) {
    return input->display_private;
  }

  static  decltype(::viz::mojom::RootCompositorFrameSinkParams::display_client)& display_client(
       ::viz::mojom::RootCompositorFrameSinkParamsPtr& input) {
    return input->display_client;
  }

  static  decltype(::viz::mojom::RootCompositorFrameSinkParams::external_begin_frame_controller)& external_begin_frame_controller(
       ::viz::mojom::RootCompositorFrameSinkParamsPtr& input) {
    return input->external_begin_frame_controller;
  }

  static bool Read(::viz::mojom::RootCompositorFrameSinkParams::DataView input, ::viz::mojom::RootCompositorFrameSinkParamsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_MANAGER_MOJOM_H_