// services/viz/public/mojom/compositing/layer.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/layer.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/layer.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/layer.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/layer.mojom-import-headers.h"
#include "services/viz/public/mojom/compositing/layer.mojom-test-utils.h"


namespace viz::mojom {
Layer::Layer()
    : id(),
      type(),
      bounds(),
      contents_opaque(),
      contents_opaque_for_text(),
      is_drawable(),
      background_color(),
      safe_opaque_background_color(),
      element_id(),
      update_rect(),
      offset_to_transform_parent(),
      transform_tree_index(),
      clip_tree_index(),
      effect_tree_index(),
      scroll_tree_index() {}

Layer::Layer(
    int64_t id_in,
    ::cc::mojom::LayerType type_in,
    const ::gfx::Size& bounds_in,
    bool contents_opaque_in,
    bool contents_opaque_for_text_in,
    bool is_drawable_in,
    const ::SkColor4f& background_color_in,
    const ::SkColor4f& safe_opaque_background_color_in,
    ::cc::ElementId element_id_in,
    const ::gfx::Rect& update_rect_in,
    const ::gfx::Vector2dF& offset_to_transform_parent_in,
    int32_t transform_tree_index_in,
    int32_t clip_tree_index_in,
    int32_t effect_tree_index_in,
    int32_t scroll_tree_index_in)
    : id(std::move(id_in)),
      type(std::move(type_in)),
      bounds(std::move(bounds_in)),
      contents_opaque(std::move(contents_opaque_in)),
      contents_opaque_for_text(std::move(contents_opaque_for_text_in)),
      is_drawable(std::move(is_drawable_in)),
      background_color(std::move(background_color_in)),
      safe_opaque_background_color(std::move(safe_opaque_background_color_in)),
      element_id(std::move(element_id_in)),
      update_rect(std::move(update_rect_in)),
      offset_to_transform_parent(std::move(offset_to_transform_parent_in)),
      transform_tree_index(std::move(transform_tree_index_in)),
      clip_tree_index(std::move(clip_tree_index_in)),
      effect_tree_index(std::move(effect_tree_index_in)),
      scroll_tree_index(std::move(scroll_tree_index_in)) {}

Layer::~Layer() = default;

void Layer::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cc::mojom::LayerType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bounds"), this->bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "contents_opaque"), this->contents_opaque,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "contents_opaque_for_text"), this->contents_opaque_for_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_drawable"), this->is_drawable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "background_color"), this->background_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::SkColor4f&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "safe_opaque_background_color"), this->safe_opaque_background_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::SkColor4f&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "element_id"), this->element_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cc::ElementId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "update_rect"), this->update_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "offset_to_transform_parent"), this->offset_to_transform_parent,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Vector2dF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transform_tree_index"), this->transform_tree_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "clip_tree_index"), this->clip_tree_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "effect_tree_index"), this->effect_tree_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_tree_index"), this->scroll_tree_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Layer::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AnchorPositionScrollData::AnchorPositionScrollData()
    : adjustment_container_ids(),
      accumulated_scroll_origin(),
      needs_scroll_adjustment_in_x(),
      needs_scroll_adjustment_in_y() {}

AnchorPositionScrollData::AnchorPositionScrollData(
    std::vector<::cc::ElementId> adjustment_container_ids_in,
    const ::gfx::Vector2d& accumulated_scroll_origin_in,
    bool needs_scroll_adjustment_in_x_in,
    bool needs_scroll_adjustment_in_y_in)
    : adjustment_container_ids(std::move(adjustment_container_ids_in)),
      accumulated_scroll_origin(std::move(accumulated_scroll_origin_in)),
      needs_scroll_adjustment_in_x(std::move(needs_scroll_adjustment_in_x_in)),
      needs_scroll_adjustment_in_y(std::move(needs_scroll_adjustment_in_y_in)) {}

AnchorPositionScrollData::~AnchorPositionScrollData() = default;

void AnchorPositionScrollData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "adjustment_container_ids"), this->adjustment_container_ids,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::cc::ElementId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "accumulated_scroll_origin"), this->accumulated_scroll_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Vector2d&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "needs_scroll_adjustment_in_x"), this->needs_scroll_adjustment_in_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "needs_scroll_adjustment_in_y"), this->needs_scroll_adjustment_in_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AnchorPositionScrollData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
StickyPositionNodeData::StickyPositionNodeData()
    : scroll_ancestor(),
      is_anchored_left(),
      is_anchored_right(),
      is_anchored_top(),
      is_anchored_bottom(),
      left_offset(),
      right_offset(),
      top_offset(),
      bottom_offset(),
      constraint_box_rect(),
      scroll_container_relative_sticky_box_rect(),
      scroll_container_relative_containing_block_rect(),
      nearest_node_shifting_sticky_box(),
      nearest_node_shifting_containing_block(),
      total_sticky_box_sticky_offset(),
      total_containing_block_sticky_offset() {}

StickyPositionNodeData::StickyPositionNodeData(
    int32_t scroll_ancestor_in,
    bool is_anchored_left_in,
    bool is_anchored_right_in,
    bool is_anchored_top_in,
    bool is_anchored_bottom_in,
    float left_offset_in,
    float right_offset_in,
    float top_offset_in,
    float bottom_offset_in,
    const ::gfx::RectF& constraint_box_rect_in,
    const ::gfx::RectF& scroll_container_relative_sticky_box_rect_in,
    const ::gfx::RectF& scroll_container_relative_containing_block_rect_in,
    int32_t nearest_node_shifting_sticky_box_in,
    int32_t nearest_node_shifting_containing_block_in,
    const ::gfx::Vector2dF& total_sticky_box_sticky_offset_in,
    const ::gfx::Vector2dF& total_containing_block_sticky_offset_in)
    : scroll_ancestor(std::move(scroll_ancestor_in)),
      is_anchored_left(std::move(is_anchored_left_in)),
      is_anchored_right(std::move(is_anchored_right_in)),
      is_anchored_top(std::move(is_anchored_top_in)),
      is_anchored_bottom(std::move(is_anchored_bottom_in)),
      left_offset(std::move(left_offset_in)),
      right_offset(std::move(right_offset_in)),
      top_offset(std::move(top_offset_in)),
      bottom_offset(std::move(bottom_offset_in)),
      constraint_box_rect(std::move(constraint_box_rect_in)),
      scroll_container_relative_sticky_box_rect(std::move(scroll_container_relative_sticky_box_rect_in)),
      scroll_container_relative_containing_block_rect(std::move(scroll_container_relative_containing_block_rect_in)),
      nearest_node_shifting_sticky_box(std::move(nearest_node_shifting_sticky_box_in)),
      nearest_node_shifting_containing_block(std::move(nearest_node_shifting_containing_block_in)),
      total_sticky_box_sticky_offset(std::move(total_sticky_box_sticky_offset_in)),
      total_containing_block_sticky_offset(std::move(total_containing_block_sticky_offset_in)) {}

StickyPositionNodeData::~StickyPositionNodeData() = default;

void StickyPositionNodeData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_ancestor"), this->scroll_ancestor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_anchored_left"), this->is_anchored_left,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_anchored_right"), this->is_anchored_right,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_anchored_top"), this->is_anchored_top,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_anchored_bottom"), this->is_anchored_bottom,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "left_offset"), this->left_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "right_offset"), this->right_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_offset"), this->top_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bottom_offset"), this->bottom_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "constraint_box_rect"), this->constraint_box_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::RectF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_container_relative_sticky_box_rect"), this->scroll_container_relative_sticky_box_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::RectF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_container_relative_containing_block_rect"), this->scroll_container_relative_containing_block_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::RectF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "nearest_node_shifting_sticky_box"), this->nearest_node_shifting_sticky_box,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "nearest_node_shifting_containing_block"), this->nearest_node_shifting_containing_block,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total_sticky_box_sticky_offset"), this->total_sticky_box_sticky_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Vector2dF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total_containing_block_sticky_offset"), this->total_containing_block_sticky_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Vector2dF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool StickyPositionNodeData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TransformTreeUpdate::TransformTreeUpdate()
    : page_scale_factor(),
      device_scale_factor(),
      device_transform_scale_factor(),
      nodes_affected_by_outer_viewport_bounds_delta(),
      sticky_position_data(),
      anchor_position_scroll_data() {}

TransformTreeUpdate::TransformTreeUpdate(
    float page_scale_factor_in,
    float device_scale_factor_in,
    float device_transform_scale_factor_in,
    std::vector<int32_t> nodes_affected_by_outer_viewport_bounds_delta_in,
    std::vector<StickyPositionNodeDataPtr> sticky_position_data_in,
    std::vector<AnchorPositionScrollDataPtr> anchor_position_scroll_data_in)
    : page_scale_factor(std::move(page_scale_factor_in)),
      device_scale_factor(std::move(device_scale_factor_in)),
      device_transform_scale_factor(std::move(device_transform_scale_factor_in)),
      nodes_affected_by_outer_viewport_bounds_delta(std::move(nodes_affected_by_outer_viewport_bounds_delta_in)),
      sticky_position_data(std::move(sticky_position_data_in)),
      anchor_position_scroll_data(std::move(anchor_position_scroll_data_in)) {}

TransformTreeUpdate::~TransformTreeUpdate() = default;

void TransformTreeUpdate::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_scale_factor"), this->page_scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_scale_factor"), this->device_scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_transform_scale_factor"), this->device_transform_scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "nodes_affected_by_outer_viewport_bounds_delta"), this->nodes_affected_by_outer_viewport_bounds_delta,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<int32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sticky_position_data"), this->sticky_position_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<StickyPositionNodeDataPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "anchor_position_scroll_data"), this->anchor_position_scroll_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<AnchorPositionScrollDataPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TransformTreeUpdate::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TransformNode::TransformNode()
    : id(),
      parent_id(),
      parent_frame_id(),
      element_id(),
      local(),
      origin(),
      scroll_offset(),
      snap_amount(),
      sticky_position_constraint_id(),
      anchor_position_scroll_data_id(),
      sorting_context_id(),
      has_potential_animation(),
      is_currently_animating(),
      flattens_inherited_transform(),
      scrolls(),
      should_undo_overscroll(),
      should_be_snapped(),
      moved_by_outer_viewport_bounds_delta_y(),
      in_subtree_of_page_scale_layer(),
      transform_changed(),
      delegates_to_parent_for_backface(),
      will_change_transform(),
      visible_frame_element_id() {}

TransformNode::TransformNode(
    int32_t id_in,
    int32_t parent_id_in,
    int32_t parent_frame_id_in,
    ::cc::ElementId element_id_in,
    const ::gfx::Transform& local_in,
    const ::gfx::Point3F& origin_in,
    const ::gfx::PointF& scroll_offset_in,
    const ::gfx::Vector2dF& snap_amount_in,
    std::optional<uint32_t> sticky_position_constraint_id_in,
    std::optional<uint32_t> anchor_position_scroll_data_id_in,
    int32_t sorting_context_id_in,
    bool has_potential_animation_in,
    bool is_currently_animating_in,
    bool flattens_inherited_transform_in,
    bool scrolls_in,
    bool should_undo_overscroll_in,
    bool should_be_snapped_in,
    bool moved_by_outer_viewport_bounds_delta_y_in,
    bool in_subtree_of_page_scale_layer_in,
    bool transform_changed_in,
    bool delegates_to_parent_for_backface_in,
    bool will_change_transform_in,
    ::cc::ElementId visible_frame_element_id_in)
    : id(std::move(id_in)),
      parent_id(std::move(parent_id_in)),
      parent_frame_id(std::move(parent_frame_id_in)),
      element_id(std::move(element_id_in)),
      local(std::move(local_in)),
      origin(std::move(origin_in)),
      scroll_offset(std::move(scroll_offset_in)),
      snap_amount(std::move(snap_amount_in)),
      sticky_position_constraint_id(std::move(sticky_position_constraint_id_in)),
      anchor_position_scroll_data_id(std::move(anchor_position_scroll_data_id_in)),
      sorting_context_id(std::move(sorting_context_id_in)),
      has_potential_animation(std::move(has_potential_animation_in)),
      is_currently_animating(std::move(is_currently_animating_in)),
      flattens_inherited_transform(std::move(flattens_inherited_transform_in)),
      scrolls(std::move(scrolls_in)),
      should_undo_overscroll(std::move(should_undo_overscroll_in)),
      should_be_snapped(std::move(should_be_snapped_in)),
      moved_by_outer_viewport_bounds_delta_y(std::move(moved_by_outer_viewport_bounds_delta_y_in)),
      in_subtree_of_page_scale_layer(std::move(in_subtree_of_page_scale_layer_in)),
      transform_changed(std::move(transform_changed_in)),
      delegates_to_parent_for_backface(std::move(delegates_to_parent_for_backface_in)),
      will_change_transform(std::move(will_change_transform_in)),
      visible_frame_element_id(std::move(visible_frame_element_id_in)) {}

TransformNode::~TransformNode() = default;

void TransformNode::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parent_id"), this->parent_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parent_frame_id"), this->parent_frame_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "element_id"), this->element_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cc::ElementId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "local"), this->local,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Transform&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Point3F&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_offset"), this->scroll_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "snap_amount"), this->snap_amount,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Vector2dF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sticky_position_constraint_id"), this->sticky_position_constraint_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "anchor_position_scroll_data_id"), this->anchor_position_scroll_data_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sorting_context_id"), this->sorting_context_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_potential_animation"), this->has_potential_animation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_currently_animating"), this->is_currently_animating,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "flattens_inherited_transform"), this->flattens_inherited_transform,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scrolls"), this->scrolls,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_undo_overscroll"), this->should_undo_overscroll,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_be_snapped"), this->should_be_snapped,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "moved_by_outer_viewport_bounds_delta_y"), this->moved_by_outer_viewport_bounds_delta_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "in_subtree_of_page_scale_layer"), this->in_subtree_of_page_scale_layer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transform_changed"), this->transform_changed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "delegates_to_parent_for_backface"), this->delegates_to_parent_for_backface,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "will_change_transform"), this->will_change_transform,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visible_frame_element_id"), this->visible_frame_element_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cc::ElementId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TransformNode::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ClipNode::ClipNode()
    : id(),
      parent_id(),
      transform_id(),
      clip(),
      pixel_moving_filter_id() {}

ClipNode::ClipNode(
    int32_t id_in,
    int32_t parent_id_in,
    int32_t transform_id_in,
    const ::gfx::RectF& clip_in,
    int32_t pixel_moving_filter_id_in)
    : id(std::move(id_in)),
      parent_id(std::move(parent_id_in)),
      transform_id(std::move(transform_id_in)),
      clip(std::move(clip_in)),
      pixel_moving_filter_id(std::move(pixel_moving_filter_id_in)) {}

ClipNode::~ClipNode() = default;

void ClipNode::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parent_id"), this->parent_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transform_id"), this->transform_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "clip"), this->clip,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::RectF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pixel_moving_filter_id"), this->pixel_moving_filter_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ClipNode::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
EffectNode::EffectNode()
    : id(),
      parent_id(),
      transform_id(),
      clip_id(),
      element_id(),
      opacity(),
      has_render_surface(),
      surface_contents_scale(),
      blend_mode(),
      target_id() {}

EffectNode::EffectNode(
    int32_t id_in,
    int32_t parent_id_in,
    int32_t transform_id_in,
    int32_t clip_id_in,
    ::cc::ElementId element_id_in,
    float opacity_in,
    bool has_render_surface_in,
    const ::gfx::Vector2dF& surface_contents_scale_in,
    uint32_t blend_mode_in,
    int32_t target_id_in)
    : id(std::move(id_in)),
      parent_id(std::move(parent_id_in)),
      transform_id(std::move(transform_id_in)),
      clip_id(std::move(clip_id_in)),
      element_id(std::move(element_id_in)),
      opacity(std::move(opacity_in)),
      has_render_surface(std::move(has_render_surface_in)),
      surface_contents_scale(std::move(surface_contents_scale_in)),
      blend_mode(std::move(blend_mode_in)),
      target_id(std::move(target_id_in)) {}

EffectNode::~EffectNode() = default;

void EffectNode::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parent_id"), this->parent_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transform_id"), this->transform_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "clip_id"), this->clip_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "element_id"), this->element_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cc::ElementId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "opacity"), this->opacity,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_render_surface"), this->has_render_surface,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "surface_contents_scale"), this->surface_contents_scale,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Vector2dF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blend_mode"), this->blend_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_id"), this->target_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool EffectNode::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ScrollNode::ScrollNode()
    : id(),
      parent_id(),
      transform_id(),
      container_bounds(),
      bounds(),
      element_id(),
      max_scroll_offset_affected_by_page_scale(),
      scrolls_inner_viewport(),
      scrolls_outer_viewport(),
      prevent_viewport_scrolling_from_inner(),
      user_scrollable_horizontal(),
      user_scrollable_vertical(),
      is_composited() {}

ScrollNode::ScrollNode(
    int32_t id_in,
    int32_t parent_id_in,
    int32_t transform_id_in,
    const ::gfx::Size& container_bounds_in,
    const ::gfx::Size& bounds_in,
    ::cc::ElementId element_id_in,
    bool max_scroll_offset_affected_by_page_scale_in,
    bool scrolls_inner_viewport_in,
    bool scrolls_outer_viewport_in,
    bool prevent_viewport_scrolling_from_inner_in,
    bool user_scrollable_horizontal_in,
    bool user_scrollable_vertical_in,
    bool is_composited_in)
    : id(std::move(id_in)),
      parent_id(std::move(parent_id_in)),
      transform_id(std::move(transform_id_in)),
      container_bounds(std::move(container_bounds_in)),
      bounds(std::move(bounds_in)),
      element_id(std::move(element_id_in)),
      max_scroll_offset_affected_by_page_scale(std::move(max_scroll_offset_affected_by_page_scale_in)),
      scrolls_inner_viewport(std::move(scrolls_inner_viewport_in)),
      scrolls_outer_viewport(std::move(scrolls_outer_viewport_in)),
      prevent_viewport_scrolling_from_inner(std::move(prevent_viewport_scrolling_from_inner_in)),
      user_scrollable_horizontal(std::move(user_scrollable_horizontal_in)),
      user_scrollable_vertical(std::move(user_scrollable_vertical_in)),
      is_composited(std::move(is_composited_in)) {}

ScrollNode::~ScrollNode() = default;

void ScrollNode::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parent_id"), this->parent_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transform_id"), this->transform_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "container_bounds"), this->container_bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bounds"), this->bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "element_id"), this->element_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cc::ElementId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_scroll_offset_affected_by_page_scale"), this->max_scroll_offset_affected_by_page_scale,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scrolls_inner_viewport"), this->scrolls_inner_viewport,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scrolls_outer_viewport"), this->scrolls_outer_viewport,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prevent_viewport_scrolling_from_inner"), this->prevent_viewport_scrolling_from_inner,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_scrollable_horizontal"), this->user_scrollable_horizontal,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_scrollable_vertical"), this->user_scrollable_vertical,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_composited"), this->is_composited,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ScrollNode::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // viz::mojom


namespace mojo {


// static
bool StructTraits<::viz::mojom::Layer::DataView, ::viz::mojom::LayerPtr>::Read(
    ::viz::mojom::Layer::DataView input,
    ::viz::mojom::LayerPtr* output) {
  bool success = true;
  ::viz::mojom::LayerPtr result(::viz::mojom::Layer::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadBounds(&result->bounds))
        success = false;
      if (success)
        result->contents_opaque = input.contents_opaque();
      if (success)
        result->contents_opaque_for_text = input.contents_opaque_for_text();
      if (success)
        result->is_drawable = input.is_drawable();
      if (success && !input.ReadBackgroundColor(&result->background_color))
        success = false;
      if (success && !input.ReadSafeOpaqueBackgroundColor(&result->safe_opaque_background_color))
        success = false;
      if (success && !input.ReadElementId(&result->element_id))
        success = false;
      if (success && !input.ReadUpdateRect(&result->update_rect))
        success = false;
      if (success && !input.ReadOffsetToTransformParent(&result->offset_to_transform_parent))
        success = false;
      if (success)
        result->transform_tree_index = input.transform_tree_index();
      if (success)
        result->clip_tree_index = input.clip_tree_index();
      if (success)
        result->effect_tree_index = input.effect_tree_index();
      if (success)
        result->scroll_tree_index = input.scroll_tree_index();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::AnchorPositionScrollData::DataView, ::viz::mojom::AnchorPositionScrollDataPtr>::Read(
    ::viz::mojom::AnchorPositionScrollData::DataView input,
    ::viz::mojom::AnchorPositionScrollDataPtr* output) {
  bool success = true;
  ::viz::mojom::AnchorPositionScrollDataPtr result(::viz::mojom::AnchorPositionScrollData::New());
  
      if (success && !input.ReadAdjustmentContainerIds(&result->adjustment_container_ids))
        success = false;
      if (success && !input.ReadAccumulatedScrollOrigin(&result->accumulated_scroll_origin))
        success = false;
      if (success)
        result->needs_scroll_adjustment_in_x = input.needs_scroll_adjustment_in_x();
      if (success)
        result->needs_scroll_adjustment_in_y = input.needs_scroll_adjustment_in_y();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::StickyPositionNodeData::DataView, ::viz::mojom::StickyPositionNodeDataPtr>::Read(
    ::viz::mojom::StickyPositionNodeData::DataView input,
    ::viz::mojom::StickyPositionNodeDataPtr* output) {
  bool success = true;
  ::viz::mojom::StickyPositionNodeDataPtr result(::viz::mojom::StickyPositionNodeData::New());
  
      if (success)
        result->scroll_ancestor = input.scroll_ancestor();
      if (success)
        result->is_anchored_left = input.is_anchored_left();
      if (success)
        result->is_anchored_right = input.is_anchored_right();
      if (success)
        result->is_anchored_top = input.is_anchored_top();
      if (success)
        result->is_anchored_bottom = input.is_anchored_bottom();
      if (success)
        result->left_offset = input.left_offset();
      if (success)
        result->right_offset = input.right_offset();
      if (success)
        result->top_offset = input.top_offset();
      if (success)
        result->bottom_offset = input.bottom_offset();
      if (success && !input.ReadConstraintBoxRect(&result->constraint_box_rect))
        success = false;
      if (success && !input.ReadScrollContainerRelativeStickyBoxRect(&result->scroll_container_relative_sticky_box_rect))
        success = false;
      if (success && !input.ReadScrollContainerRelativeContainingBlockRect(&result->scroll_container_relative_containing_block_rect))
        success = false;
      if (success)
        result->nearest_node_shifting_sticky_box = input.nearest_node_shifting_sticky_box();
      if (success)
        result->nearest_node_shifting_containing_block = input.nearest_node_shifting_containing_block();
      if (success && !input.ReadTotalStickyBoxStickyOffset(&result->total_sticky_box_sticky_offset))
        success = false;
      if (success && !input.ReadTotalContainingBlockStickyOffset(&result->total_containing_block_sticky_offset))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::TransformTreeUpdate::DataView, ::viz::mojom::TransformTreeUpdatePtr>::Read(
    ::viz::mojom::TransformTreeUpdate::DataView input,
    ::viz::mojom::TransformTreeUpdatePtr* output) {
  bool success = true;
  ::viz::mojom::TransformTreeUpdatePtr result(::viz::mojom::TransformTreeUpdate::New());
  
      if (success)
        result->page_scale_factor = input.page_scale_factor();
      if (success)
        result->device_scale_factor = input.device_scale_factor();
      if (success)
        result->device_transform_scale_factor = input.device_transform_scale_factor();
      if (success && !input.ReadNodesAffectedByOuterViewportBoundsDelta(&result->nodes_affected_by_outer_viewport_bounds_delta))
        success = false;
      if (success && !input.ReadStickyPositionData(&result->sticky_position_data))
        success = false;
      if (success && !input.ReadAnchorPositionScrollData(&result->anchor_position_scroll_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::TransformNode::DataView, ::viz::mojom::TransformNodePtr>::Read(
    ::viz::mojom::TransformNode::DataView input,
    ::viz::mojom::TransformNodePtr* output) {
  bool success = true;
  ::viz::mojom::TransformNodePtr result(::viz::mojom::TransformNode::New());
  
      if (success)
        result->id = input.id();
      if (success)
        result->parent_id = input.parent_id();
      if (success)
        result->parent_frame_id = input.parent_frame_id();
      if (success && !input.ReadElementId(&result->element_id))
        success = false;
      if (success && !input.ReadLocal(&result->local))
        success = false;
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success && !input.ReadScrollOffset(&result->scroll_offset))
        success = false;
      if (success && !input.ReadSnapAmount(&result->snap_amount))
        success = false;
      if (success) {
        result->sticky_position_constraint_id = input.sticky_position_constraint_id();
      }
      if (success) {
        result->anchor_position_scroll_data_id = input.anchor_position_scroll_data_id();
      }
      if (success)
        result->sorting_context_id = input.sorting_context_id();
      if (success)
        result->has_potential_animation = input.has_potential_animation();
      if (success)
        result->is_currently_animating = input.is_currently_animating();
      if (success)
        result->flattens_inherited_transform = input.flattens_inherited_transform();
      if (success)
        result->scrolls = input.scrolls();
      if (success)
        result->should_undo_overscroll = input.should_undo_overscroll();
      if (success)
        result->should_be_snapped = input.should_be_snapped();
      if (success)
        result->moved_by_outer_viewport_bounds_delta_y = input.moved_by_outer_viewport_bounds_delta_y();
      if (success)
        result->in_subtree_of_page_scale_layer = input.in_subtree_of_page_scale_layer();
      if (success)
        result->transform_changed = input.transform_changed();
      if (success)
        result->delegates_to_parent_for_backface = input.delegates_to_parent_for_backface();
      if (success)
        result->will_change_transform = input.will_change_transform();
      if (success && !input.ReadVisibleFrameElementId(&result->visible_frame_element_id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::ClipNode::DataView, ::viz::mojom::ClipNodePtr>::Read(
    ::viz::mojom::ClipNode::DataView input,
    ::viz::mojom::ClipNodePtr* output) {
  bool success = true;
  ::viz::mojom::ClipNodePtr result(::viz::mojom::ClipNode::New());
  
      if (success)
        result->id = input.id();
      if (success)
        result->parent_id = input.parent_id();
      if (success)
        result->transform_id = input.transform_id();
      if (success && !input.ReadClip(&result->clip))
        success = false;
      if (success)
        result->pixel_moving_filter_id = input.pixel_moving_filter_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::EffectNode::DataView, ::viz::mojom::EffectNodePtr>::Read(
    ::viz::mojom::EffectNode::DataView input,
    ::viz::mojom::EffectNodePtr* output) {
  bool success = true;
  ::viz::mojom::EffectNodePtr result(::viz::mojom::EffectNode::New());
  
      if (success)
        result->id = input.id();
      if (success)
        result->parent_id = input.parent_id();
      if (success)
        result->transform_id = input.transform_id();
      if (success)
        result->clip_id = input.clip_id();
      if (success && !input.ReadElementId(&result->element_id))
        success = false;
      if (success)
        result->opacity = input.opacity();
      if (success)
        result->has_render_surface = input.has_render_surface();
      if (success && !input.ReadSurfaceContentsScale(&result->surface_contents_scale))
        success = false;
      if (success)
        result->blend_mode = input.blend_mode();
      if (success)
        result->target_id = input.target_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::ScrollNode::DataView, ::viz::mojom::ScrollNodePtr>::Read(
    ::viz::mojom::ScrollNode::DataView input,
    ::viz::mojom::ScrollNodePtr* output) {
  bool success = true;
  ::viz::mojom::ScrollNodePtr result(::viz::mojom::ScrollNode::New());
  
      if (success)
        result->id = input.id();
      if (success)
        result->parent_id = input.parent_id();
      if (success)
        result->transform_id = input.transform_id();
      if (success && !input.ReadContainerBounds(&result->container_bounds))
        success = false;
      if (success && !input.ReadBounds(&result->bounds))
        success = false;
      if (success && !input.ReadElementId(&result->element_id))
        success = false;
      if (success)
        result->max_scroll_offset_affected_by_page_scale = input.max_scroll_offset_affected_by_page_scale();
      if (success)
        result->scrolls_inner_viewport = input.scrolls_inner_viewport();
      if (success)
        result->scrolls_outer_viewport = input.scrolls_outer_viewport();
      if (success)
        result->prevent_viewport_scrolling_from_inner = input.prevent_viewport_scrolling_from_inner();
      if (success)
        result->user_scrollable_horizontal = input.user_scrollable_horizontal();
      if (success)
        result->user_scrollable_vertical = input.user_scrollable_vertical();
      if (success)
        result->is_composited = input.is_composited();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom {




}  // viz::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif