// services/viz/public/mojom/compositing/selection.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SELECTION_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SELECTION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/selection.mojom-shared-internal.h"
#include "ui/gfx/mojom/selection_bound.mojom-shared.h"







namespace viz::mojom {
class SelectionDataView;



}  // viz::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::SelectionDataView> {
  using Data = ::viz::mojom::internal::Selection_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


class SelectionDataView {
 public:
  SelectionDataView() = default;

  SelectionDataView(
      internal::Selection_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStartDataView(
      ::gfx::mojom::SelectionBoundDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStart(UserType* output) {
    
    auto* pointer = data_->start.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SelectionBoundDataView>(
        pointer, output, message_);
  }
  inline void GetEndDataView(
      ::gfx::mojom::SelectionBoundDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEnd(UserType* output) {
    
    auto* pointer = data_->end.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SelectionBoundDataView>(
        pointer, output, message_);
  }
 private:
  internal::Selection_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // viz::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::SelectionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::SelectionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::Selection_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::start(input)) in_start = Traits::start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->start)::BaseType> start_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SelectionBoundDataView>(
        in_start, start_fragment);
    fragment->start.Set(
        start_fragment.is_null() ? nullptr : start_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->start.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null start in Selection struct");
    decltype(Traits::end(input)) in_end = Traits::end(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->end)::BaseType> end_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SelectionBoundDataView>(
        in_end, end_fragment);
    fragment->end.Set(
        end_fragment.is_null() ? nullptr : end_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->end.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null end in Selection struct");
  }

  static bool Deserialize(::viz::mojom::internal::Selection_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::SelectionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void SelectionDataView::GetStartDataView(
    ::gfx::mojom::SelectionBoundDataView* output) {
  auto pointer = data_->start.Get();
  *output = ::gfx::mojom::SelectionBoundDataView(pointer, message_);
}
inline void SelectionDataView::GetEndDataView(
    ::gfx::mojom::SelectionBoundDataView* output) {
  auto pointer = data_->end.Get();
  *output = ::gfx::mojom::SelectionBoundDataView(pointer, message_);
}



}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SELECTION_MOJOM_SHARED_H_