// third_party/blink/public/mojom/ai/ai_language_model.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/ai/ai_language_model.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/ai/ai_language_model.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* AILanguageModelInitialPromptRoleToStringHelper(AILanguageModelInitialPromptRole value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AILanguageModelInitialPromptRole::kSystem:
      return "kSystem";
    case AILanguageModelInitialPromptRole::kUser:
      return "kUser";
    case AILanguageModelInitialPromptRole::kAssistant:
      return "kAssistant";
    default:
      return nullptr;
  }
}

std::string AILanguageModelInitialPromptRoleToString(AILanguageModelInitialPromptRole value) {
  const char *str = AILanguageModelInitialPromptRoleToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AILanguageModelInitialPromptRole value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AILanguageModelInitialPromptRole value) {
  return os << AILanguageModelInitialPromptRoleToString(value);
}

NOINLINE static const char* AIManagerCreateLanguageModelErrorToStringHelper(AIManagerCreateLanguageModelError value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AIManagerCreateLanguageModelError::kUnableToCreateSession:
      return "kUnableToCreateSession";
    case AIManagerCreateLanguageModelError::kUnableToCalculateTokenSize:
      return "kUnableToCalculateTokenSize";
    case AIManagerCreateLanguageModelError::kInitialPromptsTooLarge:
      return "kInitialPromptsTooLarge";
    default:
      return nullptr;
  }
}

std::string AIManagerCreateLanguageModelErrorToString(AIManagerCreateLanguageModelError value) {
  const char *str = AIManagerCreateLanguageModelErrorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AIManagerCreateLanguageModelError value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AIManagerCreateLanguageModelError value) {
  return os << AIManagerCreateLanguageModelErrorToString(value);
}

namespace internal {


// static
bool AILanguageModelSamplingParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AILanguageModelSamplingParams_Data* object =
      static_cast<const AILanguageModelSamplingParams_Data*>(data);

  return true;
}

AILanguageModelSamplingParams_Data::AILanguageModelSamplingParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AILanguageModelParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AILanguageModelParams_Data* object =
      static_cast<const AILanguageModelParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->default_sampling_params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->default_sampling_params, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->max_sampling_params, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->max_sampling_params, validation_context))
    return false;

  return true;
}

AILanguageModelParams_Data::AILanguageModelParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AILanguageModelInstanceInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AILanguageModelInstanceInfo_Data* object =
      static_cast<const AILanguageModelInstanceInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sampling_params, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->sampling_params, validation_context))
    return false;

  return true;
}

AILanguageModelInstanceInfo_Data::AILanguageModelInstanceInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AILanguageModelInitialPrompt_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AILanguageModelInitialPrompt_Data* object =
      static_cast<const AILanguageModelInitialPrompt_Data*>(data);


  if (!::blink::mojom::internal::AILanguageModelInitialPromptRole_Data
        ::Validate(object->role, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->content, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& content_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->content, validation_context,
                                         &content_validate_params)) {
    return false;
  }

  return true;
}

AILanguageModelInitialPrompt_Data::AILanguageModelInitialPrompt_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AILanguageModelCreateOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AILanguageModelCreateOptions_Data* object =
      static_cast<const AILanguageModelCreateOptions_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->sampling_params, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& system_prompt_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->system_prompt, validation_context,
                                         &system_prompt_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->initial_prompts, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& initial_prompts_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->initial_prompts, validation_context,
                                         &initial_prompts_validate_params)) {
    return false;
  }

  return true;
}

AILanguageModelCreateOptions_Data::AILanguageModelCreateOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AIManagerCreateLanguageModelClient_OnResult_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AIManagerCreateLanguageModelClient_OnResult_Params_Data* object =
      static_cast<const AIManagerCreateLanguageModelClient_OnResult_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->language_model_remote, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->language_model_remote,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;

  return true;
}

AIManagerCreateLanguageModelClient_OnResult_Params_Data::AIManagerCreateLanguageModelClient_OnResult_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AIManagerCreateLanguageModelClient_OnError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AIManagerCreateLanguageModelClient_OnError_Params_Data* object =
      static_cast<const AIManagerCreateLanguageModelClient_OnError_Params_Data*>(data);


  if (!::blink::mojom::internal::AIManagerCreateLanguageModelError_Data
        ::Validate(object->error, validation_context))
    return false;

  return true;
}

AIManagerCreateLanguageModelClient_OnError_Params_Data::AIManagerCreateLanguageModelClient_OnError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AILanguageModelCountPromptTokensClient_OnResult_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AILanguageModelCountPromptTokensClient_OnResult_Params_Data* object =
      static_cast<const AILanguageModelCountPromptTokensClient_OnResult_Params_Data*>(data);

  return true;
}

AILanguageModelCountPromptTokensClient_OnResult_Params_Data::AILanguageModelCountPromptTokensClient_OnResult_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AILanguageModel_Prompt_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AILanguageModel_Prompt_Params_Data* object =
      static_cast<const AILanguageModel_Prompt_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& input_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->input, validation_context,
                                         &input_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->pending_responder, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->pending_responder,
                                                 validation_context)) {
    return false;
  }

  return true;
}

AILanguageModel_Prompt_Params_Data::AILanguageModel_Prompt_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AILanguageModel_Fork_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AILanguageModel_Fork_Params_Data* object =
      static_cast<const AILanguageModel_Fork_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

AILanguageModel_Fork_Params_Data::AILanguageModel_Fork_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AILanguageModel_Destroy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AILanguageModel_Destroy_Params_Data* object =
      static_cast<const AILanguageModel_Destroy_Params_Data*>(data);

  return true;
}

AILanguageModel_Destroy_Params_Data::AILanguageModel_Destroy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AILanguageModel_CountPromptTokens_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AILanguageModel_CountPromptTokens_Params_Data* object =
      static_cast<const AILanguageModel_CountPromptTokens_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& input_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->input, validation_context,
                                         &input_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

AILanguageModel_CountPromptTokens_Params_Data::AILanguageModel_CountPromptTokens_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::AILanguageModelInitialPromptRole>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::AILanguageModelInitialPromptRole value) {
  return std::move(context).WriteString(::blink::mojom::AILanguageModelInitialPromptRoleToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::AIManagerCreateLanguageModelError>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::AIManagerCreateLanguageModelError value) {
  return std::move(context).WriteString(::blink::mojom::AIManagerCreateLanguageModelErrorToString(value));
}

} // namespace perfetto