// third_party/blink/public/mojom/content_extraction/ai_page_content.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/content_extraction/ai_page_content.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/content_extraction/ai_page_content.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* AIPageContentAttributeTypeToStringHelper(AIPageContentAttributeType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AIPageContentAttributeType::kRoot:
      return "kRoot";
    case AIPageContentAttributeType::kIframe:
      return "kIframe";
    case AIPageContentAttributeType::kContainer:
      return "kContainer";
    case AIPageContentAttributeType::kText:
      return "kText";
    case AIPageContentAttributeType::kAnchor:
      return "kAnchor";
    case AIPageContentAttributeType::kParagraph:
      return "kParagraph";
    case AIPageContentAttributeType::kHeading:
      return "kHeading";
    case AIPageContentAttributeType::kImage:
      return "kImage";
    case AIPageContentAttributeType::kForm:
      return "kForm";
    case AIPageContentAttributeType::kFormControl:
      return "kFormControl";
    case AIPageContentAttributeType::kTable:
      return "kTable";
    case AIPageContentAttributeType::kTableRow:
      return "kTableRow";
    case AIPageContentAttributeType::kTableCell:
      return "kTableCell";
    case AIPageContentAttributeType::kOrderedList:
      return "kOrderedList";
    case AIPageContentAttributeType::kUnorderedList:
      return "kUnorderedList";
    case AIPageContentAttributeType::kListItem:
      return "kListItem";
    default:
      return nullptr;
  }
}

std::string AIPageContentAttributeTypeToString(AIPageContentAttributeType value) {
  const char *str = AIPageContentAttributeTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AIPageContentAttributeType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AIPageContentAttributeType value) {
  return os << AIPageContentAttributeTypeToString(value);
}

NOINLINE static const char* AIPageContentAnnotatedRoleToStringHelper(AIPageContentAnnotatedRole value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AIPageContentAnnotatedRole::kHeader:
      return "kHeader";
    case AIPageContentAnnotatedRole::kNav:
      return "kNav";
    case AIPageContentAnnotatedRole::kSearch:
      return "kSearch";
    case AIPageContentAnnotatedRole::kMain:
      return "kMain";
    case AIPageContentAnnotatedRole::kArticle:
      return "kArticle";
    case AIPageContentAnnotatedRole::kSection:
      return "kSection";
    case AIPageContentAnnotatedRole::kAside:
      return "kAside";
    case AIPageContentAnnotatedRole::kFooter:
      return "kFooter";
    case AIPageContentAnnotatedRole::kContentHidden:
      return "kContentHidden";
    default:
      return nullptr;
  }
}

std::string AIPageContentAnnotatedRoleToString(AIPageContentAnnotatedRole value) {
  const char *str = AIPageContentAnnotatedRoleToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AIPageContentAnnotatedRole value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AIPageContentAnnotatedRole value) {
  return os << AIPageContentAnnotatedRoleToString(value);
}

NOINLINE static const char* AIPageContentTextSizeToStringHelper(AIPageContentTextSize value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AIPageContentTextSize::kXS:
      return "kXS";
    case AIPageContentTextSize::kS:
      return "kS";
    case AIPageContentTextSize::kM:
      return "kM";
    case AIPageContentTextSize::kL:
      return "kL";
    case AIPageContentTextSize::kXL:
      return "kXL";
    default:
      return nullptr;
  }
}

std::string AIPageContentTextSizeToString(AIPageContentTextSize value) {
  const char *str = AIPageContentTextSizeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AIPageContentTextSize value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AIPageContentTextSize value) {
  return os << AIPageContentTextSizeToString(value);
}

NOINLINE static const char* AIPageContentAnchorRelToStringHelper(AIPageContentAnchorRel value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AIPageContentAnchorRel::kRelationUnknown:
      return "kRelationUnknown";
    case AIPageContentAnchorRel::kRelationNoReferrer:
      return "kRelationNoReferrer";
    case AIPageContentAnchorRel::kRelationNoOpener:
      return "kRelationNoOpener";
    case AIPageContentAnchorRel::kRelationOpener:
      return "kRelationOpener";
    case AIPageContentAnchorRel::kRelationPrivacyPolicy:
      return "kRelationPrivacyPolicy";
    case AIPageContentAnchorRel::kRelationTermsOfService:
      return "kRelationTermsOfService";
    default:
      return nullptr;
  }
}

std::string AIPageContentAnchorRelToString(AIPageContentAnchorRel value) {
  const char *str = AIPageContentAnchorRelToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AIPageContentAnchorRel value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AIPageContentAnchorRel value) {
  return os << AIPageContentAnchorRelToString(value);
}

NOINLINE static const char* AIPageContentTableRowTypeToStringHelper(AIPageContentTableRowType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AIPageContentTableRowType::kHeader:
      return "kHeader";
    case AIPageContentTableRowType::kBody:
      return "kBody";
    case AIPageContentTableRowType::kFooter:
      return "kFooter";
    default:
      return nullptr;
  }
}

std::string AIPageContentTableRowTypeToString(AIPageContentTableRowType value) {
  const char *str = AIPageContentTableRowTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AIPageContentTableRowType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AIPageContentTableRowType value) {
  return os << AIPageContentTableRowTypeToString(value);
}

namespace internal {


// static
bool AIPageContentGeometry_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AIPageContentGeometry_Data* object =
      static_cast<const AIPageContentGeometry_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->outer_bounding_box, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->outer_bounding_box, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->visible_bounding_box, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->visible_bounding_box, validation_context))
    return false;

  return true;
}

AIPageContentGeometry_Data::AIPageContentGeometry_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AIPageContentTextStyle_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AIPageContentTextStyle_Data* object =
      static_cast<const AIPageContentTextStyle_Data*>(data);


  if (!::blink::mojom::internal::AIPageContentTextSize_Data
        ::Validate(object->text_size, validation_context))
    return false;

  return true;
}

AIPageContentTextStyle_Data::AIPageContentTextStyle_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AIPageContentTextInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AIPageContentTextInfo_Data* object =
      static_cast<const AIPageContentTextInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_content, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& text_content_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->text_content, validation_context,
                                         &text_content_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_style, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->text_style, validation_context))
    return false;

  return true;
}

AIPageContentTextInfo_Data::AIPageContentTextInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AIPageContentAnchorData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AIPageContentAnchorData_Data* object =
      static_cast<const AIPageContentAnchorData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rel, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& rel_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::AIPageContentAnchorRel_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->rel, validation_context,
                                         &rel_validate_params)) {
    return false;
  }

  return true;
}

AIPageContentAnchorData_Data::AIPageContentAnchorData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AIPageContentImageInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AIPageContentImageInfo_Data* object =
      static_cast<const AIPageContentImageInfo_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& image_caption_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->image_caption, validation_context,
                                         &image_caption_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->source_origin, validation_context))
    return false;

  return true;
}

AIPageContentImageInfo_Data::AIPageContentImageInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AIPageContentIframeData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AIPageContentIframeData_Data* object =
      static_cast<const AIPageContentIframeData_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->frame_token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->frame_token, validation_context))
    return false;

  return true;
}

AIPageContentIframeData_Data::AIPageContentIframeData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AIPageContentTableData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AIPageContentTableData_Data* object =
      static_cast<const AIPageContentTableData_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& table_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->table_name, validation_context,
                                         &table_name_validate_params)) {
    return false;
  }

  return true;
}

AIPageContentTableData_Data::AIPageContentTableData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AIPageContentTableRowData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AIPageContentTableRowData_Data* object =
      static_cast<const AIPageContentTableRowData_Data*>(data);


  if (!::blink::mojom::internal::AIPageContentTableRowType_Data
        ::Validate(object->row_type, validation_context))
    return false;

  return true;
}

AIPageContentTableRowData_Data::AIPageContentTableRowData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AIPageContentFormData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AIPageContentFormData_Data* object =
      static_cast<const AIPageContentFormData_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& form_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->form_name, validation_context,
                                         &form_name_validate_params)) {
    return false;
  }

  return true;
}

AIPageContentFormData_Data::AIPageContentFormData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AIPageContentSelectOption_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AIPageContentSelectOption_Data* object =
      static_cast<const AIPageContentSelectOption_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->value, validation_context,
                                         &value_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->text, validation_context,
                                         &text_validate_params)) {
    return false;
  }

  return true;
}

AIPageContentSelectOption_Data::AIPageContentSelectOption_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AIPageContentFormControlData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AIPageContentFormControlData_Data* object =
      static_cast<const AIPageContentFormControlData_Data*>(data);


  if (!::blink::mojom::internal::FormControlType_Data
        ::Validate(object->form_control_type, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& field_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->field_name, validation_context,
                                         &field_name_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& field_value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->field_value, validation_context,
                                         &field_value_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->select_options, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& select_options_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->select_options, validation_context,
                                         &select_options_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& placeholder_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->placeholder, validation_context,
                                         &placeholder_validate_params)) {
    return false;
  }

  return true;
}

AIPageContentFormControlData_Data::AIPageContentFormControlData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AIPageContentAttributes_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 112, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AIPageContentAttributes_Data* object =
      static_cast<const AIPageContentAttributes_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->dom_node_ids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& dom_node_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->dom_node_ids, validation_context,
                                         &dom_node_ids_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::AIPageContentAttributeType_Data
        ::Validate(object->attribute_type, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->geometry, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->text_info, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->image_info, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->anchor_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->form_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->form_control_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->table_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->iframe_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->table_row_data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->annotated_roles, 14, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& annotated_roles_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::AIPageContentAnnotatedRole_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->annotated_roles, validation_context,
                                         &annotated_roles_validate_params)) {
    return false;
  }

  return true;
}

AIPageContentAttributes_Data::AIPageContentAttributes_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AIPageContentNode_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AIPageContentNode_Data* object =
      static_cast<const AIPageContentNode_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->children_nodes, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& children_nodes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->children_nodes, validation_context,
                                         &children_nodes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->content_attributes, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->content_attributes, validation_context))
    return false;

  return true;
}

AIPageContentNode_Data::AIPageContentNode_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AIPageContent_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AIPageContent_Data* object =
      static_cast<const AIPageContent_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->root_node, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->root_node, validation_context))
    return false;

  return true;
}

AIPageContent_Data::AIPageContent_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AIPageContentOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AIPageContentOptions_Data* object =
      static_cast<const AIPageContentOptions_Data*>(data);

  return true;
}

AIPageContentOptions_Data::AIPageContentOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AIPageContentAgent_GetAIPageContent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AIPageContentAgent_GetAIPageContent_Params_Data* object =
      static_cast<const AIPageContentAgent_GetAIPageContent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  return true;
}

AIPageContentAgent_GetAIPageContent_Params_Data::AIPageContentAgent_GetAIPageContent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AIPageContentAgent_GetAIPageContent_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AIPageContentAgent_GetAIPageContent_ResponseParams_Data* object =
      static_cast<const AIPageContentAgent_GetAIPageContent_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->page_content, validation_context))
    return false;

  return true;
}

AIPageContentAgent_GetAIPageContent_ResponseParams_Data::AIPageContentAgent_GetAIPageContent_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::AIPageContentAttributeType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::AIPageContentAttributeType value) {
  return std::move(context).WriteString(::blink::mojom::AIPageContentAttributeTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::AIPageContentAnnotatedRole>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::AIPageContentAnnotatedRole value) {
  return std::move(context).WriteString(::blink::mojom::AIPageContentAnnotatedRoleToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::AIPageContentTextSize>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::AIPageContentTextSize value) {
  return std::move(context).WriteString(::blink::mojom::AIPageContentTextSizeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::AIPageContentAnchorRel>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::AIPageContentAnchorRel value) {
  return std::move(context).WriteString(::blink::mojom::AIPageContentAnchorRelToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::AIPageContentTableRowType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::AIPageContentTableRowType value) {
  return std::move(context).WriteString(::blink::mojom::AIPageContentTableRowTypeToString(value));
}

} // namespace perfetto