// third_party/blink/public/mojom/webpreferences/web_preferences.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBPREFERENCES_WEB_PREFERENCES_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBPREFERENCES_WEB_PREFERENCES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/webpreferences/web_preferences.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/css/preferred_color_scheme.mojom-shared.h"
#include "third_party/blink/public/mojom/css/preferred_contrast.mojom-shared.h"
#include "third_party/blink/public/mojom/v8_cache_options.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"



#include "base/component_export.h"




namespace blink::mojom {
class WebPreferencesDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::WebPreferencesDataView> {
  using Data = ::blink::mojom::internal::WebPreferences_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class PointerType : int32_t {
  
  kPointerNone = 1,
  
  kPointerFirstType = 1,
  
  kPointerCoarseType = 2,
  
  kPointerFineType = 4,
  kMinValue = 1,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PointerType value);
inline bool IsKnownEnumValue(PointerType value) {
  return internal::PointerType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class HoverType : int32_t {
  
  kHoverNone = 1,
  
  kHoverFirstType = 1,
  
  kHoverHoverType = 2,
  kMinValue = 1,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, HoverType value);
inline bool IsKnownEnumValue(HoverType value) {
  return internal::HoverType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class OutputDeviceUpdateAbilityType : int32_t {
  
  kSlowType = 0,
  
  kFastType = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, OutputDeviceUpdateAbilityType value);
inline bool IsKnownEnumValue(OutputDeviceUpdateAbilityType value) {
  return internal::OutputDeviceUpdateAbilityType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class EditingBehavior : int32_t {
  
  kEditingMacBehavior = 0,
  
  kEditingWindowsBehavior = 1,
  
  kEditingUnixBehavior = 2,
  
  kEditingAndroidBehavior = 3,
  
  kEditingChromeOSBehavior = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, EditingBehavior value);
inline bool IsKnownEnumValue(EditingBehavior value) {
  return internal::EditingBehavior_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ImageAnimationPolicy : int32_t {
  
  kImageAnimationPolicyAllowed = 0,
  
  kImageAnimationPolicyAnimateOnce = 1,
  
  kImageAnimationPolicyNoAnimation = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ImageAnimationPolicy value);
inline bool IsKnownEnumValue(ImageAnimationPolicy value) {
  return internal::ImageAnimationPolicy_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ViewportStyle : int32_t {
  
  kDefault = 0,
  
  kMobile = 1,
  
  kTelevision = 2,
  
  kLast = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ViewportStyle value);
inline bool IsKnownEnumValue(ViewportStyle value) {
  return internal::ViewportStyle_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AutoplayPolicy : int32_t {
  
  kNoUserGestureRequired = 0,
  
  kUserGestureRequired = 1,
  
  kDocumentUserActivationRequired = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, AutoplayPolicy value);
inline bool IsKnownEnumValue(AutoplayPolicy value) {
  return internal::AutoplayPolicy_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class EffectiveConnectionType : int32_t {
  
  kEffectiveConnectionUnknownType = 0,
  
  kEffectiveConnectionOfflineType = 1,
  
  kEffectiveConnectionSlow2GType = 2,
  
  kEffectiveConnection2GType = 3,
  
  kEffectiveConnection3GType = 4,
  
  kEffectiveConnection4GType = 5,
  
  kEffectiveConnectionTypeLast = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, EffectiveConnectionType value);
inline bool IsKnownEnumValue(EffectiveConnectionType value) {
  return internal::EffectiveConnectionType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class WebPreferencesDataView {
 public:
  WebPreferencesDataView() = default;

  WebPreferencesDataView(
      internal::WebPreferences_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStandardFontFamilyMapDataView(
      mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStandardFontFamilyMap(UserType* output) {
    
    auto* pointer = data_->standard_font_family_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>>(
        pointer, output, message_);
  }
  inline void GetFixedFontFamilyMapDataView(
      mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFixedFontFamilyMap(UserType* output) {
    
    auto* pointer = data_->fixed_font_family_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>>(
        pointer, output, message_);
  }
  inline void GetSerifFontFamilyMapDataView(
      mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSerifFontFamilyMap(UserType* output) {
    
    auto* pointer = data_->serif_font_family_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>>(
        pointer, output, message_);
  }
  inline void GetSansSerifFontFamilyMapDataView(
      mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSansSerifFontFamilyMap(UserType* output) {
    
    auto* pointer = data_->sans_serif_font_family_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>>(
        pointer, output, message_);
  }
  inline void GetCursiveFontFamilyMapDataView(
      mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCursiveFontFamilyMap(UserType* output) {
    
    auto* pointer = data_->cursive_font_family_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>>(
        pointer, output, message_);
  }
  inline void GetFantasyFontFamilyMapDataView(
      mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFantasyFontFamilyMap(UserType* output) {
    
    auto* pointer = data_->fantasy_font_family_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>>(
        pointer, output, message_);
  }
  inline void GetMathFontFamilyMapDataView(
      mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMathFontFamilyMap(UserType* output) {
    
    auto* pointer = data_->math_font_family_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>>(
        pointer, output, message_);
  }
  int32_t default_font_size() const {
    return data_->default_font_size;
  }
  int32_t default_fixed_font_size() const {
    return data_->default_fixed_font_size;
  }
  int32_t minimum_font_size() const {
    return data_->minimum_font_size;
  }
  int32_t minimum_logical_font_size() const {
    return data_->minimum_logical_font_size;
  }
  inline void GetDefaultEncodingDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDefaultEncoding(UserType* output) {
    
    auto* pointer = data_->default_encoding.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool context_menu_on_mouse_up() const {
    return data_->context_menu_on_mouse_up;
  }
  bool javascript_enabled() const {
    return data_->javascript_enabled;
  }
  bool web_security_enabled() const {
    return data_->web_security_enabled;
  }
  bool loads_images_automatically() const {
    return data_->loads_images_automatically;
  }
  bool images_enabled() const {
    return data_->images_enabled;
  }
  bool plugins_enabled() const {
    return data_->plugins_enabled;
  }
  bool dom_paste_enabled() const {
    return data_->dom_paste_enabled;
  }
  bool shrinks_standalone_images_to_fit() const {
    return data_->shrinks_standalone_images_to_fit;
  }
  bool text_areas_are_resizable() const {
    return data_->text_areas_are_resizable;
  }
  bool allow_scripts_to_close_windows() const {
    return data_->allow_scripts_to_close_windows;
  }
  bool remote_fonts_enabled() const {
    return data_->remote_fonts_enabled;
  }
  bool javascript_can_access_clipboard() const {
    return data_->javascript_can_access_clipboard;
  }
  bool dns_prefetching_enabled() const {
    return data_->dns_prefetching_enabled;
  }
  bool data_saver_enabled() const {
    return data_->data_saver_enabled;
  }
  bool local_storage_enabled() const {
    return data_->local_storage_enabled;
  }
  bool databases_enabled() const {
    return data_->databases_enabled;
  }
  bool tabs_to_links() const {
    return data_->tabs_to_links;
  }
  bool disable_ipc_flooding_protection() const {
    return data_->disable_ipc_flooding_protection;
  }
  bool hyperlink_auditing_enabled() const {
    return data_->hyperlink_auditing_enabled;
  }
  bool allow_universal_access_from_file_urls() const {
    return data_->allow_universal_access_from_file_urls;
  }
  bool allow_file_access_from_file_urls() const {
    return data_->allow_file_access_from_file_urls;
  }
  bool allow_remote_access_from_local_urls() const {
    return data_->allow_remote_access_from_local_urls;
  }
  bool webgl1_enabled() const {
    return data_->webgl1_enabled;
  }
  bool webgl2_enabled() const {
    return data_->webgl2_enabled;
  }
  bool pepper_3d_enabled() const {
    return data_->pepper_3d_enabled;
  }
  bool privileged_webgl_extensions_enabled() const {
    return data_->privileged_webgl_extensions_enabled;
  }
  bool webgl_errors_to_console_enabled() const {
    return data_->webgl_errors_to_console_enabled;
  }
  bool hide_scrollbars() const {
    return data_->hide_scrollbars;
  }
  bool prefers_default_scrollbar_styles() const {
    return data_->prefers_default_scrollbar_styles;
  }
  bool accelerated_2d_canvas_enabled() const {
    return data_->accelerated_2d_canvas_enabled;
  }
  bool canvas_2d_layers_enabled() const {
    return data_->canvas_2d_layers_enabled;
  }
  bool antialiased_2d_canvas_disabled() const {
    return data_->antialiased_2d_canvas_disabled;
  }
  bool antialiased_clips_2d_canvas_enabled() const {
    return data_->antialiased_clips_2d_canvas_enabled;
  }
  bool accelerated_filters_enabled() const {
    return data_->accelerated_filters_enabled;
  }
  bool deferred_filters_enabled() const {
    return data_->deferred_filters_enabled;
  }
  bool container_culling_enabled() const {
    return data_->container_culling_enabled;
  }
  bool allow_running_insecure_content() const {
    return data_->allow_running_insecure_content;
  }
  bool disable_reading_from_canvas() const {
    return data_->disable_reading_from_canvas;
  }
  bool strict_mixed_content_checking() const {
    return data_->strict_mixed_content_checking;
  }
  bool strict_powerful_feature_restrictions() const {
    return data_->strict_powerful_feature_restrictions;
  }
  bool allow_geolocation_on_insecure_origins() const {
    return data_->allow_geolocation_on_insecure_origins;
  }
  bool strictly_block_blockable_mixed_content() const {
    return data_->strictly_block_blockable_mixed_content;
  }
  bool block_mixed_plugin_content() const {
    return data_->block_mixed_plugin_content;
  }
  bool password_echo_enabled() const {
    return data_->password_echo_enabled;
  }
  bool should_clear_document_background() const {
    return data_->should_clear_document_background;
  }
  bool enable_scroll_animator() const {
    return data_->enable_scroll_animator;
  }
  bool prefers_reduced_motion() const {
    return data_->prefers_reduced_motion;
  }
  bool prefers_reduced_transparency() const {
    return data_->prefers_reduced_transparency;
  }
  bool inverted_colors() const {
    return data_->inverted_colors;
  }
  bool touch_event_feature_detection_enabled() const {
    return data_->touch_event_feature_detection_enabled;
  }
  bool enable_error_page() const {
    return data_->enable_error_page;
  }
  int32_t pointer_events_max_touch_points() const {
    return data_->pointer_events_max_touch_points;
  }
  int32_t available_pointer_types() const {
    return data_->available_pointer_types;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPrimaryPointerType(UserType* output) const {
    auto data_value = data_->primary_pointer_type;
    return mojo::internal::Deserialize<::blink::mojom::PointerType>(
        data_value, output);
  }
  PointerType primary_pointer_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::PointerType>(data_->primary_pointer_type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadOutputDeviceUpdateAbilityType(UserType* output) const {
    auto data_value = data_->output_device_update_ability_type;
    return mojo::internal::Deserialize<::blink::mojom::OutputDeviceUpdateAbilityType>(
        data_value, output);
  }
  OutputDeviceUpdateAbilityType output_device_update_ability_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::OutputDeviceUpdateAbilityType>(data_->output_device_update_ability_type));
  }
  int32_t available_hover_types() const {
    return data_->available_hover_types;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPrimaryHoverType(UserType* output) const {
    auto data_value = data_->primary_hover_type;
    return mojo::internal::Deserialize<::blink::mojom::HoverType>(
        data_value, output);
  }
  HoverType primary_hover_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::HoverType>(data_->primary_hover_type));
  }
  bool dont_send_key_events_to_javascript() const {
    return data_->dont_send_key_events_to_javascript;
  }
  bool barrel_button_for_drag_enabled() const {
    return data_->barrel_button_for_drag_enabled;
  }
  bool sync_xhr_in_documents_enabled() const {
    return data_->sync_xhr_in_documents_enabled;
  }
  bool target_blank_implies_no_opener_enabled_will_be_removed() const {
    return data_->target_blank_implies_no_opener_enabled_will_be_removed;
  }
  bool allow_non_empty_navigator_plugins() const {
    return data_->allow_non_empty_navigator_plugins;
  }
  int32_t number_of_cpu_cores() const {
    return data_->number_of_cpu_cores;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadEditingBehavior(UserType* output) const {
    auto data_value = data_->editing_behavior;
    return mojo::internal::Deserialize<::blink::mojom::EditingBehavior>(
        data_value, output);
  }
  EditingBehavior editing_behavior() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::EditingBehavior>(data_->editing_behavior));
  }
  bool supports_multiple_windows() const {
    return data_->supports_multiple_windows;
  }
  bool viewport_enabled() const {
    return data_->viewport_enabled;
  }
  bool viewport_meta_enabled() const {
    return data_->viewport_meta_enabled;
  }
  bool auto_zoom_focused_editable_to_legible_scale() const {
    return data_->auto_zoom_focused_editable_to_legible_scale;
  }
  bool shrinks_viewport_contents_to_fit() const {
    return data_->shrinks_viewport_contents_to_fit;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadViewportStyle(UserType* output) const {
    auto data_value = data_->viewport_style;
    return mojo::internal::Deserialize<::blink::mojom::ViewportStyle>(
        data_value, output);
  }
  ViewportStyle viewport_style() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ViewportStyle>(data_->viewport_style));
  }
  bool smooth_scroll_for_find_enabled() const {
    return data_->smooth_scroll_for_find_enabled;
  }
  bool main_frame_resizes_are_orientation_changes() const {
    return data_->main_frame_resizes_are_orientation_changes;
  }
  bool initialize_at_minimum_page_scale() const {
    return data_->initialize_at_minimum_page_scale;
  }
  bool smart_insert_delete_enabled() const {
    return data_->smart_insert_delete_enabled;
  }
  bool spatial_navigation_enabled() const {
    return data_->spatial_navigation_enabled;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadV8CacheOptions(UserType* output) const {
    auto data_value = data_->v8_cache_options;
    return mojo::internal::Deserialize<::blink::mojom::V8CacheOptions>(
        data_value, output);
  }
  ::blink::mojom::V8CacheOptions v8_cache_options() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::V8CacheOptions>(data_->v8_cache_options));
  }
  bool record_whole_document() const {
    return data_->record_whole_document;
  }
  bool stylus_handwriting_enabled() const {
    return data_->stylus_handwriting_enabled;
  }
  bool cookie_enabled() const {
    return data_->cookie_enabled;
  }
  bool accelerated_video_decode_enabled() const {
    return data_->accelerated_video_decode_enabled;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAnimationPolicy(UserType* output) const {
    auto data_value = data_->animation_policy;
    return mojo::internal::Deserialize<::blink::mojom::ImageAnimationPolicy>(
        data_value, output);
  }
  ImageAnimationPolicy animation_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ImageAnimationPolicy>(data_->animation_policy));
  }
  bool user_gesture_required_for_presentation() const {
    return data_->user_gesture_required_for_presentation;
  }
  bool text_tracks_enabled() const {
    return data_->text_tracks_enabled;
  }
  inline void GetTextTrackBackgroundColorDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextTrackBackgroundColor(UserType* output) {
    
    auto* pointer = data_->text_track_background_color.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTextTrackTextColorDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextTrackTextColor(UserType* output) {
    
    auto* pointer = data_->text_track_text_color.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTextTrackTextSizeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextTrackTextSize(UserType* output) {
    
    auto* pointer = data_->text_track_text_size.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTextTrackTextShadowDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextTrackTextShadow(UserType* output) {
    
    auto* pointer = data_->text_track_text_shadow.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTextTrackFontFamilyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextTrackFontFamily(UserType* output) {
    
    auto* pointer = data_->text_track_font_family.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTextTrackFontStyleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextTrackFontStyle(UserType* output) {
    
    auto* pointer = data_->text_track_font_style.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTextTrackFontVariantDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextTrackFontVariant(UserType* output) {
    
    auto* pointer = data_->text_track_font_variant.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTextTrackWindowColorDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextTrackWindowColor(UserType* output) {
    
    auto* pointer = data_->text_track_window_color.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTextTrackWindowRadiusDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextTrackWindowRadius(UserType* output) {
    
    auto* pointer = data_->text_track_window_radius.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  float text_track_margin_percentage() const {
    return data_->text_track_margin_percentage;
  }
  bool immersive_mode_enabled() const {
    return data_->immersive_mode_enabled;
  }
  bool double_tap_to_zoom_enabled() const {
    return data_->double_tap_to_zoom_enabled;
  }
  bool fullscreen_supported() const {
    return data_->fullscreen_supported;
  }
  bool text_autosizing_enabled() const {
    return data_->text_autosizing_enabled;
  }
  inline void GetWebAppScopeDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWebAppScope(UserType* output) {
    
    auto* pointer = data_->web_app_scope.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  bool force_dark_mode_enabled() const {
    return data_->force_dark_mode_enabled;
  }
  float default_minimum_page_scale_factor() const {
    return data_->default_minimum_page_scale_factor;
  }
  float default_maximum_page_scale_factor() const {
    return data_->default_maximum_page_scale_factor;
  }
  bool hide_download_ui() const {
    return data_->hide_download_ui;
  }
  bool presentation_receiver() const {
    return data_->presentation_receiver;
  }
  bool media_controls_enabled() const {
    return data_->media_controls_enabled;
  }
  bool do_not_update_selection_on_mutating_selection_range() const {
    return data_->do_not_update_selection_on_mutating_selection_range;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAutoplayPolicy(UserType* output) const {
    auto data_value = data_->autoplay_policy;
    return mojo::internal::Deserialize<::blink::mojom::AutoplayPolicy>(
        data_value, output);
  }
  AutoplayPolicy autoplay_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::AutoplayPolicy>(data_->autoplay_policy));
  }
  bool require_transient_activation_for_get_display_media() const {
    return data_->require_transient_activation_for_get_display_media;
  }
  bool require_transient_activation_for_show_file_or_directory_picker() const {
    return data_->require_transient_activation_for_show_file_or_directory_picker;
  }
  bool require_transient_activation_and_user_confirmation_for_subapps_api() const {
    return data_->require_transient_activation_and_user_confirmation_for_subapps_api;
  }
  bool in_forced_colors() const {
    return data_->in_forced_colors;
  }
  bool is_forced_colors_disabled() const {
    return data_->is_forced_colors_disabled;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPreferredRootScrollbarColorScheme(UserType* output) const {
    auto data_value = data_->preferred_root_scrollbar_color_scheme;
    return mojo::internal::Deserialize<::blink::mojom::PreferredColorScheme>(
        data_value, output);
  }
  ::blink::mojom::PreferredColorScheme preferred_root_scrollbar_color_scheme() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::PreferredColorScheme>(data_->preferred_root_scrollbar_color_scheme));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPreferredColorScheme(UserType* output) const {
    auto data_value = data_->preferred_color_scheme;
    return mojo::internal::Deserialize<::blink::mojom::PreferredColorScheme>(
        data_value, output);
  }
  ::blink::mojom::PreferredColorScheme preferred_color_scheme() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::PreferredColorScheme>(data_->preferred_color_scheme));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPreferredContrast(UserType* output) const {
    auto data_value = data_->preferred_contrast;
    return mojo::internal::Deserialize<::blink::mojom::PreferredContrast>(
        data_value, output);
  }
  ::blink::mojom::PreferredContrast preferred_contrast() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::PreferredContrast>(data_->preferred_contrast));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadLowPriorityIframesThreshold(UserType* output) const {
    auto data_value = data_->low_priority_iframes_threshold;
    return mojo::internal::Deserialize<::blink::mojom::EffectiveConnectionType>(
        data_value, output);
  }
  EffectiveConnectionType low_priority_iframes_threshold() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::EffectiveConnectionType>(data_->low_priority_iframes_threshold));
  }
  bool picture_in_picture_enabled() const {
    return data_->picture_in_picture_enabled;
  }
  bool translate_service_available() const {
    return data_->translate_service_available;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadNetworkQualityEstimatorWebHoldback(UserType* output) const {
    auto data_value = data_->network_quality_estimator_web_holdback;
    return mojo::internal::Deserialize<::blink::mojom::EffectiveConnectionType>(
        data_value, output);
  }
  EffectiveConnectionType network_quality_estimator_web_holdback() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::EffectiveConnectionType>(data_->network_quality_estimator_web_holdback));
  }
  bool lazy_load_enabled() const {
    return data_->lazy_load_enabled;
  }
  bool allow_mixed_content_upgrades() const {
    return data_->allow_mixed_content_upgrades;
  }
  bool always_show_focus() const {
    return data_->always_show_focus;
  }
  bool touch_drag_drop_enabled() const {
    return data_->touch_drag_drop_enabled;
  }
  bool webxr_immersive_ar_allowed() const {
    return data_->webxr_immersive_ar_allowed;
  }
  bool renderer_wide_named_frame_lookup() const {
    return data_->renderer_wide_named_frame_lookup;
  }
  bool strict_mime_type_check_for_worker_scripts_enabled() const {
    return data_->strict_mime_type_check_for_worker_scripts_enabled;
  }
  bool modal_context_menu() const {
    return data_->modal_context_menu;
  }
  bool dynamic_safe_area_insets_enabled() const {
    return data_->dynamic_safe_area_insets_enabled;
  }
 private:
  internal::WebPreferences_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

namespace std {

template <>
struct hash<::blink::mojom::PointerType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::PointerType> {};

template <>
struct hash<::blink::mojom::HoverType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::HoverType> {};

template <>
struct hash<::blink::mojom::OutputDeviceUpdateAbilityType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::OutputDeviceUpdateAbilityType> {};

template <>
struct hash<::blink::mojom::EditingBehavior>
    : public mojo::internal::EnumHashImpl<::blink::mojom::EditingBehavior> {};

template <>
struct hash<::blink::mojom::ImageAnimationPolicy>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ImageAnimationPolicy> {};

template <>
struct hash<::blink::mojom::ViewportStyle>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ViewportStyle> {};

template <>
struct hash<::blink::mojom::AutoplayPolicy>
    : public mojo::internal::EnumHashImpl<::blink::mojom::AutoplayPolicy> {};

template <>
struct hash<::blink::mojom::EffectiveConnectionType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::EffectiveConnectionType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PointerType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::PointerType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::PointerType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::HoverType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::HoverType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::HoverType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::OutputDeviceUpdateAbilityType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::OutputDeviceUpdateAbilityType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::OutputDeviceUpdateAbilityType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::EditingBehavior, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::EditingBehavior, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::EditingBehavior>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ImageAnimationPolicy, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ImageAnimationPolicy, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::ImageAnimationPolicy>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ViewportStyle, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ViewportStyle, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::ViewportStyle>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AutoplayPolicy, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::AutoplayPolicy, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::AutoplayPolicy>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::EffectiveConnectionType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::EffectiveConnectionType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::EffectiveConnectionType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebPreferencesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebPreferencesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebPreferences_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::standard_font_family_map(input)) in_standard_font_family_map = Traits::standard_font_family_map(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->standard_font_family_map)::BaseType>
        standard_font_family_map_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& standard_font_family_map_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>>(
        in_standard_font_family_map, standard_font_family_map_fragment, &standard_font_family_map_validate_params);
    fragment->standard_font_family_map.Set(
        standard_font_family_map_fragment.is_null() ? nullptr : standard_font_family_map_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->standard_font_family_map.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null standard_font_family_map in WebPreferences struct");
    decltype(Traits::fixed_font_family_map(input)) in_fixed_font_family_map = Traits::fixed_font_family_map(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->fixed_font_family_map)::BaseType>
        fixed_font_family_map_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& fixed_font_family_map_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>>(
        in_fixed_font_family_map, fixed_font_family_map_fragment, &fixed_font_family_map_validate_params);
    fragment->fixed_font_family_map.Set(
        fixed_font_family_map_fragment.is_null() ? nullptr : fixed_font_family_map_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->fixed_font_family_map.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null fixed_font_family_map in WebPreferences struct");
    decltype(Traits::serif_font_family_map(input)) in_serif_font_family_map = Traits::serif_font_family_map(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->serif_font_family_map)::BaseType>
        serif_font_family_map_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& serif_font_family_map_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>>(
        in_serif_font_family_map, serif_font_family_map_fragment, &serif_font_family_map_validate_params);
    fragment->serif_font_family_map.Set(
        serif_font_family_map_fragment.is_null() ? nullptr : serif_font_family_map_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->serif_font_family_map.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null serif_font_family_map in WebPreferences struct");
    decltype(Traits::sans_serif_font_family_map(input)) in_sans_serif_font_family_map = Traits::sans_serif_font_family_map(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sans_serif_font_family_map)::BaseType>
        sans_serif_font_family_map_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& sans_serif_font_family_map_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>>(
        in_sans_serif_font_family_map, sans_serif_font_family_map_fragment, &sans_serif_font_family_map_validate_params);
    fragment->sans_serif_font_family_map.Set(
        sans_serif_font_family_map_fragment.is_null() ? nullptr : sans_serif_font_family_map_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->sans_serif_font_family_map.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sans_serif_font_family_map in WebPreferences struct");
    decltype(Traits::cursive_font_family_map(input)) in_cursive_font_family_map = Traits::cursive_font_family_map(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cursive_font_family_map)::BaseType>
        cursive_font_family_map_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& cursive_font_family_map_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>>(
        in_cursive_font_family_map, cursive_font_family_map_fragment, &cursive_font_family_map_validate_params);
    fragment->cursive_font_family_map.Set(
        cursive_font_family_map_fragment.is_null() ? nullptr : cursive_font_family_map_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->cursive_font_family_map.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cursive_font_family_map in WebPreferences struct");
    decltype(Traits::fantasy_font_family_map(input)) in_fantasy_font_family_map = Traits::fantasy_font_family_map(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->fantasy_font_family_map)::BaseType>
        fantasy_font_family_map_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& fantasy_font_family_map_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>>(
        in_fantasy_font_family_map, fantasy_font_family_map_fragment, &fantasy_font_family_map_validate_params);
    fragment->fantasy_font_family_map.Set(
        fantasy_font_family_map_fragment.is_null() ? nullptr : fantasy_font_family_map_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->fantasy_font_family_map.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null fantasy_font_family_map in WebPreferences struct");
    decltype(Traits::math_font_family_map(input)) in_math_font_family_map = Traits::math_font_family_map(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->math_font_family_map)::BaseType>
        math_font_family_map_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& math_font_family_map_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>>(
        in_math_font_family_map, math_font_family_map_fragment, &math_font_family_map_validate_params);
    fragment->math_font_family_map.Set(
        math_font_family_map_fragment.is_null() ? nullptr : math_font_family_map_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->math_font_family_map.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null math_font_family_map in WebPreferences struct");
    fragment->default_font_size = Traits::default_font_size(input);
    fragment->default_fixed_font_size = Traits::default_fixed_font_size(input);
    fragment->minimum_font_size = Traits::minimum_font_size(input);
    fragment->minimum_logical_font_size = Traits::minimum_logical_font_size(input);
    decltype(Traits::default_encoding(input)) in_default_encoding = Traits::default_encoding(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->default_encoding)::BaseType> default_encoding_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_default_encoding, default_encoding_fragment);
    fragment->default_encoding.Set(
        default_encoding_fragment.is_null() ? nullptr : default_encoding_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->default_encoding.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null default_encoding in WebPreferences struct");
    fragment->context_menu_on_mouse_up = Traits::context_menu_on_mouse_up(input);
    fragment->javascript_enabled = Traits::javascript_enabled(input);
    fragment->web_security_enabled = Traits::web_security_enabled(input);
    fragment->loads_images_automatically = Traits::loads_images_automatically(input);
    fragment->images_enabled = Traits::images_enabled(input);
    fragment->plugins_enabled = Traits::plugins_enabled(input);
    fragment->dom_paste_enabled = Traits::dom_paste_enabled(input);
    fragment->shrinks_standalone_images_to_fit = Traits::shrinks_standalone_images_to_fit(input);
    fragment->text_areas_are_resizable = Traits::text_areas_are_resizable(input);
    fragment->allow_scripts_to_close_windows = Traits::allow_scripts_to_close_windows(input);
    fragment->remote_fonts_enabled = Traits::remote_fonts_enabled(input);
    fragment->javascript_can_access_clipboard = Traits::javascript_can_access_clipboard(input);
    fragment->dns_prefetching_enabled = Traits::dns_prefetching_enabled(input);
    fragment->data_saver_enabled = Traits::data_saver_enabled(input);
    fragment->local_storage_enabled = Traits::local_storage_enabled(input);
    fragment->databases_enabled = Traits::databases_enabled(input);
    fragment->tabs_to_links = Traits::tabs_to_links(input);
    fragment->disable_ipc_flooding_protection = Traits::disable_ipc_flooding_protection(input);
    fragment->hyperlink_auditing_enabled = Traits::hyperlink_auditing_enabled(input);
    fragment->allow_universal_access_from_file_urls = Traits::allow_universal_access_from_file_urls(input);
    fragment->allow_file_access_from_file_urls = Traits::allow_file_access_from_file_urls(input);
    fragment->allow_remote_access_from_local_urls = Traits::allow_remote_access_from_local_urls(input);
    fragment->webgl1_enabled = Traits::webgl1_enabled(input);
    fragment->webgl2_enabled = Traits::webgl2_enabled(input);
    fragment->pepper_3d_enabled = Traits::pepper_3d_enabled(input);
    fragment->privileged_webgl_extensions_enabled = Traits::privileged_webgl_extensions_enabled(input);
    fragment->webgl_errors_to_console_enabled = Traits::webgl_errors_to_console_enabled(input);
    fragment->hide_scrollbars = Traits::hide_scrollbars(input);
    fragment->prefers_default_scrollbar_styles = Traits::prefers_default_scrollbar_styles(input);
    fragment->accelerated_2d_canvas_enabled = Traits::accelerated_2d_canvas_enabled(input);
    fragment->canvas_2d_layers_enabled = Traits::canvas_2d_layers_enabled(input);
    fragment->antialiased_2d_canvas_disabled = Traits::antialiased_2d_canvas_disabled(input);
    fragment->antialiased_clips_2d_canvas_enabled = Traits::antialiased_clips_2d_canvas_enabled(input);
    fragment->accelerated_filters_enabled = Traits::accelerated_filters_enabled(input);
    fragment->deferred_filters_enabled = Traits::deferred_filters_enabled(input);
    fragment->container_culling_enabled = Traits::container_culling_enabled(input);
    fragment->allow_running_insecure_content = Traits::allow_running_insecure_content(input);
    fragment->disable_reading_from_canvas = Traits::disable_reading_from_canvas(input);
    fragment->strict_mixed_content_checking = Traits::strict_mixed_content_checking(input);
    fragment->strict_powerful_feature_restrictions = Traits::strict_powerful_feature_restrictions(input);
    fragment->allow_geolocation_on_insecure_origins = Traits::allow_geolocation_on_insecure_origins(input);
    fragment->strictly_block_blockable_mixed_content = Traits::strictly_block_blockable_mixed_content(input);
    fragment->block_mixed_plugin_content = Traits::block_mixed_plugin_content(input);
    fragment->password_echo_enabled = Traits::password_echo_enabled(input);
    fragment->should_clear_document_background = Traits::should_clear_document_background(input);
    fragment->enable_scroll_animator = Traits::enable_scroll_animator(input);
    fragment->prefers_reduced_motion = Traits::prefers_reduced_motion(input);
    fragment->prefers_reduced_transparency = Traits::prefers_reduced_transparency(input);
    fragment->inverted_colors = Traits::inverted_colors(input);
    fragment->touch_event_feature_detection_enabled = Traits::touch_event_feature_detection_enabled(input);
    fragment->enable_error_page = Traits::enable_error_page(input);
    fragment->pointer_events_max_touch_points = Traits::pointer_events_max_touch_points(input);
    fragment->available_pointer_types = Traits::available_pointer_types(input);
    mojo::internal::Serialize<::blink::mojom::PointerType>(
        Traits::primary_pointer_type(input), &fragment->primary_pointer_type);
    mojo::internal::Serialize<::blink::mojom::OutputDeviceUpdateAbilityType>(
        Traits::output_device_update_ability_type(input), &fragment->output_device_update_ability_type);
    fragment->available_hover_types = Traits::available_hover_types(input);
    mojo::internal::Serialize<::blink::mojom::HoverType>(
        Traits::primary_hover_type(input), &fragment->primary_hover_type);
    fragment->dont_send_key_events_to_javascript = Traits::dont_send_key_events_to_javascript(input);
    fragment->barrel_button_for_drag_enabled = Traits::barrel_button_for_drag_enabled(input);
    fragment->sync_xhr_in_documents_enabled = Traits::sync_xhr_in_documents_enabled(input);
    fragment->target_blank_implies_no_opener_enabled_will_be_removed = Traits::target_blank_implies_no_opener_enabled_will_be_removed(input);
    fragment->allow_non_empty_navigator_plugins = Traits::allow_non_empty_navigator_plugins(input);
    fragment->number_of_cpu_cores = Traits::number_of_cpu_cores(input);
    mojo::internal::Serialize<::blink::mojom::EditingBehavior>(
        Traits::editing_behavior(input), &fragment->editing_behavior);
    fragment->supports_multiple_windows = Traits::supports_multiple_windows(input);
    fragment->viewport_enabled = Traits::viewport_enabled(input);
    fragment->viewport_meta_enabled = Traits::viewport_meta_enabled(input);
    fragment->auto_zoom_focused_editable_to_legible_scale = Traits::auto_zoom_focused_editable_to_legible_scale(input);
    fragment->shrinks_viewport_contents_to_fit = Traits::shrinks_viewport_contents_to_fit(input);
    mojo::internal::Serialize<::blink::mojom::ViewportStyle>(
        Traits::viewport_style(input), &fragment->viewport_style);
    fragment->smooth_scroll_for_find_enabled = Traits::smooth_scroll_for_find_enabled(input);
    fragment->main_frame_resizes_are_orientation_changes = Traits::main_frame_resizes_are_orientation_changes(input);
    fragment->initialize_at_minimum_page_scale = Traits::initialize_at_minimum_page_scale(input);
    fragment->smart_insert_delete_enabled = Traits::smart_insert_delete_enabled(input);
    fragment->spatial_navigation_enabled = Traits::spatial_navigation_enabled(input);
    mojo::internal::Serialize<::blink::mojom::V8CacheOptions>(
        Traits::v8_cache_options(input), &fragment->v8_cache_options);
    fragment->record_whole_document = Traits::record_whole_document(input);
    fragment->stylus_handwriting_enabled = Traits::stylus_handwriting_enabled(input);
    fragment->cookie_enabled = Traits::cookie_enabled(input);
    fragment->accelerated_video_decode_enabled = Traits::accelerated_video_decode_enabled(input);
    mojo::internal::Serialize<::blink::mojom::ImageAnimationPolicy>(
        Traits::animation_policy(input), &fragment->animation_policy);
    fragment->user_gesture_required_for_presentation = Traits::user_gesture_required_for_presentation(input);
    fragment->text_tracks_enabled = Traits::text_tracks_enabled(input);
    decltype(Traits::text_track_background_color(input)) in_text_track_background_color = Traits::text_track_background_color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text_track_background_color)::BaseType> text_track_background_color_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_text_track_background_color, text_track_background_color_fragment);
    fragment->text_track_background_color.Set(
        text_track_background_color_fragment.is_null() ? nullptr : text_track_background_color_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->text_track_background_color.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text_track_background_color in WebPreferences struct");
    decltype(Traits::text_track_text_color(input)) in_text_track_text_color = Traits::text_track_text_color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text_track_text_color)::BaseType> text_track_text_color_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_text_track_text_color, text_track_text_color_fragment);
    fragment->text_track_text_color.Set(
        text_track_text_color_fragment.is_null() ? nullptr : text_track_text_color_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->text_track_text_color.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text_track_text_color in WebPreferences struct");
    decltype(Traits::text_track_text_size(input)) in_text_track_text_size = Traits::text_track_text_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text_track_text_size)::BaseType> text_track_text_size_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_text_track_text_size, text_track_text_size_fragment);
    fragment->text_track_text_size.Set(
        text_track_text_size_fragment.is_null() ? nullptr : text_track_text_size_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->text_track_text_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text_track_text_size in WebPreferences struct");
    decltype(Traits::text_track_text_shadow(input)) in_text_track_text_shadow = Traits::text_track_text_shadow(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text_track_text_shadow)::BaseType> text_track_text_shadow_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_text_track_text_shadow, text_track_text_shadow_fragment);
    fragment->text_track_text_shadow.Set(
        text_track_text_shadow_fragment.is_null() ? nullptr : text_track_text_shadow_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->text_track_text_shadow.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text_track_text_shadow in WebPreferences struct");
    decltype(Traits::text_track_font_family(input)) in_text_track_font_family = Traits::text_track_font_family(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text_track_font_family)::BaseType> text_track_font_family_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_text_track_font_family, text_track_font_family_fragment);
    fragment->text_track_font_family.Set(
        text_track_font_family_fragment.is_null() ? nullptr : text_track_font_family_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->text_track_font_family.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text_track_font_family in WebPreferences struct");
    decltype(Traits::text_track_font_style(input)) in_text_track_font_style = Traits::text_track_font_style(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text_track_font_style)::BaseType> text_track_font_style_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_text_track_font_style, text_track_font_style_fragment);
    fragment->text_track_font_style.Set(
        text_track_font_style_fragment.is_null() ? nullptr : text_track_font_style_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->text_track_font_style.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text_track_font_style in WebPreferences struct");
    decltype(Traits::text_track_font_variant(input)) in_text_track_font_variant = Traits::text_track_font_variant(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text_track_font_variant)::BaseType> text_track_font_variant_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_text_track_font_variant, text_track_font_variant_fragment);
    fragment->text_track_font_variant.Set(
        text_track_font_variant_fragment.is_null() ? nullptr : text_track_font_variant_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->text_track_font_variant.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text_track_font_variant in WebPreferences struct");
    decltype(Traits::text_track_window_color(input)) in_text_track_window_color = Traits::text_track_window_color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text_track_window_color)::BaseType> text_track_window_color_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_text_track_window_color, text_track_window_color_fragment);
    fragment->text_track_window_color.Set(
        text_track_window_color_fragment.is_null() ? nullptr : text_track_window_color_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->text_track_window_color.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text_track_window_color in WebPreferences struct");
    decltype(Traits::text_track_window_radius(input)) in_text_track_window_radius = Traits::text_track_window_radius(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text_track_window_radius)::BaseType> text_track_window_radius_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_text_track_window_radius, text_track_window_radius_fragment);
    fragment->text_track_window_radius.Set(
        text_track_window_radius_fragment.is_null() ? nullptr : text_track_window_radius_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->text_track_window_radius.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text_track_window_radius in WebPreferences struct");
    fragment->text_track_margin_percentage = Traits::text_track_margin_percentage(input);
    fragment->immersive_mode_enabled = Traits::immersive_mode_enabled(input);
    fragment->double_tap_to_zoom_enabled = Traits::double_tap_to_zoom_enabled(input);
    fragment->fullscreen_supported = Traits::fullscreen_supported(input);
    fragment->text_autosizing_enabled = Traits::text_autosizing_enabled(input);
    decltype(Traits::web_app_scope(input)) in_web_app_scope = Traits::web_app_scope(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->web_app_scope)::BaseType> web_app_scope_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_web_app_scope, web_app_scope_fragment);
    fragment->web_app_scope.Set(
        web_app_scope_fragment.is_null() ? nullptr : web_app_scope_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->web_app_scope.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null web_app_scope in WebPreferences struct");
    fragment->force_dark_mode_enabled = Traits::force_dark_mode_enabled(input);
    fragment->default_minimum_page_scale_factor = Traits::default_minimum_page_scale_factor(input);
    fragment->default_maximum_page_scale_factor = Traits::default_maximum_page_scale_factor(input);
    fragment->hide_download_ui = Traits::hide_download_ui(input);
    fragment->presentation_receiver = Traits::presentation_receiver(input);
    fragment->media_controls_enabled = Traits::media_controls_enabled(input);
    fragment->do_not_update_selection_on_mutating_selection_range = Traits::do_not_update_selection_on_mutating_selection_range(input);
    mojo::internal::Serialize<::blink::mojom::AutoplayPolicy>(
        Traits::autoplay_policy(input), &fragment->autoplay_policy);
    fragment->require_transient_activation_for_get_display_media = Traits::require_transient_activation_for_get_display_media(input);
    fragment->require_transient_activation_for_show_file_or_directory_picker = Traits::require_transient_activation_for_show_file_or_directory_picker(input);
    fragment->require_transient_activation_and_user_confirmation_for_subapps_api = Traits::require_transient_activation_and_user_confirmation_for_subapps_api(input);
    fragment->in_forced_colors = Traits::in_forced_colors(input);
    fragment->is_forced_colors_disabled = Traits::is_forced_colors_disabled(input);
    mojo::internal::Serialize<::blink::mojom::PreferredColorScheme>(
        Traits::preferred_root_scrollbar_color_scheme(input), &fragment->preferred_root_scrollbar_color_scheme);
    mojo::internal::Serialize<::blink::mojom::PreferredColorScheme>(
        Traits::preferred_color_scheme(input), &fragment->preferred_color_scheme);
    mojo::internal::Serialize<::blink::mojom::PreferredContrast>(
        Traits::preferred_contrast(input), &fragment->preferred_contrast);
    mojo::internal::Serialize<::blink::mojom::EffectiveConnectionType>(
        Traits::low_priority_iframes_threshold(input), &fragment->low_priority_iframes_threshold);
    fragment->picture_in_picture_enabled = Traits::picture_in_picture_enabled(input);
    fragment->translate_service_available = Traits::translate_service_available(input);
    mojo::internal::Serialize<::blink::mojom::EffectiveConnectionType>(
        Traits::network_quality_estimator_web_holdback(input), &fragment->network_quality_estimator_web_holdback);
    fragment->lazy_load_enabled = Traits::lazy_load_enabled(input);
    fragment->allow_mixed_content_upgrades = Traits::allow_mixed_content_upgrades(input);
    fragment->always_show_focus = Traits::always_show_focus(input);
    fragment->touch_drag_drop_enabled = Traits::touch_drag_drop_enabled(input);
    fragment->webxr_immersive_ar_allowed = Traits::webxr_immersive_ar_allowed(input);
    fragment->renderer_wide_named_frame_lookup = Traits::renderer_wide_named_frame_lookup(input);
    fragment->strict_mime_type_check_for_worker_scripts_enabled = Traits::strict_mime_type_check_for_worker_scripts_enabled(input);
    fragment->modal_context_menu = Traits::modal_context_menu(input);
    fragment->dynamic_safe_area_insets_enabled = Traits::dynamic_safe_area_insets_enabled(input);
  }

  static bool Deserialize(::blink::mojom::internal::WebPreferences_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebPreferencesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void WebPreferencesDataView::GetStandardFontFamilyMapDataView(
    mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>* output) {
  auto pointer = data_->standard_font_family_map.Get();
  *output = mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>(pointer, message_);
}
inline void WebPreferencesDataView::GetFixedFontFamilyMapDataView(
    mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>* output) {
  auto pointer = data_->fixed_font_family_map.Get();
  *output = mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>(pointer, message_);
}
inline void WebPreferencesDataView::GetSerifFontFamilyMapDataView(
    mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>* output) {
  auto pointer = data_->serif_font_family_map.Get();
  *output = mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>(pointer, message_);
}
inline void WebPreferencesDataView::GetSansSerifFontFamilyMapDataView(
    mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>* output) {
  auto pointer = data_->sans_serif_font_family_map.Get();
  *output = mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>(pointer, message_);
}
inline void WebPreferencesDataView::GetCursiveFontFamilyMapDataView(
    mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>* output) {
  auto pointer = data_->cursive_font_family_map.Get();
  *output = mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>(pointer, message_);
}
inline void WebPreferencesDataView::GetFantasyFontFamilyMapDataView(
    mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>* output) {
  auto pointer = data_->fantasy_font_family_map.Get();
  *output = mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>(pointer, message_);
}
inline void WebPreferencesDataView::GetMathFontFamilyMapDataView(
    mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>* output) {
  auto pointer = data_->math_font_family_map.Get();
  *output = mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>(pointer, message_);
}
inline void WebPreferencesDataView::GetDefaultEncodingDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->default_encoding.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebPreferencesDataView::GetTextTrackBackgroundColorDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text_track_background_color.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebPreferencesDataView::GetTextTrackTextColorDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text_track_text_color.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebPreferencesDataView::GetTextTrackTextSizeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text_track_text_size.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebPreferencesDataView::GetTextTrackTextShadowDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text_track_text_shadow.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebPreferencesDataView::GetTextTrackFontFamilyDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text_track_font_family.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebPreferencesDataView::GetTextTrackFontStyleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text_track_font_style.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebPreferencesDataView::GetTextTrackFontVariantDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text_track_font_variant.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebPreferencesDataView::GetTextTrackWindowColorDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text_track_window_color.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebPreferencesDataView::GetTextTrackWindowRadiusDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text_track_window_radius.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebPreferencesDataView::GetWebAppScopeDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->web_app_scope.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::PointerType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::PointerType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::HoverType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::HoverType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::OutputDeviceUpdateAbilityType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::OutputDeviceUpdateAbilityType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::EditingBehavior> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::EditingBehavior value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::ImageAnimationPolicy> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::ImageAnimationPolicy value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::ViewportStyle> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::ViewportStyle value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::AutoplayPolicy> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::AutoplayPolicy value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::EffectiveConnectionType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::EffectiveConnectionType value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBPREFERENCES_WEB_PREFERENCES_MOJOM_SHARED_H_