// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_RENDERER_HOST_SCOPED_VIEW_TRANSITION_RESOURCES_H_
#define CONTENT_BROWSER_RENDERER_HOST_SCOPED_VIEW_TRANSITION_RESOURCES_H_

#include <map>
#include <memory>
#include <vector>

#include "base/memory/ptr_util.h"
#include "content/common/content_export.h"
#include "third_party/blink/public/common/tokens/tokens.h"

namespace content {

// For cross-document navigations associated with a ViewTransition, textures
// generated by the old Document are cached in the GPU process. The ownership of
// these textures is transferred from the old renderer to the browser and
// finally to the new renderer process.
//
// This class manages the lifetime of these resources to ensure they are
// released when ownership is with the browser process or if the renderer
// process owning the resources is terminated before the transition animations
// start in the new renderer process.
class CONTENT_EXPORT ScopedViewTransitionResources {
 public:
  explicit ScopedViewTransitionResources(
      const blink::ViewTransitionToken& transition_token);
  ~ScopedViewTransitionResources();

 private:
  const blink::ViewTransitionToken transition_token_;
};

}  // namespace content

#endif  // CONTENT_BROWSER_RENDERER_HOST_SCOPED_VIEW_TRANSITION_RESOURCES_H_
