// content/common/renderer_variations_configuration.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/renderer_variations_configuration.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/common/renderer_variations_configuration.mojom-params-data.h"
#include "content/common/renderer_variations_configuration.mojom-shared-message-ids.h"

#include "content/common/renderer_variations_configuration.mojom-import-headers.h"
#include "content/common/renderer_variations_configuration.mojom-test-utils.h"


namespace content::mojom {
const char RendererVariationsConfiguration::Name_[] = "content.mojom.RendererVariationsConfiguration";

RendererVariationsConfiguration::IPCStableHashFunction RendererVariationsConfiguration::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RendererVariationsConfiguration>(message.name())) {
    case messages::RendererVariationsConfiguration::kSetVariationsHeaders: {
      return &RendererVariationsConfiguration::SetVariationsHeaders_Sym::IPCStableHash;
    }
    case messages::RendererVariationsConfiguration::kSetFieldTrialGroup: {
      return &RendererVariationsConfiguration::SetFieldTrialGroup_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RendererVariationsConfiguration::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RendererVariationsConfiguration>(message.name())) {
      case messages::RendererVariationsConfiguration::kSetVariationsHeaders:
            return "Receive content::mojom::RendererVariationsConfiguration::SetVariationsHeaders";
      case messages::RendererVariationsConfiguration::kSetFieldTrialGroup:
            return "Receive content::mojom::RendererVariationsConfiguration::SetFieldTrialGroup";
    }
  } else {
    switch (static_cast<messages::RendererVariationsConfiguration>(message.name())) {
      case messages::RendererVariationsConfiguration::kSetVariationsHeaders:
            return "Receive reply content::mojom::RendererVariationsConfiguration::SetVariationsHeaders";
      case messages::RendererVariationsConfiguration::kSetFieldTrialGroup:
            return "Receive reply content::mojom::RendererVariationsConfiguration::SetFieldTrialGroup";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RendererVariationsConfiguration::SetVariationsHeaders_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::RendererVariationsConfiguration::SetVariationsHeaders");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RendererVariationsConfiguration::SetFieldTrialGroup_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::RendererVariationsConfiguration::SetFieldTrialGroup");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

RendererVariationsConfigurationProxy::RendererVariationsConfigurationProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RendererVariationsConfigurationProxy::SetVariationsHeaders(
    ::variations::mojom::VariationsHeadersPtr in_variations_headers) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::RendererVariationsConfiguration::SetVariationsHeaders", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("variations_headers"), in_variations_headers,
                        "<value of type ::variations::mojom::VariationsHeadersPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RendererVariationsConfiguration::kSetVariationsHeaders), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RendererVariationsConfiguration_SetVariationsHeaders_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->variations_headers)::BaseType> variations_headers_fragment(
          params.message());
  mojo::internal::Serialize<::variations::mojom::VariationsHeadersDataView>(
      in_variations_headers, variations_headers_fragment);
  params->variations_headers.Set(
      variations_headers_fragment.is_null() ? nullptr : variations_headers_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererVariationsConfiguration::Name_);
  message.set_method_name("SetVariationsHeaders");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererVariationsConfigurationProxy::SetFieldTrialGroup(
    const std::string& in_trial_name, const std::string& in_group_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::RendererVariationsConfiguration::SetFieldTrialGroup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trial_name"), in_trial_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_name"), in_group_name,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RendererVariationsConfiguration::kSetFieldTrialGroup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RendererVariationsConfiguration_SetFieldTrialGroup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->trial_name)::BaseType> trial_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_trial_name, trial_name_fragment);
  params->trial_name.Set(
      trial_name_fragment.is_null() ? nullptr : trial_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->trial_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null trial_name in RendererVariationsConfiguration.SetFieldTrialGroup request");
  mojo::internal::MessageFragment<
      typename decltype(params->group_name)::BaseType> group_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_group_name, group_name_fragment);
  params->group_name.Set(
      group_name_fragment.is_null() ? nullptr : group_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->group_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null group_name in RendererVariationsConfiguration.SetFieldTrialGroup request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererVariationsConfiguration::Name_);
  message.set_method_name("SetFieldTrialGroup");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool RendererVariationsConfigurationStubDispatch::Accept(
    RendererVariationsConfiguration* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RendererVariationsConfiguration>(message->header()->name)) {
    case messages::RendererVariationsConfiguration::kSetVariationsHeaders: {
      DCHECK(message->is_serialized());
      internal::RendererVariationsConfiguration_SetVariationsHeaders_Params_Data* params =
          reinterpret_cast<internal::RendererVariationsConfiguration_SetVariationsHeaders_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for RendererVariationsConfiguration.0
      bool success = true;
      ::variations::mojom::VariationsHeadersPtr p_variations_headers{};
      RendererVariationsConfiguration_SetVariationsHeaders_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadVariationsHeaders(&p_variations_headers))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererVariationsConfiguration::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetVariationsHeaders(        
        std::move(p_variations_headers));
      return true;
    }
    case messages::RendererVariationsConfiguration::kSetFieldTrialGroup: {
      DCHECK(message->is_serialized());
      internal::RendererVariationsConfiguration_SetFieldTrialGroup_Params_Data* params =
          reinterpret_cast<internal::RendererVariationsConfiguration_SetFieldTrialGroup_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for RendererVariationsConfiguration.1
      bool success = true;
      std::string p_trial_name{};
      std::string p_group_name{};
      RendererVariationsConfiguration_SetFieldTrialGroup_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTrialName(&p_trial_name))
        success = false;
      if (success && !input_data_view.ReadGroupName(&p_group_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererVariationsConfiguration::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFieldTrialGroup(        
        std::move(p_trial_name), 
        std::move(p_group_name));
      return true;
    }
  }
  return false;
}

// static
bool RendererVariationsConfigurationStubDispatch::AcceptWithResponder(
    RendererVariationsConfiguration* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RendererVariationsConfiguration>(message->header()->name)) {
    case messages::RendererVariationsConfiguration::kSetVariationsHeaders: {
      break;
    }
    case messages::RendererVariationsConfiguration::kSetFieldTrialGroup: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRendererVariationsConfigurationValidationInfo[] = {
    {base::to_underlying(messages::RendererVariationsConfiguration::kSetVariationsHeaders),
     { &internal::RendererVariationsConfiguration_SetVariationsHeaders_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::RendererVariationsConfiguration::kSetFieldTrialGroup),
     { &internal::RendererVariationsConfiguration_SetFieldTrialGroup_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RendererVariationsConfigurationRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::RendererVariationsConfiguration::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRendererVariationsConfigurationValidationInfo);
}



}  // content::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace content::mojom {


void RendererVariationsConfigurationInterceptorForTesting::SetVariationsHeaders(::variations::mojom::VariationsHeadersPtr variations_headers) {
  GetForwardingInterface()->SetVariationsHeaders(
    std::move(variations_headers)
    );
}
void RendererVariationsConfigurationInterceptorForTesting::SetFieldTrialGroup(const std::string& trial_name, const std::string& group_name) {
  GetForwardingInterface()->SetFieldTrialGroup(
    std::move(trial_name)
    , 
    std::move(group_name)
    );
}
RendererVariationsConfigurationAsyncWaiter::RendererVariationsConfigurationAsyncWaiter(
    RendererVariationsConfiguration* proxy) : proxy_(proxy) {}

RendererVariationsConfigurationAsyncWaiter::~RendererVariationsConfigurationAsyncWaiter() = default;






}  // content::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif