// services/network/public/mojom/url_response_head.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/url_response_head.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/url_response_head.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* NavigationDeliveryTypeToStringHelper(NavigationDeliveryType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case NavigationDeliveryType::kDefault:
      return "kDefault";
    case NavigationDeliveryType::kNavigationalPrefetch:
      return "kNavigationalPrefetch";
    default:
      return nullptr;
  }
}

std::string NavigationDeliveryTypeToString(NavigationDeliveryType value) {
  const char *str = NavigationDeliveryTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown NavigationDeliveryType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, NavigationDeliveryType value) {
  return os << NavigationDeliveryTypeToString(value);
}

namespace internal {


// static
bool URLResponseHead_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 264, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const URLResponseHead_Data* object =
      static_cast<const URLResponseHead_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request_time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response_time, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->original_response_time, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->original_response_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->headers, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->headers, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mime_type, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& mime_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->mime_type, validation_context,
                                         &mime_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->charset, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& charset_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->charset, validation_context,
                                         &charset_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->encoded_body_length, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->load_timing, 11, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->load_timing, validation_context))
    return false;


  if (!::network::mojom::internal::ConnectionInfo_Data
        ::Validate(object->connection_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->alpn_negotiated_protocol, 17, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& alpn_negotiated_protocol_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->alpn_negotiated_protocol, validation_context,
                                         &alpn_negotiated_protocol_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::AlternateProtocolUsage_Data
        ::Validate(object->alternate_protocol_usage, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->remote_endpoint, 19, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->remote_endpoint, validation_context))
    return false;


  if (!::network::mojom::internal::IPAddressSpace_Data
        ::Validate(object->client_address_space, validation_context))
    return false;


  if (!::network::mojom::internal::IPAddressSpace_Data
        ::Validate(object->response_address_space, validation_context))
    return false;


  if (!::network::mojom::internal::NavigationDeliveryType_Data
        ::Validate(object->navigation_delivery_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->proxy_chain, 25, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->proxy_chain, validation_context))
    return false;


  if (!::network::mojom::internal::FetchResponseSource_Data
        ::Validate(object->service_worker_response_source, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url_list_via_service_worker, 28, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& url_list_via_service_worker_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->url_list_via_service_worker, validation_context,
                                         &url_list_via_service_worker_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::ServiceWorkerStatus_Data
        ::Validate(object->initial_service_worker_status_$value, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->service_worker_router_info, validation_context))
    return false;


  if (!::network::mojom::internal::FetchResponseType_Data
        ::Validate(object->response_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cache_storage_cache_name, 34, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& cache_storage_cache_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->cache_storage_cache_name, validation_context,
                                         &cache_storage_cache_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->ssl_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request_cookies, 37, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& request_cookies_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->request_cookies, validation_context,
                                         &request_cookies_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cors_exposed_header_names, 38, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& cors_exposed_header_names_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->cors_exposed_header_names, validation_context,
                                         &cors_exposed_header_names_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->auth_challenge_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request_start, 51, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request_start, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response_start, 52, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response_start, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->parsed_headers, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->recursive_prefetch_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->dns_aliases, 55, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& dns_aliases_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->dns_aliases, validation_context,
                                         &dns_aliases_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::PrivateNetworkAccessPreflightResult_Data
        ::Validate(object->private_network_access_preflight_result, validation_context))
    return false;

  return true;
}

URLResponseHead_Data::URLResponseHead_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::NavigationDeliveryType>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::NavigationDeliveryType value) {
  return std::move(context).WriteString(::network::mojom::NavigationDeliveryTypeToString(value));
}

} // namespace perfetto