// services/viz/public/mojom/compositing/frame_timing_details.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_TIMING_DETAILS_MOJOM_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_TIMING_DETAILS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/frame_timing_details.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/frame_timing_details.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/frame_timing_details.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/viz/public/mojom/compositing/begin_frame_args.mojom.h"
#include "ui/gfx/mojom/presentation_feedback.mojom.h"
#include "ui/gfx/mojom/swap_timings.mojom.h"
#include <string>
#include <vector>




#include "services/viz/public/cpp/compositing/frame_timing_details_mojom_traits.h"




namespace viz::mojom {








class  FrameTimingDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FrameTimingDetails, T>::value>;
  using DataView = FrameTimingDetailsDataView;
  using Data_ = internal::FrameTimingDetails_Data;

  template <typename... Args>
  static FrameTimingDetailsPtr New(Args&&... args) {
    return FrameTimingDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FrameTimingDetailsPtr From(const U& u) {
    return mojo::TypeConverter<FrameTimingDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FrameTimingDetails>::Convert(*this);
  }


  FrameTimingDetails();

  FrameTimingDetails(
      ::base::TimeTicks received_compositor_frame_timestamp,
      ::base::TimeTicks embedded_frame_timestamp,
      ::base::TimeTicks draw_start_timestamp,
      const ::gfx::SwapTimings& swap_timings,
      const ::gfx::PresentationFeedback& presentation_feedback,
      ::viz::mojom::BeginFrameIdPtr frame_id);

FrameTimingDetails(const FrameTimingDetails&) = delete;
FrameTimingDetails& operator=(const FrameTimingDetails&) = delete;

  ~FrameTimingDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FrameTimingDetailsPtr>
  FrameTimingDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FrameTimingDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FrameTimingDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FrameTimingDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameTimingDetails::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FrameTimingDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FrameTimingDetails_UnserializedMessageContext<
            UserType, FrameTimingDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FrameTimingDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FrameTimingDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FrameTimingDetails_UnserializedMessageContext<
            UserType, FrameTimingDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FrameTimingDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::TimeTicks received_compositor_frame_timestamp;
  
  ::base::TimeTicks embedded_frame_timestamp;
  
  ::base::TimeTicks draw_start_timestamp;
  
  ::gfx::SwapTimings swap_timings;
  
  ::gfx::PresentationFeedback presentation_feedback;
  
  ::viz::mojom::BeginFrameIdPtr frame_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FrameTimingDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FrameTimingDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FrameTimingDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FrameTimingDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
FrameTimingDetailsPtr FrameTimingDetails::Clone() const {
  return New(
      mojo::Clone(received_compositor_frame_timestamp),
      mojo::Clone(embedded_frame_timestamp),
      mojo::Clone(draw_start_timestamp),
      mojo::Clone(swap_timings),
      mojo::Clone(presentation_feedback),
      mojo::Clone(frame_id)
  );
}

template <typename T, FrameTimingDetails::EnableIfSame<T>*>
bool FrameTimingDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->received_compositor_frame_timestamp, other_struct.received_compositor_frame_timestamp))
    return false;
  if (!mojo::Equals(this->embedded_frame_timestamp, other_struct.embedded_frame_timestamp))
    return false;
  if (!mojo::Equals(this->draw_start_timestamp, other_struct.draw_start_timestamp))
    return false;
  if (!mojo::Equals(this->swap_timings, other_struct.swap_timings))
    return false;
  if (!mojo::Equals(this->presentation_feedback, other_struct.presentation_feedback))
    return false;
  if (!mojo::Equals(this->frame_id, other_struct.frame_id))
    return false;
  return true;
}

template <typename T, FrameTimingDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.received_compositor_frame_timestamp < rhs.received_compositor_frame_timestamp)
    return true;
  if (rhs.received_compositor_frame_timestamp < lhs.received_compositor_frame_timestamp)
    return false;
  if (lhs.embedded_frame_timestamp < rhs.embedded_frame_timestamp)
    return true;
  if (rhs.embedded_frame_timestamp < lhs.embedded_frame_timestamp)
    return false;
  if (lhs.draw_start_timestamp < rhs.draw_start_timestamp)
    return true;
  if (rhs.draw_start_timestamp < lhs.draw_start_timestamp)
    return false;
  if (lhs.swap_timings < rhs.swap_timings)
    return true;
  if (rhs.swap_timings < lhs.swap_timings)
    return false;
  if (lhs.presentation_feedback < rhs.presentation_feedback)
    return true;
  if (rhs.presentation_feedback < lhs.presentation_feedback)
    return false;
  if (lhs.frame_id < rhs.frame_id)
    return true;
  if (rhs.frame_id < lhs.frame_id)
    return false;
  return false;
}


}  // viz::mojom

namespace mojo {


template <>
struct  StructTraits<::viz::mojom::FrameTimingDetails::DataView,
                                         ::viz::mojom::FrameTimingDetailsPtr> {
  static bool IsNull(const ::viz::mojom::FrameTimingDetailsPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::FrameTimingDetailsPtr* output) { output->reset(); }

  static const decltype(::viz::mojom::FrameTimingDetails::received_compositor_frame_timestamp)& received_compositor_frame_timestamp(
      const ::viz::mojom::FrameTimingDetailsPtr& input) {
    return input->received_compositor_frame_timestamp;
  }

  static const decltype(::viz::mojom::FrameTimingDetails::embedded_frame_timestamp)& embedded_frame_timestamp(
      const ::viz::mojom::FrameTimingDetailsPtr& input) {
    return input->embedded_frame_timestamp;
  }

  static const decltype(::viz::mojom::FrameTimingDetails::draw_start_timestamp)& draw_start_timestamp(
      const ::viz::mojom::FrameTimingDetailsPtr& input) {
    return input->draw_start_timestamp;
  }

  static const decltype(::viz::mojom::FrameTimingDetails::swap_timings)& swap_timings(
      const ::viz::mojom::FrameTimingDetailsPtr& input) {
    return input->swap_timings;
  }

  static const decltype(::viz::mojom::FrameTimingDetails::presentation_feedback)& presentation_feedback(
      const ::viz::mojom::FrameTimingDetailsPtr& input) {
    return input->presentation_feedback;
  }

  static const decltype(::viz::mojom::FrameTimingDetails::frame_id)& frame_id(
      const ::viz::mojom::FrameTimingDetailsPtr& input) {
    return input->frame_id;
  }

  static bool Read(::viz::mojom::FrameTimingDetails::DataView input, ::viz::mojom::FrameTimingDetailsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_TIMING_DETAILS_MOJOM_H_