// third_party/blink/public/mojom/loader/resource_load_info_notifier.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_RESOURCE_LOAD_INFO_NOTIFIER_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_RESOURCE_LOAD_INFO_NOTIFIER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/loader/resource_load_info_notifier.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/loader/resource_load_info_notifier.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/loader/resource_load_info_notifier.mojom-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/fetch_api.mojom-forward.h"
#include "services/network/public/mojom/url_loader.mojom.h"
#include "services/network/public/mojom/url_loader_completion_status.mojom.h"
#include "services/network/public/mojom/url_request.mojom-forward.h"
#include "services/network/public/mojom/url_response_head.mojom-forward.h"
#include "third_party/blink/public/mojom/loader/resource_load_info.mojom-forward.h"
#include "url/mojom/scheme_host_port.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class ResourceLoadInfoNotifierProxy;

template <typename ImplRefTraits>
class ResourceLoadInfoNotifierStub;

class ResourceLoadInfoNotifierRequestValidator;


class BLINK_COMMON_EXPORT ResourceLoadInfoNotifier
    : public ResourceLoadInfoNotifierInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ResourceLoadInfoNotifierInterfaceBase;
  using Proxy_ = ResourceLoadInfoNotifierProxy;

  template <typename ImplRefTraits>
  using Stub_ = ResourceLoadInfoNotifierStub<ImplRefTraits>;

  using RequestValidator_ = ResourceLoadInfoNotifierRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kNotifyResourceRedirectReceivedMinVersion = 0,
    kNotifyResourceResponseReceivedMinVersion = 0,
    kNotifyResourceTransferSizeUpdatedMinVersion = 0,
    kNotifyResourceLoadCompletedMinVersion = 0,
    kNotifyResourceLoadCanceledMinVersion = 0,
    kCloneMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct NotifyResourceRedirectReceived_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyResourceResponseReceived_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyResourceTransferSizeUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyResourceLoadCompleted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyResourceLoadCanceled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Clone_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ResourceLoadInfoNotifier() = default;

  
  virtual void NotifyResourceRedirectReceived(const ::net::RedirectInfo& redirect_info, ::network::mojom::URLResponseHeadPtr redirect_response) = 0;

  
  virtual void NotifyResourceResponseReceived(int64_t request_id, const ::url::SchemeHostPort& final_response_url, ::network::mojom::URLResponseHeadPtr head, ::network::mojom::RequestDestination request_destination, bool is_ad_resource) = 0;

  
  virtual void NotifyResourceTransferSizeUpdated(int64_t request_id, int32_t transfer_size_diff) = 0;

  
  virtual void NotifyResourceLoadCompleted(::blink::mojom::ResourceLoadInfoPtr resource_load_info, const ::network::URLLoaderCompletionStatus& status) = 0;

  
  virtual void NotifyResourceLoadCanceled(int64_t request_id) = 0;

  
  virtual void Clone(::mojo::PendingReceiver<ResourceLoadInfoNotifier> pending_resource_load_info_notifier) = 0;
};



class BLINK_COMMON_EXPORT ResourceLoadInfoNotifierProxy
    : public ResourceLoadInfoNotifier {
 public:
  using InterfaceType = ResourceLoadInfoNotifier;

  explicit ResourceLoadInfoNotifierProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void NotifyResourceRedirectReceived(const ::net::RedirectInfo& redirect_info, ::network::mojom::URLResponseHeadPtr redirect_response) final;
  
  void NotifyResourceResponseReceived(int64_t request_id, const ::url::SchemeHostPort& final_response_url, ::network::mojom::URLResponseHeadPtr head, ::network::mojom::RequestDestination request_destination, bool is_ad_resource) final;
  
  void NotifyResourceTransferSizeUpdated(int64_t request_id, int32_t transfer_size_diff) final;
  
  void NotifyResourceLoadCompleted(::blink::mojom::ResourceLoadInfoPtr resource_load_info, const ::network::URLLoaderCompletionStatus& status) final;
  
  void NotifyResourceLoadCanceled(int64_t request_id) final;
  
  void Clone(::mojo::PendingReceiver<ResourceLoadInfoNotifier> pending_resource_load_info_notifier) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT ResourceLoadInfoNotifierStubDispatch {
 public:
  static bool Accept(ResourceLoadInfoNotifier* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ResourceLoadInfoNotifier* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ResourceLoadInfoNotifier>>
class ResourceLoadInfoNotifierStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ResourceLoadInfoNotifierStub() = default;
  ~ResourceLoadInfoNotifierStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ResourceLoadInfoNotifierStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ResourceLoadInfoNotifierStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT ResourceLoadInfoNotifierRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // blink::mojom

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_RESOURCE_LOAD_INFO_NOTIFIER_MOJOM_H_