/* header auto-generated by pidl */

#ifndef _PIDL_HEADER_libnetapi
#define _PIDL_HEADER_libnetapi

#include <stdint.h>


#define LIBNETAPI_LOCAL_SERVER(x) (!x || is_myname_or_ipaddr(x))
#ifndef MAXSUBAUTHS
#define MAXSUBAUTHS 15 /* max sub authorities in a SID */
#endif
#include "librpc/gen_ndr/misc.h"
#ifndef _HEADER_libnetapi
#define _HEADER_libnetapi

#define ERROR_MORE_DATA	( 234L )
#define USER_PRIV_GUEST	( 0 )
#define USER_PRIV_USER	( 1 )
#define USER_PRIV_ADMIN	( 2 )
#define AF_OP_PRINT	( 0x1 )
#define AF_OP_COMM	( 0x2 )
#define AF_OP_SERVER	( 0x4 )
#define AF_OP_ACCOUNTS	( 0x8 )
#define AF_SETTABLE_BITS	( (AF_OP_PRINT|AF_OP_COMM|AF_OP_SERVER|AF_OP_ACCOUNTS) )
#define USER_MAXSTORAGE_UNLIMITED	( (uint32_t)-1L )
#define ENCRYPTED_PWLEN	( 16 )
#define FILTER_TEMP_DUPLICATE_ACCOUNT	( 0x0001 )
#define FILTER_NORMAL_ACCOUNT	( 0x0002 )
#define FILTER_INTERDOMAIN_TRUST_ACCOUNT	( 0x0008 )
#define FILTER_WORKSTATION_TRUST_ACCOUNT	( 0x0010 )
#define FILTER_SERVER_TRUST_ACCOUNT	( 0x0020 )
#define LG_INCLUDE_INDIRECT	( 0x0001 )
#define TIMEQ_FOREVER	( (uint32_t)-1L )
#define CSC_MASK	( 0x30 )
enum NET_API_STATUS
#ifndef USE_UINT_ENUMS
 {
	NERR_Success=(int)(0),
	NERR_NoOfflineJoinInfo=(int)(2709),
	NERR_BadOfflineJoinInfo=(int)(2710),
	NERR_CantCreateJoinInfo=(int)(2711),
	NERR_BadDomainJoinInfo=(int)(2712),
	NERR_JoinPerformedMustRestart=(int)(2713),
	NERR_NoJoinPending=(int)(2714),
	NERR_ValuesNotSet=(int)(2715),
	NERR_CantVerifyHostname=(int)(2716),
	NERR_CantLoadOfflineHive=(int)(2717),
	NERR_Connectionsecure=(int)(2718),
	NERR_ProvisioningBlobUnsupported=(int)(2719)
}
#else
 { __do_not_use_enum_NET_API_STATUS=INT_MAX}
#define NERR_Success ( 0 )
#define NERR_NoOfflineJoinInfo ( 2709 )
#define NERR_BadOfflineJoinInfo ( 2710 )
#define NERR_CantCreateJoinInfo ( 2711 )
#define NERR_BadDomainJoinInfo ( 2712 )
#define NERR_JoinPerformedMustRestart ( 2713 )
#define NERR_NoJoinPending ( 2714 )
#define NERR_ValuesNotSet ( 2715 )
#define NERR_CantVerifyHostname ( 2716 )
#define NERR_CantLoadOfflineHive ( 2717 )
#define NERR_Connectionsecure ( 2718 )
#define NERR_ProvisioningBlobUnsupported ( 2719 )
#endif
;

struct domsid {
	uint8_t sid_rev_num;
	uint8_t num_auths;
	uint8_t id_auth[6];
	uint32_t *sub_auths;
};

/* bitmap NetJoinFlags */
#define NETSETUP_JOIN_DOMAIN ( 0x00000001 )
#define NETSETUP_ACCT_CREATE ( 0x00000002 )
#define NETSETUP_ACCT_DELETE ( 0x00000004 )
#define NETSETUP_WIN9X_UPGRADE ( 0x00000010 )
#define NETSETUP_DOMAIN_JOIN_IF_JOINED ( 0x00000020 )
#define NETSETUP_JOIN_UNSECURE ( 0x00000040 )
#define NETSETUP_MACHINE_PWD_PASSED ( 0x00000080 )
#define NETSETUP_DEFER_SPN_SET ( 0x00000100 )
#define NETSETUP_JOIN_DC_ACCOUNT ( 0x00000200 )
#define NETSETUP_JOIN_WITH_NEW_NAME ( 0x00000400 )
#define NETSETUP_JOIN_READONLY ( 0x00000800 )
#define NETSETUP_AMBIGUOUS_DC ( 0x00001000 )
#define NETSETUP_NO_NETLOGON_CACHE ( 0x00002000 )
#define NETSETUP_DONT_CONTROL_SERVICES ( 0x00004000 )
#define NETSETUP_SET_MACHINE_NAME ( 0x00008000 )
#define NETSETUP_FORCE_SPN_SET ( 0x00010000 )
#define NETSETUP_NO_ACCT_REUSE ( 0x00020000 )
#define NETSETUP_INSTALL_INVOCATION ( 0x00040000 )
#define NETSETUP_IGNORE_UNSUPPORTED_FLAGS ( 0x10000000 )

enum NETSETUP_JOIN_STATUS
#ifndef USE_UINT_ENUMS
 {
	NetSetupUnknownStatus=(int)(0),
	NetSetupUnjoined=(int)(1),
	NetSetupWorkgroupName=(int)(2),
	NetSetupDomainName=(int)(3)
}
#else
 { __do_not_use_enum_NETSETUP_JOIN_STATUS=INT_MAX}
#define NetSetupUnknownStatus ( 0 )
#define NetSetupUnjoined ( 1 )
#define NetSetupWorkgroupName ( 2 )
#define NetSetupDomainName ( 3 )
#endif
;

/* bitmap NetProvisionFlags */
#define NETSETUP_PROVISION_DOWNLEVEL_PRIV_SUPPORT ( 0x00000001 )
#define NETSETUP_PROVISION_REUSE_ACCOUNT ( 0x00000002 )
#define NETSETUP_PROVISION_USE_DEFAULT_PASSWORD ( 0x00000004 )
#define NETSETUP_PROVISION_SKIP_ACCOUNT_SEARCH ( 0x00000008 )
#define NETSETUP_PROVISION_ROOT_CA_CERTS ( 0x00000010 )

/* bitmap NetProvisionJoinFlags */
#define NETSETUP_PROVISION_ONLINE_CALLER ( 0x40000000 )

struct SERVER_INFO_100 {
	uint32_t sv100_platform_id;
	const char * sv100_name;
};

struct SERVER_INFO_101 {
	uint32_t sv101_platform_id;
	const char * sv101_name;
	uint32_t sv101_version_major;
	uint32_t sv101_version_minor;
	uint32_t sv101_type;
	const char * sv101_comment;
};

struct SERVER_INFO_102 {
	uint32_t sv102_platform_id;
	const char * sv102_name;
	uint32_t sv102_version_major;
	uint32_t sv102_version_minor;
	uint32_t sv102_type;
	const char * sv102_comment;
	uint32_t sv102_users;
	uint32_t sv102_disc;
	uint8_t sv102_hidden;
	uint32_t sv102_announce;
	uint32_t sv102_anndelta;
	uint32_t sv102_licenses;
	const char * sv102_userpath;
};

struct SERVER_INFO_402 {
	uint32_t sv402_ulist_mtime;
	uint32_t sv402_glist_mtime;
	uint32_t sv402_alist_mtime;
	const char * sv402_alerts;
	uint32_t sv402_security;
	uint32_t sv402_numadmin;
	uint32_t sv402_lanmask;
	const char * sv402_guestacct;
	uint32_t sv402_chdevs;
	uint32_t sv402_chdevq;
	uint32_t sv402_chdevjobs;
	uint32_t sv402_connections;
	uint32_t sv402_shares;
	uint32_t sv402_openfiles;
	uint32_t sv402_sessopens;
	uint32_t sv402_sessvcs;
	uint32_t sv402_sessreqs;
	uint32_t sv402_opensearch;
	uint32_t sv402_activelocks;
	uint32_t sv402_numreqbuf;
	uint32_t sv402_sizreqbuf;
	uint32_t sv402_numbigbuf;
	uint32_t sv402_numfiletasks;
	uint32_t sv402_alertsched;
	uint32_t sv402_erroralert;
	uint32_t sv402_logonalert;
	uint32_t sv402_accessalert;
	uint32_t sv402_diskalert;
	uint32_t sv402_netioalert;
	uint32_t sv402_maxauditsz;
	const char * sv402_srvheuristics;
};

struct SERVER_INFO_403 {
	uint32_t sv403_ulist_mtime;
	uint32_t sv403_glist_mtime;
	uint32_t sv403_alist_mtime;
	const char * sv403_alerts;
	uint32_t sv403_security;
	uint32_t sv403_numadmin;
	uint32_t sv403_lanmask;
	const char * sv403_guestacct;
	uint32_t sv403_chdevs;
	uint32_t sv403_chdevq;
	uint32_t sv403_chdevjobs;
	uint32_t sv403_connections;
	uint32_t sv403_shares;
	uint32_t sv403_openfiles;
	uint32_t sv403_sessopens;
	uint32_t sv403_sessvcs;
	uint32_t sv403_sessreqs;
	uint32_t sv403_opensearch;
	uint32_t sv403_activelocks;
	uint32_t sv403_numreqbuf;
	uint32_t sv403_sizreqbuf;
	uint32_t sv403_numbigbuf;
	uint32_t sv403_numfiletasks;
	uint32_t sv403_alertsched;
	uint32_t sv403_erroralert;
	uint32_t sv403_logonalert;
	uint32_t sv403_accessalert;
	uint32_t sv403_diskalert;
	uint32_t sv403_netioalert;
	uint32_t sv403_maxauditsz;
	const char * sv403_srvheuristics;
	uint32_t sv403_auditedevents;
	uint32_t sv403_autoprofile;
	const char * sv403_autopath;
};

struct SERVER_INFO_502 {
	uint32_t sv502_sessopens;
	uint32_t sv502_sessvcs;
	uint32_t sv502_opensearch;
	uint32_t sv502_sizreqbuf;
	uint32_t sv502_initworkitems;
	uint32_t sv502_maxworkitems;
	uint32_t sv502_rawworkitems;
	uint32_t sv502_irpstacksize;
	uint32_t sv502_maxrawbuflen;
	uint32_t sv502_sessusers;
	uint32_t sv502_sessconns;
	uint32_t sv502_maxpagedmemoryusage;
	uint32_t sv502_maxnonpagedmemoryusage;
	uint8_t sv502_enablesoftcompat;
	uint8_t sv502_enableforcedlogoff;
	uint8_t sv502_timesource;
	uint8_t sv502_acceptdownlevelapis;
	uint8_t sv502_lmannounce;
};

struct SERVER_INFO_503 {
	uint32_t sv503_sessopens;
	uint32_t sv503_sessvcs;
	uint32_t sv503_opensearch;
	uint32_t sv503_sizreqbuf;
	uint32_t sv503_initworkitems;
	uint32_t sv503_maxworkitems;
	uint32_t sv503_rawworkitems;
	uint32_t sv503_irpstacksize;
	uint32_t sv503_maxrawbuflen;
	uint32_t sv503_sessusers;
	uint32_t sv503_sessconns;
	uint32_t sv503_maxpagedmemoryusage;
	uint32_t sv503_maxnonpagedmemoryusage;
	uint8_t sv503_enablesoftcompat;
	uint8_t sv503_enableforcedlogoff;
	uint8_t sv503_timesource;
	uint8_t sv503_acceptdownlevelapis;
	uint8_t sv503_lmannounce;
	const char * sv503_domain;
	uint32_t sv503_maxcopyreadlen;
	uint32_t sv503_maxcopywritelen;
	uint32_t sv503_minkeepsearch;
	uint32_t sv503_maxkeepsearch;
	uint32_t sv503_minkeepcomplsearch;
	uint32_t sv503_maxkeepcomplsearch;
	uint32_t sv503_threadcountadd;
	uint32_t sv503_numblockthreads;
	uint32_t sv503_scavtimeout;
	uint32_t sv503_minrcvqueue;
	uint32_t sv503_minfreeworkitems;
	uint32_t sv503_xactmemsize;
	uint32_t sv503_threadpriority;
	uint32_t sv503_maxmpxct;
	uint32_t sv503_oplockbreakwait;
	uint32_t sv503_oplockbreakresponsewait;
	uint8_t sv503_enableoplocks;
	uint8_t sv503_enableoplockforceclose;
	uint8_t sv503_enablefcbopens;
	uint8_t sv503_enableraw;
	uint8_t sv503_enablesharednetdrives;
	uint32_t sv503_minfreeconnections;
	uint32_t sv503_maxfreeconnections;
};

struct SERVER_INFO_599 {
	uint32_t sv599_sessopens;
	uint32_t sv599_sessvcs;
	uint32_t sv599_opensearch;
	uint32_t sv599_sizreqbuf;
	uint32_t sv599_initworkitems;
	uint32_t sv599_maxworkitems;
	uint32_t sv599_rawworkitems;
	uint32_t sv599_irpstacksize;
	uint32_t sv599_maxrawbuflen;
	uint32_t sv599_sessusers;
	uint32_t sv599_sessconns;
	uint32_t sv599_maxpagedmemoryusage;
	uint32_t sv599_maxnonpagedmemoryusage;
	uint8_t sv599_enablesoftcompat;
	uint8_t sv599_enableforcedlogoff;
	uint8_t sv599_timesource;
	uint8_t sv599_acceptdownlevelapis;
	uint8_t sv599_lmannounce;
	const char * sv599_domain;
	uint32_t sv599_maxcopyreadlen;
	uint32_t sv599_maxcopywritelen;
	uint32_t sv599_minkeepsearch;
	uint32_t sv599_maxkeepsearch;
	uint32_t sv599_minkeepcomplsearch;
	uint32_t sv599_maxkeepcomplsearch;
	uint32_t sv599_threadcountadd;
	uint32_t sv599_numblockthreads;
	uint32_t sv599_scavtimeout;
	uint32_t sv599_minrcvqueue;
	uint32_t sv599_minfreeworkitems;
	uint32_t sv599_xactmemsize;
	uint32_t sv599_threadpriority;
	uint32_t sv599_maxmpxct;
	uint32_t sv599_oplockbreakwait;
	uint32_t sv599_oplockbreakresponsewait;
	uint8_t sv599_enableoplocks;
	uint8_t sv599_enableoplockforceclose;
	uint8_t sv599_enablefcbopens;
	uint8_t sv599_enableraw;
	uint8_t sv599_enablesharednetdrives;
	uint32_t sv599_minfreeconnections;
	uint32_t sv599_maxfreeconnections;
	uint32_t sv599_initsesstable;
	uint32_t sv599_initconntable;
	uint32_t sv599_initfiletable;
	uint32_t sv599_initsearchtable;
	uint32_t sv599_alertschedule;
	uint32_t sv599_errorthreshold;
	uint32_t sv599_networkerrorthreshold;
	uint32_t sv599_diskspacethreshold;
	uint32_t sv599_reserved;
	uint32_t sv599_maxlinkdelay;
	uint32_t sv599_minlinkthroughput;
	uint32_t sv599_linkinfovalidtime;
	uint32_t sv599_scavqosinfoupdatetime;
	uint32_t sv599_maxworkitemidletime;
};

struct SERVER_INFO_598 {
	uint32_t sv598_maxrawworkitems;
	uint32_t sv598_maxthreadsperqueue;
	uint32_t sv598_producttype;
	uint32_t sv598_serversize;
	uint32_t sv598_connectionlessautodisc;
	uint32_t sv598_sharingviolationretries;
	uint32_t sv598_sharingviolationdelay;
	uint32_t sv598_maxglobalopensearch;
	uint32_t sv598_removeduplicatesearches;
	uint32_t sv598_lockviolationoffset;
	uint32_t sv598_lockviolationdelay;
	uint32_t sv598_mdlreadswitchover;
	uint32_t sv598_cachedopenlimit;
	uint32_t sv598_otherqueueaffinity;
	uint8_t sv598_restrictnullsessaccess;
	uint8_t sv598_enablewfw311directipx;
	uint32_t sv598_queuesamplesecs;
	uint32_t sv598_balancecount;
	uint32_t sv598_preferredaffinity;
	uint32_t sv598_maxfreerfcbs;
	uint32_t sv598_maxfreemfcbs;
	uint32_t sv598_maxfreelfcbs;
	uint32_t sv598_maxfreepagedpoolchunks;
	uint32_t sv598_minpagedpoolchunksize;
	uint32_t sv598_maxpagedpoolchunksize;
	uint8_t sv598_sendsfrompreferredprocessor;
	uint32_t sv598_cacheddirectorylimit;
	uint32_t sv598_maxcopylength;
	uint8_t sv598_enablecompression;
	uint8_t sv598_autosharewks;
	uint8_t sv598_autoshareserver;
	uint8_t sv598_enablesecuritysignature;
	uint8_t sv598_requiresecuritysignature;
	uint32_t sv598_minclientbuffersize;
	struct GUID sv598_serverguid;
	uint32_t sv598_ConnectionNoSessionsTimeout;
	uint32_t sv598_IdleThreadTimeOut;
	uint8_t sv598_enableW9xsecuritysignature;
	uint8_t sv598_enforcekerberosreauthentication;
	uint8_t sv598_disabledos;
	uint32_t sv598_lowdiskspaceminimum;
	uint8_t sv598_disablestrictnamechecking;
};

struct SERVER_INFO_1005 {
	const char * sv1005_comment;
};

struct SERVER_INFO_1107 {
	uint32_t sv1107_users;
};

struct SERVER_INFO_1010 {
	int32_t sv1010_disc;
};

struct SERVER_INFO_1016 {
	uint8_t sv1016_hidden;
};

struct SERVER_INFO_1017 {
	uint32_t sv1017_announce;
};

struct SERVER_INFO_1018 {
	uint32_t sv1018_anndelta;
};

struct SERVER_INFO_1501 {
	uint32_t sv1501_sessopens;
};

struct SERVER_INFO_1502 {
	uint32_t sv1502_sessvcs;
};

struct SERVER_INFO_1503 {
	uint32_t sv1503_opensearch;
};

struct SERVER_INFO_1506 {
	uint32_t sv1506_maxworkitems;
};

struct SERVER_INFO_1509 {
	uint32_t sv1509_maxrawbuflen;
};

struct SERVER_INFO_1510 {
	uint32_t sv1510_sessusers;
};

struct SERVER_INFO_1511 {
	uint32_t sv1511_sessconns;
};

struct SERVER_INFO_1512 {
	uint32_t sv1512_maxnonpagedmemoryusage;
};

struct SERVER_INFO_1513 {
	uint32_t sv1513_maxpagedmemoryusage;
};

struct SERVER_INFO_1514 {
	uint8_t sv1514_enablesoftcompat;
};

struct SERVER_INFO_1515 {
	uint8_t sv1515_enableforcedlogoff;
};

struct SERVER_INFO_1516 {
	uint8_t sv1516_timesource;
};

struct SERVER_INFO_1518 {
	uint8_t sv1518_lmannounce;
};

struct SERVER_INFO_1520 {
	uint32_t sv1520_maxcopyreadlen;
};

struct SERVER_INFO_1521 {
	uint32_t sv1521_maxcopywritelen;
};

struct SERVER_INFO_1522 {
	uint32_t sv1522_minkeepsearch;
};

struct SERVER_INFO_1523 {
	uint32_t sv1523_maxkeepsearch;
};

struct SERVER_INFO_1524 {
	uint32_t sv1524_minkeepcomplsearch;
};

struct SERVER_INFO_1525 {
	uint32_t sv1525_maxkeepcomplsearch;
};

struct SERVER_INFO_1528 {
	uint32_t sv1528_scavtimeout;
};

struct SERVER_INFO_1529 {
	uint32_t sv1529_minrcvqueue;
};

struct SERVER_INFO_1530 {
	uint32_t sv1530_minfreeworkitems;
};

struct SERVER_INFO_1533 {
	uint32_t sv1533_maxmpxct;
};

struct SERVER_INFO_1534 {
	uint32_t sv1534_oplockbreakwait;
};

struct SERVER_INFO_1535 {
	uint32_t sv1535_oplockbreakresponsewait;
};

struct SERVER_INFO_1536 {
	uint8_t sv1536_enableoplocks;
};

struct SERVER_INFO_1537 {
	uint8_t sv1537_enableoplockforceclose;
};

struct SERVER_INFO_1538 {
	uint8_t sv1538_enablefcbopens;
};

struct SERVER_INFO_1539 {
	uint8_t sv1539_enableraw;
};

struct SERVER_INFO_1540 {
	uint8_t sv1540_enablesharednetdrives;
};

struct SERVER_INFO_1541 {
	uint8_t sv1541_minfreeconnections;
};

struct SERVER_INFO_1542 {
	uint8_t sv1542_maxfreeconnections;
};

struct SERVER_INFO_1543 {
	uint32_t sv1543_initsesstable;
};

struct SERVER_INFO_1544 {
	uint32_t sv1544_initconntable;
};

struct SERVER_INFO_1545 {
	uint32_t sv1545_initfiletable;
};

struct SERVER_INFO_1546 {
	uint32_t sv1546_initsearchtable;
};

struct SERVER_INFO_1547 {
	uint32_t sv1547_alertschedule;
};

struct SERVER_INFO_1548 {
	uint32_t sv1548_errorthreshold;
};

struct SERVER_INFO_1549 {
	uint32_t sv1549_networkerrorthreshold;
};

struct SERVER_INFO_1550 {
	uint32_t sv1550_diskspacethreshold;
};

struct SERVER_INFO_1552 {
	uint32_t sv1552_maxlinkdelay;
};

struct SERVER_INFO_1553 {
	uint32_t sv1553_minlinkthroughput;
};

struct SERVER_INFO_1554 {
	uint32_t sv1554_linkinfovalidtime;
};

struct SERVER_INFO_1555 {
	uint32_t sv1555_scavqosinfoupdatetime;
};

struct SERVER_INFO_1556 {
	uint32_t sv1556_maxworkitemidletime;
};

struct SERVER_INFO_1557 {
	uint32_t sv1557_maxrawworkitems;
};

struct SERVER_INFO_1560 {
	uint32_t sv1560_producttype;
};

struct SERVER_INFO_1561 {
	uint32_t sv1561_serversize;
};

struct SERVER_INFO_1562 {
	uint32_t sv1562_connectionlessautodisc;
};

struct SERVER_INFO_1563 {
	uint32_t sv1563_sharingviolationretries;
};

struct SERVER_INFO_1564 {
	uint32_t sv1564_sharingviolationdelay;
};

struct SERVER_INFO_1565 {
	uint32_t sv1565_maxglobalopensearch;
};

struct SERVER_INFO_1566 {
	uint8_t sv1566_removeduplicatesearches;
};

struct SERVER_INFO_1567 {
	uint32_t sv1567_lockviolationretries;
};

struct SERVER_INFO_1568 {
	uint32_t sv1568_lockviolationoffset;
};

struct SERVER_INFO_1569 {
	uint32_t sv1569_lockviolationdelay;
};

struct SERVER_INFO_1570 {
	uint32_t sv1570_mdlreadswitchover;
};

struct SERVER_INFO_1571 {
	uint32_t sv1571_cachedopenlimit;
};

struct SERVER_INFO_1572 {
	uint32_t sv1572_criticalthreads;
};

struct SERVER_INFO_1573 {
	uint32_t sv1573_restrictnullsessaccess;
};

struct SERVER_INFO_1574 {
	uint32_t sv1574_enablewfw311directipx;
};

struct SERVER_INFO_1575 {
	uint32_t sv1575_otherqueueaffinity;
};

struct SERVER_INFO_1576 {
	uint32_t sv1576_queuesamplesecs;
};

struct SERVER_INFO_1577 {
	uint32_t sv1577_balancecount;
};

struct SERVER_INFO_1578 {
	uint32_t sv1578_preferredaffinity;
};

struct SERVER_INFO_1579 {
	uint32_t sv1579_maxfreerfcbs;
};

struct SERVER_INFO_1580 {
	uint32_t sv1580_maxfreemfcbs;
};

struct SERVER_INFO_1581 {
	uint32_t sv1581_maxfreemlcbs;
};

struct SERVER_INFO_1582 {
	uint32_t sv1582_maxfreepagedpoolchunks;
};

struct SERVER_INFO_1583 {
	uint32_t sv1583_minpagedpoolchunksize;
};

struct SERVER_INFO_1584 {
	uint32_t sv1584_maxpagedpoolchunksize;
};

struct SERVER_INFO_1585 {
	uint8_t sv1585_sendsfrompreferredprocessor;
};

struct SERVER_INFO_1586 {
	uint32_t sv1586_maxthreadsperqueue;
};

struct SERVER_INFO_1587 {
	uint32_t sv1587_cacheddirectorylimit;
};

struct SERVER_INFO_1588 {
	uint32_t sv1588_maxcopylength;
};

struct SERVER_INFO_1590 {
	uint32_t sv1590_enablecompression;
};

struct SERVER_INFO_1591 {
	uint32_t sv1591_autosharewks;
};

struct SERVER_INFO_1592 {
	uint32_t sv1592_autosharewks;
};

struct SERVER_INFO_1593 {
	uint32_t sv1593_enablesecuritysignature;
};

struct SERVER_INFO_1594 {
	uint32_t sv1594_requiresecuritysignature;
};

struct SERVER_INFO_1595 {
	uint32_t sv1595_minclientbuffersize;
};

struct SERVER_INFO_1596 {
	uint32_t sv1596_ConnectionNoSessionsTimeout;
};

struct SERVER_INFO_1597 {
	uint32_t sv1597_IdleThreadTimeOut;
};

struct SERVER_INFO_1598 {
	uint32_t sv1598_enableW9xsecuritysignature;
};

struct SERVER_INFO_1599 {
	uint8_t sv1598_enforcekerberosreauthentication;
};

struct SERVER_INFO_1600 {
	uint8_t sv1598_disabledos;
};

struct SERVER_INFO_1601 {
	uint32_t sv1598_lowdiskspaceminimum;
};

struct SERVER_INFO_1602 {
	uint8_t sv_1598_disablestrictnamechecking;
};

struct WKSTA_INFO_100 {
	uint32_t wki100_platform_id;
	const char * wki100_computername;
	const char * wki100_langroup;
	uint32_t wki100_ver_major;
	uint32_t wki100_ver_minor;
};

struct WKSTA_INFO_101 {
	uint32_t wki101_platform_id;
	const char * wki101_computername;
	const char * wki101_langroup;
	uint32_t wki101_ver_major;
	uint32_t wki101_ver_minor;
	const char * wki101_lanroot;
};

struct WKSTA_INFO_102 {
	uint32_t wki102_platform_id;
	const char * wki102_computername;
	const char * wki102_langroup;
	uint32_t wki102_ver_major;
	uint32_t wki102_ver_minor;
	const char * wki102_lanroot;
	uint32_t wki102_logged_on_users;
};

/* bitmap DOMAIN_CONTROLLER_INFO_FLAGS */
#define DS_PDC_FLAG ( 0x00000001 )
#define DS_GC_FLAG ( 0x00000004 )
#define DS_LDAP_FLAG ( 0x00000008 )
#define DS_DS_FLAG ( 0x00000010 )
#define DS_KDC_FLAG ( 0x00000020 )
#define DS_TIMESERV_FLAG ( 0x00000040 )
#define DS_CLOSEST_FLAG ( 0x00000080 )
#define DS_WRITABLE_FLAG ( 0x00000100 )
#define DS_GOOD_TIMESERV_FLAG ( 0x00000200 )
#define DS_NDNC_FLAG ( 0x00000400 )
#define DS_SELECT_SECRET_DOMAIN_6_FLAG ( 0x00000800 )
#define DS_FULL_SECRET_DOMAIN_6_FLAG ( 0x00001000 )
#define DS_WS_FLAG ( 0x00002000 )
#define DS_DS_8_FLAG ( 0x00004000 )
#define DS_DNS_CONTROLLER_FLAG ( 0x20000000 )
#define DS_DNS_DOMAIN_FLAG ( 0x40000000 )
#define DS_DNS_FOREST_FLAG ( 0x80000000 )

struct DOMAIN_CONTROLLER_INFO {
	const char * domain_controller_name;
	const char * domain_controller_address;
	uint32_t domain_controller_address_type;
	struct GUID domain_guid;
	const char * domain_name;
	const char * dns_forest_name;
	uint32_t flags;
	const char * dc_site_name;
	const char * client_site_name;
};

struct USER_INFO_0 {
	const char * usri0_name;
};

struct USER_INFO_1 {
	const char * usri1_name;
	const char * usri1_password;
	uint32_t usri1_password_age;
	uint32_t usri1_priv;
	const char * usri1_home_dir;
	const char * usri1_comment;
	uint32_t usri1_flags;
	const char * usri1_script_path;
};

struct USER_INFO_2 {
	const char * usri2_name;
	const char * usri2_password;
	uint32_t usri2_password_age;
	uint32_t usri2_priv;
	const char * usri2_home_dir;
	const char * usri2_comment;
	uint32_t usri2_flags;
	const char * usri2_script_path;
	uint32_t usri2_auth_flags;
	const char * usri2_full_name;
	const char * usri2_usr_comment;
	const char * usri2_parms;
	const char * usri2_workstations;
	uint32_t usri2_last_logon;
	uint32_t usri2_last_logoff;
	uint32_t usri2_acct_expires;
	uint32_t usri2_max_storage;
	uint32_t usri2_units_per_week;
	uint8_t *usri2_logon_hours;/* [unique] */
	uint32_t usri2_bad_pw_count;
	uint32_t usri2_num_logons;
	const char * usri2_logon_server;
	uint32_t usri2_country_code;
	uint32_t usri2_code_page;
};

struct USER_INFO_3 {
	const char * usri3_name;
	uint32_t usri3_password_age;
	uint32_t usri3_priv;
	const char * usri3_home_dir;
	const char * usri3_comment;
	uint32_t usri3_flags;
	const char * usri3_script_path;
	uint32_t usri3_auth_flags;
	const char * usri3_full_name;
	const char * usri3_usr_comment;
	const char * usri3_parms;
	const char * usri3_workstations;
	uint32_t usri3_last_logon;
	uint32_t usri3_last_logoff;
	uint32_t usri3_acct_expires;
	uint32_t usri3_max_storage;
	uint32_t usri3_units_per_week;
	uint8_t *usri3_logon_hours;/* [unique] */
	uint32_t usri3_bad_pw_count;
	uint32_t usri3_num_logons;
	const char * usri3_logon_server;
	uint32_t usri3_country_code;
	uint32_t usri3_code_page;
	uint32_t usri3_user_id;
	uint32_t usri3_primary_group_id;
	const char * usri3_profile;
	const char * usri3_home_dir_drive;
	uint32_t usri3_password_expired;
};

struct USER_INFO_4 {
	const char * usri4_name;
	const char * usri4_password;
	uint32_t usri4_password_age;
	uint32_t usri4_priv;
	const char * usri4_home_dir;
	const char * usri4_comment;
	uint32_t usri4_flags;
	const char * usri4_script_path;
	uint32_t usri4_auth_flags;
	const char * usri4_full_name;
	const char * usri4_usr_comment;
	const char * usri4_parms;
	const char * usri4_workstations;
	uint32_t usri4_last_logon;
	uint32_t usri4_last_logoff;
	uint32_t usri4_acct_expires;
	uint32_t usri4_max_storage;
	uint32_t usri4_units_per_week;
	uint8_t *usri4_logon_hours;/* [unique] */
	uint32_t usri4_bad_pw_count;
	uint32_t usri4_num_logons;
	const char * usri4_logon_server;
	uint32_t usri4_country_code;
	uint32_t usri4_code_page;
	struct domsid *usri4_user_sid;/* [unique] */
	uint32_t usri4_primary_group_id;
	const char * usri4_profile;
	const char * usri4_home_dir_drive;
	uint32_t usri4_password_expired;
};

struct USER_INFO_10 {
	const char * usri10_name;
	const char * usri10_comment;
	const char * usri10_usr_comment;
	const char * usri10_full_name;
};

struct USER_INFO_11 {
	const char * usri11_name;
	const char * usri11_comment;
	const char * usri11_usr_comment;
	const char * usri11_full_name;
	uint32_t usri11_priv;
	uint32_t usri11_auth_flags;
	uint32_t usri11_password_age;
	const char * usri11_home_dir;
	const char * usri11_parms;
	uint32_t usri11_last_logon;
	uint32_t usri11_last_logoff;
	uint32_t usri11_bad_pw_count;
	uint32_t usri11_num_logons;
	const char * usri11_logon_server;
	uint32_t usri11_country_code;
	const char * usri11_workstations;
	uint32_t usri11_max_storage;
	uint32_t usri11_units_per_week;
	uint8_t *usri11_logon_hours;/* [unique] */
	uint32_t usri11_code_page;
};

struct USER_INFO_20 {
	const char * usri20_name;
	const char * usri20_full_name;
	const char * usri20_comment;
	uint32_t usri20_flags;
	uint32_t usri20_user_id;
};

struct USER_INFO_21 {
	uint8_t *usri21_password;
};

struct USER_INFO_22 {
	const char * usri22_name;
	uint8_t *usri22_password;
	uint32_t usri22_password_age;
	uint32_t usri22_priv;
	const char * usri22_home_dir;
	const char * usri22_comment;
	uint32_t usri22_flags;
	uint32_t usri22_script_path;
	uint32_t usri22_auth_flags;
	const char * usri22_full_name;
	const char * usri22_usr_comment;
	const char * usri22_parms;
	const char * usri22_workstations;
	uint32_t usri22_last_logon;
	uint32_t usri22_last_logoff;
	uint32_t usri22_acct_expires;
	uint32_t usri22_max_storage;
	uint32_t usri22_units_per_week;
	uint8_t *usri22_logon_hours;/* [unique] */
	uint32_t usri22_bad_pw_count;
	uint32_t usri22_num_logons;
	const char * usri22_logon_server;
	uint32_t usri22_country_code;
	uint32_t usri22_code_page;
};

struct USER_INFO_23 {
	const char * usri23_name;
	const char * usri23_full_name;
	const char * usri23_comment;
	uint32_t usri23_flags;
	struct domsid *usri23_user_sid;/* [unique] */
};

struct USER_INFO_1003 {
	const char * usri1003_password;
};

struct USER_INFO_1005 {
	uint32_t usri1005_priv;
};

struct USER_INFO_1006 {
	const char * usri1006_home_dir;
};

struct USER_INFO_1007 {
	const char * usri1007_comment;
};

struct USER_INFO_1008 {
	uint32_t usri1008_flags;
};

struct USER_INFO_1009 {
	const char * usri1009_script_path;
};

struct USER_INFO_1010 {
	uint32_t usri1010_auth_flags;
};

struct USER_INFO_1011 {
	const char * usri1011_full_name;
};

struct USER_INFO_1012 {
	const char * usri1012_usr_comment;
};

struct USER_INFO_1013 {
	const char * usri1013_parms;
};

struct USER_INFO_1014 {
	const char * usri1014_workstations;
};

struct USER_INFO_1017 {
	uint32_t usri1017_acct_expires;
};

struct USER_INFO_1018 {
	uint32_t usri1018_max_storage;
};

struct USER_INFO_1020 {
	uint32_t usri1020_units_per_week;
	uint8_t *usri1020_logon_hours;/* [unique] */
};

struct USER_INFO_1023 {
	const char * usri1023_logon_server;
};

struct USER_INFO_1024 {
	uint32_t usri1024_country_code;
};

struct USER_INFO_1025 {
	uint32_t usri1025_code_page;
};

struct USER_INFO_1051 {
	uint32_t usri1051_primary_group_id;
};

struct USER_INFO_1052 {
	const char * usri1052_profile;
};

struct USER_INFO_1053 {
	const char * usri1053_home_dir_drive;
};

struct USER_INFO_X {
	const char * usriX_name;
	const char * usriX_password;
	uint32_t usriX_password_age;
	uint32_t usriX_priv;
	const char * usriX_home_dir;
	const char * usriX_comment;
	uint32_t usriX_flags;
	const char * usriX_script_path;
	uint32_t usriX_auth_flags;
	const char * usriX_full_name;
	const char * usriX_usr_comment;
	const char * usriX_parms;
	const char * usriX_workstations;
	uint32_t usriX_last_logon;
	uint32_t usriX_last_logoff;
	uint32_t usriX_acct_expires;
	uint32_t usriX_max_storage;
	uint32_t usriX_units_per_week;
	uint8_t *usriX_logon_hours;/* [unique] */
	uint32_t usriX_bad_pw_count;
	uint32_t usriX_num_logons;
	const char * usriX_logon_server;
	uint32_t usriX_country_code;
	uint32_t usriX_code_page;
	const char * usriX_profile;
	const char * usriX_home_dir_drive;
	uint32_t usriX_user_id;
	uint32_t usriX_primary_group_id;
	uint32_t usriX_password_expired;
};

struct GROUP_USERS_INFO_0 {
	const char * grui0_name;
};

struct GROUP_USERS_INFO_1 {
	const char * grui1_name;
	uint32_t grui1_attributes;
};

struct LOCALGROUP_USERS_INFO_0 {
	const char * lgrui0_name;
};

struct USER_MODALS_INFO_0 {
	uint32_t usrmod0_min_passwd_len;
	uint32_t usrmod0_max_passwd_age;
	uint32_t usrmod0_min_passwd_age;
	uint32_t usrmod0_force_logoff;
	uint32_t usrmod0_password_hist_len;
};

struct USER_MODALS_INFO_1 {
	uint32_t usrmod1_role;
	const char * usrmod1_primary;
};

struct USER_MODALS_INFO_2 {
	const char * usrmod2_domain_name;
	struct domsid *usrmod2_domain_id;/* [unique] */
};

struct USER_MODALS_INFO_3 {
	uint32_t usrmod3_lockout_duration;
	uint32_t usrmod3_lockout_observation_window;
	uint32_t usrmod3_lockout_threshold;
};

struct USER_MODALS_INFO_1001 {
	uint32_t usrmod1001_min_passwd_len;
};

struct USER_MODALS_INFO_1002 {
	uint32_t usrmod1002_max_passwd_age;
};

struct USER_MODALS_INFO_1003 {
	uint32_t usrmod1003_min_passwd_age;
};

struct USER_MODALS_INFO_1004 {
	uint32_t usrmod1004_force_logoff;
};

struct USER_MODALS_INFO_1005 {
	uint32_t usrmod1005_password_hist_len;
};

struct USER_MODALS_INFO_1006 {
	uint32_t usrmod1006_role;
};

struct USER_MODALS_INFO_1007 {
	const char * usrmod1007_primary;
};

struct NET_DISPLAY_USER {
	const char * usri1_name;
	const char * usri1_comment;
	uint32_t usri1_flags;
	const char * usri1_full_name;
	uint32_t usri1_user_id;
	uint32_t usri1_next_index;
};

struct NET_DISPLAY_MACHINE {
	const char * usri2_name;
	const char * usri2_comment;
	uint32_t usri2_flags;
	uint32_t usri2_user_id;
	uint32_t usri2_next_index;
};

struct NET_DISPLAY_GROUP {
	const char * grpi3_name;
	const char * grpi3_comment;
	uint32_t grpi3_group_id;
	uint32_t grpi3_attributes;
	uint32_t grpi3_next_index;
};

struct GROUP_INFO_0 {
	const char * grpi0_name;
};

struct GROUP_INFO_1 {
	const char * grpi1_name;
	const char * grpi1_comment;
};

struct GROUP_INFO_2 {
	const char * grpi2_name;
	const char * grpi2_comment;
	uint32_t grpi2_group_id;
	uint32_t grpi2_attributes;
};

struct GROUP_INFO_3 {
	const char * grpi3_name;
	const char * grpi3_comment;
	struct domsid *grpi3_group_sid;/* [unique] */
	uint32_t grpi3_attributes;
};

struct GROUP_INFO_1002 {
	const char * grpi1002_comment;
};

struct GROUP_INFO_1005 {
	uint32_t grpi1005_attributes;
};

struct LOCALGROUP_INFO_0 {
	const char * lgrpi0_name;
};

struct LOCALGROUP_INFO_1 {
	const char * lgrpi1_name;
	const char * lgrpi1_comment;
};

struct LOCALGROUP_INFO_1002 {
	const char * lgrpi1002_comment;
};

enum SID_NAME_USE
#ifndef USE_UINT_ENUMS
 {
	SidTypeUser=(int)(1),
	SidTypeGroup=(int)(2),
	SidTypeDomain=(int)(3),
	SidTypeAlias=(int)(4),
	SidTypeWellKnownGroup=(int)(5),
	SidTypeDeletedAccount=(int)(6),
	SidTypeInvalid=(int)(7),
	SidTypeUnknown=(int)(8),
	SidTypeComputer=(int)(9),
	SidTypeLabel=(int)(10)
}
#else
 { __do_not_use_enum_SID_NAME_USE=INT_MAX}
#define SidTypeUser ( 1 )
#define SidTypeGroup ( 2 )
#define SidTypeDomain ( 3 )
#define SidTypeAlias ( 4 )
#define SidTypeWellKnownGroup ( 5 )
#define SidTypeDeletedAccount ( 6 )
#define SidTypeInvalid ( 7 )
#define SidTypeUnknown ( 8 )
#define SidTypeComputer ( 9 )
#define SidTypeLabel ( 10 )
#endif
;

struct LOCALGROUP_MEMBERS_INFO_0 {
	struct domsid *lgrmi0_sid;/* [unique] */
};

struct LOCALGROUP_MEMBERS_INFO_1 {
	struct domsid *lgrmi1_sid;/* [unique] */
	enum SID_NAME_USE lgrmi1_sidusage;
	const char * lgrmi1_name;
};

struct LOCALGROUP_MEMBERS_INFO_2 {
	struct domsid *lgrmi2_sid;/* [unique] */
	enum SID_NAME_USE lgrmi2_sidusage;
	const char * lgrmi2_domainandname;
};

struct LOCALGROUP_MEMBERS_INFO_3 {
	const char * lgrmi3_domainandname;
};

struct TIME_OF_DAY_INFO {
	uint32_t tod_elapsedt;
	uint32_t tod_msecs;
	uint32_t tod_hours;
	uint32_t tod_mins;
	uint32_t tod_secs;
	uint32_t tod_hunds;
	int32_t tod_timezone;
	uint32_t tod_tinterval;
	uint32_t tod_day;
	uint32_t tod_month;
	uint32_t tod_year;
	uint32_t tod_weekday;
};

struct SHARE_INFO_0 {
	const char * shi0_netname;
};

struct SHARE_INFO_1 {
	const char * shi1_netname;
	uint32_t shi1_type;
	const char * shi1_remark;
};

struct SHARE_INFO_2 {
	const char * shi2_netname;
	uint32_t shi2_type;
	const char * shi2_remark;
	uint32_t shi2_permissions;
	uint32_t shi2_max_uses;
	uint32_t shi2_current_uses;
	const char * shi2_path;
	const char * shi2_passwd;
};

struct SHARE_INFO_501 {
	const char * shi501_netname;
	uint32_t shi501_type;
	const char * shi501_remark;
	uint32_t shi501_flags;
};

struct SHARE_INFO_502 {
	const char * shi502_netname;
	uint32_t shi502_type;
	const char * shi502_remark;
	uint32_t shi502_permissions;
	uint32_t shi502_max_uses;
	uint32_t shi502_current_uses;
	const char * shi502_path;
	const char * shi502_passwd;
	uint32_t shi502_reserved;
	struct security_descriptor *shi502_security_descriptor;/* [unique] */
};

struct SHARE_INFO_1004 {
	const char * shi1004_remark;
};

/* bitmap SHARE_INFO_1005_FLAGS */
#define SHI1005_FLAGS_DFS ( 0x01 )
#define SHI1005_FLAGS_DFS_ROOT ( 0x02 )
#define CSC_CACHE_MANUAL_REINT ( 0x00 )
#define CSC_CACHE_AUTO_REINT ( 0x10 )
#define CSC_CACHE_VDO ( 0x20 )
#define CSC_CACHE_NONE ( 0x30 )
#define SHI1005_FLAGS_RESTRICT_EXCLUSIVE_OPENS ( 0x0100 )
#define SHI1005_FLAGS_FORCE_SHARED_DELETE ( 0x0200 )
#define SHI1005_FLAGS_ALLOW_NAMESPACE_CACHING ( 0x0400 )
#define SHI1005_FLAGS_ACCESS_BASED_DIRECTORY_ENUM ( 0x0800 )

struct SHARE_INFO_1005 {
	uint32_t shi1005_flags;
};

struct SHARE_INFO_1006 {
	uint32_t shi1006_max_uses;
};

struct FILE_INFO_2 {
	uint32_t fi2_id;
};

struct FILE_INFO_3 {
	uint32_t fi3_id;
	uint32_t fi3_permissions;
	uint32_t fi3_num_locks;
	const char * fi3_pathname;
	const char * fi3_username;
};

struct NETLOGON_INFO_1 {
	uint32_t netlog1_flags;
	enum NET_API_STATUS netlog1_pdc_connection_status;
};

struct NETLOGON_INFO_2 {
	uint32_t netlog2_flags;
	enum NET_API_STATUS netlog2_pdc_connection_status;
	const char * netlog2_trusted_dc_name;
	enum NET_API_STATUS netlog2_tc_connection_status;
};

struct NETLOGON_INFO_3 {
	uint32_t netlog1_flags;
	uint32_t netlog3_logon_attempts;
	uint32_t netlog3_reserved1;
	uint32_t netlog3_reserved2;
	uint32_t netlog3_reserved3;
	uint32_t netlog3_reserved4;
	uint32_t netlog3_reserved5;
};

struct NETLOGON_INFO_4 {
	const char * netlog4_trusted_dc_name;
	const char * netlog4_trusted_domain_name;
};


struct NetJoinDomain {
	struct {
		const char * server;/* [unique] */
		const char * domain;/* [ref] */
		const char * account_ou;/* [unique] */
		const char * account;/* [unique] */
		const char * password;/* [unique] */
		uint32_t join_flags;
	} in;

	struct {
		enum NET_API_STATUS result;
	} out;

};


struct NetUnjoinDomain {
	struct {
		const char * server_name;/* [unique] */
		const char * account;/* [unique] */
		const char * password;/* [unique] */
		uint32_t unjoin_flags;
	} in;

	struct {
		enum NET_API_STATUS result;
	} out;

};


struct NetGetJoinInformation {
	struct {
		const char * server_name;/* [unique] */
	} in;

	struct {
		const char * *name_buffer;/* [ref] */
		uint16_t *name_type;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetGetJoinableOUs {
	struct {
		const char * server_name;/* [unique] */
		const char * domain;/* [ref] */
		const char * account;/* [unique] */
		const char * password;/* [unique] */
	} in;

	struct {
		uint32_t *ou_count;/* [ref] */
		const char * **ous;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetRenameMachineInDomain {
	struct {
		const char * server_name;
		const char * new_machine_name;
		const char * account;
		const char * password;
		uint32_t rename_options;
	} in;

	struct {
		enum NET_API_STATUS result;
	} out;

};


struct NetProvisionComputerAccount {
	struct {
		const char * domain;/* [ref] */
		const char * machine_name;/* [ref] */
		const char * machine_account_ou;/* [unique] */
		const char * dcname;/* [unique] */
		uint32_t options;
		uint8_t **provision_bin_data;/* [unique] */
		uint32_t *provision_bin_data_size;/* [unique] */
		const char * *provision_text_data;/* [unique] */
	} in;

	struct {
		uint8_t **provision_bin_data;/* [unique] */
		uint32_t *provision_bin_data_size;/* [unique] */
		const char * *provision_text_data;/* [unique] */
		enum NET_API_STATUS result;
	} out;

};


struct NetRequestOfflineDomainJoin {
	struct {
		uint8_t *provision_bin_data;/* [unique] */
		uint32_t provision_bin_data_size;
		uint32_t options;
		const char * windows_path;/* [unique] */
	} in;

	struct {
		enum NET_API_STATUS result;
	} out;

};


struct NetComposeOfflineDomainJoin {
	struct {
		const char * dns_domain_name;/* [ref] */
		const char * netbios_domain_name;/* [ref] */
		struct domsid *domain_sid;/* [ref] */
		struct GUID *domain_guid;/* [ref] */
		const char * forest_name;/* [ref] */
		const char * machine_account_name;/* [ref] */
		const char * machine_account_password;/* [ref] */
		const char * dc_name;/* [unique] */
		const char * dc_address;/* [unique] */
		uint8_t domain_is_ad;
		uint8_t **compose_bin_data;/* [unique] */
		uint32_t *compose_bin_data_size;/* [unique] */
		const char * *compose_text_data;/* [unique] */
	} in;

	struct {
		uint8_t **compose_bin_data;/* [unique] */
		uint32_t *compose_bin_data_size;/* [unique] */
		const char * *compose_text_data;/* [unique] */
		enum NET_API_STATUS result;
	} out;

};


struct NetServerGetInfo {
	struct {
		const char * server_name;/* [unique] */
		uint32_t level;
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetServerSetInfo {
	struct {
		const char * server_name;/* [unique] */
		uint32_t level;
		uint8_t *buffer;/* [ref] */
	} in;

	struct {
		uint32_t *parm_error;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetWkstaGetInfo {
	struct {
		const char * server_name;/* [unique] */
		uint32_t level;
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetGetDCName {
	struct {
		const char * server_name;/* [unique] */
		const char * domain_name;/* [unique] */
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetGetAnyDCName {
	struct {
		const char * server_name;/* [unique] */
		const char * domain_name;/* [unique] */
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct DsGetDcName {
	struct {
		const char * server_name;/* [unique] */
		const char * domain_name;/* [ref] */
		struct GUID *domain_guid;/* [unique] */
		const char * site_name;/* [unique] */
		uint32_t flags;
	} in;

	struct {
		struct DOMAIN_CONTROLLER_INFO **dc_info;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetUserAdd {
	struct {
		const char * server_name;/* [unique] */
		uint32_t level;
		uint8_t *buffer;/* [ref] */
	} in;

	struct {
		uint32_t *parm_error;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetUserDel {
	struct {
		const char * server_name;/* [unique] */
		const char * user_name;/* [ref] */
	} in;

	struct {
		enum NET_API_STATUS result;
	} out;

};


struct NetUserEnum {
	struct {
		const char * server_name;/* [unique] */
		uint32_t level;
		uint32_t filter;
		uint32_t prefmaxlen;
		uint32_t *resume_handle;/* [ref] */
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		uint32_t *entries_read;/* [ref] */
		uint32_t *total_entries;/* [ref] */
		uint32_t *resume_handle;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetUserChangePassword {
	struct {
		const char * domain_name;
		const char * user_name;
		const char * old_password;
		const char * new_password;
	} in;

	struct {
		enum NET_API_STATUS result;
	} out;

};


struct NetUserGetInfo {
	struct {
		const char * server_name;
		const char * user_name;
		uint32_t level;
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetUserSetInfo {
	struct {
		const char * server_name;
		const char * user_name;
		uint32_t level;
		uint8_t *buffer;/* [ref] */
	} in;

	struct {
		uint32_t *parm_err;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetUserGetGroups {
	struct {
		const char * server_name;
		const char * user_name;
		uint32_t level;
		uint32_t prefmaxlen;
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		uint32_t *entries_read;/* [ref] */
		uint32_t *total_entries;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetUserSetGroups {
	struct {
		const char * server_name;
		const char * user_name;
		uint32_t level;
		uint8_t *buffer;/* [ref] */
		uint32_t num_entries;
	} in;

	struct {
		enum NET_API_STATUS result;
	} out;

};


struct NetUserGetLocalGroups {
	struct {
		const char * server_name;
		const char * user_name;
		uint32_t level;
		uint32_t flags;
		uint32_t prefmaxlen;
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		uint32_t *entries_read;/* [ref] */
		uint32_t *total_entries;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetUserModalsGet {
	struct {
		const char * server_name;
		uint32_t level;
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetUserModalsSet {
	struct {
		const char * server_name;
		uint32_t level;
		uint8_t *buffer;/* [ref] */
	} in;

	struct {
		uint32_t *parm_err;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetQueryDisplayInformation {
	struct {
		const char * server_name;/* [unique] */
		uint32_t level;
		uint32_t idx;
		uint32_t entries_requested;
		uint32_t prefmaxlen;
	} in;

	struct {
		uint32_t *entries_read;/* [ref] */
		void **buffer;/* [noprint,ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetGroupAdd {
	struct {
		const char * server_name;
		uint32_t level;
		uint8_t *buffer;/* [ref] */
	} in;

	struct {
		uint32_t *parm_err;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetGroupDel {
	struct {
		const char * server_name;
		const char * group_name;
	} in;

	struct {
		enum NET_API_STATUS result;
	} out;

};


struct NetGroupEnum {
	struct {
		const char * server_name;
		uint32_t level;
		uint32_t prefmaxlen;
		uint32_t *resume_handle;/* [ref] */
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		uint32_t *entries_read;/* [ref] */
		uint32_t *total_entries;/* [ref] */
		uint32_t *resume_handle;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetGroupSetInfo {
	struct {
		const char * server_name;
		const char * group_name;
		uint32_t level;
		uint8_t *buffer;/* [ref] */
	} in;

	struct {
		uint32_t *parm_err;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetGroupGetInfo {
	struct {
		const char * server_name;
		const char * group_name;
		uint32_t level;
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetGroupAddUser {
	struct {
		const char * server_name;
		const char * group_name;
		const char * user_name;
	} in;

	struct {
		enum NET_API_STATUS result;
	} out;

};


struct NetGroupDelUser {
	struct {
		const char * server_name;
		const char * group_name;
		const char * user_name;
	} in;

	struct {
		enum NET_API_STATUS result;
	} out;

};


struct NetGroupGetUsers {
	struct {
		const char * server_name;
		const char * group_name;
		uint32_t level;
		uint32_t prefmaxlen;
		uint32_t *resume_handle;/* [ref] */
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		uint32_t *entries_read;/* [ref] */
		uint32_t *total_entries;/* [ref] */
		uint32_t *resume_handle;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetGroupSetUsers {
	struct {
		const char * server_name;
		const char * group_name;
		uint32_t level;
		uint8_t *buffer;/* [ref] */
		uint32_t num_entries;
	} in;

	struct {
		enum NET_API_STATUS result;
	} out;

};


struct NetLocalGroupAdd {
	struct {
		const char * server_name;
		uint32_t level;
		uint8_t *buffer;/* [ref] */
	} in;

	struct {
		uint32_t *parm_err;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetLocalGroupDel {
	struct {
		const char * server_name;
		const char * group_name;
	} in;

	struct {
		enum NET_API_STATUS result;
	} out;

};


struct NetLocalGroupGetInfo {
	struct {
		const char * server_name;
		const char * group_name;
		uint32_t level;
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetLocalGroupSetInfo {
	struct {
		const char * server_name;
		const char * group_name;
		uint32_t level;
		uint8_t *buffer;/* [ref] */
	} in;

	struct {
		uint32_t *parm_err;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetLocalGroupEnum {
	struct {
		const char * server_name;
		uint32_t level;
		uint32_t prefmaxlen;
		uint32_t *resume_handle;/* [ref] */
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		uint32_t *entries_read;/* [ref] */
		uint32_t *total_entries;/* [ref] */
		uint32_t *resume_handle;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetLocalGroupAddMembers {
	struct {
		const char * server_name;
		const char * group_name;
		uint32_t level;
		uint8_t *buffer;/* [ref] */
		uint32_t total_entries;
	} in;

	struct {
		enum NET_API_STATUS result;
	} out;

};


struct NetLocalGroupDelMembers {
	struct {
		const char * server_name;
		const char * group_name;
		uint32_t level;
		uint8_t *buffer;/* [ref] */
		uint32_t total_entries;
	} in;

	struct {
		enum NET_API_STATUS result;
	} out;

};


struct NetLocalGroupGetMembers {
	struct {
		const char * server_name;
		const char * local_group_name;
		uint32_t level;
		uint32_t prefmaxlen;
		uint32_t *resume_handle;/* [ref] */
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		uint32_t *entries_read;/* [ref] */
		uint32_t *total_entries;/* [ref] */
		uint32_t *resume_handle;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetLocalGroupSetMembers {
	struct {
		const char * server_name;
		const char * group_name;
		uint32_t level;
		uint8_t *buffer;/* [ref] */
		uint32_t total_entries;
	} in;

	struct {
		enum NET_API_STATUS result;
	} out;

};


struct NetRemoteTOD {
	struct {
		const char * server_name;
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetShareAdd {
	struct {
		const char * server_name;
		uint32_t level;
		uint8_t *buffer;/* [ref] */
	} in;

	struct {
		uint32_t *parm_err;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetShareDel {
	struct {
		const char * server_name;
		const char * net_name;
		uint32_t reserved;
	} in;

	struct {
		enum NET_API_STATUS result;
	} out;

};


struct NetShareEnum {
	struct {
		const char * server_name;
		uint32_t level;
		uint32_t prefmaxlen;
		uint32_t *resume_handle;/* [ref] */
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		uint32_t *entries_read;/* [ref] */
		uint32_t *total_entries;/* [ref] */
		uint32_t *resume_handle;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetShareGetInfo {
	struct {
		const char * server_name;
		const char * net_name;
		uint32_t level;
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetShareSetInfo {
	struct {
		const char * server_name;
		const char * net_name;
		uint32_t level;
		uint8_t *buffer;/* [ref] */
	} in;

	struct {
		uint32_t *parm_err;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetFileClose {
	struct {
		const char * server_name;
		uint32_t fileid;
	} in;

	struct {
		enum NET_API_STATUS result;
	} out;

};


struct NetFileGetInfo {
	struct {
		const char * server_name;
		uint32_t fileid;
		uint32_t level;
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetFileEnum {
	struct {
		const char * server_name;
		const char * base_path;
		const char * user_name;
		uint32_t level;
		uint32_t prefmaxlen;
		uint32_t *resume_handle;/* [ref] */
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		uint32_t *entries_read;/* [ref] */
		uint32_t *total_entries;/* [ref] */
		uint32_t *resume_handle;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetShutdownInit {
	struct {
		const char * server_name;
		const char * message;
		uint32_t timeout;
		uint8_t force_apps;
		uint8_t do_reboot;
	} in;

	struct {
		enum NET_API_STATUS result;
	} out;

};


struct NetShutdownAbort {
	struct {
		const char * server_name;
	} in;

	struct {
		enum NET_API_STATUS result;
	} out;

};


struct I_NetLogonControl {
	struct {
		const char * server_name;
		uint32_t function_code;
		uint32_t query_level;
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct I_NetLogonControl2 {
	struct {
		const char * server_name;
		uint32_t function_code;
		uint32_t query_level;
		uint8_t *data;/* [unique] */
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};

#endif /* _HEADER_libnetapi */
#endif /* _PIDL_HEADER_libnetapi */
