/* MetadataDateTime.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from MetadataDateTime.vala, do not modify */

#include "metadata.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <stdio.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _metadata_date_time_unref0(var) ((var == NULL) ? NULL : (var = (metadata_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecMetadataDateTime ParamSpecMetadataDateTime;

struct _MetadataDateTimePrivate {
	GDateTime* timestamp;
};

struct _ParamSpecMetadataDateTime {
	GParamSpec parent_instance;
};

static gint MetadataDateTime_private_offset;
static gpointer metadata_date_time_parent_class = NULL;
static GTimeZone* metadata_date_time_local;
static GTimeZone* metadata_date_time_local = NULL;

static void metadata_date_time_finalize (MetadataDateTime * obj);
static GType metadata_date_time_get_type_once (void);

GQuark
metadata_date_time_error_quark (void)
{
	return g_quark_from_static_string ("metadata-date-time-error-quark");
}

static GType
metadata_date_time_error_get_type_once (void)
{
	static const GEnumValue values[] = {{METADATA_DATE_TIME_ERROR_INVALID_FORMAT, "METADATA_DATE_TIME_ERROR_INVALID_FORMAT", "invalid-format"}, {METADATA_DATE_TIME_ERROR_UNSUPPORTED_FORMAT, "METADATA_DATE_TIME_ERROR_UNSUPPORTED_FORMAT", "unsupported-format"}, {0, NULL, NULL}};
	GType metadata_date_time_error_type_id;
	metadata_date_time_error_type_id = g_enum_register_static ("MetadataDateTimeError", values);
	return metadata_date_time_error_type_id;
}

GType
metadata_date_time_error_get_type (void)
{
	static volatile gsize metadata_date_time_error_type_id__once = 0;
	if (g_once_init_enter (&metadata_date_time_error_type_id__once)) {
		GType metadata_date_time_error_type_id;
		metadata_date_time_error_type_id = metadata_date_time_error_get_type_once ();
		g_once_init_leave (&metadata_date_time_error_type_id__once, metadata_date_time_error_type_id);
	}
	return metadata_date_time_error_type_id__once;
}

static inline gpointer
metadata_date_time_get_instance_private (MetadataDateTime* self)
{
	return G_STRUCT_MEMBER_P (self, MetadataDateTime_private_offset);
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

MetadataDateTime*
metadata_date_time_construct (GType object_type,
                              GDateTime* timestamp)
{
	MetadataDateTime* self = NULL;
	GDateTime* _tmp0_;
	g_return_val_if_fail (timestamp != NULL, NULL);
	self = (MetadataDateTime*) g_type_create_instance (object_type);
	_tmp0_ = _g_date_time_ref0 (timestamp);
	_g_date_time_unref0 (self->priv->timestamp);
	self->priv->timestamp = _tmp0_;
	return self;
}

MetadataDateTime*
metadata_date_time_new (GDateTime* timestamp)
{
	return metadata_date_time_construct (TYPE_METADATA_DATE_TIME, timestamp);
}

MetadataDateTime*
metadata_date_time_construct_from_exif (GType object_type,
                                        const gchar* label,
                                        GError** error)
{
	MetadataDateTime* self = NULL;
	GDateTime* _tmp0_ = NULL;
	gboolean _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (label != NULL, NULL);
	self = (MetadataDateTime*) g_type_create_instance (object_type);
	_tmp1_ = metadata_date_time_from_exif_date_time (label, &_tmp0_);
	_g_date_time_unref0 (self->priv->timestamp);
	self->priv->timestamp = _tmp0_;
	if (!_tmp1_) {
		GError* _tmp2_;
		_tmp2_ = g_error_new (METADATA_DATE_TIME_ERROR, METADATA_DATE_TIME_ERROR_INVALID_FORMAT, "%s is not EXIF format date/time", label);
		_inner_error0_ = _tmp2_;
		if (_inner_error0_->domain == METADATA_DATE_TIME_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_metadata_date_time_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	return self;
}

MetadataDateTime*
metadata_date_time_new_from_exif (const gchar* label,
                                  GError** error)
{
	return metadata_date_time_construct_from_exif (TYPE_METADATA_DATE_TIME, label, error);
}

MetadataDateTime*
metadata_date_time_construct_from_iptc (GType object_type,
                                        const gchar* date,
                                        const gchar* time,
                                        GError** error)
{
	MetadataDateTime* self = NULL;
	GError* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (date != NULL, NULL);
	g_return_val_if_fail (time != NULL, NULL);
	self = (MetadataDateTime*) g_type_create_instance (object_type);
	_tmp0_ = g_error_new_literal (METADATA_DATE_TIME_ERROR, METADATA_DATE_TIME_ERROR_UNSUPPORTED_FORMAT, "IPTC date/time format not currently supported");
	_inner_error0_ = _tmp0_;
	if (_inner_error0_->domain == METADATA_DATE_TIME_ERROR) {
		g_propagate_error (error, _inner_error0_);
		_metadata_date_time_unref0 (self);
		return NULL;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	return self;
}

MetadataDateTime*
metadata_date_time_new_from_iptc (const gchar* date,
                                  const gchar* time,
                                  GError** error)
{
	return metadata_date_time_construct_from_iptc (TYPE_METADATA_DATE_TIME, date, time, error);
}

MetadataDateTime*
metadata_date_time_construct_from_xmp (GType object_type,
                                       const gchar* label,
                                       GError** error)
{
	MetadataDateTime* self = NULL;
	GDateTime* dt = NULL;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (label != NULL, NULL);
	self = (MetadataDateTime*) g_type_create_instance (object_type);
	_tmp0_ = g_date_time_new_from_iso8601 (label, NULL);
	dt = _tmp0_;
	_tmp1_ = dt;
	if (_tmp1_ == NULL) {
		GError* _tmp2_;
		_tmp2_ = g_error_new (METADATA_DATE_TIME_ERROR, METADATA_DATE_TIME_ERROR_INVALID_FORMAT, "%s is not XMP format date/time", label);
		_inner_error0_ = _tmp2_;
		if (_inner_error0_->domain == METADATA_DATE_TIME_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_date_time_unref0 (dt);
			_metadata_date_time_unref0 (self);
			return NULL;
		} else {
			_g_date_time_unref0 (dt);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp3_ = dt;
	_tmp4_ = _g_date_time_ref0 (_tmp3_);
	_g_date_time_unref0 (self->priv->timestamp);
	self->priv->timestamp = _tmp4_;
	_g_date_time_unref0 (dt);
	return self;
}

MetadataDateTime*
metadata_date_time_new_from_xmp (const gchar* label,
                                 GError** error)
{
	return metadata_date_time_construct_from_xmp (TYPE_METADATA_DATE_TIME, label, error);
}

GDateTime*
metadata_date_time_get_timestamp (MetadataDateTime* self)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* result;
	g_return_val_if_fail (IS_METADATA_DATE_TIME (self), NULL);
	_tmp0_ = self->priv->timestamp;
	_tmp1_ = _g_date_time_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
metadata_date_time_get_exif_label (MetadataDateTime* self)
{
	GDateTime* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (IS_METADATA_DATE_TIME (self), NULL);
	_tmp0_ = self->priv->timestamp;
	_tmp1_ = metadata_date_time_to_exif_date_time (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
metadata_date_time_get_xmp_label (MetadataDateTime* self)
{
	GDateTime* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (IS_METADATA_DATE_TIME (self), NULL);
	_tmp0_ = self->priv->timestamp;
	_tmp1_ = g_date_time_format_iso8601 (_tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
metadata_date_time_from_exif_date_time (const gchar* date_time,
                                        GDateTime** timestamp)
{
	GDateTime* _vala_timestamp = NULL;
	struct tm tm = {0};
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	struct tm _tmp8_;
	GTimeZone* _tmp14_;
	struct tm _tmp15_;
	struct tm _tmp16_;
	struct tm _tmp17_;
	struct tm _tmp18_;
	struct tm _tmp19_;
	struct tm _tmp20_;
	GDateTime* _tmp21_;
	gboolean result;
	g_return_val_if_fail (date_time != NULL, FALSE);
	_g_date_time_unref0 (_vala_timestamp);
	_vala_timestamp = NULL;
	memset (&tm, 0, sizeof (struct tm));
	if (sscanf (date_time, "%d:%d:%d %d:%d:%d", &tm.tm_year, &tm.tm_mon, &tm.tm_mday, &tm.tm_hour, &tm.tm_min, &tm.tm_sec) != 6) {
		gchar* tmp = NULL;
		gchar* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp0_ = g_strdup (date_time);
		tmp = _tmp0_;
		_tmp1_ = tmp;
		g_strcanon (_tmp1_, "0123456789", ' ');
		_tmp2_ = tmp;
		if (sscanf (_tmp2_, "%4d%2d%2d%2d%2d%2d", &tm.tm_year, &tm.tm_mon, &tm.tm_mday, &tm.tm_hour, &tm.tm_min, &tm.tm_sec) != 6) {
			result = FALSE;
			_g_free0 (tmp);
			if (timestamp) {
				*timestamp = _vala_timestamp;
			} else {
				_g_date_time_unref0 (_vala_timestamp);
			}
			return result;
		}
		_g_free0 (tmp);
	}
	_tmp8_ = tm;
	if (_tmp8_.tm_year <= 1900) {
		_tmp7_ = TRUE;
	} else {
		struct tm _tmp9_;
		_tmp9_ = tm;
		_tmp7_ = _tmp9_.tm_mon <= 0;
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		struct tm _tmp10_;
		_tmp10_ = tm;
		_tmp6_ = _tmp10_.tm_mday < 0;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		struct tm _tmp11_;
		_tmp11_ = tm;
		_tmp5_ = _tmp11_.tm_hour < 0;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		struct tm _tmp12_;
		_tmp12_ = tm;
		_tmp4_ = _tmp12_.tm_min < 0;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		struct tm _tmp13_;
		_tmp13_ = tm;
		_tmp3_ = _tmp13_.tm_sec < 0;
	}
	if (_tmp3_) {
		result = FALSE;
		if (timestamp) {
			*timestamp = _vala_timestamp;
		} else {
			_g_date_time_unref0 (_vala_timestamp);
		}
		return result;
	}
	_tmp14_ = metadata_date_time_local;
	_tmp15_ = tm;
	_tmp16_ = tm;
	_tmp17_ = tm;
	_tmp18_ = tm;
	_tmp19_ = tm;
	_tmp20_ = tm;
	_tmp21_ = g_date_time_new (_tmp14_, _tmp15_.tm_year, _tmp16_.tm_mon, _tmp17_.tm_mday, _tmp18_.tm_hour, _tmp19_.tm_min, (gdouble) _tmp20_.tm_sec);
	_g_date_time_unref0 (_vala_timestamp);
	_vala_timestamp = _tmp21_;
	result = TRUE;
	if (timestamp) {
		*timestamp = _vala_timestamp;
	} else {
		_g_date_time_unref0 (_vala_timestamp);
	}
	return result;
}

gchar*
metadata_date_time_to_exif_date_time (GDateTime* timestamp)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (timestamp != NULL, NULL);
	_tmp0_ = g_date_time_to_local (timestamp);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_date_time_format (_tmp1_, "%Y:%m:%d %H:%M:%S");
	_tmp3_ = _tmp2_;
	_g_date_time_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gchar*
metadata_date_time_to_string (MetadataDateTime* self)
{
	GDateTime* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (IS_METADATA_DATE_TIME (self), NULL);
	_tmp0_ = self->priv->timestamp;
	_tmp1_ = metadata_date_time_to_exif_date_time (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
value_metadata_date_time_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_metadata_date_time_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		metadata_date_time_unref (value->data[0].v_pointer);
	}
}

static void
value_metadata_date_time_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = metadata_date_time_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_metadata_date_time_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_metadata_date_time_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		MetadataDateTime * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = metadata_date_time_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_metadata_date_time_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	MetadataDateTime ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = metadata_date_time_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_metadata_date_time (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	ParamSpecMetadataDateTime* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_METADATA_DATE_TIME), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_metadata_date_time (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_METADATA_DATE_TIME), NULL);
	return value->data[0].v_pointer;
}

void
value_set_metadata_date_time (GValue* value,
                              gpointer v_object)
{
	MetadataDateTime * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_METADATA_DATE_TIME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_METADATA_DATE_TIME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		metadata_date_time_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		metadata_date_time_unref (old);
	}
}

void
value_take_metadata_date_time (GValue* value,
                               gpointer v_object)
{
	MetadataDateTime * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_METADATA_DATE_TIME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_METADATA_DATE_TIME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		metadata_date_time_unref (old);
	}
}

static void
metadata_date_time_class_init (MetadataDateTimeClass * klass,
                               gpointer klass_data)
{
	GTimeZone* _tmp0_;
	metadata_date_time_parent_class = g_type_class_peek_parent (klass);
	((MetadataDateTimeClass *) klass)->finalize = metadata_date_time_finalize;
	g_type_class_adjust_private_offset (klass, &MetadataDateTime_private_offset);
	_tmp0_ = g_time_zone_new_local ();
	metadata_date_time_local = _tmp0_;
}

static void
metadata_date_time_instance_init (MetadataDateTime * self,
                                  gpointer klass)
{
	self->priv = metadata_date_time_get_instance_private (self);
	self->ref_count = 1;
}

static void
metadata_date_time_finalize (MetadataDateTime * obj)
{
	MetadataDateTime * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_METADATA_DATE_TIME, MetadataDateTime);
	g_signal_handlers_destroy (self);
	_g_date_time_unref0 (self->priv->timestamp);
}

static GType
metadata_date_time_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_metadata_date_time_init, value_metadata_date_time_free_value, value_metadata_date_time_copy_value, value_metadata_date_time_peek_pointer, "p", value_metadata_date_time_collect_value, "p", value_metadata_date_time_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (MetadataDateTimeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) metadata_date_time_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MetadataDateTime), 0, (GInstanceInitFunc) metadata_date_time_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType metadata_date_time_type_id;
	metadata_date_time_type_id = g_type_register_fundamental (g_type_fundamental_next (), "MetadataDateTime", &g_define_type_info, &g_define_type_fundamental_info, 0);
	MetadataDateTime_private_offset = g_type_add_instance_private (metadata_date_time_type_id, sizeof (MetadataDateTimePrivate));
	return metadata_date_time_type_id;
}

GType
metadata_date_time_get_type (void)
{
	static volatile gsize metadata_date_time_type_id__once = 0;
	if (g_once_init_enter (&metadata_date_time_type_id__once)) {
		GType metadata_date_time_type_id;
		metadata_date_time_type_id = metadata_date_time_get_type_once ();
		g_once_init_leave (&metadata_date_time_type_id__once, metadata_date_time_type_id);
	}
	return metadata_date_time_type_id__once;
}

gpointer
metadata_date_time_ref (gpointer instance)
{
	MetadataDateTime * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
metadata_date_time_unref (gpointer instance)
{
	MetadataDateTime * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		METADATA_DATE_TIME_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

