// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.6.0
// - protoc             (unknown)
// source: machine/image.proto

package machine

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	ImageService_List_FullMethodName   = "/machine.ImageService/List"
	ImageService_Pull_FullMethodName   = "/machine.ImageService/Pull"
	ImageService_Import_FullMethodName = "/machine.ImageService/Import"
	ImageService_Remove_FullMethodName = "/machine.ImageService/Remove"
)

// ImageServiceClient is the client API for ImageService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// The machine service definition.
type ImageServiceClient interface {
	// List images in the containerd.
	List(ctx context.Context, in *ImageServiceListRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[ImageServiceListResponse], error)
	// Pull an image into the containerd.
	Pull(ctx context.Context, in *ImageServicePullRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[ImageServicePullResponse], error)
	// Import an image from a stream (tarball).
	Import(ctx context.Context, opts ...grpc.CallOption) (grpc.ClientStreamingClient[ImageServiceImportRequest, ImageServiceImportResponse], error)
	// Remove an image from the containerd.
	Remove(ctx context.Context, in *ImageServiceRemoveRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type imageServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewImageServiceClient(cc grpc.ClientConnInterface) ImageServiceClient {
	return &imageServiceClient{cc}
}

func (c *imageServiceClient) List(ctx context.Context, in *ImageServiceListRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[ImageServiceListResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &ImageService_ServiceDesc.Streams[0], ImageService_List_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[ImageServiceListRequest, ImageServiceListResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ImageService_ListClient = grpc.ServerStreamingClient[ImageServiceListResponse]

func (c *imageServiceClient) Pull(ctx context.Context, in *ImageServicePullRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[ImageServicePullResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &ImageService_ServiceDesc.Streams[1], ImageService_Pull_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[ImageServicePullRequest, ImageServicePullResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ImageService_PullClient = grpc.ServerStreamingClient[ImageServicePullResponse]

func (c *imageServiceClient) Import(ctx context.Context, opts ...grpc.CallOption) (grpc.ClientStreamingClient[ImageServiceImportRequest, ImageServiceImportResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &ImageService_ServiceDesc.Streams[2], ImageService_Import_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[ImageServiceImportRequest, ImageServiceImportResponse]{ClientStream: stream}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ImageService_ImportClient = grpc.ClientStreamingClient[ImageServiceImportRequest, ImageServiceImportResponse]

func (c *imageServiceClient) Remove(ctx context.Context, in *ImageServiceRemoveRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ImageService_Remove_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ImageServiceServer is the server API for ImageService service.
// All implementations must embed UnimplementedImageServiceServer
// for forward compatibility.
//
// The machine service definition.
type ImageServiceServer interface {
	// List images in the containerd.
	List(*ImageServiceListRequest, grpc.ServerStreamingServer[ImageServiceListResponse]) error
	// Pull an image into the containerd.
	Pull(*ImageServicePullRequest, grpc.ServerStreamingServer[ImageServicePullResponse]) error
	// Import an image from a stream (tarball).
	Import(grpc.ClientStreamingServer[ImageServiceImportRequest, ImageServiceImportResponse]) error
	// Remove an image from the containerd.
	Remove(context.Context, *ImageServiceRemoveRequest) (*emptypb.Empty, error)
	mustEmbedUnimplementedImageServiceServer()
}

// UnimplementedImageServiceServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedImageServiceServer struct{}

func (UnimplementedImageServiceServer) List(*ImageServiceListRequest, grpc.ServerStreamingServer[ImageServiceListResponse]) error {
	return status.Error(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedImageServiceServer) Pull(*ImageServicePullRequest, grpc.ServerStreamingServer[ImageServicePullResponse]) error {
	return status.Error(codes.Unimplemented, "method Pull not implemented")
}
func (UnimplementedImageServiceServer) Import(grpc.ClientStreamingServer[ImageServiceImportRequest, ImageServiceImportResponse]) error {
	return status.Error(codes.Unimplemented, "method Import not implemented")
}
func (UnimplementedImageServiceServer) Remove(context.Context, *ImageServiceRemoveRequest) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method Remove not implemented")
}
func (UnimplementedImageServiceServer) mustEmbedUnimplementedImageServiceServer() {}
func (UnimplementedImageServiceServer) testEmbeddedByValue()                      {}

// UnsafeImageServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ImageServiceServer will
// result in compilation errors.
type UnsafeImageServiceServer interface {
	mustEmbedUnimplementedImageServiceServer()
}

func RegisterImageServiceServer(s grpc.ServiceRegistrar, srv ImageServiceServer) {
	// If the following call panics, it indicates UnimplementedImageServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&ImageService_ServiceDesc, srv)
}

func _ImageService_List_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ImageServiceListRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ImageServiceServer).List(m, &grpc.GenericServerStream[ImageServiceListRequest, ImageServiceListResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ImageService_ListServer = grpc.ServerStreamingServer[ImageServiceListResponse]

func _ImageService_Pull_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ImageServicePullRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ImageServiceServer).Pull(m, &grpc.GenericServerStream[ImageServicePullRequest, ImageServicePullResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ImageService_PullServer = grpc.ServerStreamingServer[ImageServicePullResponse]

func _ImageService_Import_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(ImageServiceServer).Import(&grpc.GenericServerStream[ImageServiceImportRequest, ImageServiceImportResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ImageService_ImportServer = grpc.ClientStreamingServer[ImageServiceImportRequest, ImageServiceImportResponse]

func _ImageService_Remove_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImageServiceRemoveRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageServiceServer).Remove(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ImageService_Remove_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageServiceServer).Remove(ctx, req.(*ImageServiceRemoveRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ImageService_ServiceDesc is the grpc.ServiceDesc for ImageService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ImageService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "machine.ImageService",
	HandlerType: (*ImageServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Remove",
			Handler:    _ImageService_Remove_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "List",
			Handler:       _ImageService_List_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Pull",
			Handler:       _ImageService_Pull_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Import",
			Handler:       _ImageService_Import_Handler,
			ClientStreams: true,
		},
	},
	Metadata: "machine/image.proto",
}
