/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta1

// IPBlockApplyConfiguration represents a declarative configuration of the IPBlock type for use
// with apply.
//
// DEPRECATED 1.9 - This group version of IPBlock is deprecated by networking/v1/IPBlock.
// IPBlock describes a particular CIDR (Ex. "192.168.1.0/24","2001:db8::/64") that is allowed
// to the pods matched by a NetworkPolicySpec's podSelector. The except entry describes CIDRs
// that should not be included within this rule.
type IPBlockApplyConfiguration struct {
	// CIDR is a string representing the IP Block
	// Valid examples are "192.168.1.0/24" or "2001:db8::/64"
	CIDR *string `json:"cidr,omitempty"`
	// Except is a slice of CIDRs that should not be included within an IP Block
	// Valid examples are "192.168.1.0/24" or "2001:db8::/64"
	// Except values will be rejected if they are outside the CIDR range
	Except []string `json:"except,omitempty"`
}

// IPBlockApplyConfiguration constructs a declarative configuration of the IPBlock type for use with
// apply.
func IPBlock() *IPBlockApplyConfiguration {
	return &IPBlockApplyConfiguration{}
}

// WithCIDR sets the CIDR field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the CIDR field is set to the value of the last call.
func (b *IPBlockApplyConfiguration) WithCIDR(value string) *IPBlockApplyConfiguration {
	b.CIDR = &value
	return b
}

// WithExcept adds the given value to the Except field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Except field.
func (b *IPBlockApplyConfiguration) WithExcept(values ...string) *IPBlockApplyConfiguration {
	for i := range values {
		b.Except = append(b.Except, values[i])
	}
	return b
}
