/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package v1alpha2

import (
	context "context"
	time "time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
	gatewayapiapisv1alpha2 "sigs.k8s.io/gateway-api/apis/v1alpha2"
	versioned "sigs.k8s.io/gateway-api/pkg/client/clientset/versioned"
	internalinterfaces "sigs.k8s.io/gateway-api/pkg/client/informers/externalversions/internalinterfaces"
	apisv1alpha2 "sigs.k8s.io/gateway-api/pkg/client/listers/apis/v1alpha2"
)

// TLSRouteInformer provides access to a shared informer and lister for
// TLSRoutes.
type TLSRouteInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() apisv1alpha2.TLSRouteLister
}

type tLSRouteInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewTLSRouteInformer constructs a new informer for TLSRoute type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewTLSRouteInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredTLSRouteInformer(client, namespace, resyncPeriod, indexers, nil)
}

// NewFilteredTLSRouteInformer constructs a new informer for TLSRoute type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredTLSRouteInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.GatewayV1alpha2().TLSRoutes(namespace).List(context.TODO(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.GatewayV1alpha2().TLSRoutes(namespace).Watch(context.TODO(), options)
			},
		},
		&gatewayapiapisv1alpha2.TLSRoute{},
		resyncPeriod,
		indexers,
	)
}

func (f *tLSRouteInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredTLSRouteInformer(client, f.namespace, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *tLSRouteInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&gatewayapiapisv1alpha2.TLSRoute{}, f.defaultInformer)
}

func (f *tLSRouteInformer) Lister() apisv1alpha2.TLSRouteLister {
	return apisv1alpha2.NewTLSRouteLister(f.Informer().GetIndexer())
}
