// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from property.h.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#pragma once

// clang-format off

#include <QDebug>


#include "../Color.h"
#include "CornerProperty.h"
#include "LineProperty.h"
#include "OffsetProperty.h"

#include "union_export.h"

// clang-format on

namespace Union
{
namespace Properties
{

class ShadowPropertyPrivate;

/*!
\class Union::Properties::ShadowProperty
\inmodule core
\ingroup core-properties

\brief A property group containing properties relating to an element's shadow.

*/
class UNION_EXPORT ShadowProperty
{
public:
    /*!
     * Default constructor. Constructs a null instance.
     *
     * A null instance in this case means an instance that does not have any
     * values for its properties. This includes property groups.
     */
    ShadowProperty();
    /*!
     * Copy constructor.
     */
    ShadowProperty(const ShadowProperty &other);
    /*!
     * Move constructor.
     */
    ShadowProperty(ShadowProperty &&other);
    ~ShadowProperty();

    /*!
     * Copy assignment operator.
     */
    ShadowProperty &operator=(const ShadowProperty &other);
    /*!
     * Move assignment operator.
     */
    ShadowProperty &operator=(ShadowProperty &&other);

    /*!
     * Returns the value of offset.
     */
    std::optional<OffsetProperty> offset() const;
    /*!
     * Returns offset if set or a new OffsetProperty if not.
     */
    OffsetProperty offset_or_new() const;
    /*!
     * Set the value of offset.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setOffset(const std::optional<OffsetProperty> &newValue);

    /*!
     * Returns the value of color.
     */
    std::optional<Union::Color> color() const;
    /*!
     * Set the value of color.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setColor(const std::optional<Union::Color> &newValue);

    /*!
     * Returns the value of size.
     */
    std::optional<qreal> size() const;
    /*!
     * Set the value of size.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setSize(const std::optional<qreal> &newValue);

    /*!
     * Returns the value of blur.
     */
    std::optional<qreal> blur() const;
    /*!
     * Set the value of blur.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setBlur(const std::optional<qreal> &newValue);

    /*!
     * Returns the value of left.
     */
    std::optional<LineProperty> left() const;
    /*!
     * Returns left if set or a new LineProperty if not.
     */
    LineProperty left_or_new() const;
    /*!
     * Set the value of left.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setLeft(const std::optional<LineProperty> &newValue);

    /*!
     * Returns the value of right.
     */
    std::optional<LineProperty> right() const;
    /*!
     * Returns right if set or a new LineProperty if not.
     */
    LineProperty right_or_new() const;
    /*!
     * Set the value of right.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setRight(const std::optional<LineProperty> &newValue);

    /*!
     * Returns the value of top.
     */
    std::optional<LineProperty> top() const;
    /*!
     * Returns top if set or a new LineProperty if not.
     */
    LineProperty top_or_new() const;
    /*!
     * Set the value of top.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setTop(const std::optional<LineProperty> &newValue);

    /*!
     * Returns the value of bottom.
     */
    std::optional<LineProperty> bottom() const;
    /*!
     * Returns bottom if set or a new LineProperty if not.
     */
    LineProperty bottom_or_new() const;
    /*!
     * Set the value of bottom.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setBottom(const std::optional<LineProperty> &newValue);

    /*!
     * Returns the value of topLeft.
     */
    std::optional<CornerProperty> topLeft() const;
    /*!
     * Returns topLeft if set or a new CornerProperty if not.
     */
    CornerProperty topLeft_or_new() const;
    /*!
     * Set the value of topLeft.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setTopLeft(const std::optional<CornerProperty> &newValue);

    /*!
     * Returns the value of topRight.
     */
    std::optional<CornerProperty> topRight() const;
    /*!
     * Returns topRight if set or a new CornerProperty if not.
     */
    CornerProperty topRight_or_new() const;
    /*!
     * Set the value of topRight.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setTopRight(const std::optional<CornerProperty> &newValue);

    /*!
     * Returns the value of bottomLeft.
     */
    std::optional<CornerProperty> bottomLeft() const;
    /*!
     * Returns bottomLeft if set or a new CornerProperty if not.
     */
    CornerProperty bottomLeft_or_new() const;
    /*!
     * Set the value of bottomLeft.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setBottomLeft(const std::optional<CornerProperty> &newValue);

    /*!
     * Returns the value of bottomRight.
     */
    std::optional<CornerProperty> bottomRight() const;
    /*!
     * Returns bottomRight if set or a new CornerProperty if not.
     */
    CornerProperty bottomRight_or_new() const;
    /*!
     * Set the value of bottomRight.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setBottomRight(const std::optional<CornerProperty> &newValue);

    /*!
     * Returns if this property group has any value set.
     *
     * Note that for any property that is also a property group, this will also
     * check if that group has any value.
     */
    bool hasAnyValue() const;

    /*!
     * Copy property values from source to destination if destination does not have a property value.
     *
     * This will recursively copy property values of grouped properties.
     *
     * \a source      The source property group to copy from.
     * \a destination The destination property group to copy to.
     */
    static void resolveProperties(const ShadowProperty &source, ShadowProperty &destination);

    /*!
     * Create and return an empty ShadowProperty instance.
     *
     * This will create an empty ShadowProperty instance, which is defined as
     * an instance with all of its values default-constructed. Note that this is
     * different from a default-constructed instance which will have all its
     * values unset.
     */
    static ShadowProperty empty();

private:
    std::unique_ptr<ShadowPropertyPrivate> d;
};

/*!
 * \relates Union::Properties::ShadowProperty
 * Equality comparison for ShadowProperty.
 */
UNION_EXPORT bool operator==(const ShadowProperty &left, const ShadowProperty &right);
}
}

/*!
 * \relates Union::Properties::ShadowProperty
 * QDebug support for ShadowProperty.
 */
UNION_EXPORT QDebug operator<<(QDebug debug, const Union::Properties::ShadowProperty &type);