// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from qml_group.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include "TextPropertyGroup.h"

#include <QQmlEngine>

#include "QuickStyle.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

TextPropertyGroup::TextPropertyGroup(QuickStyle *style)
    : QObject()
    , m_style(style)
{
    m_alignment = std::make_unique<AlignmentPropertyGroup>(m_style);
}

void TextPropertyGroup::update(TextProperty *newState)
{
    if (newState == m_state) {
        return;
    }

    m_state = newState;

    if (!newState) {
        m_alignment->update(nullptr);
    } else {
        m_alignment->update(newState->alignment());
    }

    Q_EMIT fontChanged();
    Q_EMIT colorChanged();
    Q_EMIT updated();
}

void TextPropertyGroup::refreshColors()
{
    m_alignment->refreshColors();
    Q_EMIT colorChanged();
}

AlignmentPropertyGroup *TextPropertyGroup::alignment() const
{
    return m_alignment.get();
}

QJSValue TextPropertyGroup::font() const
{
    if (!m_state) {
        return QJSValue(QJSValue::UndefinedValue);
    }

    auto value = m_state->font();
    if (value) {
        return m_style->engine()->toScriptValue(value.value());
    }

    return QJSValue(QJSValue::UndefinedValue);
}

QJSValue TextPropertyGroup::color() const
{
    if (!m_state) {
        return QJSValue(QJSValue::UndefinedValue);
    }

    auto value = m_state->color();
    if (value) {
        return m_style->engine()->toScriptValue(value.value().toQColor());
    }

    return QJSValue(QJSValue::UndefinedValue);
}

#include "moc_TextPropertyGroup.cpp"