//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/imaging/hd/renderProductSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdRenderProductSchemaTokens,
    HD_RENDER_PRODUCT_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

HdPathDataSourceHandle
HdRenderProductSchema::GetPath() const
{
    return _GetTypedDataSource<HdPathDataSource>(
        HdRenderProductSchemaTokens->path);
}

HdTokenDataSourceHandle
HdRenderProductSchema::GetType() const
{
    return _GetTypedDataSource<HdTokenDataSource>(
        HdRenderProductSchemaTokens->type);
}

HdTokenDataSourceHandle
HdRenderProductSchema::GetName() const
{
    return _GetTypedDataSource<HdTokenDataSource>(
        HdRenderProductSchemaTokens->name);
}

HdVec2iDataSourceHandle
HdRenderProductSchema::GetResolution() const
{
    return _GetTypedDataSource<HdVec2iDataSource>(
        HdRenderProductSchemaTokens->resolution);
}

HdRenderVarVectorSchema
HdRenderProductSchema::GetRenderVars() const
{
    return HdRenderVarVectorSchema(_GetTypedDataSource<HdVectorDataSource>(
        HdRenderProductSchemaTokens->renderVars));
}

HdPathDataSourceHandle
HdRenderProductSchema::GetCameraPrim() const
{
    return _GetTypedDataSource<HdPathDataSource>(
        HdRenderProductSchemaTokens->cameraPrim);
}

HdFloatDataSourceHandle
HdRenderProductSchema::GetPixelAspectRatio() const
{
    return _GetTypedDataSource<HdFloatDataSource>(
        HdRenderProductSchemaTokens->pixelAspectRatio);
}

HdTokenDataSourceHandle
HdRenderProductSchema::GetAspectRatioConformPolicy() const
{
    return _GetTypedDataSource<HdTokenDataSource>(
        HdRenderProductSchemaTokens->aspectRatioConformPolicy);
}

HdVec2fDataSourceHandle
HdRenderProductSchema::GetApertureSize() const
{
    return _GetTypedDataSource<HdVec2fDataSource>(
        HdRenderProductSchemaTokens->apertureSize);
}

HdVec4fDataSourceHandle
HdRenderProductSchema::GetDataWindowNDC() const
{
    return _GetTypedDataSource<HdVec4fDataSource>(
        HdRenderProductSchemaTokens->dataWindowNDC);
}

HdBoolDataSourceHandle
HdRenderProductSchema::GetDisableMotionBlur() const
{
    return _GetTypedDataSource<HdBoolDataSource>(
        HdRenderProductSchemaTokens->disableMotionBlur);
}

HdBoolDataSourceHandle
HdRenderProductSchema::GetDisableDepthOfField() const
{
    return _GetTypedDataSource<HdBoolDataSource>(
        HdRenderProductSchemaTokens->disableDepthOfField);
}

HdContainerDataSourceHandle
HdRenderProductSchema::GetNamespacedSettings() const
{
    return _GetTypedDataSource<HdContainerDataSource>(
        HdRenderProductSchemaTokens->namespacedSettings);
}

/*static*/
HdContainerDataSourceHandle
HdRenderProductSchema::BuildRetained(
        const HdPathDataSourceHandle &path,
        const HdTokenDataSourceHandle &type,
        const HdTokenDataSourceHandle &name,
        const HdVec2iDataSourceHandle &resolution,
        const HdVectorDataSourceHandle &renderVars,
        const HdPathDataSourceHandle &cameraPrim,
        const HdFloatDataSourceHandle &pixelAspectRatio,
        const HdTokenDataSourceHandle &aspectRatioConformPolicy,
        const HdVec2fDataSourceHandle &apertureSize,
        const HdVec4fDataSourceHandle &dataWindowNDC,
        const HdBoolDataSourceHandle &disableMotionBlur,
        const HdBoolDataSourceHandle &disableDepthOfField,
        const HdContainerDataSourceHandle &namespacedSettings
)
{
    TfToken _names[13];
    HdDataSourceBaseHandle _values[13];

    size_t _count = 0;

    if (path) {
        _names[_count] = HdRenderProductSchemaTokens->path;
        _values[_count++] = path;
    }

    if (type) {
        _names[_count] = HdRenderProductSchemaTokens->type;
        _values[_count++] = type;
    }

    if (name) {
        _names[_count] = HdRenderProductSchemaTokens->name;
        _values[_count++] = name;
    }

    if (resolution) {
        _names[_count] = HdRenderProductSchemaTokens->resolution;
        _values[_count++] = resolution;
    }

    if (renderVars) {
        _names[_count] = HdRenderProductSchemaTokens->renderVars;
        _values[_count++] = renderVars;
    }

    if (cameraPrim) {
        _names[_count] = HdRenderProductSchemaTokens->cameraPrim;
        _values[_count++] = cameraPrim;
    }

    if (pixelAspectRatio) {
        _names[_count] = HdRenderProductSchemaTokens->pixelAspectRatio;
        _values[_count++] = pixelAspectRatio;
    }

    if (aspectRatioConformPolicy) {
        _names[_count] = HdRenderProductSchemaTokens->aspectRatioConformPolicy;
        _values[_count++] = aspectRatioConformPolicy;
    }

    if (apertureSize) {
        _names[_count] = HdRenderProductSchemaTokens->apertureSize;
        _values[_count++] = apertureSize;
    }

    if (dataWindowNDC) {
        _names[_count] = HdRenderProductSchemaTokens->dataWindowNDC;
        _values[_count++] = dataWindowNDC;
    }

    if (disableMotionBlur) {
        _names[_count] = HdRenderProductSchemaTokens->disableMotionBlur;
        _values[_count++] = disableMotionBlur;
    }

    if (disableDepthOfField) {
        _names[_count] = HdRenderProductSchemaTokens->disableDepthOfField;
        _values[_count++] = disableDepthOfField;
    }

    if (namespacedSettings) {
        _names[_count] = HdRenderProductSchemaTokens->namespacedSettings;
        _values[_count++] = namespacedSettings;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

HdRenderProductSchema::Builder &
HdRenderProductSchema::Builder::SetPath(
    const HdPathDataSourceHandle &path)
{
    _path = path;
    return *this;
}

HdRenderProductSchema::Builder &
HdRenderProductSchema::Builder::SetType(
    const HdTokenDataSourceHandle &type)
{
    _type = type;
    return *this;
}

HdRenderProductSchema::Builder &
HdRenderProductSchema::Builder::SetName(
    const HdTokenDataSourceHandle &name)
{
    _name = name;
    return *this;
}

HdRenderProductSchema::Builder &
HdRenderProductSchema::Builder::SetResolution(
    const HdVec2iDataSourceHandle &resolution)
{
    _resolution = resolution;
    return *this;
}

HdRenderProductSchema::Builder &
HdRenderProductSchema::Builder::SetRenderVars(
    const HdVectorDataSourceHandle &renderVars)
{
    _renderVars = renderVars;
    return *this;
}

HdRenderProductSchema::Builder &
HdRenderProductSchema::Builder::SetCameraPrim(
    const HdPathDataSourceHandle &cameraPrim)
{
    _cameraPrim = cameraPrim;
    return *this;
}

HdRenderProductSchema::Builder &
HdRenderProductSchema::Builder::SetPixelAspectRatio(
    const HdFloatDataSourceHandle &pixelAspectRatio)
{
    _pixelAspectRatio = pixelAspectRatio;
    return *this;
}

HdRenderProductSchema::Builder &
HdRenderProductSchema::Builder::SetAspectRatioConformPolicy(
    const HdTokenDataSourceHandle &aspectRatioConformPolicy)
{
    _aspectRatioConformPolicy = aspectRatioConformPolicy;
    return *this;
}

HdRenderProductSchema::Builder &
HdRenderProductSchema::Builder::SetApertureSize(
    const HdVec2fDataSourceHandle &apertureSize)
{
    _apertureSize = apertureSize;
    return *this;
}

HdRenderProductSchema::Builder &
HdRenderProductSchema::Builder::SetDataWindowNDC(
    const HdVec4fDataSourceHandle &dataWindowNDC)
{
    _dataWindowNDC = dataWindowNDC;
    return *this;
}

HdRenderProductSchema::Builder &
HdRenderProductSchema::Builder::SetDisableMotionBlur(
    const HdBoolDataSourceHandle &disableMotionBlur)
{
    _disableMotionBlur = disableMotionBlur;
    return *this;
}

HdRenderProductSchema::Builder &
HdRenderProductSchema::Builder::SetDisableDepthOfField(
    const HdBoolDataSourceHandle &disableDepthOfField)
{
    _disableDepthOfField = disableDepthOfField;
    return *this;
}

HdRenderProductSchema::Builder &
HdRenderProductSchema::Builder::SetNamespacedSettings(
    const HdContainerDataSourceHandle &namespacedSettings)
{
    _namespacedSettings = namespacedSettings;
    return *this;
}

HdContainerDataSourceHandle
HdRenderProductSchema::Builder::Build()
{
    return HdRenderProductSchema::BuildRetained(
        _path,
        _type,
        _name,
        _resolution,
        _renderVars,
        _cameraPrim,
        _pixelAspectRatio,
        _aspectRatioConformPolicy,
        _apertureSize,
        _dataWindowNDC,
        _disableMotionBlur,
        _disableDepthOfField,
        _namespacedSettings
    );
}

/*static*/
HdRenderProductSchema
HdRenderProductSchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return HdRenderProductSchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                HdRenderProductSchemaTokens->renderProduct))
        : nullptr);
}

/*static*/
const TfToken &
HdRenderProductSchema::GetSchemaToken()
{
    return HdRenderProductSchemaTokens->renderProduct;
}

/*static*/
const HdDataSourceLocator &
HdRenderProductSchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator(GetSchemaToken());
    return locator;
}

/* static */
const HdDataSourceLocator &
HdRenderProductSchema::GetResolutionLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdRenderProductSchemaTokens->resolution);
    return locator;
}

/* static */
const HdDataSourceLocator &
HdRenderProductSchema::GetRenderVarsLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdRenderProductSchemaTokens->renderVars);
    return locator;
}

/* static */
const HdDataSourceLocator &
HdRenderProductSchema::GetNamespacedSettingsLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdRenderProductSchemaTokens->namespacedSettings);
    return locator;
} 

PXR_NAMESPACE_CLOSE_SCOPE