/** @file
 * VirtualBox API Enum Stringifier - Definition.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/stringify-enums.xsl
 */

/*
 * Copyright (C) 2022-2026 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */



/*********************************************************************************************************************************
*   Header Files                                                                                                                 *
*********************************************************************************************************************************/
#include "StringifyEnums.h"

#include "iprt/asm.h"
#include "iprt/assert.h"
#include "iprt/string.h"


/*********************************************************************************************************************************
*   Global Variables                                                                                                             *
*********************************************************************************************************************************/
typedef char UNKNOWNBUF[64];
static UNKNOWNBUF           s_aszUnknown[16];
static uint32_t volatile    s_iUnknown = 0;


static const char *formatUnknown(const char *pszName, int iValue)
{
    size_t iUnknown = ASMAtomicIncU32(&s_iUnknown) % RT_ELEMENTS(s_aszUnknown);
    char *pszBuf = s_aszUnknown[iUnknown];
    RTStrPrintf(pszBuf, sizeof(UNKNOWNBUF), "Unk-%s-%#x", pszName, iValue);
    return pszBuf;
}



const char *stringifySettingsVersion(SettingsVersion_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case SettingsVersion_Null:
            return "Null";
        case SettingsVersion_v1_0:
            return "v1_0";
        case SettingsVersion_v1_1:
            return "v1_1";
        case SettingsVersion_v1_2:
            return "v1_2";
        case SettingsVersion_v1_3pre:
            return "v1_3pre";
        case SettingsVersion_v1_3:
            return "v1_3";
        case SettingsVersion_v1_4:
            return "v1_4";
        case SettingsVersion_v1_5:
            return "v1_5";
        case SettingsVersion_v1_6:
            return "v1_6";
        case SettingsVersion_v1_7:
            return "v1_7";
        case SettingsVersion_v1_8:
            return "v1_8";
        case SettingsVersion_v1_9:
            return "v1_9";
        case SettingsVersion_v1_10:
            return "v1_10";
        case SettingsVersion_v1_11:
            return "v1_11";
        case SettingsVersion_v1_12:
            return "v1_12";
        case SettingsVersion_v1_13:
            return "v1_13";
        case SettingsVersion_v1_14:
            return "v1_14";
        case SettingsVersion_v1_15:
            return "v1_15";
        case SettingsVersion_v1_16:
            return "v1_16";
        case SettingsVersion_v1_17:
            return "v1_17";
        case SettingsVersion_v1_18:
            return "v1_18";
        case SettingsVersion_v1_19:
            return "v1_19";
        case SettingsVersion_v1_20:
            return "v1_20";
        case SettingsVersion_v1_21:
            return "v1_21";
        case SettingsVersion_Future:
            return "Future";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("SettingsVersion", (int)aValue));
    }
}


const char *stringifyAccessMode(AccessMode_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case AccessMode_ReadOnly:
            return "ReadOnly";
        case AccessMode_ReadWrite:
            return "ReadWrite";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("AccessMode", (int)aValue));
    }
}


const char *stringifyMachineState(MachineState_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case MachineState_Null:
            return "Null";
        case MachineState_PoweredOff:
            return "PoweredOff";
        case MachineState_Saved:
            return "Saved";
        case MachineState_Teleported:
            return "Teleported";
        case MachineState_Aborted:
            return "Aborted";
        case MachineState_AbortedSaved:
            return "AbortedSaved";
        case MachineState_Running:
            return "Running";
        case MachineState_Paused:
            return "Paused";
        case MachineState_Stuck:
            return "Stuck";
        case MachineState_Teleporting:
            return "Teleporting";
        case MachineState_LiveSnapshotting:
            return "LiveSnapshotting";
        case MachineState_Starting:
            return "Starting";
        case MachineState_Stopping:
            return "Stopping";
        case MachineState_Saving:
            return "Saving";
        case MachineState_Restoring:
            return "Restoring";
        case MachineState_TeleportingPausedVM:
            return "TeleportingPausedVM";
        case MachineState_TeleportingIn:
            return "TeleportingIn";
        case MachineState_DeletingSnapshotOnline:
            return "DeletingSnapshotOnline";
        case MachineState_DeletingSnapshotPaused:
            return "DeletingSnapshotPaused";
        case MachineState_OnlineSnapshotting:
            return "OnlineSnapshotting";
        case MachineState_RestoringSnapshot:
            return "RestoringSnapshot";
        case MachineState_DeletingSnapshot:
            return "DeletingSnapshot";
        case MachineState_SettingUp:
            return "SettingUp";
        case MachineState_Snapshotting:
            return "Snapshotting";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("MachineState", (int)aValue));
    }
}


const char *stringifySessionState(SessionState_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case SessionState_Null:
            return "Null";
        case SessionState_Unlocked:
            return "Unlocked";
        case SessionState_Locked:
            return "Locked";
        case SessionState_Spawning:
            return "Spawning";
        case SessionState_Unlocking:
            return "Unlocking";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("SessionState", (int)aValue));
    }
}


const char *stringifyPlatformArchitecture(PlatformArchitecture_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case PlatformArchitecture_None:
            return "None";
        case PlatformArchitecture_x86:
            return "x86";
        case PlatformArchitecture_ARM:
            return "ARM";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("PlatformArchitecture", (int)aValue));
    }
}


const char *stringifyCPUArchitecture(CPUArchitecture_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case CPUArchitecture_Any:
            return "Any";
        case CPUArchitecture_x86:
            return "x86";
        case CPUArchitecture_AMD64:
            return "AMD64";
        case CPUArchitecture_ARMv8_32:
            return "ARMv8_32";
        case CPUArchitecture_ARMv8_64:
            return "ARMv8_64";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("CPUArchitecture", (int)aValue));
    }
}


const char *stringifyCPUPropertyTypeX86(CPUPropertyTypeX86_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case CPUPropertyTypeX86_Null:
            return "Null";
        case CPUPropertyTypeX86_PAE:
            return "PAE";
        case CPUPropertyTypeX86_LongMode:
            return "LongMode";
        case CPUPropertyTypeX86_TripleFaultReset:
            return "TripleFaultReset";
        case CPUPropertyTypeX86_APIC:
            return "APIC";
        case CPUPropertyTypeX86_X2APIC:
            return "X2APIC";
        case CPUPropertyTypeX86_IBPBOnVMExit:
            return "IBPBOnVMExit";
        case CPUPropertyTypeX86_IBPBOnVMEntry:
            return "IBPBOnVMEntry";
        case CPUPropertyTypeX86_HWVirt:
            return "HWVirt";
        case CPUPropertyTypeX86_SpecCtrl:
            return "SpecCtrl";
        case CPUPropertyTypeX86_SpecCtrlByHost:
            return "SpecCtrlByHost";
        case CPUPropertyTypeX86_L1DFlushOnEMTScheduling:
            return "L1DFlushOnEMTScheduling";
        case CPUPropertyTypeX86_L1DFlushOnVMEntry:
            return "L1DFlushOnVMEntry";
        case CPUPropertyTypeX86_MDSClearOnEMTScheduling:
            return "MDSClearOnEMTScheduling";
        case CPUPropertyTypeX86_MDSClearOnVMEntry:
            return "MDSClearOnVMEntry";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("CPUPropertyTypeX86", (int)aValue));
    }
}


const char *stringifyCPUPropertyTypeARM(CPUPropertyTypeARM_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case CPUPropertyTypeARM_Null:
            return "Null";
        case CPUPropertyTypeARM_HWVirt:
            return "HWVirt";
        case CPUPropertyTypeARM_GICITS:
            return "GICITS";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("CPUPropertyTypeARM", (int)aValue));
    }
}


const char *stringifyHWVirtExPropertyType(HWVirtExPropertyType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case HWVirtExPropertyType_Null:
            return "Null";
        case HWVirtExPropertyType_Enabled:
            return "Enabled";
        case HWVirtExPropertyType_VPID:
            return "VPID";
        case HWVirtExPropertyType_NestedPaging:
            return "NestedPaging";
        case HWVirtExPropertyType_UnrestrictedExecution:
            return "UnrestrictedExecution";
        case HWVirtExPropertyType_LargePages:
            return "LargePages";
        case HWVirtExPropertyType_Force:
            return "Force";
        case HWVirtExPropertyType_UseNativeApi:
            return "UseNativeApi";
        case HWVirtExPropertyType_VirtVmsaveVmload:
            return "VirtVmsaveVmload";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("HWVirtExPropertyType", (int)aValue));
    }
}


const char *stringifyParavirtProvider(ParavirtProvider_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case ParavirtProvider_None:
            return "None";
        case ParavirtProvider_Default:
            return "Default";
        case ParavirtProvider_Legacy:
            return "Legacy";
        case ParavirtProvider_Minimal:
            return "Minimal";
        case ParavirtProvider_HyperV:
            return "HyperV";
        case ParavirtProvider_KVM:
            return "KVM";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("ParavirtProvider", (int)aValue));
    }
}


const char *stringifyLockType(LockType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case LockType_Null:
            return "Null";
        case LockType_Shared:
            return "Shared";
        case LockType_Write:
            return "Write";
        case LockType_VM:
            return "VM";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("LockType", (int)aValue));
    }
}


const char *stringifySessionType(SessionType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case SessionType_Null:
            return "Null";
        case SessionType_WriteLock:
            return "WriteLock";
        case SessionType_Remote:
            return "Remote";
        case SessionType_Shared:
            return "Shared";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("SessionType", (int)aValue));
    }
}


const char *stringifyDeviceType(DeviceType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case DeviceType_Null:
            return "Null";
        case DeviceType_Floppy:
            return "Floppy";
        case DeviceType_DVD:
            return "DVD";
        case DeviceType_HardDisk:
            return "HardDisk";
        case DeviceType_Network:
            return "Network";
        case DeviceType_USB:
            return "USB";
        case DeviceType_SharedFolder:
            return "SharedFolder";
        case DeviceType_Graphics3D:
            return "Graphics3D";
        case DeviceType_End:
            return "End";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("DeviceType", (int)aValue));
    }
}


const char *stringifyDeviceActivity(DeviceActivity_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case DeviceActivity_Null:
            return "Null";
        case DeviceActivity_Idle:
            return "Idle";
        case DeviceActivity_Reading:
            return "Reading";
        case DeviceActivity_Writing:
            return "Writing";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("DeviceActivity", (int)aValue));
    }
}


const char *stringifyClipboardMode(ClipboardMode_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case ClipboardMode_Disabled:
            return "Disabled";
        case ClipboardMode_HostToGuest:
            return "HostToGuest";
        case ClipboardMode_GuestToHost:
            return "GuestToHost";
        case ClipboardMode_Bidirectional:
            return "Bidirectional";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("ClipboardMode", (int)aValue));
    }
}


const char *stringifyDnDMode(DnDMode_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case DnDMode_Disabled:
            return "Disabled";
        case DnDMode_HostToGuest:
            return "HostToGuest";
        case DnDMode_GuestToHost:
            return "GuestToHost";
        case DnDMode_Bidirectional:
            return "Bidirectional";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("DnDMode", (int)aValue));
    }
}


const char *stringifyScope(Scope_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case Scope_Global:
            return "Global";
        case Scope_Machine:
            return "Machine";
        case Scope_Session:
            return "Session";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("Scope", (int)aValue));
    }
}


const char *stringifyFirmwareBootMenuMode(FirmwareBootMenuMode_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case FirmwareBootMenuMode_Disabled:
            return "Disabled";
        case FirmwareBootMenuMode_MenuOnly:
            return "MenuOnly";
        case FirmwareBootMenuMode_MessageAndMenu:
            return "MessageAndMenu";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("FirmwareBootMenuMode", (int)aValue));
    }
}


const char *stringifyAPICMode(APICMode_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case APICMode_Disabled:
            return "Disabled";
        case APICMode_APIC:
            return "APIC";
        case APICMode_X2APIC:
            return "X2APIC";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("APICMode", (int)aValue));
    }
}


const char *stringifyProcessorFeature(ProcessorFeature_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case ProcessorFeature_HWVirtEx:
            return "HWVirtEx";
        case ProcessorFeature_PAE:
            return "PAE";
        case ProcessorFeature_LongMode:
            return "LongMode";
        case ProcessorFeature_NestedPaging:
            return "NestedPaging";
        case ProcessorFeature_UnrestrictedGuest:
            return "UnrestrictedGuest";
        case ProcessorFeature_NestedHWVirt:
            return "NestedHWVirt";
        case ProcessorFeature_VirtVmsaveVmload:
            return "VirtVmsaveVmload";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("ProcessorFeature", (int)aValue));
    }
}


const char *stringifyFirmwareType(FirmwareType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case FirmwareType_BIOS:
            return "BIOS";
        case FirmwareType_EFI:
            return "EFI";
        case FirmwareType_EFI32:
            return "EFI32";
        case FirmwareType_EFI64:
            return "EFI64";
        case FirmwareType_EFIDUAL:
            return "EFIDUAL";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("FirmwareType", (int)aValue));
    }
}


const char *stringifyPointingHIDType(PointingHIDType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case PointingHIDType_None:
            return "None";
        case PointingHIDType_PS2Mouse:
            return "PS2Mouse";
        case PointingHIDType_USBMouse:
            return "USBMouse";
        case PointingHIDType_USBTablet:
            return "USBTablet";
        case PointingHIDType_ComboMouse:
            return "ComboMouse";
        case PointingHIDType_USBMultiTouch:
            return "USBMultiTouch";
        case PointingHIDType_USBMultiTouchScreenPlusPad:
            return "USBMultiTouchScreenPlusPad";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("PointingHIDType", (int)aValue));
    }
}


const char *stringifyKeyboardHIDType(KeyboardHIDType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case KeyboardHIDType_None:
            return "None";
        case KeyboardHIDType_PS2Keyboard:
            return "PS2Keyboard";
        case KeyboardHIDType_USBKeyboard:
            return "USBKeyboard";
        case KeyboardHIDType_ComboKeyboard:
            return "ComboKeyboard";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("KeyboardHIDType", (int)aValue));
    }
}


const char *stringifyBitmapFormat(BitmapFormat_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case BitmapFormat_Opaque:
            return "Opaque";
        case BitmapFormat_BGR:
            return "BGR";
        case BitmapFormat_BGR0:
            return "BGR0";
        case BitmapFormat_BGRA:
            return "BGRA";
        case BitmapFormat_RGBA:
            return "RGBA";
        case BitmapFormat_PNG:
            return "PNG";
        case BitmapFormat_JPEG:
            return "JPEG";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("BitmapFormat", (int)aValue));
    }
}


const char *stringifyPartitioningType(PartitioningType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case PartitioningType_MBR:
            return "MBR";
        case PartitioningType_GPT:
            return "GPT";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("PartitioningType", (int)aValue));
    }
}


const char *stringifyPartitionType(PartitionType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case PartitionType_Empty:
            return "Empty";
        case PartitionType_FAT12:
            return "FAT12";
        case PartitionType_FAT16:
            return "FAT16";
        case PartitionType_FAT:
            return "FAT";
        case PartitionType_IFS:
            return "IFS";
        case PartitionType_FAT32CHS:
            return "FAT32CHS";
        case PartitionType_FAT32LBA:
            return "FAT32LBA";
        case PartitionType_FAT16B:
            return "FAT16B";
        case PartitionType_Extended:
            return "Extended";
        case PartitionType_WindowsRE:
            return "WindowsRE";
        case PartitionType_LinuxSwapOld:
            return "LinuxSwapOld";
        case PartitionType_LinuxOld:
            return "LinuxOld";
        case PartitionType_DragonFlyBSDSlice:
            return "DragonFlyBSDSlice";
        case PartitionType_LinuxSwap:
            return "LinuxSwap";
        case PartitionType_Linux:
            return "Linux";
        case PartitionType_LinuxExtended:
            return "LinuxExtended";
        case PartitionType_LinuxLVM:
            return "LinuxLVM";
        case PartitionType_BSDSlice:
            return "BSDSlice";
        case PartitionType_AppleUFS:
            return "AppleUFS";
        case PartitionType_AppleHFS:
            return "AppleHFS";
        case PartitionType_Solaris:
            return "Solaris";
        case PartitionType_GPT:
            return "GPT";
        case PartitionType_EFI:
            return "EFI";
        case PartitionType_Unknown:
            return "Unknown";
        case PartitionType_MBR:
            return "MBR";
        case PartitionType_iFFS:
            return "iFFS";
        case PartitionType_SonyBoot:
            return "SonyBoot";
        case PartitionType_LenovoBoot:
            return "LenovoBoot";
        case PartitionType_WindowsMSR:
            return "WindowsMSR";
        case PartitionType_WindowsBasicData:
            return "WindowsBasicData";
        case PartitionType_WindowsLDMMeta:
            return "WindowsLDMMeta";
        case PartitionType_WindowsLDMData:
            return "WindowsLDMData";
        case PartitionType_WindowsRecovery:
            return "WindowsRecovery";
        case PartitionType_WindowsStorageSpaces:
            return "WindowsStorageSpaces";
        case PartitionType_WindowsStorageReplica:
            return "WindowsStorageReplica";
        case PartitionType_IBMGPFS:
            return "IBMGPFS";
        case PartitionType_LinuxData:
            return "LinuxData";
        case PartitionType_LinuxRAID:
            return "LinuxRAID";
        case PartitionType_LinuxRootX86:
            return "LinuxRootX86";
        case PartitionType_LinuxRootAMD64:
            return "LinuxRootAMD64";
        case PartitionType_LinuxRootARM32:
            return "LinuxRootARM32";
        case PartitionType_LinuxRootARM64:
            return "LinuxRootARM64";
        case PartitionType_LinuxHome:
            return "LinuxHome";
        case PartitionType_LinuxSrv:
            return "LinuxSrv";
        case PartitionType_LinuxPlainDmCrypt:
            return "LinuxPlainDmCrypt";
        case PartitionType_LinuxLUKS:
            return "LinuxLUKS";
        case PartitionType_LinuxReserved:
            return "LinuxReserved";
        case PartitionType_FreeBSDBoot:
            return "FreeBSDBoot";
        case PartitionType_FreeBSDData:
            return "FreeBSDData";
        case PartitionType_FreeBSDSwap:
            return "FreeBSDSwap";
        case PartitionType_FreeBSDUFS:
            return "FreeBSDUFS";
        case PartitionType_FreeBSDVinum:
            return "FreeBSDVinum";
        case PartitionType_FreeBSDZFS:
            return "FreeBSDZFS";
        case PartitionType_FreeBSDUnknown:
            return "FreeBSDUnknown";
        case PartitionType_AppleHFSPlus:
            return "AppleHFSPlus";
        case PartitionType_AppleAPFS:
            return "AppleAPFS";
        case PartitionType_AppleRAID:
            return "AppleRAID";
        case PartitionType_AppleRAIDOffline:
            return "AppleRAIDOffline";
        case PartitionType_AppleBoot:
            return "AppleBoot";
        case PartitionType_AppleLabel:
            return "AppleLabel";
        case PartitionType_AppleTvRecovery:
            return "AppleTvRecovery";
        case PartitionType_AppleCoreStorage:
            return "AppleCoreStorage";
        case PartitionType_SoftRAIDStatus:
            return "SoftRAIDStatus";
        case PartitionType_SoftRAIDScratch:
            return "SoftRAIDScratch";
        case PartitionType_SoftRAIDVolume:
            return "SoftRAIDVolume";
        case PartitionType_SoftRAIDCache:
            return "SoftRAIDCache";
        case PartitionType_AppleUnknown:
            return "AppleUnknown";
        case PartitionType_SolarisBoot:
            return "SolarisBoot";
        case PartitionType_SolarisRoot:
            return "SolarisRoot";
        case PartitionType_SolarisSwap:
            return "SolarisSwap";
        case PartitionType_SolarisBackup:
            return "SolarisBackup";
        case PartitionType_SolarisUsr:
            return "SolarisUsr";
        case PartitionType_SolarisVar:
            return "SolarisVar";
        case PartitionType_SolarisHome:
            return "SolarisHome";
        case PartitionType_SolarisAltSector:
            return "SolarisAltSector";
        case PartitionType_SolarisReserved:
            return "SolarisReserved";
        case PartitionType_SolarisUnknown:
            return "SolarisUnknown";
        case PartitionType_NetBSDSwap:
            return "NetBSDSwap";
        case PartitionType_NetBSDFFS:
            return "NetBSDFFS";
        case PartitionType_NetBSDLFS:
            return "NetBSDLFS";
        case PartitionType_NetBSDRAID:
            return "NetBSDRAID";
        case PartitionType_NetBSDConcatenated:
            return "NetBSDConcatenated";
        case PartitionType_NetBSDEncrypted:
            return "NetBSDEncrypted";
        case PartitionType_NetBSDUnknown:
            return "NetBSDUnknown";
        case PartitionType_ChromeOSKernel:
            return "ChromeOSKernel";
        case PartitionType_ChromeOSRootFS:
            return "ChromeOSRootFS";
        case PartitionType_ChromeOSFuture:
            return "ChromeOSFuture";
        case PartitionType_ContLnxUsr:
            return "ContLnxUsr";
        case PartitionType_ContLnxRoot:
            return "ContLnxRoot";
        case PartitionType_ContLnxReserved:
            return "ContLnxReserved";
        case PartitionType_ContLnxRootRAID:
            return "ContLnxRootRAID";
        case PartitionType_HaikuBFS:
            return "HaikuBFS";
        case PartitionType_MidntBSDBoot:
            return "MidntBSDBoot";
        case PartitionType_MidntBSDData:
            return "MidntBSDData";
        case PartitionType_MidntBSDSwap:
            return "MidntBSDSwap";
        case PartitionType_MidntBSDUFS:
            return "MidntBSDUFS";
        case PartitionType_MidntBSDVium:
            return "MidntBSDVium";
        case PartitionType_MidntBSDZFS:
            return "MidntBSDZFS";
        case PartitionType_MidntBSDUnknown:
            return "MidntBSDUnknown";
        case PartitionType_OpenBSDData:
            return "OpenBSDData";
        case PartitionType_QNXPowerSafeFS:
            return "QNXPowerSafeFS";
        case PartitionType_Plan9:
            return "Plan9";
        case PartitionType_VMWareVMKCore:
            return "VMWareVMKCore";
        case PartitionType_VMWareVMFS:
            return "VMWareVMFS";
        case PartitionType_VMWareReserved:
            return "VMWareReserved";
        case PartitionType_VMWareUnknown:
            return "VMWareUnknown";
        case PartitionType_AndroidX86Bootloader:
            return "AndroidX86Bootloader";
        case PartitionType_AndroidX86Bootloader2:
            return "AndroidX86Bootloader2";
        case PartitionType_AndroidX86Boot:
            return "AndroidX86Boot";
        case PartitionType_AndroidX86Recovery:
            return "AndroidX86Recovery";
        case PartitionType_AndroidX86Misc:
            return "AndroidX86Misc";
        case PartitionType_AndroidX86Metadata:
            return "AndroidX86Metadata";
        case PartitionType_AndroidX86System:
            return "AndroidX86System";
        case PartitionType_AndroidX86Cache:
            return "AndroidX86Cache";
        case PartitionType_AndroidX86Data:
            return "AndroidX86Data";
        case PartitionType_AndroidX86Persistent:
            return "AndroidX86Persistent";
        case PartitionType_AndroidX86Vendor:
            return "AndroidX86Vendor";
        case PartitionType_AndroidX86Config:
            return "AndroidX86Config";
        case PartitionType_AndroidX86Factory:
            return "AndroidX86Factory";
        case PartitionType_AndroidX86FactoryAlt:
            return "AndroidX86FactoryAlt";
        case PartitionType_AndroidX86Fastboot:
            return "AndroidX86Fastboot";
        case PartitionType_AndroidX86OEM:
            return "AndroidX86OEM";
        case PartitionType_AndroidARMMeta:
            return "AndroidARMMeta";
        case PartitionType_AndroidARMExt:
            return "AndroidARMExt";
        case PartitionType_ONIEBoot:
            return "ONIEBoot";
        case PartitionType_ONIEConfig:
            return "ONIEConfig";
        case PartitionType_PowerPCPrep:
            return "PowerPCPrep";
        case PartitionType_XDGShrBootConfig:
            return "XDGShrBootConfig";
        case PartitionType_CephBlock:
            return "CephBlock";
        case PartitionType_CephBlockDB:
            return "CephBlockDB";
        case PartitionType_CephBlockDBDmc:
            return "CephBlockDBDmc";
        case PartitionType_CephBlockDBDmcLUKS:
            return "CephBlockDBDmcLUKS";
        case PartitionType_CephBlockDmc:
            return "CephBlockDmc";
        case PartitionType_CephBlockDmcLUKS:
            return "CephBlockDmcLUKS";
        case PartitionType_CephBlockWALog:
            return "CephBlockWALog";
        case PartitionType_CephBlockWALogDmc:
            return "CephBlockWALogDmc";
        case PartitionType_CephBlockWALogDmcLUKS:
            return "CephBlockWALogDmcLUKS";
        case PartitionType_CephDisk:
            return "CephDisk";
        case PartitionType_CephDiskDmc:
            return "CephDiskDmc";
        case PartitionType_CephJournal:
            return "CephJournal";
        case PartitionType_CephJournalDmc:
            return "CephJournalDmc";
        case PartitionType_CephJournalDmcLUKS:
            return "CephJournalDmcLUKS";
        case PartitionType_CephLockbox:
            return "CephLockbox";
        case PartitionType_CephMultipathBlock1:
            return "CephMultipathBlock1";
        case PartitionType_CephMultipathBlock2:
            return "CephMultipathBlock2";
        case PartitionType_CephMultipathBlockDB:
            return "CephMultipathBlockDB";
        case PartitionType_CephMultipathBLockWALog:
            return "CephMultipathBLockWALog";
        case PartitionType_CephMultipathJournal:
            return "CephMultipathJournal";
        case PartitionType_CephMultipathOSD:
            return "CephMultipathOSD";
        case PartitionType_CephOSD:
            return "CephOSD";
        case PartitionType_CephOSDDmc:
            return "CephOSDDmc";
        case PartitionType_CephOSDDmcLUKS:
            return "CephOSDDmcLUKS";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("PartitionType", (int)aValue));
    }
}


const char *stringifyTrackedObjectState(TrackedObjectState_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case TrackedObjectState_None:
            return "None";
        case TrackedObjectState_Alive:
            return "Alive";
        case TrackedObjectState_Deleted:
            return "Deleted";
        case TrackedObjectState_Invalid:
            return "Invalid";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("TrackedObjectState", (int)aValue));
    }
}


const char *stringifyDHCPOption(DHCPOption_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case DHCPOption_SubnetMask:
            return "SubnetMask";
        case DHCPOption_TimeOffset:
            return "TimeOffset";
        case DHCPOption_Routers:
            return "Routers";
        case DHCPOption_TimeServers:
            return "TimeServers";
        case DHCPOption_NameServers:
            return "NameServers";
        case DHCPOption_DomainNameServers:
            return "DomainNameServers";
        case DHCPOption_LogServers:
            return "LogServers";
        case DHCPOption_CookieServers:
            return "CookieServers";
        case DHCPOption_LPRServers:
            return "LPRServers";
        case DHCPOption_ImpressServers:
            return "ImpressServers";
        case DHCPOption_ResourseLocationServers:
            return "ResourseLocationServers";
        case DHCPOption_HostName:
            return "HostName";
        case DHCPOption_BootFileSize:
            return "BootFileSize";
        case DHCPOption_MeritDumpFile:
            return "MeritDumpFile";
        case DHCPOption_DomainName:
            return "DomainName";
        case DHCPOption_SwapServer:
            return "SwapServer";
        case DHCPOption_RootPath:
            return "RootPath";
        case DHCPOption_ExtensionPath:
            return "ExtensionPath";
        case DHCPOption_IPForwarding:
            return "IPForwarding";
        case DHCPOption_OptNonLocalSourceRouting:
            return "OptNonLocalSourceRouting";
        case DHCPOption_PolicyFilter:
            return "PolicyFilter";
        case DHCPOption_MaxDgramReassemblySize:
            return "MaxDgramReassemblySize";
        case DHCPOption_DefaultIPTTL:
            return "DefaultIPTTL";
        case DHCPOption_PathMTUAgingTimeout:
            return "PathMTUAgingTimeout";
        case DHCPOption_PathMTUPlateauTable:
            return "PathMTUPlateauTable";
        case DHCPOption_InterfaceMTU:
            return "InterfaceMTU";
        case DHCPOption_AllSubnetsAreLocal:
            return "AllSubnetsAreLocal";
        case DHCPOption_BroadcastAddress:
            return "BroadcastAddress";
        case DHCPOption_PerformMaskDiscovery:
            return "PerformMaskDiscovery";
        case DHCPOption_MaskSupplier:
            return "MaskSupplier";
        case DHCPOption_PerformRouterDiscovery:
            return "PerformRouterDiscovery";
        case DHCPOption_RouterSolicitationAddress:
            return "RouterSolicitationAddress";
        case DHCPOption_StaticRoute:
            return "StaticRoute";
        case DHCPOption_TrailerEncapsulation:
            return "TrailerEncapsulation";
        case DHCPOption_ARPCacheTimeout:
            return "ARPCacheTimeout";
        case DHCPOption_EthernetEncapsulation:
            return "EthernetEncapsulation";
        case DHCPOption_TCPDefaultTTL:
            return "TCPDefaultTTL";
        case DHCPOption_TCPKeepaliveInterval:
            return "TCPKeepaliveInterval";
        case DHCPOption_TCPKeepaliveGarbage:
            return "TCPKeepaliveGarbage";
        case DHCPOption_NISDomain:
            return "NISDomain";
        case DHCPOption_NISServers:
            return "NISServers";
        case DHCPOption_NTPServers:
            return "NTPServers";
        case DHCPOption_VendorSpecificInfo:
            return "VendorSpecificInfo";
        case DHCPOption_NetBIOSNameServers:
            return "NetBIOSNameServers";
        case DHCPOption_NetBIOSDatagramServers:
            return "NetBIOSDatagramServers";
        case DHCPOption_NetBIOSNodeType:
            return "NetBIOSNodeType";
        case DHCPOption_NetBIOSScope:
            return "NetBIOSScope";
        case DHCPOption_XWindowsFontServers:
            return "XWindowsFontServers";
        case DHCPOption_XWindowsDisplayManager:
            return "XWindowsDisplayManager";
        case DHCPOption_NetWareIPDomainName:
            return "NetWareIPDomainName";
        case DHCPOption_NetWareIPInformation:
            return "NetWareIPInformation";
        case DHCPOption_NISPlusDomain:
            return "NISPlusDomain";
        case DHCPOption_NISPlusServers:
            return "NISPlusServers";
        case DHCPOption_TFTPServerName:
            return "TFTPServerName";
        case DHCPOption_BootfileName:
            return "BootfileName";
        case DHCPOption_MobileIPHomeAgents:
            return "MobileIPHomeAgents";
        case DHCPOption_SMTPServers:
            return "SMTPServers";
        case DHCPOption_POP3Servers:
            return "POP3Servers";
        case DHCPOption_NNTPServers:
            return "NNTPServers";
        case DHCPOption_WWWServers:
            return "WWWServers";
        case DHCPOption_FingerServers:
            return "FingerServers";
        case DHCPOption_IRCServers:
            return "IRCServers";
        case DHCPOption_StreetTalkServers:
            return "StreetTalkServers";
        case DHCPOption_STDAServers:
            return "STDAServers";
        case DHCPOption_SLPDirectoryAgent:
            return "SLPDirectoryAgent";
        case DHCPOption_SLPServiceScope:
            return "SLPServiceScope";
        case DHCPOption_DomainSearch:
            return "DomainSearch";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("DHCPOption", (int)aValue));
    }
}


const char *stringifyDHCPOptionEncoding(DHCPOptionEncoding_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case DHCPOptionEncoding_Normal:
            return "Normal";
        case DHCPOptionEncoding_Hex:
            return "Hex";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("DHCPOptionEncoding", (int)aValue));
    }
}


const char *stringifyDHCPConfigScope(DHCPConfigScope_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case DHCPConfigScope_Global:
            return "Global";
        case DHCPConfigScope_Group:
            return "Group";
        case DHCPConfigScope_MachineNIC:
            return "MachineNIC";
        case DHCPConfigScope_MAC:
            return "MAC";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("DHCPConfigScope", (int)aValue));
    }
}


const char *stringifyDHCPGroupConditionType(DHCPGroupConditionType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case DHCPGroupConditionType_MAC:
            return "MAC";
        case DHCPGroupConditionType_MACWildcard:
            return "MACWildcard";
        case DHCPGroupConditionType_vendorClassID:
            return "vendorClassID";
        case DHCPGroupConditionType_vendorClassIDWildcard:
            return "vendorClassIDWildcard";
        case DHCPGroupConditionType_userClassID:
            return "userClassID";
        case DHCPGroupConditionType_userClassIDWildcard:
            return "userClassIDWildcard";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("DHCPGroupConditionType", (int)aValue));
    }
}


const char *stringifyVFSType(VFSType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case VFSType_File:
            return "File";
        case VFSType_Cloud:
            return "Cloud";
        case VFSType_S3:
            return "S3";
        case VFSType_WebDav:
            return "WebDav";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("VFSType", (int)aValue));
    }
}


const char *stringifyImportOptions(ImportOptions_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case ImportOptions_KeepAllMACs:
            return "KeepAllMACs";
        case ImportOptions_KeepNATMACs:
            return "KeepNATMACs";
        case ImportOptions_ImportToVDI:
            return "ImportToVDI";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("ImportOptions", (int)aValue));
    }
}


const char *stringifyExportOptions(ExportOptions_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case ExportOptions_CreateManifest:
            return "CreateManifest";
        case ExportOptions_ExportDVDImages:
            return "ExportDVDImages";
        case ExportOptions_StripAllMACs:
            return "StripAllMACs";
        case ExportOptions_StripAllNonNATMACs:
            return "StripAllNonNATMACs";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("ExportOptions", (int)aValue));
    }
}


const char *stringifyCertificateVersion(CertificateVersion_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case CertificateVersion_V1:
            return "V1";
        case CertificateVersion_V2:
            return "V2";
        case CertificateVersion_V3:
            return "V3";
        case CertificateVersion_Unknown:
            return "Unknown";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("CertificateVersion", (int)aValue));
    }
}


const char *stringifyVirtualSystemDescriptionType(VirtualSystemDescriptionType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case VirtualSystemDescriptionType_Ignore:
            return "Ignore";
        case VirtualSystemDescriptionType_OS:
            return "OS";
        case VirtualSystemDescriptionType_Name:
            return "Name";
        case VirtualSystemDescriptionType_Product:
            return "Product";
        case VirtualSystemDescriptionType_Vendor:
            return "Vendor";
        case VirtualSystemDescriptionType_Version:
            return "Version";
        case VirtualSystemDescriptionType_ProductUrl:
            return "ProductUrl";
        case VirtualSystemDescriptionType_VendorUrl:
            return "VendorUrl";
        case VirtualSystemDescriptionType_Description:
            return "Description";
        case VirtualSystemDescriptionType_License:
            return "License";
        case VirtualSystemDescriptionType_Miscellaneous:
            return "Miscellaneous";
        case VirtualSystemDescriptionType_CPU:
            return "CPU";
        case VirtualSystemDescriptionType_Memory:
            return "Memory";
        case VirtualSystemDescriptionType_HardDiskControllerIDE:
            return "HardDiskControllerIDE";
        case VirtualSystemDescriptionType_HardDiskControllerSATA:
            return "HardDiskControllerSATA";
        case VirtualSystemDescriptionType_HardDiskControllerSCSI:
            return "HardDiskControllerSCSI";
        case VirtualSystemDescriptionType_HardDiskControllerSAS:
            return "HardDiskControllerSAS";
        case VirtualSystemDescriptionType_HardDiskImage:
            return "HardDiskImage";
        case VirtualSystemDescriptionType_Floppy:
            return "Floppy";
        case VirtualSystemDescriptionType_CDROM:
            return "CDROM";
        case VirtualSystemDescriptionType_NetworkAdapter:
            return "NetworkAdapter";
        case VirtualSystemDescriptionType_USBController:
            return "USBController";
        case VirtualSystemDescriptionType_SoundCard:
            return "SoundCard";
        case VirtualSystemDescriptionType_SettingsFile:
            return "SettingsFile";
        case VirtualSystemDescriptionType_BaseFolder:
            return "BaseFolder";
        case VirtualSystemDescriptionType_PrimaryGroup:
            return "PrimaryGroup";
        case VirtualSystemDescriptionType_CloudInstanceShape:
            return "CloudInstanceShape";
        case VirtualSystemDescriptionType_CloudDomain:
            return "CloudDomain";
        case VirtualSystemDescriptionType_CloudBootDiskSize:
            return "CloudBootDiskSize";
        case VirtualSystemDescriptionType_CloudBucket:
            return "CloudBucket";
        case VirtualSystemDescriptionType_CloudOCIVCN:
            return "CloudOCIVCN";
        case VirtualSystemDescriptionType_CloudPublicIP:
            return "CloudPublicIP";
        case VirtualSystemDescriptionType_CloudProfileName:
            return "CloudProfileName";
        case VirtualSystemDescriptionType_CloudOCISubnet:
            return "CloudOCISubnet";
        case VirtualSystemDescriptionType_CloudKeepObject:
            return "CloudKeepObject";
        case VirtualSystemDescriptionType_CloudLaunchInstance:
            return "CloudLaunchInstance";
        case VirtualSystemDescriptionType_CloudInstanceId:
            return "CloudInstanceId";
        case VirtualSystemDescriptionType_CloudImageId:
            return "CloudImageId";
        case VirtualSystemDescriptionType_CloudInstanceState:
            return "CloudInstanceState";
        case VirtualSystemDescriptionType_CloudImageState:
            return "CloudImageState";
        case VirtualSystemDescriptionType_CloudInstanceDisplayName:
            return "CloudInstanceDisplayName";
        case VirtualSystemDescriptionType_CloudImageDisplayName:
            return "CloudImageDisplayName";
        case VirtualSystemDescriptionType_CloudOCILaunchMode:
            return "CloudOCILaunchMode";
        case VirtualSystemDescriptionType_CloudPrivateIP:
            return "CloudPrivateIP";
        case VirtualSystemDescriptionType_CloudBootVolumeId:
            return "CloudBootVolumeId";
        case VirtualSystemDescriptionType_CloudOCIVCNCompartment:
            return "CloudOCIVCNCompartment";
        case VirtualSystemDescriptionType_CloudOCISubnetCompartment:
            return "CloudOCISubnetCompartment";
        case VirtualSystemDescriptionType_CloudPublicSSHKey:
            return "CloudPublicSSHKey";
        case VirtualSystemDescriptionType_BootingFirmware:
            return "BootingFirmware";
        case VirtualSystemDescriptionType_CloudInitScriptPath:
            return "CloudInitScriptPath";
        case VirtualSystemDescriptionType_CloudCompartmentId:
            return "CloudCompartmentId";
        case VirtualSystemDescriptionType_CloudShapeCpus:
            return "CloudShapeCpus";
        case VirtualSystemDescriptionType_CloudShapeMemory:
            return "CloudShapeMemory";
        case VirtualSystemDescriptionType_CloudInstanceMetadata:
            return "CloudInstanceMetadata";
        case VirtualSystemDescriptionType_CloudInstanceFreeFormTags:
            return "CloudInstanceFreeFormTags";
        case VirtualSystemDescriptionType_CloudImageFreeFormTags:
            return "CloudImageFreeFormTags";
        case VirtualSystemDescriptionType_HardDiskControllerVirtioSCSI:
            return "HardDiskControllerVirtioSCSI";
        case VirtualSystemDescriptionType_HardDiskControllerNVMe:
            return "HardDiskControllerNVMe";
        case VirtualSystemDescriptionType_NVRAM:
            return "NVRAM";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("VirtualSystemDescriptionType", (int)aValue));
    }
}


const char *stringifyVirtualSystemDescriptionValueType(VirtualSystemDescriptionValueType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case VirtualSystemDescriptionValueType_Reference:
            return "Reference";
        case VirtualSystemDescriptionValueType_Original:
            return "Original";
        case VirtualSystemDescriptionValueType_Auto:
            return "Auto";
        case VirtualSystemDescriptionValueType_ExtraConfig:
            return "ExtraConfig";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("VirtualSystemDescriptionValueType", (int)aValue));
    }
}


const char *stringifyTpmType(TpmType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case TpmType_None:
            return "None";
        case TpmType_v1_2:
            return "v1_2";
        case TpmType_v2_0:
            return "v2_0";
        case TpmType_Host:
            return "Host";
        case TpmType_Swtpm:
            return "Swtpm";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("TpmType", (int)aValue));
    }
}


const char *stringifyRecordingDestination(RecordingDestination_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case RecordingDestination_None:
            return "None";
        case RecordingDestination_File:
            return "File";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("RecordingDestination", (int)aValue));
    }
}


const char *stringifyRecordingFeature(RecordingFeature_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case RecordingFeature_None:
            return "None";
        case RecordingFeature_Video:
            return "Video";
        case RecordingFeature_Audio:
            return "Audio";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("RecordingFeature", (int)aValue));
    }
}


const char *stringifyRecordingAudioCodec(RecordingAudioCodec_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case RecordingAudioCodec_None:
            return "None";
        case RecordingAudioCodec_WavPCM:
            return "WavPCM";
        case RecordingAudioCodec_MP3:
            return "MP3";
        case RecordingAudioCodec_OggVorbis:
            return "OggVorbis";
        case RecordingAudioCodec_Opus:
            return "Opus";
        case RecordingAudioCodec_Other:
            return "Other";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("RecordingAudioCodec", (int)aValue));
    }
}


const char *stringifyRecordingCodecDeadline(RecordingCodecDeadline_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case RecordingCodecDeadline_Default:
            return "Default";
        case RecordingCodecDeadline_Realtime:
            return "Realtime";
        case RecordingCodecDeadline_Good:
            return "Good";
        case RecordingCodecDeadline_Best:
            return "Best";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("RecordingCodecDeadline", (int)aValue));
    }
}


const char *stringifyRecordingVideoCodec(RecordingVideoCodec_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case RecordingVideoCodec_None:
            return "None";
        case RecordingVideoCodec_MJPEG:
            return "MJPEG";
        case RecordingVideoCodec_H262:
            return "H262";
        case RecordingVideoCodec_H264:
            return "H264";
        case RecordingVideoCodec_H265:
            return "H265";
        case RecordingVideoCodec_H266:
            return "H266";
        case RecordingVideoCodec_VP8:
            return "VP8";
        case RecordingVideoCodec_VP9:
            return "VP9";
        case RecordingVideoCodec_AV1:
            return "AV1";
        case RecordingVideoCodec_Other:
            return "Other";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("RecordingVideoCodec", (int)aValue));
    }
}


const char *stringifyRecordingVideoScalingMode(RecordingVideoScalingMode_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case RecordingVideoScalingMode_None:
            return "None";
        case RecordingVideoScalingMode_NearestNeighbor:
            return "NearestNeighbor";
        case RecordingVideoScalingMode_Bilinear:
            return "Bilinear";
        case RecordingVideoScalingMode_Bicubic:
            return "Bicubic";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("RecordingVideoScalingMode", (int)aValue));
    }
}


const char *stringifyRecordingRateControlMode(RecordingRateControlMode_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case RecordingRateControlMode_ABR:
            return "ABR";
        case RecordingRateControlMode_CBR:
            return "CBR";
        case RecordingRateControlMode_VBR:
            return "VBR";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("RecordingRateControlMode", (int)aValue));
    }
}


const char *stringifyRecordingState(RecordingState_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case RecordingState_Unknown:
            return "Unknown";
        case RecordingState_Initializing:
            return "Initializing";
        case RecordingState_Started:
            return "Started";
        case RecordingState_Paused:
            return "Paused";
        case RecordingState_Resumed:
            return "Resumed";
        case RecordingState_Finalizing:
            return "Finalizing";
        case RecordingState_Stopped:
            return "Stopped";
        case RecordingState_Canceled:
            return "Canceled";
        case RecordingState_LimitReached:
            return "LimitReached";
        case RecordingState_Error:
            return "Error";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("RecordingState", (int)aValue));
    }
}


const char *stringifySignatureType(SignatureType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case SignatureType_X509:
            return "X509";
        case SignatureType_Sha256:
            return "Sha256";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("SignatureType", (int)aValue));
    }
}


const char *stringifyUefiVariableAttributes(UefiVariableAttributes_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case UefiVariableAttributes_None:
            return "None";
        case UefiVariableAttributes_NonVolatile:
            return "NonVolatile";
        case UefiVariableAttributes_BootServiceAccess:
            return "BootServiceAccess";
        case UefiVariableAttributes_RuntimeAccess:
            return "RuntimeAccess";
        case UefiVariableAttributes_HwErrorRecord:
            return "HwErrorRecord";
        case UefiVariableAttributes_AuthWriteAccess:
            return "AuthWriteAccess";
        case UefiVariableAttributes_AuthTimeBasedWriteAccess:
            return "AuthTimeBasedWriteAccess";
        case UefiVariableAttributes_AuthAppendWrite:
            return "AuthAppendWrite";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("UefiVariableAttributes", (int)aValue));
    }
}


const char *stringifyGraphicsControllerType(GraphicsControllerType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case GraphicsControllerType_Null:
            return "Null";
        case GraphicsControllerType_VBoxVGA:
            return "VBoxVGA";
        case GraphicsControllerType_VMSVGA:
            return "VMSVGA";
        case GraphicsControllerType_VBoxSVGA:
            return "VBoxSVGA";
        case GraphicsControllerType_QemuRamFB:
            return "QemuRamFB";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("GraphicsControllerType", (int)aValue));
    }
}


const char *stringifyGraphicsFeature(GraphicsFeature_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case GraphicsFeature_None:
            return "None";
        case GraphicsFeature_Acceleration3D:
            return "Acceleration3D";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("GraphicsFeature", (int)aValue));
    }
}


const char *stringifyCleanupMode(CleanupMode_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case CleanupMode_UnregisterOnly:
            return "UnregisterOnly";
        case CleanupMode_DetachAllReturnNone:
            return "DetachAllReturnNone";
        case CleanupMode_DetachAllReturnHardDisksOnly:
            return "DetachAllReturnHardDisksOnly";
        case CleanupMode_Full:
            return "Full";
        case CleanupMode_DetachAllReturnHardDisksAndVMRemovable:
            return "DetachAllReturnHardDisksAndVMRemovable";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("CleanupMode", (int)aValue));
    }
}


const char *stringifyCloneMode(CloneMode_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case CloneMode_MachineState:
            return "MachineState";
        case CloneMode_MachineAndChildStates:
            return "MachineAndChildStates";
        case CloneMode_AllStates:
            return "AllStates";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("CloneMode", (int)aValue));
    }
}


const char *stringifyCloneOptions(CloneOptions_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case CloneOptions_Link:
            return "Link";
        case CloneOptions_KeepAllMACs:
            return "KeepAllMACs";
        case CloneOptions_KeepNATMACs:
            return "KeepNATMACs";
        case CloneOptions_KeepDiskNames:
            return "KeepDiskNames";
        case CloneOptions_KeepHwUUIDs:
            return "KeepHwUUIDs";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("CloneOptions", (int)aValue));
    }
}


const char *stringifyAutostopType(AutostopType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case AutostopType_Disabled:
            return "Disabled";
        case AutostopType_SaveState:
            return "SaveState";
        case AutostopType_PowerOff:
            return "PowerOff";
        case AutostopType_AcpiShutdown:
            return "AcpiShutdown";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("AutostopType", (int)aValue));
    }
}


const char *stringifyVMProcPriority(VMProcPriority_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case VMProcPriority_Invalid:
            return "Invalid";
        case VMProcPriority_Default:
            return "Default";
        case VMProcPriority_Flat:
            return "Flat";
        case VMProcPriority_Low:
            return "Low";
        case VMProcPriority_Normal:
            return "Normal";
        case VMProcPriority_High:
            return "High";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("VMProcPriority", (int)aValue));
    }
}


const char *stringifyIommuType(IommuType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case IommuType_None:
            return "None";
        case IommuType_Automatic:
            return "Automatic";
        case IommuType_AMD:
            return "AMD";
        case IommuType_Intel:
            return "Intel";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("IommuType", (int)aValue));
    }
}


const char *stringifyVMExecutionEngine(VMExecutionEngine_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case VMExecutionEngine_NotSet:
            return "NotSet";
        case VMExecutionEngine_Default:
            return "Default";
        case VMExecutionEngine_HwVirt:
            return "HwVirt";
        case VMExecutionEngine_NativeApi:
            return "NativeApi";
        case VMExecutionEngine_Interpreter:
            return "Interpreter";
        case VMExecutionEngine_Recompiler:
            return "Recompiler";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("VMExecutionEngine", (int)aValue));
    }
}


const char *stringifyHostNetworkInterfaceMediumType(HostNetworkInterfaceMediumType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case HostNetworkInterfaceMediumType_Unknown:
            return "Unknown";
        case HostNetworkInterfaceMediumType_Ethernet:
            return "Ethernet";
        case HostNetworkInterfaceMediumType_PPP:
            return "PPP";
        case HostNetworkInterfaceMediumType_SLIP:
            return "SLIP";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("HostNetworkInterfaceMediumType", (int)aValue));
    }
}


const char *stringifyHostNetworkInterfaceStatus(HostNetworkInterfaceStatus_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case HostNetworkInterfaceStatus_Unknown:
            return "Unknown";
        case HostNetworkInterfaceStatus_Up:
            return "Up";
        case HostNetworkInterfaceStatus_Down:
            return "Down";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("HostNetworkInterfaceStatus", (int)aValue));
    }
}


const char *stringifyHostNetworkInterfaceType(HostNetworkInterfaceType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case HostNetworkInterfaceType_Invalid:
            return "Invalid";
        case HostNetworkInterfaceType_Bridged:
            return "Bridged";
        case HostNetworkInterfaceType_HostOnly:
            return "HostOnly";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("HostNetworkInterfaceType", (int)aValue));
    }
}


const char *stringifyUpdateChannel(UpdateChannel_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case UpdateChannel_Invalid:
            return "Invalid";
        case UpdateChannel_Stable:
            return "Stable";
        case UpdateChannel_All:
            return "All";
        case UpdateChannel_WithBetas:
            return "WithBetas";
        case UpdateChannel_WithTesting:
            return "WithTesting";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("UpdateChannel", (int)aValue));
    }
}


const char *stringifyUpdateSeverity(UpdateSeverity_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case UpdateSeverity_Invalid:
            return "Invalid";
        case UpdateSeverity_Critical:
            return "Critical";
        case UpdateSeverity_Major:
            return "Major";
        case UpdateSeverity_Minor:
            return "Minor";
        case UpdateSeverity_Testing:
            return "Testing";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("UpdateSeverity", (int)aValue));
    }
}


const char *stringifyUpdateState(UpdateState_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case UpdateState_Invalid:
            return "Invalid";
        case UpdateState_Available:
            return "Available";
        case UpdateState_NotAvailable:
            return "NotAvailable";
        case UpdateState_Downloading:
            return "Downloading";
        case UpdateState_Downloaded:
            return "Downloaded";
        case UpdateState_Installing:
            return "Installing";
        case UpdateState_Installed:
            return "Installed";
        case UpdateState_UserInteraction:
            return "UserInteraction";
        case UpdateState_Canceled:
            return "Canceled";
        case UpdateState_Maintenance:
            return "Maintenance";
        case UpdateState_Error:
            return "Error";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("UpdateState", (int)aValue));
    }
}


const char *stringifyProxyMode(ProxyMode_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case ProxyMode_System:
            return "System";
        case ProxyMode_NoProxy:
            return "NoProxy";
        case ProxyMode_Manual:
            return "Manual";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("ProxyMode", (int)aValue));
    }
}


const char *stringifyAdditionsFacilityType(AdditionsFacilityType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case AdditionsFacilityType_None:
            return "None";
        case AdditionsFacilityType_VBoxGuestDriver:
            return "VBoxGuestDriver";
        case AdditionsFacilityType_AutoLogon:
            return "AutoLogon";
        case AdditionsFacilityType_VBoxService:
            return "VBoxService";
        case AdditionsFacilityType_VBoxTrayClient:
            return "VBoxTrayClient";
        case AdditionsFacilityType_Seamless:
            return "Seamless";
        case AdditionsFacilityType_Graphics:
            return "Graphics";
        case AdditionsFacilityType_MonitorAttach:
            return "MonitorAttach";
        case AdditionsFacilityType_All:
            return "All";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("AdditionsFacilityType", (int)aValue));
    }
}


const char *stringifyAdditionsFacilityClass(AdditionsFacilityClass_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case AdditionsFacilityClass_None:
            return "None";
        case AdditionsFacilityClass_Driver:
            return "Driver";
        case AdditionsFacilityClass_Service:
            return "Service";
        case AdditionsFacilityClass_Program:
            return "Program";
        case AdditionsFacilityClass_Feature:
            return "Feature";
        case AdditionsFacilityClass_ThirdParty:
            return "ThirdParty";
        case AdditionsFacilityClass_All:
            return "All";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("AdditionsFacilityClass", (int)aValue));
    }
}


const char *stringifyAdditionsFacilityStatus(AdditionsFacilityStatus_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case AdditionsFacilityStatus_Inactive:
            return "Inactive";
        case AdditionsFacilityStatus_Paused:
            return "Paused";
        case AdditionsFacilityStatus_PreInit:
            return "PreInit";
        case AdditionsFacilityStatus_Init:
            return "Init";
        case AdditionsFacilityStatus_Active:
            return "Active";
        case AdditionsFacilityStatus_Terminating:
            return "Terminating";
        case AdditionsFacilityStatus_Terminated:
            return "Terminated";
        case AdditionsFacilityStatus_Failed:
            return "Failed";
        case AdditionsFacilityStatus_Unknown:
            return "Unknown";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("AdditionsFacilityStatus", (int)aValue));
    }
}


const char *stringifyAdditionsRunLevelType(AdditionsRunLevelType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case AdditionsRunLevelType_None:
            return "None";
        case AdditionsRunLevelType_System:
            return "System";
        case AdditionsRunLevelType_Userland:
            return "Userland";
        case AdditionsRunLevelType_Desktop:
            return "Desktop";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("AdditionsRunLevelType", (int)aValue));
    }
}


const char *stringifyAdditionsUpdateFlag(AdditionsUpdateFlag_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case AdditionsUpdateFlag_None:
            return "None";
        case AdditionsUpdateFlag_WaitForUpdateStartOnly:
            return "WaitForUpdateStartOnly";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("AdditionsUpdateFlag", (int)aValue));
    }
}


const char *stringifyGuestShutdownFlag(GuestShutdownFlag_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case GuestShutdownFlag_None:
            return "None";
        case GuestShutdownFlag_PowerOff:
            return "PowerOff";
        case GuestShutdownFlag_Reboot:
            return "Reboot";
        case GuestShutdownFlag_Force:
            return "Force";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("GuestShutdownFlag", (int)aValue));
    }
}


const char *stringifyGuestSessionStatus(GuestSessionStatus_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case GuestSessionStatus_Undefined:
            return "Undefined";
        case GuestSessionStatus_Starting:
            return "Starting";
        case GuestSessionStatus_Started:
            return "Started";
        case GuestSessionStatus_Terminating:
            return "Terminating";
        case GuestSessionStatus_Terminated:
            return "Terminated";
        case GuestSessionStatus_TimedOutKilled:
            return "TimedOutKilled";
        case GuestSessionStatus_TimedOutAbnormally:
            return "TimedOutAbnormally";
        case GuestSessionStatus_Down:
            return "Down";
        case GuestSessionStatus_Error:
            return "Error";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("GuestSessionStatus", (int)aValue));
    }
}


const char *stringifyGuestSessionWaitForFlag(GuestSessionWaitForFlag_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case GuestSessionWaitForFlag_None:
            return "None";
        case GuestSessionWaitForFlag_Start:
            return "Start";
        case GuestSessionWaitForFlag_Terminate:
            return "Terminate";
        case GuestSessionWaitForFlag_Status:
            return "Status";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("GuestSessionWaitForFlag", (int)aValue));
    }
}


const char *stringifyGuestSessionWaitResult(GuestSessionWaitResult_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case GuestSessionWaitResult_None:
            return "None";
        case GuestSessionWaitResult_Start:
            return "Start";
        case GuestSessionWaitResult_Terminate:
            return "Terminate";
        case GuestSessionWaitResult_Status:
            return "Status";
        case GuestSessionWaitResult_Error:
            return "Error";
        case GuestSessionWaitResult_Timeout:
            return "Timeout";
        case GuestSessionWaitResult_WaitFlagNotSupported:
            return "WaitFlagNotSupported";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("GuestSessionWaitResult", (int)aValue));
    }
}


const char *stringifyGuestUserState(GuestUserState_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case GuestUserState_Unknown:
            return "Unknown";
        case GuestUserState_LoggedIn:
            return "LoggedIn";
        case GuestUserState_LoggedOut:
            return "LoggedOut";
        case GuestUserState_Locked:
            return "Locked";
        case GuestUserState_Unlocked:
            return "Unlocked";
        case GuestUserState_Disabled:
            return "Disabled";
        case GuestUserState_Idle:
            return "Idle";
        case GuestUserState_InUse:
            return "InUse";
        case GuestUserState_Created:
            return "Created";
        case GuestUserState_Deleted:
            return "Deleted";
        case GuestUserState_SessionChanged:
            return "SessionChanged";
        case GuestUserState_CredentialsChanged:
            return "CredentialsChanged";
        case GuestUserState_RoleChanged:
            return "RoleChanged";
        case GuestUserState_GroupAdded:
            return "GroupAdded";
        case GuestUserState_GroupRemoved:
            return "GroupRemoved";
        case GuestUserState_Elevated:
            return "Elevated";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("GuestUserState", (int)aValue));
    }
}


const char *stringifyFileSeekOrigin(FileSeekOrigin_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case FileSeekOrigin_Begin:
            return "Begin";
        case FileSeekOrigin_Current:
            return "Current";
        case FileSeekOrigin_End:
            return "End";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("FileSeekOrigin", (int)aValue));
    }
}


const char *stringifyProcessInputFlag(ProcessInputFlag_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case ProcessInputFlag_None:
            return "None";
        case ProcessInputFlag_EndOfFile:
            return "EndOfFile";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("ProcessInputFlag", (int)aValue));
    }
}


const char *stringifyProcessOutputFlag(ProcessOutputFlag_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case ProcessOutputFlag_None:
            return "None";
        case ProcessOutputFlag_StdErr:
            return "StdErr";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("ProcessOutputFlag", (int)aValue));
    }
}


const char *stringifyProcessWaitForFlag(ProcessWaitForFlag_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case ProcessWaitForFlag_None:
            return "None";
        case ProcessWaitForFlag_Start:
            return "Start";
        case ProcessWaitForFlag_Terminate:
            return "Terminate";
        case ProcessWaitForFlag_StdIn:
            return "StdIn";
        case ProcessWaitForFlag_StdOut:
            return "StdOut";
        case ProcessWaitForFlag_StdErr:
            return "StdErr";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("ProcessWaitForFlag", (int)aValue));
    }
}


const char *stringifyProcessWaitResult(ProcessWaitResult_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case ProcessWaitResult_None:
            return "None";
        case ProcessWaitResult_Start:
            return "Start";
        case ProcessWaitResult_Terminate:
            return "Terminate";
        case ProcessWaitResult_Status:
            return "Status";
        case ProcessWaitResult_Error:
            return "Error";
        case ProcessWaitResult_Timeout:
            return "Timeout";
        case ProcessWaitResult_StdIn:
            return "StdIn";
        case ProcessWaitResult_StdOut:
            return "StdOut";
        case ProcessWaitResult_StdErr:
            return "StdErr";
        case ProcessWaitResult_WaitFlagNotSupported:
            return "WaitFlagNotSupported";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("ProcessWaitResult", (int)aValue));
    }
}


const char *stringifyFileCopyFlag(FileCopyFlag_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case FileCopyFlag_None:
            return "None";
        case FileCopyFlag_NoReplace:
            return "NoReplace";
        case FileCopyFlag_FollowLinks:
            return "FollowLinks";
        case FileCopyFlag_Update:
            return "Update";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("FileCopyFlag", (int)aValue));
    }
}


const char *stringifyFsObjMoveFlag(FsObjMoveFlag_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case FsObjMoveFlag_None:
            return "None";
        case FsObjMoveFlag_Replace:
            return "Replace";
        case FsObjMoveFlag_FollowLinks:
            return "FollowLinks";
        case FsObjMoveFlag_AllowDirectoryMoves:
            return "AllowDirectoryMoves";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("FsObjMoveFlag", (int)aValue));
    }
}


const char *stringifyDirectoryCreateFlag(DirectoryCreateFlag_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case DirectoryCreateFlag_None:
            return "None";
        case DirectoryCreateFlag_Parents:
            return "Parents";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("DirectoryCreateFlag", (int)aValue));
    }
}


const char *stringifyDirectoryCopyFlag(DirectoryCopyFlag_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case DirectoryCopyFlag_None:
            return "None";
        case DirectoryCopyFlag_CopyIntoExisting:
            return "CopyIntoExisting";
        case DirectoryCopyFlag_Recursive:
            return "Recursive";
        case DirectoryCopyFlag_FollowLinks:
            return "FollowLinks";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("DirectoryCopyFlag", (int)aValue));
    }
}


const char *stringifyDirectoryRemoveRecFlag(DirectoryRemoveRecFlag_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case DirectoryRemoveRecFlag_None:
            return "None";
        case DirectoryRemoveRecFlag_ContentAndDir:
            return "ContentAndDir";
        case DirectoryRemoveRecFlag_ContentOnly:
            return "ContentOnly";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("DirectoryRemoveRecFlag", (int)aValue));
    }
}


const char *stringifyFsObjRenameFlag(FsObjRenameFlag_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case FsObjRenameFlag_NoReplace:
            return "NoReplace";
        case FsObjRenameFlag_Replace:
            return "Replace";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("FsObjRenameFlag", (int)aValue));
    }
}


const char *stringifyProcessCreateFlag(ProcessCreateFlag_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case ProcessCreateFlag_None:
            return "None";
        case ProcessCreateFlag_WaitForProcessStartOnly:
            return "WaitForProcessStartOnly";
        case ProcessCreateFlag_IgnoreOrphanedProcesses:
            return "IgnoreOrphanedProcesses";
        case ProcessCreateFlag_Hidden:
            return "Hidden";
        case ProcessCreateFlag_Profile:
            return "Profile";
        case ProcessCreateFlag_WaitForStdOut:
            return "WaitForStdOut";
        case ProcessCreateFlag_WaitForStdErr:
            return "WaitForStdErr";
        case ProcessCreateFlag_ExpandArguments:
            return "ExpandArguments";
        case ProcessCreateFlag_UnquotedArguments:
            return "UnquotedArguments";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("ProcessCreateFlag", (int)aValue));
    }
}


const char *stringifyProcessPriority(ProcessPriority_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case ProcessPriority_Invalid:
            return "Invalid";
        case ProcessPriority_Default:
            return "Default";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("ProcessPriority", (int)aValue));
    }
}


const char *stringifySymlinkType(SymlinkType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case SymlinkType_Unknown:
            return "Unknown";
        case SymlinkType_Directory:
            return "Directory";
        case SymlinkType_File:
            return "File";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("SymlinkType", (int)aValue));
    }
}


const char *stringifySymlinkReadFlag(SymlinkReadFlag_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case SymlinkReadFlag_None:
            return "None";
        case SymlinkReadFlag_NoSymlinks:
            return "NoSymlinks";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("SymlinkReadFlag", (int)aValue));
    }
}


const char *stringifyProcessStatus(ProcessStatus_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case ProcessStatus_Undefined:
            return "Undefined";
        case ProcessStatus_Starting:
            return "Starting";
        case ProcessStatus_Started:
            return "Started";
        case ProcessStatus_Paused:
            return "Paused";
        case ProcessStatus_Terminating:
            return "Terminating";
        case ProcessStatus_TerminatedNormally:
            return "TerminatedNormally";
        case ProcessStatus_TerminatedSignal:
            return "TerminatedSignal";
        case ProcessStatus_TerminatedAbnormally:
            return "TerminatedAbnormally";
        case ProcessStatus_TimedOutKilled:
            return "TimedOutKilled";
        case ProcessStatus_TimedOutAbnormally:
            return "TimedOutAbnormally";
        case ProcessStatus_Down:
            return "Down";
        case ProcessStatus_Error:
            return "Error";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("ProcessStatus", (int)aValue));
    }
}


const char *stringifyProcessInputStatus(ProcessInputStatus_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case ProcessInputStatus_Undefined:
            return "Undefined";
        case ProcessInputStatus_Broken:
            return "Broken";
        case ProcessInputStatus_Available:
            return "Available";
        case ProcessInputStatus_Written:
            return "Written";
        case ProcessInputStatus_Overflow:
            return "Overflow";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("ProcessInputStatus", (int)aValue));
    }
}


const char *stringifyPathStyle(PathStyle_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case PathStyle_DOS:
            return "DOS";
        case PathStyle_UNIX:
            return "UNIX";
        case PathStyle_Unknown:
            return "Unknown";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("PathStyle", (int)aValue));
    }
}


const char *stringifyDirectoryStatus(DirectoryStatus_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case DirectoryStatus_Undefined:
            return "Undefined";
        case DirectoryStatus_Open:
            return "Open";
        case DirectoryStatus_Close:
            return "Close";
        case DirectoryStatus_Rewind:
            return "Rewind";
        case DirectoryStatus_Down:
            return "Down";
        case DirectoryStatus_Error:
            return "Error";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("DirectoryStatus", (int)aValue));
    }
}


const char *stringifyFileAccessMode(FileAccessMode_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case FileAccessMode_ReadOnly:
            return "ReadOnly";
        case FileAccessMode_WriteOnly:
            return "WriteOnly";
        case FileAccessMode_ReadWrite:
            return "ReadWrite";
        case FileAccessMode_AppendOnly:
            return "AppendOnly";
        case FileAccessMode_AppendRead:
            return "AppendRead";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("FileAccessMode", (int)aValue));
    }
}


const char *stringifyFileOpenAction(FileOpenAction_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case FileOpenAction_OpenExisting:
            return "OpenExisting";
        case FileOpenAction_OpenOrCreate:
            return "OpenOrCreate";
        case FileOpenAction_CreateNew:
            return "CreateNew";
        case FileOpenAction_CreateOrReplace:
            return "CreateOrReplace";
        case FileOpenAction_OpenExistingTruncated:
            return "OpenExistingTruncated";
        case FileOpenAction_AppendOrCreate:
            return "AppendOrCreate";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("FileOpenAction", (int)aValue));
    }
}


const char *stringifyFileSharingMode(FileSharingMode_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case FileSharingMode_Read:
            return "Read";
        case FileSharingMode_Write:
            return "Write";
        case FileSharingMode_ReadWrite:
            return "ReadWrite";
        case FileSharingMode_Delete:
            return "Delete";
        case FileSharingMode_ReadDelete:
            return "ReadDelete";
        case FileSharingMode_WriteDelete:
            return "WriteDelete";
        case FileSharingMode_All:
            return "All";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("FileSharingMode", (int)aValue));
    }
}


const char *stringifyFileOpenExFlag(FileOpenExFlag_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case FileOpenExFlag_None:
            return "None";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("FileOpenExFlag", (int)aValue));
    }
}


const char *stringifyFileStatus(FileStatus_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case FileStatus_Undefined:
            return "Undefined";
        case FileStatus_Opening:
            return "Opening";
        case FileStatus_Open:
            return "Open";
        case FileStatus_Closing:
            return "Closing";
        case FileStatus_Closed:
            return "Closed";
        case FileStatus_Down:
            return "Down";
        case FileStatus_Error:
            return "Error";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("FileStatus", (int)aValue));
    }
}


const char *stringifyFsObjType(FsObjType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case FsObjType_Unknown:
            return "Unknown";
        case FsObjType_Fifo:
            return "Fifo";
        case FsObjType_DevChar:
            return "DevChar";
        case FsObjType_Directory:
            return "Directory";
        case FsObjType_DevBlock:
            return "DevBlock";
        case FsObjType_File:
            return "File";
        case FsObjType_Symlink:
            return "Symlink";
        case FsObjType_Socket:
            return "Socket";
        case FsObjType_WhiteOut:
            return "WhiteOut";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("FsObjType", (int)aValue));
    }
}


const char *stringifyDnDAction(DnDAction_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case DnDAction_Ignore:
            return "Ignore";
        case DnDAction_Copy:
            return "Copy";
        case DnDAction_Move:
            return "Move";
        case DnDAction_Link:
            return "Link";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("DnDAction", (int)aValue));
    }
}


const char *stringifyDirectoryOpenFlag(DirectoryOpenFlag_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case DirectoryOpenFlag_None:
            return "None";
        case DirectoryOpenFlag_NoSymlinks:
            return "NoSymlinks";
        case DirectoryOpenFlag_DenyAscent:
            return "DenyAscent";
        case DirectoryOpenFlag_NoFollowSymlinks:
            return "NoFollowSymlinks";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("DirectoryOpenFlag", (int)aValue));
    }
}


const char *stringifyMediumState(MediumState_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case MediumState_NotCreated:
            return "NotCreated";
        case MediumState_Created:
            return "Created";
        case MediumState_LockedRead:
            return "LockedRead";
        case MediumState_LockedWrite:
            return "LockedWrite";
        case MediumState_Inaccessible:
            return "Inaccessible";
        case MediumState_Creating:
            return "Creating";
        case MediumState_Deleting:
            return "Deleting";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("MediumState", (int)aValue));
    }
}


const char *stringifyMediumType(MediumType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case MediumType_Normal:
            return "Normal";
        case MediumType_Immutable:
            return "Immutable";
        case MediumType_Writethrough:
            return "Writethrough";
        case MediumType_Shareable:
            return "Shareable";
        case MediumType_Readonly:
            return "Readonly";
        case MediumType_MultiAttach:
            return "MultiAttach";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("MediumType", (int)aValue));
    }
}


const char *stringifyMediumVariant(MediumVariant_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case MediumVariant_Standard:
            return "Standard";
        case MediumVariant_VmdkSplit2G:
            return "VmdkSplit2G";
        case MediumVariant_VmdkRawDisk:
            return "VmdkRawDisk";
        case MediumVariant_VmdkStreamOptimized:
            return "VmdkStreamOptimized";
        case MediumVariant_VmdkESX:
            return "VmdkESX";
        case MediumVariant_VdiZeroExpand:
            return "VdiZeroExpand";
        case MediumVariant_Fixed:
            return "Fixed";
        case MediumVariant_Diff:
            return "Diff";
        case MediumVariant_Formatted:
            return "Formatted";
        case MediumVariant_NoCreateDir:
            return "NoCreateDir";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("MediumVariant", (int)aValue));
    }
}


const char *stringifyDataType(DataType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case DataType_Int32:
            return "Int32";
        case DataType_Int8:
            return "Int8";
        case DataType_String:
            return "String";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("DataType", (int)aValue));
    }
}


const char *stringifyDataFlags(DataFlags_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case DataFlags_None:
            return "None";
        case DataFlags_Mandatory:
            return "Mandatory";
        case DataFlags_Expert:
            return "Expert";
        case DataFlags_Array:
            return "Array";
        case DataFlags_FlagMask:
            return "FlagMask";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("DataFlags", (int)aValue));
    }
}


const char *stringifyMediumFormatCapabilities(MediumFormatCapabilities_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case MediumFormatCapabilities_Uuid:
            return "Uuid";
        case MediumFormatCapabilities_CreateFixed:
            return "CreateFixed";
        case MediumFormatCapabilities_CreateDynamic:
            return "CreateDynamic";
        case MediumFormatCapabilities_CreateSplit2G:
            return "CreateSplit2G";
        case MediumFormatCapabilities_Differencing:
            return "Differencing";
        case MediumFormatCapabilities_Asynchronous:
            return "Asynchronous";
        case MediumFormatCapabilities_File:
            return "File";
        case MediumFormatCapabilities_Properties:
            return "Properties";
        case MediumFormatCapabilities_TcpNetworking:
            return "TcpNetworking";
        case MediumFormatCapabilities_VFS:
            return "VFS";
        case MediumFormatCapabilities_Discard:
            return "Discard";
        case MediumFormatCapabilities_Preferred:
            return "Preferred";
        case MediumFormatCapabilities_CapabilityMask:
            return "CapabilityMask";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("MediumFormatCapabilities", (int)aValue));
    }
}


const char *stringifyPartitionTableType(PartitionTableType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case PartitionTableType_MBR:
            return "MBR";
        case PartitionTableType_GPT:
            return "GPT";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("PartitionTableType", (int)aValue));
    }
}


const char *stringifyKeyboardLED(KeyboardLED_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case KeyboardLED_NumLock:
            return "NumLock";
        case KeyboardLED_CapsLock:
            return "CapsLock";
        case KeyboardLED_ScrollLock:
            return "ScrollLock";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("KeyboardLED", (int)aValue));
    }
}


const char *stringifyMouseButtonState(MouseButtonState_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case MouseButtonState_LeftButton:
            return "LeftButton";
        case MouseButtonState_RightButton:
            return "RightButton";
        case MouseButtonState_MiddleButton:
            return "MiddleButton";
        case MouseButtonState_WheelUp:
            return "WheelUp";
        case MouseButtonState_WheelDown:
            return "WheelDown";
        case MouseButtonState_XButton1:
            return "XButton1";
        case MouseButtonState_XButton2:
            return "XButton2";
        case MouseButtonState_MouseStateMask:
            return "MouseStateMask";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("MouseButtonState", (int)aValue));
    }
}


const char *stringifyTouchContactState(TouchContactState_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case TouchContactState_None:
            return "None";
        case TouchContactState_InContact:
            return "InContact";
        case TouchContactState_InRange:
            return "InRange";
        case TouchContactState_ContactStateMask:
            return "ContactStateMask";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("TouchContactState", (int)aValue));
    }
}


const char *stringifyFramebufferCapabilities(FramebufferCapabilities_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case FramebufferCapabilities_UpdateImage:
            return "UpdateImage";
        case FramebufferCapabilities_VHWA:
            return "VHWA";
        case FramebufferCapabilities_VisibleRegion:
            return "VisibleRegion";
        case FramebufferCapabilities_RenderCursor:
            return "RenderCursor";
        case FramebufferCapabilities_MoveCursor:
            return "MoveCursor";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("FramebufferCapabilities", (int)aValue));
    }
}


const char *stringifyGuestMonitorStatus(GuestMonitorStatus_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case GuestMonitorStatus_Disabled:
            return "Disabled";
        case GuestMonitorStatus_Enabled:
            return "Enabled";
        case GuestMonitorStatus_Blank:
            return "Blank";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("GuestMonitorStatus", (int)aValue));
    }
}


const char *stringifyScreenLayoutMode(ScreenLayoutMode_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case ScreenLayoutMode_Apply:
            return "Apply";
        case ScreenLayoutMode_Reset:
            return "Reset";
        case ScreenLayoutMode_Attach:
            return "Attach";
        case ScreenLayoutMode_Silent:
            return "Silent";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("ScreenLayoutMode", (int)aValue));
    }
}


const char *stringifyNetworkAttachmentType(NetworkAttachmentType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case NetworkAttachmentType_Null:
            return "Null";
        case NetworkAttachmentType_NAT:
            return "NAT";
        case NetworkAttachmentType_Bridged:
            return "Bridged";
        case NetworkAttachmentType_Internal:
            return "Internal";
        case NetworkAttachmentType_HostOnly:
            return "HostOnly";
        case NetworkAttachmentType_Generic:
            return "Generic";
        case NetworkAttachmentType_NATNetwork:
            return "NATNetwork";
        case NetworkAttachmentType_Cloud:
            return "Cloud";
        case NetworkAttachmentType_HostOnlyNetwork:
            return "HostOnlyNetwork";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("NetworkAttachmentType", (int)aValue));
    }
}


const char *stringifyNetworkAdapterType(NetworkAdapterType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case NetworkAdapterType_Null:
            return "Null";
        case NetworkAdapterType_Am79C970A:
            return "Am79C970A";
        case NetworkAdapterType_Am79C973:
            return "Am79C973";
        case NetworkAdapterType_I82540EM:
            return "I82540EM";
        case NetworkAdapterType_I82543GC:
            return "I82543GC";
        case NetworkAdapterType_I82545EM:
            return "I82545EM";
        case NetworkAdapterType_Virtio:
            return "Virtio";
        case NetworkAdapterType_Am79C960:
            return "Am79C960";
        case NetworkAdapterType_NE2000:
            return "NE2000";
        case NetworkAdapterType_NE1000:
            return "NE1000";
        case NetworkAdapterType_WD8013:
            return "WD8013";
        case NetworkAdapterType_WD8003:
            return "WD8003";
        case NetworkAdapterType_ELNK2:
            return "ELNK2";
        case NetworkAdapterType_ELNK1:
            return "ELNK1";
        case NetworkAdapterType_UsbNet:
            return "UsbNet";
        case NetworkAdapterType_I82583V:
            return "I82583V";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("NetworkAdapterType", (int)aValue));
    }
}


const char *stringifyNetworkAdapterPromiscModePolicy(NetworkAdapterPromiscModePolicy_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case NetworkAdapterPromiscModePolicy_Deny:
            return "Deny";
        case NetworkAdapterPromiscModePolicy_AllowNetwork:
            return "AllowNetwork";
        case NetworkAdapterPromiscModePolicy_AllowAll:
            return "AllowAll";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("NetworkAdapterPromiscModePolicy", (int)aValue));
    }
}


const char *stringifyPortMode(PortMode_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case PortMode_Disconnected:
            return "Disconnected";
        case PortMode_HostPipe:
            return "HostPipe";
        case PortMode_HostDevice:
            return "HostDevice";
        case PortMode_RawFile:
            return "RawFile";
        case PortMode_TCP:
            return "TCP";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("PortMode", (int)aValue));
    }
}


const char *stringifyUartType(UartType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case UartType_U16450:
            return "U16450";
        case UartType_U16550A:
            return "U16550A";
        case UartType_U16750:
            return "U16750";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("UartType", (int)aValue));
    }
}


const char *stringifyUSBControllerType(USBControllerType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case USBControllerType_Null:
            return "Null";
        case USBControllerType_OHCI:
            return "OHCI";
        case USBControllerType_EHCI:
            return "EHCI";
        case USBControllerType_XHCI:
            return "XHCI";
        case USBControllerType_Last:
            return "Last";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("USBControllerType", (int)aValue));
    }
}


const char *stringifyUSBConnectionSpeed(USBConnectionSpeed_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case USBConnectionSpeed_Null:
            return "Null";
        case USBConnectionSpeed_Low:
            return "Low";
        case USBConnectionSpeed_Full:
            return "Full";
        case USBConnectionSpeed_High:
            return "High";
        case USBConnectionSpeed_Super:
            return "Super";
        case USBConnectionSpeed_SuperPlus:
            return "SuperPlus";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("USBConnectionSpeed", (int)aValue));
    }
}


const char *stringifyUSBDeviceState(USBDeviceState_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case USBDeviceState_NotSupported:
            return "NotSupported";
        case USBDeviceState_Unavailable:
            return "Unavailable";
        case USBDeviceState_Busy:
            return "Busy";
        case USBDeviceState_Available:
            return "Available";
        case USBDeviceState_Held:
            return "Held";
        case USBDeviceState_Captured:
            return "Captured";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("USBDeviceState", (int)aValue));
    }
}


const char *stringifyUSBDeviceFilterAction(USBDeviceFilterAction_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case USBDeviceFilterAction_Null:
            return "Null";
        case USBDeviceFilterAction_Ignore:
            return "Ignore";
        case USBDeviceFilterAction_Hold:
            return "Hold";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("USBDeviceFilterAction", (int)aValue));
    }
}


const char *stringifyAudioDriverType(AudioDriverType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case AudioDriverType_Default:
            return "Default";
        case AudioDriverType_Null:
            return "Null";
        case AudioDriverType_OSS:
            return "OSS";
        case AudioDriverType_ALSA:
            return "ALSA";
        case AudioDriverType_Pulse:
            return "Pulse";
        case AudioDriverType_WinMM:
            return "WinMM";
        case AudioDriverType_DirectSound:
            return "DirectSound";
        case AudioDriverType_WAS:
            return "WAS";
        case AudioDriverType_CoreAudio:
            return "CoreAudio";
        case AudioDriverType_MMPM:
            return "MMPM";
        case AudioDriverType_SolAudio:
            return "SolAudio";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("AudioDriverType", (int)aValue));
    }
}


const char *stringifyAudioControllerType(AudioControllerType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case AudioControllerType_AC97:
            return "AC97";
        case AudioControllerType_SB16:
            return "SB16";
        case AudioControllerType_HDA:
            return "HDA";
        case AudioControllerType_VirtioSound:
            return "VirtioSound";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("AudioControllerType", (int)aValue));
    }
}


const char *stringifyAudioCodecType(AudioCodecType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case AudioCodecType_Null:
            return "Null";
        case AudioCodecType_SB16:
            return "SB16";
        case AudioCodecType_STAC9700:
            return "STAC9700";
        case AudioCodecType_AD1980:
            return "AD1980";
        case AudioCodecType_STAC9221:
            return "STAC9221";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("AudioCodecType", (int)aValue));
    }
}


const char *stringifyAudioDirection(AudioDirection_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case AudioDirection_Unknown:
            return "Unknown";
        case AudioDirection_In:
            return "In";
        case AudioDirection_Out:
            return "Out";
        case AudioDirection_Duplex:
            return "Duplex";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("AudioDirection", (int)aValue));
    }
}


const char *stringifyAudioDeviceType(AudioDeviceType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case AudioDeviceType_Unknown:
            return "Unknown";
        case AudioDeviceType_BuiltLin:
            return "BuiltLin";
        case AudioDeviceType_ExternalUSB:
            return "ExternalUSB";
        case AudioDeviceType_ExternalOther:
            return "ExternalOther";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("AudioDeviceType", (int)aValue));
    }
}


const char *stringifyAudioDeviceState(AudioDeviceState_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case AudioDeviceState_Unknown:
            return "Unknown";
        case AudioDeviceState_Active:
            return "Active";
        case AudioDeviceState_Disabled:
            return "Disabled";
        case AudioDeviceState_NotPresent:
            return "NotPresent";
        case AudioDeviceState_Unplugged:
            return "Unplugged";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("AudioDeviceState", (int)aValue));
    }
}


const char *stringifyAuthType(AuthType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case AuthType_Null:
            return "Null";
        case AuthType_External:
            return "External";
        case AuthType_Guest:
            return "Guest";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("AuthType", (int)aValue));
    }
}


const char *stringifyReason(Reason_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case Reason_Unspecified:
            return "Unspecified";
        case Reason_HostSuspend:
            return "HostSuspend";
        case Reason_HostResume:
            return "HostResume";
        case Reason_HostBatteryLow:
            return "HostBatteryLow";
        case Reason_Snapshot:
            return "Snapshot";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("Reason", (int)aValue));
    }
}


const char *stringifyStorageBus(StorageBus_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case StorageBus_Null:
            return "Null";
        case StorageBus_IDE:
            return "IDE";
        case StorageBus_SATA:
            return "SATA";
        case StorageBus_SCSI:
            return "SCSI";
        case StorageBus_Floppy:
            return "Floppy";
        case StorageBus_SAS:
            return "SAS";
        case StorageBus_USB:
            return "USB";
        case StorageBus_PCIe:
            return "PCIe";
        case StorageBus_VirtioSCSI:
            return "VirtioSCSI";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("StorageBus", (int)aValue));
    }
}


const char *stringifyStorageControllerType(StorageControllerType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case StorageControllerType_Null:
            return "Null";
        case StorageControllerType_LsiLogic:
            return "LsiLogic";
        case StorageControllerType_BusLogic:
            return "BusLogic";
        case StorageControllerType_IntelAhci:
            return "IntelAhci";
        case StorageControllerType_PIIX3:
            return "PIIX3";
        case StorageControllerType_PIIX4:
            return "PIIX4";
        case StorageControllerType_ICH6:
            return "ICH6";
        case StorageControllerType_I82078:
            return "I82078";
        case StorageControllerType_LsiLogicSas:
            return "LsiLogicSas";
        case StorageControllerType_USB:
            return "USB";
        case StorageControllerType_NVMe:
            return "NVMe";
        case StorageControllerType_VirtioSCSI:
            return "VirtioSCSI";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("StorageControllerType", (int)aValue));
    }
}


const char *stringifyChipsetType(ChipsetType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case ChipsetType_Null:
            return "Null";
        case ChipsetType_PIIX3:
            return "PIIX3";
        case ChipsetType_ICH9:
            return "ICH9";
        case ChipsetType_ARMv8Virtual:
            return "ARMv8Virtual";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("ChipsetType", (int)aValue));
    }
}


const char *stringifyNATAliasMode(NATAliasMode_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case NATAliasMode_AliasLog:
            return "AliasLog";
        case NATAliasMode_AliasProxyOnly:
            return "AliasProxyOnly";
        case NATAliasMode_AliasUseSamePorts:
            return "AliasUseSamePorts";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("NATAliasMode", (int)aValue));
    }
}


const char *stringifyNATProtocol(NATProtocol_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case NATProtocol_UDP:
            return "UDP";
        case NATProtocol_TCP:
            return "TCP";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("NATProtocol", (int)aValue));
    }
}


const char *stringifyBandwidthGroupType(BandwidthGroupType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case BandwidthGroupType_Null:
            return "Null";
        case BandwidthGroupType_Disk:
            return "Disk";
        case BandwidthGroupType_Network:
            return "Network";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("BandwidthGroupType", (int)aValue));
    }
}


const char *stringifyGuestDebugProvider(GuestDebugProvider_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case GuestDebugProvider_None:
            return "None";
        case GuestDebugProvider_Native:
            return "Native";
        case GuestDebugProvider_GDB:
            return "GDB";
        case GuestDebugProvider_KD:
            return "KD";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("GuestDebugProvider", (int)aValue));
    }
}


const char *stringifyGuestDebugIoProvider(GuestDebugIoProvider_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case GuestDebugIoProvider_None:
            return "None";
        case GuestDebugIoProvider_TCP:
            return "TCP";
        case GuestDebugIoProvider_UDP:
            return "UDP";
        case GuestDebugIoProvider_IPC:
            return "IPC";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("GuestDebugIoProvider", (int)aValue));
    }
}


const char *stringifyVBoxEventType(VBoxEventType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case VBoxEventType_Invalid:
            return "Invalid";
        case VBoxEventType_Any:
            return "Any";
        case VBoxEventType_Vetoable:
            return "Vetoable";
        case VBoxEventType_MachineEvent:
            return "MachineEvent";
        case VBoxEventType_SnapshotEvent:
            return "SnapshotEvent";
        case VBoxEventType_InputEvent:
            return "InputEvent";
        case VBoxEventType_LastWildcard:
            return "LastWildcard";
        case VBoxEventType_OnMachineStateChanged:
            return "OnMachineStateChanged";
        case VBoxEventType_OnMachineDataChanged:
            return "OnMachineDataChanged";
        case VBoxEventType_OnExtraDataChanged:
            return "OnExtraDataChanged";
        case VBoxEventType_OnExtraDataCanChange:
            return "OnExtraDataCanChange";
        case VBoxEventType_OnMediumRegistered:
            return "OnMediumRegistered";
        case VBoxEventType_OnMachineRegistered:
            return "OnMachineRegistered";
        case VBoxEventType_OnSessionStateChanged:
            return "OnSessionStateChanged";
        case VBoxEventType_OnSnapshotTaken:
            return "OnSnapshotTaken";
        case VBoxEventType_OnSnapshotDeleted:
            return "OnSnapshotDeleted";
        case VBoxEventType_OnSnapshotChanged:
            return "OnSnapshotChanged";
        case VBoxEventType_OnGuestPropertyChanged:
            return "OnGuestPropertyChanged";
        case VBoxEventType_OnMousePointerShapeChanged:
            return "OnMousePointerShapeChanged";
        case VBoxEventType_OnMouseCapabilityChanged:
            return "OnMouseCapabilityChanged";
        case VBoxEventType_OnKeyboardLedsChanged:
            return "OnKeyboardLedsChanged";
        case VBoxEventType_OnStateChanged:
            return "OnStateChanged";
        case VBoxEventType_OnAdditionsStateChanged:
            return "OnAdditionsStateChanged";
        case VBoxEventType_OnNetworkAdapterChanged:
            return "OnNetworkAdapterChanged";
        case VBoxEventType_OnSerialPortChanged:
            return "OnSerialPortChanged";
        case VBoxEventType_OnParallelPortChanged:
            return "OnParallelPortChanged";
        case VBoxEventType_OnStorageControllerChanged:
            return "OnStorageControllerChanged";
        case VBoxEventType_OnMediumChanged:
            return "OnMediumChanged";
        case VBoxEventType_OnVRDEServerChanged:
            return "OnVRDEServerChanged";
        case VBoxEventType_OnUSBControllerChanged:
            return "OnUSBControllerChanged";
        case VBoxEventType_OnUSBDeviceStateChanged:
            return "OnUSBDeviceStateChanged";
        case VBoxEventType_OnSharedFolderChanged:
            return "OnSharedFolderChanged";
        case VBoxEventType_OnRuntimeError:
            return "OnRuntimeError";
        case VBoxEventType_OnCanShowWindow:
            return "OnCanShowWindow";
        case VBoxEventType_OnShowWindow:
            return "OnShowWindow";
        case VBoxEventType_OnCPUChanged:
            return "OnCPUChanged";
        case VBoxEventType_OnVRDEServerInfoChanged:
            return "OnVRDEServerInfoChanged";
        case VBoxEventType_OnEventSourceChanged:
            return "OnEventSourceChanged";
        case VBoxEventType_OnCPUExecutionCapChanged:
            return "OnCPUExecutionCapChanged";
        case VBoxEventType_OnGuestKeyboard:
            return "OnGuestKeyboard";
        case VBoxEventType_OnGuestMouse:
            return "OnGuestMouse";
        case VBoxEventType_OnNATRedirect:
            return "OnNATRedirect";
        case VBoxEventType_OnHostPCIDevicePlug:
            return "OnHostPCIDevicePlug";
        case VBoxEventType_OnVBoxSVCAvailabilityChanged:
            return "OnVBoxSVCAvailabilityChanged";
        case VBoxEventType_OnBandwidthGroupChanged:
            return "OnBandwidthGroupChanged";
        case VBoxEventType_OnGuestMonitorChanged:
            return "OnGuestMonitorChanged";
        case VBoxEventType_OnStorageDeviceChanged:
            return "OnStorageDeviceChanged";
        case VBoxEventType_OnClipboardModeChanged:
            return "OnClipboardModeChanged";
        case VBoxEventType_OnDnDModeChanged:
            return "OnDnDModeChanged";
        case VBoxEventType_OnNATNetworkChanged:
            return "OnNATNetworkChanged";
        case VBoxEventType_OnNATNetworkStartStop:
            return "OnNATNetworkStartStop";
        case VBoxEventType_OnNATNetworkAlter:
            return "OnNATNetworkAlter";
        case VBoxEventType_OnNATNetworkCreationDeletion:
            return "OnNATNetworkCreationDeletion";
        case VBoxEventType_OnNATNetworkSetting:
            return "OnNATNetworkSetting";
        case VBoxEventType_OnNATNetworkPortForward:
            return "OnNATNetworkPortForward";
        case VBoxEventType_OnGuestSessionStateChanged:
            return "OnGuestSessionStateChanged";
        case VBoxEventType_OnGuestSessionRegistered:
            return "OnGuestSessionRegistered";
        case VBoxEventType_OnGuestProcessRegistered:
            return "OnGuestProcessRegistered";
        case VBoxEventType_OnGuestProcessStateChanged:
            return "OnGuestProcessStateChanged";
        case VBoxEventType_OnGuestProcessInputNotify:
            return "OnGuestProcessInputNotify";
        case VBoxEventType_OnGuestProcessOutput:
            return "OnGuestProcessOutput";
        case VBoxEventType_OnGuestFileRegistered:
            return "OnGuestFileRegistered";
        case VBoxEventType_OnGuestFileStateChanged:
            return "OnGuestFileStateChanged";
        case VBoxEventType_OnGuestFileOffsetChanged:
            return "OnGuestFileOffsetChanged";
        case VBoxEventType_OnGuestFileRead:
            return "OnGuestFileRead";
        case VBoxEventType_OnGuestFileWrite:
            return "OnGuestFileWrite";
        case VBoxEventType_OnRecordingStateChanged:
            return "OnRecordingStateChanged";
        case VBoxEventType_OnGuestUserStateChanged:
            return "OnGuestUserStateChanged";
        case VBoxEventType_OnGuestMultiTouch:
            return "OnGuestMultiTouch";
        case VBoxEventType_OnHostNameResolutionConfigurationChange:
            return "OnHostNameResolutionConfigurationChange";
        case VBoxEventType_OnSnapshotRestored:
            return "OnSnapshotRestored";
        case VBoxEventType_OnMediumConfigChanged:
            return "OnMediumConfigChanged";
        case VBoxEventType_OnAudioAdapterChanged:
            return "OnAudioAdapterChanged";
        case VBoxEventType_OnProgressPercentageChanged:
            return "OnProgressPercentageChanged";
        case VBoxEventType_OnProgressTaskCompleted:
            return "OnProgressTaskCompleted";
        case VBoxEventType_OnCursorPositionChanged:
            return "OnCursorPositionChanged";
        case VBoxEventType_OnGuestAdditionsStatusChanged:
            return "OnGuestAdditionsStatusChanged";
        case VBoxEventType_OnGuestMonitorInfoChanged:
            return "OnGuestMonitorInfoChanged";
        case VBoxEventType_OnGuestFileSizeChanged:
            return "OnGuestFileSizeChanged";
        case VBoxEventType_OnClipboardFileTransferModeChanged:
            return "OnClipboardFileTransferModeChanged";
        case VBoxEventType_OnCloudProviderListChanged:
            return "OnCloudProviderListChanged";
        case VBoxEventType_OnCloudProviderRegistered:
            return "OnCloudProviderRegistered";
        case VBoxEventType_OnCloudProviderUninstall:
            return "OnCloudProviderUninstall";
        case VBoxEventType_OnCloudProfileRegistered:
            return "OnCloudProfileRegistered";
        case VBoxEventType_OnCloudProfileChanged:
            return "OnCloudProfileChanged";
        case VBoxEventType_OnProgressCreated:
            return "OnProgressCreated";
        case VBoxEventType_OnLanguageChanged:
            return "OnLanguageChanged";
        case VBoxEventType_OnUpdateAgentAvailable:
            return "OnUpdateAgentAvailable";
        case VBoxEventType_OnUpdateAgentError:
            return "OnUpdateAgentError";
        case VBoxEventType_OnUpdateAgentSettingsChanged:
            return "OnUpdateAgentSettingsChanged";
        case VBoxEventType_OnUpdateAgentStateChanged:
            return "OnUpdateAgentStateChanged";
        case VBoxEventType_OnHostAudioDeviceChanged:
            return "OnHostAudioDeviceChanged";
        case VBoxEventType_OnGuestDebugControlChanged:
            return "OnGuestDebugControlChanged";
        case VBoxEventType_OnMachineGroupsChanged:
            return "OnMachineGroupsChanged";
        case VBoxEventType_OnGuestDirectoryRegistered:
            return "OnGuestDirectoryRegistered";
        case VBoxEventType_OnGuestDirectoryStateChanged:
            return "OnGuestDirectoryStateChanged";
        case VBoxEventType_OnGuestDirectoryRead:
            return "OnGuestDirectoryRead";
        case VBoxEventType_OnClipboardError:
            return "OnClipboardError";
        case VBoxEventType_OnExtPackInstalled:
            return "OnExtPackInstalled";
        case VBoxEventType_OnExtPackUninstalled:
            return "OnExtPackUninstalled";
        case VBoxEventType_OnRecordingScreenStateChanged:
            return "OnRecordingScreenStateChanged";
        case VBoxEventType_End:
            return "End";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("VBoxEventType", (int)aValue));
    }
}


const char *stringifyGuestMouseEventMode(GuestMouseEventMode_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case GuestMouseEventMode_Relative:
            return "Relative";
        case GuestMouseEventMode_Absolute:
            return "Absolute";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("GuestMouseEventMode", (int)aValue));
    }
}


const char *stringifyGuestMonitorChangedEventType(GuestMonitorChangedEventType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case GuestMonitorChangedEventType_Enabled:
            return "Enabled";
        case GuestMonitorChangedEventType_Disabled:
            return "Disabled";
        case GuestMonitorChangedEventType_NewOrigin:
            return "NewOrigin";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("GuestMonitorChangedEventType", (int)aValue));
    }
}


const char *stringifyFormValueType(FormValueType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case FormValueType_Boolean:
            return "Boolean";
        case FormValueType_String:
            return "String";
        case FormValueType_Choice:
            return "Choice";
        case FormValueType_RangedInteger:
            return "RangedInteger";
        case FormValueType_RangedInteger64:
            return "RangedInteger64";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("FormValueType", (int)aValue));
    }
}


const char *stringifyCloudMachineState(CloudMachineState_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case CloudMachineState_Invalid:
            return "Invalid";
        case CloudMachineState_Provisioning:
            return "Provisioning";
        case CloudMachineState_Running:
            return "Running";
        case CloudMachineState_Starting:
            return "Starting";
        case CloudMachineState_Stopping:
            return "Stopping";
        case CloudMachineState_Stopped:
            return "Stopped";
        case CloudMachineState_CreatingImage:
            return "CreatingImage";
        case CloudMachineState_Terminating:
            return "Terminating";
        case CloudMachineState_Terminated:
            return "Terminated";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("CloudMachineState", (int)aValue));
    }
}


const char *stringifyCloudImageState(CloudImageState_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case CloudImageState_Invalid:
            return "Invalid";
        case CloudImageState_Provisioning:
            return "Provisioning";
        case CloudImageState_Importing:
            return "Importing";
        case CloudImageState_Available:
            return "Available";
        case CloudImageState_Exporting:
            return "Exporting";
        case CloudImageState_Disabled:
            return "Disabled";
        case CloudImageState_Deleted:
            return "Deleted";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("CloudImageState", (int)aValue));
    }
}


const char *stringifyMetricType(MetricType_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case MetricType_Invalid:
            return "Invalid";
        case MetricType_CpuUtilization:
            return "CpuUtilization";
        case MetricType_MemoryUtilization:
            return "MemoryUtilization";
        case MetricType_DiskBytesRead:
            return "DiskBytesRead";
        case MetricType_DiskBytesWritten:
            return "DiskBytesWritten";
        case MetricType_NetworksBytesIn:
            return "NetworksBytesIn";
        case MetricType_NetworksBytesOut:
            return "NetworksBytesOut";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("MetricType", (int)aValue));
    }
}


const char *stringifySymlinkPolicy(SymlinkPolicy_T aValue) RT_NOEXCEPT
{
    switch (aValue)
    {
        case SymlinkPolicy_None:
            return "None";
        case SymlinkPolicy_Forbidden:
            return "Forbidden";
        case SymlinkPolicy_AllowedInShareSubtree:
            return "AllowedInShareSubtree";
        case SymlinkPolicy_AllowedToRelativeTargets:
            return "AllowedToRelativeTargets";
        case SymlinkPolicy_AllowedToAnyTarget:
            return "AllowedToAnyTarget";
        default:
            AssertMsgFailedReturn(("%d / %#x\n", aValue, aValue), formatUnknown("SymlinkPolicy", (int)aValue));
    }
}
