/** @file
 * VirtualBox API class wrapper code for IHostDrive.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2026 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_HOSTDRIVE

#include "HostDriveWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(HostDriveWrap)

//
// IHostDrive properties
//

STDMETHODIMP HostDriveWrap::COMGETTER(DrivePath)(BSTR *aDrivePath)
{
    LogRelFlow(("{%p} %s: enter aDrivePath=%p\n", this, "HostDrive::getDrivePath", aDrivePath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDrivePath);
        BSTROutConverter TmpDrivePath(aDrivePath);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVE_GET_DRIVEPATH_ENTER(this);
#endif
        AutoLimitedCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDrivePath(TmpDrivePath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVE_GET_DRIVEPATH_RETURN(this, hrc, 0 /*normal*/,TmpDrivePath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVE_GET_DRIVEPATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVE_GET_DRIVEPATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDrivePath=%ls hrc=%Rhrc\n", this, "HostDrive::getDrivePath", *aDrivePath, hrc));
    return hrc;
}

STDMETHODIMP HostDriveWrap::COMGETTER(PartitioningType)(PartitioningType_T *aPartitioningType)
{
    LogRelFlow(("{%p} %s: enter aPartitioningType=%p\n", this, "HostDrive::getPartitioningType", aPartitioningType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPartitioningType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVE_GET_PARTITIONINGTYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPartitioningType(aPartitioningType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVE_GET_PARTITIONINGTYPE_RETURN(this, hrc, 0 /*normal*/,*aPartitioningType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVE_GET_PARTITIONINGTYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aPartitioningType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVE_GET_PARTITIONINGTYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aPartitioningType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPartitioningType=%RU32 hrc=%Rhrc\n", this, "HostDrive::getPartitioningType", *aPartitioningType, hrc));
    return hrc;
}

STDMETHODIMP HostDriveWrap::COMGETTER(Uuid)(BSTR *aUuid)
{
    LogRelFlow(("{%p} %s: enter aUuid=%p\n", this, "HostDrive::getUuid", aUuid));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUuid);
        UuidOutConverter TmpUuid(aUuid);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVE_GET_UUID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUuid(TmpUuid.uuid());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVE_GET_UUID_RETURN(this, hrc, 0 /*normal*/,TmpUuid.uuid().toStringCurly().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVE_GET_UUID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVE_GET_UUID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aUuid=%ls hrc=%Rhrc\n", this, "HostDrive::getUuid", *aUuid, hrc));
    return hrc;
}

STDMETHODIMP HostDriveWrap::COMGETTER(SectorSize)(ULONG *aSectorSize)
{
    LogRelFlow(("{%p} %s: enter aSectorSize=%p\n", this, "HostDrive::getSectorSize", aSectorSize));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSectorSize);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVE_GET_SECTORSIZE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSectorSize(aSectorSize);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVE_GET_SECTORSIZE_RETURN(this, hrc, 0 /*normal*/,*aSectorSize);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVE_GET_SECTORSIZE_RETURN(this, hrc, 1 /*hrc exception*/,*aSectorSize);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVE_GET_SECTORSIZE_RETURN(this, hrc, 9 /*unhandled exception*/,*aSectorSize);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSectorSize=%RU32 hrc=%Rhrc\n", this, "HostDrive::getSectorSize", *aSectorSize, hrc));
    return hrc;
}

STDMETHODIMP HostDriveWrap::COMGETTER(Size)(LONG64 *aSize)
{
    LogRelFlow(("{%p} %s: enter aSize=%p\n", this, "HostDrive::getSize", aSize));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSize);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVE_GET_SIZE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSize(aSize);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVE_GET_SIZE_RETURN(this, hrc, 0 /*normal*/,*aSize);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVE_GET_SIZE_RETURN(this, hrc, 1 /*hrc exception*/,*aSize);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVE_GET_SIZE_RETURN(this, hrc, 9 /*unhandled exception*/,*aSize);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSize=%RI64 hrc=%Rhrc\n", this, "HostDrive::getSize", *aSize, hrc));
    return hrc;
}

STDMETHODIMP HostDriveWrap::COMGETTER(Model)(BSTR *aModel)
{
    LogRelFlow(("{%p} %s: enter aModel=%p\n", this, "HostDrive::getModel", aModel));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aModel);
        BSTROutConverter TmpModel(aModel);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVE_GET_MODEL_ENTER(this);
#endif
        AutoLimitedCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getModel(TmpModel.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVE_GET_MODEL_RETURN(this, hrc, 0 /*normal*/,TmpModel.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVE_GET_MODEL_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVE_GET_MODEL_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aModel=%ls hrc=%Rhrc\n", this, "HostDrive::getModel", *aModel, hrc));
    return hrc;
}

STDMETHODIMP HostDriveWrap::COMGETTER(Partitions)(ComSafeArrayOut(IHostDrivePartition *, aPartitions))
{
    LogRelFlow(("{%p} %s: enter aPartitions=%p\n", this, "HostDrive::getPartitions", aPartitions));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPartitions);
        ArrayComTypeOutConverter<IHostDrivePartition> TmpPartitions(ComSafeArrayOutArg(aPartitions));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVE_GET_PARTITIONS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPartitions(TmpPartitions.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVE_GET_PARTITIONS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpPartitions.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVE_GET_PARTITIONS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVE_GET_PARTITIONS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPartitions=%zu hrc=%Rhrc\n", this, "HostDrive::getPartitions", ComSafeArraySize(*aPartitions), hrc));
    return hrc;
}


//
// IHostDrive methods
//

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(HostDriveWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(HostDriveWrap, IHostDrive)
#endif // VBOX_WITH_XPCOM
