/*
 * Copyright (C) 2016-2017 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NO EDIT! - This file was generated by /build/webkitgtk-6.0/src/webkitgtk-2.50.5/Source/JavaScriptCore/wasm/generateWasmOMGIRGeneratorInlinesHeader.py

#pragma once

#if ENABLE(WEBASSEMBLY)

namespace JSC { namespace Wasm {


auto OMGIRGenerator::addI32Add(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Add, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI32Sub(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Sub, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI32Mul(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Mul, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI32And(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::BitAnd, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI32Or(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::BitOr, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI32Xor(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::BitXor, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI32Shl(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Shl, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI32ShrU(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::ZShr, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI32ShrS(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::SShr, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI32Rotr(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::RotR, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI32Rotl(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::RotL, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI32Eq(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Equal, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI32Ne(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::NotEqual, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI32LtS(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::LessThan, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI32LeS(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::LessEqual, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI32LtU(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Below, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI32LeU(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::BelowEqual, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI32GtS(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::GreaterThan, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI32GeS(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::GreaterEqual, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI32GtU(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Above, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI32GeU(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::AboveEqual, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI32Clz(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Clz, origin(), get(arg0));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI32Eqz(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp4 = constant(Int32, 0);
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Equal, origin(), temp4, get(arg0));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI64Add(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Add, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI64Sub(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Sub, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI64Mul(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Mul, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI64And(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::BitAnd, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI64Or(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::BitOr, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI64Xor(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::BitXor, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI64Shl(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp3 = m_currentBlock->appendNew<Value>(m_proc, B3::Trunc, origin(), get(arg1));
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Shl, origin(), get(arg0), temp3);
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI64ShrU(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp3 = m_currentBlock->appendNew<Value>(m_proc, B3::Trunc, origin(), get(arg1));
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::ZShr, origin(), get(arg0), temp3);
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI64ShrS(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp3 = m_currentBlock->appendNew<Value>(m_proc, B3::Trunc, origin(), get(arg1));
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::SShr, origin(), get(arg0), temp3);
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI64Rotr(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp3 = m_currentBlock->appendNew<Value>(m_proc, B3::Trunc, origin(), get(arg1));
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::RotR, origin(), get(arg0), temp3);
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI64Rotl(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp3 = m_currentBlock->appendNew<Value>(m_proc, B3::Trunc, origin(), get(arg1));
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::RotL, origin(), get(arg0), temp3);
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI64Eq(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Equal, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI64Ne(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::NotEqual, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI64LtS(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::LessThan, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI64LeS(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::LessEqual, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI64LtU(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Below, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI64LeU(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::BelowEqual, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI64GtS(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::GreaterThan, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI64GeS(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::GreaterEqual, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI64GtU(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Above, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI64GeU(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::AboveEqual, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI64Clz(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Clz, origin(), get(arg0));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI64Eqz(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp4 = constant(Int64, 0);
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Equal, origin(), temp4, get(arg0));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF32Add(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Add, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF32Sub(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Sub, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF32Mul(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Mul, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF32Div(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Div, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF32Min(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::FMin, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF32Max(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::FMax, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF32Abs(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Abs, origin(), get(arg0));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF32Neg(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Neg, origin(), get(arg0));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF32Copysign(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp6 = m_currentBlock->appendNew<Value>(m_proc, B3::BitwiseCast, origin(), get(arg1));
    Value* temp12 = constant(Int32, 0x80000000);
    Value* temp4 = m_currentBlock->appendNew<Value>(m_proc, B3::BitAnd, origin(), temp6, temp12);
    Value* temp17 = m_currentBlock->appendNew<Value>(m_proc, B3::BitwiseCast, origin(), get(arg0));
    Value* temp23 = constant(Int32, 0x7fffffff);
    Value* temp15 = m_currentBlock->appendNew<Value>(m_proc, B3::BitAnd, origin(), temp17, temp23);
    Value* temp2 = m_currentBlock->appendNew<Value>(m_proc, B3::BitOr, origin(), temp4, temp15);
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::BitwiseCast, origin(), temp2);
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF32Ceil(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Ceil, origin(), get(arg0));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF32Floor(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Floor, origin(), get(arg0));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF32Trunc(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::FTrunc, origin(), get(arg0));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF32Sqrt(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Sqrt, origin(), get(arg0));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF32Eq(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Equal, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF32Ne(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::NotEqual, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF32Lt(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::LessThan, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF32Le(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::LessEqual, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF32Gt(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::GreaterThan, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF32Ge(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::GreaterEqual, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF64Add(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Add, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF64Sub(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Sub, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF64Mul(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Mul, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF64Div(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Div, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF64Min(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::FMin, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF64Max(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::FMax, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF64Abs(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Abs, origin(), get(arg0));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF64Neg(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Neg, origin(), get(arg0));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF64Copysign(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp6 = m_currentBlock->appendNew<Value>(m_proc, B3::BitwiseCast, origin(), get(arg1));
    Value* temp12 = constant(Int64, 0x8000000000000000);
    Value* temp4 = m_currentBlock->appendNew<Value>(m_proc, B3::BitAnd, origin(), temp6, temp12);
    Value* temp17 = m_currentBlock->appendNew<Value>(m_proc, B3::BitwiseCast, origin(), get(arg0));
    Value* temp23 = constant(Int64, 0x7fffffffffffffff);
    Value* temp15 = m_currentBlock->appendNew<Value>(m_proc, B3::BitAnd, origin(), temp17, temp23);
    Value* temp2 = m_currentBlock->appendNew<Value>(m_proc, B3::BitOr, origin(), temp4, temp15);
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::BitwiseCast, origin(), temp2);
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF64Ceil(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Ceil, origin(), get(arg0));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF64Floor(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Floor, origin(), get(arg0));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF64Trunc(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::FTrunc, origin(), get(arg0));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF64Sqrt(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Sqrt, origin(), get(arg0));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF64Eq(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Equal, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF64Ne(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::NotEqual, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF64Lt(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::LessThan, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF64Le(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::LessEqual, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF64Gt(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::GreaterThan, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF64Ge(ExpressionType arg0, ExpressionType arg1, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::GreaterEqual, origin(), get(arg0), get(arg1));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI32WrapI64(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::Trunc, origin(), get(arg0));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI64ExtendSI32(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::SExt32, origin(), get(arg0));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI64ExtendUI32(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::ZExt32, origin(), get(arg0));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF32ConvertSI32(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::IToF, origin(), get(arg0));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF32ConvertUI32(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp2 = m_currentBlock->appendNew<Value>(m_proc, B3::ZExt32, origin(), get(arg0));
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::IToF, origin(), temp2);
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF32ConvertSI64(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::IToF, origin(), get(arg0));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF32DemoteF64(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::DoubleToFloat, origin(), get(arg0));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF32ReinterpretI32(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::BitwiseCast, origin(), get(arg0));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF64ConvertSI32(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::IToD, origin(), get(arg0));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF64ConvertUI32(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp2 = m_currentBlock->appendNew<Value>(m_proc, B3::ZExt32, origin(), get(arg0));
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::IToD, origin(), temp2);
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF64ConvertSI64(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::IToD, origin(), get(arg0));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF64PromoteF32(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::FloatToDouble, origin(), get(arg0));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addF64ReinterpretI64(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::BitwiseCast, origin(), get(arg0));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI32ReinterpretF32(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::BitwiseCast, origin(), get(arg0));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI64ReinterpretF64(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::BitwiseCast, origin(), get(arg0));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI32Extend8S(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::SExt8, origin(), get(arg0));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI32Extend16S(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::SExt16, origin(), get(arg0));
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI64Extend8S(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp4 = m_currentBlock->appendNew<Value>(m_proc, B3::Trunc, origin(), get(arg0));
    Value* temp2 = m_currentBlock->appendNew<Value>(m_proc, B3::SExt8, origin(), temp4);
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::SExt32, origin(), temp2);
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI64Extend16S(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp4 = m_currentBlock->appendNew<Value>(m_proc, B3::Trunc, origin(), get(arg0));
    Value* temp2 = m_currentBlock->appendNew<Value>(m_proc, B3::SExt16, origin(), temp4);
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::SExt32, origin(), temp2);
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}

auto OMGIRGenerator::addI64Extend32S(ExpressionType arg0, ExpressionType& result) -> PartialResult
{
    Value* temp2 = m_currentBlock->appendNew<Value>(m_proc, B3::Trunc, origin(), get(arg0));
    Value* temp0 = m_currentBlock->appendNew<Value>(m_proc, B3::SExt32, origin(), temp2);
    Value* resultValue = temp0;
    result = push(resultValue);
    return { };
}


} } // namespace JSC::Wasm

#endif // ENABLE(WEBASSEMBLY)

