/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMFileSystem.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSFileSystemDirectoryEntry.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsDOMFileSystemConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMFileSystem_name);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMFileSystem_root);

class JSDOMFileSystemPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDOMFileSystemPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDOMFileSystemPrototype* ptr = new (NotNull, JSC::allocateCell<JSDOMFileSystemPrototype>(vm)) JSDOMFileSystemPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDOMFileSystemPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDOMFileSystemPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDOMFileSystemPrototype, JSDOMFileSystemPrototype::Base);

using JSDOMFileSystemDOMConstructor = JSDOMConstructorNotConstructable<JSDOMFileSystem>;

template<> const ClassInfo JSDOMFileSystemDOMConstructor::s_info = { "FileSystem"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMFileSystemDOMConstructor) };

template<> JSValue JSDOMFileSystemDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDOMFileSystemDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "FileSystem"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSDOMFileSystem::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 3> JSDOMFileSystemPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMFileSystemConstructor, 0 } },
    HashTableValue { "name"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMFileSystem_name, 0 } },
    HashTableValue { "root"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMFileSystem_root, 0 } },
};

const ClassInfo JSDOMFileSystemPrototype::s_info = { "FileSystem"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMFileSystemPrototype) };

void JSDOMFileSystemPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDOMFileSystem::info(), JSDOMFileSystemPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSDOMFileSystem::s_info = { "FileSystem"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMFileSystem) };

JSDOMFileSystem::JSDOMFileSystem(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DOMFileSystem>&& impl)
    : JSDOMWrapper<DOMFileSystem>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, DOMFileSystem>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSDOMFileSystem::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSDOMFileSystemPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSDOMFileSystemPrototype::create(vm, &globalObject, structure);
}

JSObject* JSDOMFileSystem::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDOMFileSystem>(vm, globalObject);
}

JSValue JSDOMFileSystem::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMFileSystemDOMConstructor, DOMConstructorID::DOMFileSystem>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSDOMFileSystem::destroy(JSC::JSCell* cell)
{
    JSDOMFileSystem* thisObject = static_cast<JSDOMFileSystem*>(cell);
    thisObject->JSDOMFileSystem::~JSDOMFileSystem();
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMFileSystemConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDOMFileSystemPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDOMFileSystem::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsDOMFileSystem_nameGetter(JSGlobalObject& lexicalGlobalObject, JSDOMFileSystem& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.name())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMFileSystem_name, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMFileSystem>::get<jsDOMFileSystem_nameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMFileSystem_rootGetter(JSGlobalObject& lexicalGlobalObject, JSDOMFileSystem& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    if (JSValue cachedValue = thisObject.m_root.get())
        return cachedValue;
    auto* context = jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return jsUndefined();
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<FileSystemDirectoryEntry>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.root(*context));
    RETURN_IF_EXCEPTION(throwScope, { });
    thisObject.m_root.set(JSC::getVM(&lexicalGlobalObject), &thisObject, result);
    return result;
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMFileSystem_root, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMFileSystem>::get<jsDOMFileSystem_rootGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSDOMFileSystem::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSDOMFileSystem, UseCustomHeapCellType::No>(vm, "JSDOMFileSystem"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForDOMFileSystem.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForDOMFileSystem = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForDOMFileSystem.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForDOMFileSystem = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSDOMFileSystem::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSDOMFileSystem*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    visitor.append(thisObject->m_root);
}

DEFINE_VISIT_CHILDREN(JSDOMFileSystem);

void JSDOMFileSystem::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDOMFileSystem*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSDOMFileSystemOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSDOMFileSystemOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDOMFileSystem = static_cast<JSDOMFileSystem*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsDOMFileSystem->protectedWrapped().ptr(), jsDOMFileSystem);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7DOMFileSystem@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore13DOMFileSystemE[]; }
#endif
template<std::same_as<DOMFileSystem> T>
static inline void verifyVTable(DOMFileSystem* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7DOMFileSystem@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore13DOMFileSystemE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // DOMFileSystem has subclasses. If DOMFileSystem has subclasses that get passed
        // to toJS() we currently require DOMFileSystem you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<DOMFileSystem>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<DOMFileSystem>(impl.ptr());
#endif
    return createWrapper<DOMFileSystem>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, DOMFileSystem& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

DOMFileSystem* JSDOMFileSystem::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDOMFileSystem*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
