/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCanvasRenderingContext2DSettings.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMGlobalObject.h"
#include "JSPredefinedColorSpace.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<CanvasRenderingContext2DSettings>> convertDictionary<CanvasRenderingContext2DSettings>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    CanvasRenderingContext2DSettings result;
    if (jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext()->settingsValues().canvasColorSpaceEnabled) {
        JSValue colorSpaceValue;
        if (isNullOrUndefined)
            colorSpaceValue = jsUndefined();
        else {
            colorSpaceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "colorSpace"_s));
            RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
        }
        auto colorSpaceConversionResult = convertOptionalWithDefault<IDLEnumeration<PredefinedColorSpace>>(lexicalGlobalObject, colorSpaceValue, [&]() -> ConversionResult<IDLEnumeration<PredefinedColorSpace>> { return Converter<IDLEnumeration<PredefinedColorSpace>>::ReturnType { PredefinedColorSpace::SRGB }; });
        if (colorSpaceConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.colorSpace = colorSpaceConversionResult.releaseReturnValue();
    }
    JSValue desynchronizedValue;
    if (isNullOrUndefined)
        desynchronizedValue = jsUndefined();
    else {
        desynchronizedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "desynchronized"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto desynchronizedConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, desynchronizedValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (desynchronizedConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.desynchronized = desynchronizedConversionResult.releaseReturnValue();
    if (jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext()->settingsValues().canvasPixelFormatEnabled) {
        JSValue pixelFormatValue;
        if (isNullOrUndefined)
            pixelFormatValue = jsUndefined();
        else {
            pixelFormatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "pixelFormat"_s));
            RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
        }
        auto pixelFormatConversionResult = convertOptionalWithDefault<IDLEnumeration<CanvasRenderingContext2DSettings::PixelFormat>>(lexicalGlobalObject, pixelFormatValue, [&]() -> ConversionResult<IDLEnumeration<CanvasRenderingContext2DSettings::PixelFormat>> { return Converter<IDLEnumeration<CanvasRenderingContext2DSettings::PixelFormat>>::ReturnType { CanvasRenderingContext2DSettings::PixelFormat::Uint8 }; });
        if (pixelFormatConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.pixelFormat = pixelFormatConversionResult.releaseReturnValue();
    }
    if (jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext()->settingsValues().domTestingAPIsEnabled) {
        JSValue renderingModeForTestingValue;
        if (isNullOrUndefined)
            renderingModeForTestingValue = jsUndefined();
        else {
            renderingModeForTestingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "renderingModeForTesting"_s));
            RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
        }
        if (!renderingModeForTestingValue.isUndefined()) {
            auto renderingModeForTestingConversionResult = convert<IDLNullable<IDLEnumeration<CanvasRenderingContext2DSettings::RenderingMode>>>(lexicalGlobalObject, renderingModeForTestingValue);
            if (renderingModeForTestingConversionResult.hasException(throwScope)) [[unlikely]]
                return ConversionResultException { };
            result.renderingModeForTesting = renderingModeForTestingConversionResult.releaseReturnValue();
        }
    }
    JSValue willReadFrequentlyValue;
    if (isNullOrUndefined)
        willReadFrequentlyValue = jsUndefined();
    else {
        willReadFrequentlyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "willReadFrequently"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto willReadFrequentlyConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, willReadFrequentlyValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (willReadFrequentlyConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.willReadFrequently = willReadFrequentlyConversionResult.releaseReturnValue();
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const CanvasRenderingContext2DSettings& dictionary)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext()->settingsValues().canvasColorSpaceEnabled) {
        auto colorSpaceValue = toJS<IDLEnumeration<PredefinedColorSpace>>(lexicalGlobalObject, throwScope, dictionary.colorSpace);
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "colorSpace"_s), colorSpaceValue);
    }
    auto desynchronizedValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.desynchronized);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "desynchronized"_s), desynchronizedValue);
    if (jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext()->settingsValues().canvasPixelFormatEnabled) {
        auto pixelFormatValue = toJS<IDLEnumeration<CanvasRenderingContext2DSettings::PixelFormat>>(lexicalGlobalObject, throwScope, dictionary.pixelFormat);
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "pixelFormat"_s), pixelFormatValue);
    }
    if (jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext()->settingsValues().domTestingAPIsEnabled) {
        if (!IDLNullable<IDLEnumeration<CanvasRenderingContext2DSettings::RenderingMode>>::isNullValue(dictionary.renderingModeForTesting)) {
            auto renderingModeForTestingValue = toJS<IDLNullable<IDLEnumeration<CanvasRenderingContext2DSettings::RenderingMode>>>(lexicalGlobalObject, throwScope, IDLNullable<IDLEnumeration<CanvasRenderingContext2DSettings::RenderingMode>>::extractValueFromNullable(dictionary.renderingModeForTesting));
            RETURN_IF_EXCEPTION(throwScope, { });
            result->putDirect(vm, JSC::Identifier::fromString(vm, "renderingModeForTesting"_s), renderingModeForTestingValue);
        }
    }
    auto willReadFrequentlyValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.willReadFrequently);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "willReadFrequently"_s), willReadFrequentlyValue);
    return result;
}

String convertEnumerationToString(CanvasRenderingContext2DSettings::PixelFormat enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 2> values {
        MAKE_STATIC_STRING_IMPL("uint8"),
        MAKE_STATIC_STRING_IMPL("float16"),
    };
    static_assert(static_cast<size_t>(CanvasRenderingContext2DSettings::PixelFormat::Uint8) == 0, "CanvasRenderingContext2DSettings::PixelFormat::Uint8 is not 0 as expected");
    static_assert(static_cast<size_t>(CanvasRenderingContext2DSettings::PixelFormat::Float16) == 1, "CanvasRenderingContext2DSettings::PixelFormat::Float16 is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, CanvasRenderingContext2DSettings::PixelFormat enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<CanvasRenderingContext2DSettings::PixelFormat> parseEnumerationFromString<CanvasRenderingContext2DSettings::PixelFormat>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, CanvasRenderingContext2DSettings::PixelFormat>, 2> mappings {
        std::pair<ComparableASCIILiteral, CanvasRenderingContext2DSettings::PixelFormat> { "float16"_s, CanvasRenderingContext2DSettings::PixelFormat::Float16 },
        std::pair<ComparableASCIILiteral, CanvasRenderingContext2DSettings::PixelFormat> { "uint8"_s, CanvasRenderingContext2DSettings::PixelFormat::Uint8 },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<CanvasRenderingContext2DSettings::PixelFormat> parseEnumeration<CanvasRenderingContext2DSettings::PixelFormat>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<CanvasRenderingContext2DSettings::PixelFormat>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<CanvasRenderingContext2DSettings::PixelFormat>()
{
    return "\"uint8\", \"float16\""_s;
}

String convertEnumerationToString(CanvasRenderingContext2DSettings::RenderingMode enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 2> values {
        MAKE_STATIC_STRING_IMPL("Unaccelerated"),
        MAKE_STATIC_STRING_IMPL("Accelerated"),
    };
    static_assert(static_cast<size_t>(CanvasRenderingContext2DSettings::RenderingMode::Unaccelerated) == 0, "CanvasRenderingContext2DSettings::RenderingMode::Unaccelerated is not 0 as expected");
    static_assert(static_cast<size_t>(CanvasRenderingContext2DSettings::RenderingMode::Accelerated) == 1, "CanvasRenderingContext2DSettings::RenderingMode::Accelerated is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, CanvasRenderingContext2DSettings::RenderingMode enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<CanvasRenderingContext2DSettings::RenderingMode> parseEnumerationFromString<CanvasRenderingContext2DSettings::RenderingMode>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, CanvasRenderingContext2DSettings::RenderingMode>, 2> mappings {
        std::pair<ComparableASCIILiteral, CanvasRenderingContext2DSettings::RenderingMode> { "Accelerated"_s, CanvasRenderingContext2DSettings::RenderingMode::Accelerated },
        std::pair<ComparableASCIILiteral, CanvasRenderingContext2DSettings::RenderingMode> { "Unaccelerated"_s, CanvasRenderingContext2DSettings::RenderingMode::Unaccelerated },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<CanvasRenderingContext2DSettings::RenderingMode> parseEnumeration<CanvasRenderingContext2DSettings::RenderingMode>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<CanvasRenderingContext2DSettings::RenderingMode>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<CanvasRenderingContext2DSettings::RenderingMode>()
{
    return "\"Unaccelerated\", \"Accelerated\""_s;
}

} // namespace WebCore

