/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.MemberBox;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Slot;
import org.mozilla.javascript.Undefined;

public class AccessorSlot
extends Slot {
    private static final long serialVersionUID = 1677840254177335827L;
    transient Getter getter;
    transient Setter setter;

    AccessorSlot(Slot slot) {
        super(slot);
    }

    @Override
    boolean isValueSlot() {
        return false;
    }

    @Override
    boolean isSetterSlot() {
        return true;
    }

    @Override
    ScriptableObject getPropertyDescriptor(Context context, Scriptable scriptable) {
        Function function;
        String string;
        boolean bl;
        ScriptableObject scriptableObject = (ScriptableObject)context.newObject(scriptable);
        int n = this.getAttributes();
        boolean bl2 = bl = context.getLanguageVersion() >= 200;
        if (bl) {
            if (this.getter == null && this.setter == null) {
                scriptableObject.defineProperty("writable", (Object)((n & 1) == 0 ? 1 : 0), 0);
            }
        } else {
            scriptableObject.setCommonDescriptorProperties(n, this.getter == null && this.setter == null);
        }
        String string2 = string = this.name == null ? "f" : this.name.toString();
        if (this.getter != null) {
            function = this.getter.asGetterFunction(string, scriptable);
            scriptableObject.defineProperty("get", function == null ? Undefined.instance : function, 0);
        }
        if (this.setter != null) {
            function = this.setter.asSetterFunction(string, scriptable);
            scriptableObject.defineProperty("set", function == null ? Undefined.instance : function, 0);
        } else if (bl) {
            scriptableObject.defineProperty("set", Undefined.instance, 0);
        }
        if (bl) {
            scriptableObject.defineProperty("enumerable", (Object)((n & 2) == 0 ? 1 : 0), 0);
            scriptableObject.defineProperty("configurable", (Object)((n & 4) == 0 ? 1 : 0), 0);
        }
        return scriptableObject;
    }

    @Override
    public boolean setValue(Object object, Scriptable scriptable, Scriptable scriptable2, boolean bl) {
        if (this.setter == null) {
            if (this.getter != null) {
                this.throwNoSetterException(scriptable2, object);
                return true;
            }
        } else {
            return this.setter.setValue(object, scriptable, scriptable2);
        }
        return super.setValue(object, scriptable, scriptable2, bl);
    }

    @Override
    public Object getValue(Scriptable scriptable) {
        if (this.getter != null) {
            return this.getter.getValue(scriptable);
        }
        return super.getValue(scriptable);
    }

    @Override
    Function getSetterFunction(String string, Scriptable scriptable) {
        if (this.setter == null) {
            return null;
        }
        return this.setter.asSetterFunction(string, scriptable);
    }

    @Override
    Function getGetterFunction(String string, Scriptable scriptable) {
        if (this.getter == null) {
            return null;
        }
        return this.getter.asGetterFunction(string, scriptable);
    }

    static final class FunctionGetter
    implements Getter {
        final Object target;

        FunctionGetter(Object object) {
            this.target = object;
        }

        @Override
        public Object getValue(Scriptable scriptable) {
            if (this.target instanceof Function) {
                Function function = (Function)this.target;
                Context context = Context.getContext();
                return function.call(context, function.getParentScope(), scriptable, ScriptRuntime.emptyArgs);
            }
            return Undefined.instance;
        }

        @Override
        public Function asGetterFunction(String string, Scriptable scriptable) {
            return this.target instanceof Function ? (Function)this.target : null;
        }
    }

    static final class FunctionSetter
    implements Setter {
        final Object target;

        FunctionSetter(Object object) {
            this.target = object;
        }

        @Override
        public boolean setValue(Object object, Scriptable scriptable, Scriptable scriptable2) {
            if (this.target instanceof Function) {
                Function function = (Function)this.target;
                Context context = Context.getContext();
                function.call(context, function.getParentScope(), scriptable2, new Object[]{object});
            }
            return true;
        }

        @Override
        public Function asSetterFunction(String string, Scriptable scriptable) {
            return this.target instanceof Function ? (Function)this.target : null;
        }
    }

    static interface Getter {
        public Object getValue(Scriptable var1);

        public Function asGetterFunction(String var1, Scriptable var2);
    }

    static final class MemberBoxGetter
    implements Getter {
        final MemberBox member;

        MemberBoxGetter(MemberBox memberBox) {
            this.member = memberBox;
        }

        @Override
        public Object getValue(Scriptable scriptable) {
            if (this.member.delegateTo == null) {
                return this.member.invoke(scriptable, ScriptRuntime.emptyArgs);
            }
            return this.member.invoke(this.member.delegateTo, new Object[]{scriptable});
        }

        @Override
        public Function asGetterFunction(String string, Scriptable scriptable) {
            return this.member.asGetterFunction(string, scriptable);
        }
    }

    static final class MemberBoxSetter
    implements Setter {
        final MemberBox member;

        MemberBoxSetter(MemberBox memberBox) {
            this.member = memberBox;
        }

        @Override
        public boolean setValue(Object object, Scriptable scriptable, Scriptable scriptable2) {
            Context context = Context.getContext();
            Class<?>[] classArray = this.member.argTypes;
            Class<?> clazz = classArray[classArray.length - 1];
            int n = FunctionObject.getTypeTag(clazz);
            Object object2 = FunctionObject.convertArg(context, scriptable2, object, n);
            if (this.member.delegateTo == null) {
                this.member.invoke(scriptable2, new Object[]{object2});
            } else {
                this.member.invoke(this.member.delegateTo, new Object[]{scriptable2, object2});
            }
            return true;
        }

        @Override
        public Function asSetterFunction(String string, Scriptable scriptable) {
            return this.member.asSetterFunction(string, scriptable);
        }
    }

    static interface Setter {
        public boolean setValue(Object var1, Scriptable var2, Scriptable var3);

        public Function asSetterFunction(String var1, Scriptable var2);
    }
}

