---
stage: Plan
group: Product Planning
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Test cases in GitLab can help your teams create testing scenarios in their existing development platform.
title: テストケース
---

{{< details >}}

- プラン: Ultimate
- 製品: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

テストケースは、テスト計画をGitLabのワークフローに直接統合します。チームは次のことができます。

- コードを管理するのと同じプラットフォームでテストシナリオを文書化する。
- 開発タスクとともにテスト要件を追跡する。
- 実装チームとテストチーム間でテスト計画を共有する。
- 非公開設定でテストケースの表示レベルを管理する。
- 必要に応じて、テストケースのアーカイブまたは再オープンを行う。

チームはテストケースを使用することで、開発チームとテストチーム間のコラボレーションを効率化し、外部のテスト計画ツールが不要になります。

<i class="fa fa-youtube-play youtube" aria-hidden="true"></i> 開発ワークフローと統合しながら、イシューとエピックを使用して要件やテストニーズを管理する方法については、[ソフトウェア開発の効率化: 要件、テスト、開発ワークフローの統合](https://www.youtube.com/watch?v=wbfWM4y2VmM)を参照してください。
<!-- Video published on 2024-02-21 -->

## テストケースを作成する

{{< history >}}

- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

前提要件:

- プランナーロール以上を持っている必要があります。

GitLabプロジェクトでテストケースを作成するには:

1. 左側のサイドバーで、**検索または移動**を選択して、プロジェクトを見つけます。
1. **ビルド＞テストケース**を選択します。
1. **新しいテストケース**を選択します。新しいテストケースのフォームが表示されます。ここでは、新しいケースのタイトルと[説明](../../user/markdown.md)の入力、ファイルの添付、[ラベル](../../user/project/labels.md)の割り当てを行うことができます。
1. **テストケースを送信する**を選択します。新しいテストケースが表示されます。

## テストケースを表示する

プロジェクト内のすべてのテストケースは、テストケースリストで確認できます。ラベルやテストケースのタイトルなど、検索クエリを使用してイシューリストをフィルタリングできます。

前提要件:

- 公開プロジェクト内の非公開でないテストケース: プロジェクトのメンバーである必要はありません。
- プライベートプロジェクト内の非公開でないテストケース: プロジェクトのゲストロール以上を持っている必要があります。
- 非公開テストケース（プロジェクトの表示レベルに関係なく）: プロジェクトのプランナーロール以上を持っている必要があります。

テストケースを表示するには:

1. 左側のサイドバーで、**検索または移動**を選択して、プロジェクトを見つけます。
1. **ビルド＞テストケース**を選択します。
1. 表示するテストケースのタイトルを選択します。テストケースのページが表示されます。

![テストケースページの例](img/test_case_show_v13_10.png)

## テストケースを編集する

{{< history >}}

- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

テストケースのタイトルと説明を編集できます。

前提要件:

- プランナーロール以上を持っている必要があります。
- ゲストロールに降格されたユーザーは、より高いレベルのロールで作成したテストケースを引き続き編集できます。

テストケースを編集するには:

1. [テストケースを表示](#view-a-test-case)します。
1. **タイトルと説明を編集**（{{< icon name="pencil" >}}）を選択します。
1. テストケースのタイトルや説明を編集します。
1. **変更の保存**を選択します。

## テストケースを非公開に設定する

{{< history >}}

- GitLab 16.5で、[新しい](https://gitlab.com/gitlab-org/gitlab/-/issues/422121)テストケースと[既存](https://gitlab.com/gitlab-org/gitlab/-/issues/422120)のテストケースに対して導入されました。
- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

個人情報を含むテストケースで作業している場合は、そのテストケースを非公開に設定できます。

前提要件:

- プランナーロール以上を持っている必要があります。

テストケースを非公開に設定するには:

- [テストケースを作成](#create-a-test-case)するとき: **公開設定**で、**このテストケースは非公開です**チェックボックスを選択します。
- [テストケースを編集](#edit-a-test-case)するとき: 右側のサイドバーの**公開設定**の横にある**編集**を選択し、**有効にする**を選択します。

新しいテストケースを作成する際、または既存のテストケースを編集する際に、`/confidential` [クイック アクション](../../user/project/quick_actions.md)を使用することもできます。

## テストケースをアーカイブする

{{< history >}}

- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

テストケースの使用を停止する場合は、アーカイブすることができます。後で[アーカイブされたテストケースを再オープンする](#reopen-an-archived-test-case)ことができます。

前提要件:

- プランナーロール以上を持っている必要があります。

テストケースをアーカイブするには、テストケースのページで、**テストケースをアーカイブ**を選択します。

アーカイブされたテストケースを表示するには:

1. 左側のサイドバーで、**検索または移動**を選択して、プロジェクトを見つけます。
1. **ビルド＞テストケース**を選択します。
1. **アーカイブ済み**を選択します。

## アーカイブされたテストケースを再オープンする

{{< history >}}

- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

アーカイブされたテストケースを再度使用する場合は、再オープンすることができます。

前提要件:

- プランナーロール以上を持っている必要があります。

アーカイブされたテストケースを再オープンするには:

1. [テストケースを表示](#view-a-test-case)します。
1. **テストケースを再オープン**を選択します。
