/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.core;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.ec4j.core.model.PropertyType;

public class PropertyTypeRegistry {
    private final Map<String, PropertyType<?>> types;

    public static Builder builder() {
        return new Builder();
    }

    public static final PropertyTypeRegistry default_() {
        return PropertyTypeRegistry.builder().defaults().build();
    }

    PropertyTypeRegistry(Map<String, PropertyType<?>> types) {
        this.types = types;
    }

    public PropertyType<?> getType(String name) {
        return this.types.get(name.toLowerCase(Locale.US));
    }

    public Collection<PropertyType<?>> getTypes() {
        return this.types.values();
    }

    public static class Builder {
        private Map<String, PropertyType<?>> types = new LinkedHashMap();

        public PropertyTypeRegistry build() {
            Map<String, PropertyType<?>> useTypes = Collections.unmodifiableMap(this.types);
            this.types = null;
            return new PropertyTypeRegistry(useTypes);
        }

        public Builder defaults() {
            for (PropertyType<?> t : PropertyType.standardTypes()) {
                this.type(t);
            }
            return this;
        }

        public Builder type(PropertyType<?> type) {
            this.types.put(type.getName().toLowerCase(Locale.US), type);
            return this;
        }
    }
}

